/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.cql.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hl7.cql.model.ClassType;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.InstantiationContext;
import org.hl7.cql.model.TupleTypeElement;

public class TupleType
extends DataType {
    private List<TupleTypeElement> elements = new ArrayList<TupleTypeElement>();
    private List<TupleTypeElement> sortedElements = null;

    public TupleType(Collection<TupleTypeElement> elements) {
        if (elements != null) {
            this.elements.addAll(elements);
        }
    }

    public TupleType() {
        this((Collection<TupleTypeElement>)null);
    }

    public Iterable<TupleTypeElement> getElements() {
        return this.elements;
    }

    public void addElement(TupleTypeElement element) {
        this.elements.add(element);
        this.sortedElements = null;
    }

    public void addElements(Collection<TupleTypeElement> elements) {
        this.elements.addAll(elements);
        this.sortedElements = null;
    }

    private List<TupleTypeElement> getSortedElements() {
        if (this.sortedElements == null) {
            this.sortedElements = new ArrayList<TupleTypeElement>(this.elements);
            Collections.sort(this.sortedElements, (left, right) -> left.getName().compareTo(right.getName()));
        }
        return this.sortedElements;
    }

    public int hashCode() {
        int result = 13;
        for (int i = 0; i < this.elements.size(); ++i) {
            result += 37 * this.elements.get(i).hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof TupleType) {
            TupleType that = (TupleType)o;
            if (this.elements.size() == that.elements.size()) {
                List<TupleTypeElement> theseElements = this.getSortedElements();
                List<TupleTypeElement> thoseElements = that.getSortedElements();
                for (int i = 0; i < theseElements.size(); ++i) {
                    if (theseElements.get(i).equals(thoseElements.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSubTypeOf(DataType other) {
        if (other instanceof TupleType) {
            TupleType that = (TupleType)other;
            if (this.elements.size() == that.elements.size()) {
                List<TupleTypeElement> theseElements = this.getSortedElements();
                List<TupleTypeElement> thoseElements = that.getSortedElements();
                for (int i = 0; i < theseElements.size(); ++i) {
                    if (theseElements.get(i).isSubTypeOf(thoseElements.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return super.isSubTypeOf(other);
    }

    @Override
    public boolean isSuperTypeOf(DataType other) {
        if (other instanceof TupleType) {
            TupleType that = (TupleType)other;
            if (this.elements.size() == that.elements.size()) {
                List<TupleTypeElement> theseElements = this.getSortedElements();
                List<TupleTypeElement> thoseElements = that.getSortedElements();
                for (int i = 0; i < theseElements.size(); ++i) {
                    if (theseElements.get(i).isSuperTypeOf(thoseElements.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return super.isSuperTypeOf(other);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("tuple{");
        for (int i = 0; i < this.elements.size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(this.elements.get(i).toString());
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public String toLabel() {
        StringBuilder builder = new StringBuilder();
        builder.append("tuple of ");
        for (int i = 0; i < this.elements.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.elements.get(i).toLabel());
        }
        return builder.toString();
    }

    @Override
    public boolean isCompatibleWith(DataType other) {
        if (other instanceof ClassType) {
            ClassType classType = (ClassType)other;
            return this.equals(classType.getTupleType());
        }
        return false;
    }

    @Override
    public boolean isGeneric() {
        for (TupleTypeElement e : this.elements) {
            if (!e.getType().isGeneric()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInstantiable(DataType callType, InstantiationContext context) {
        if (callType instanceof TupleType) {
            TupleType tupleType = (TupleType)callType;
            if (this.elements.size() == tupleType.elements.size()) {
                List<TupleTypeElement> theseElements = this.getSortedElements();
                List<TupleTypeElement> thoseElements = tupleType.getSortedElements();
                for (int i = 0; i < theseElements.size(); ++i) {
                    if (theseElements.get(i).getName().equals(thoseElements.get(i).getName()) && theseElements.get(i).getType().isInstantiable(thoseElements.get(i).getType(), context)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public DataType instantiate(InstantiationContext context) {
        if (!this.isGeneric()) {
            return this;
        }
        TupleType result = new TupleType();
        for (int i = 0; i < this.elements.size(); ++i) {
            result.addElement(new TupleTypeElement(this.elements.get(i).getName(), this.elements.get(i).getType().instantiate(context)));
        }
        return result;
    }
}

