/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.cql.model;

import java.util.ArrayList;
import java.util.Iterator;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.InstantiationContext;

public class ChoiceType
extends DataType {
    private ArrayList<DataType> types = new ArrayList();

    public ChoiceType(Iterable<DataType> types) {
        for (DataType type : types) {
            this.addType(type);
        }
    }

    public Iterable<DataType> getTypes() {
        return this.types;
    }

    private void addType(DataType type) {
        if (type instanceof ChoiceType) {
            ChoiceType choiceType = (ChoiceType)type;
            for (DataType choice : choiceType.getTypes()) {
                this.addType(choice);
            }
        } else {
            this.types.add(type);
        }
    }

    public int hashCode() {
        int result = 13;
        for (int i = 0; i < this.types.size(); ++i) {
            result += 37 * this.types.get(i).hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof ChoiceType) {
            ChoiceType that = (ChoiceType)o;
            if (this.types.size() == that.types.size()) {
                ArrayList<DataType> theseTypes = this.types;
                ArrayList<DataType> thoseTypes = that.types;
                for (int i = 0; i < theseTypes.size(); ++i) {
                    if (((DataType)theseTypes.get(i)).equals(thoseTypes.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSubTypeOf(DataType other) {
        return super.isSubTypeOf(other);
    }

    public boolean isSubSetOf(ChoiceType other) {
        for (DataType type : this.types) {
            DataType otherType;
            Boolean currentIsSubType = false;
            Iterator<DataType> iterator = other.types.iterator();
            while (iterator.hasNext() && !(currentIsSubType = Boolean.valueOf(type.isSubTypeOf(otherType = iterator.next()))).booleanValue()) {
            }
            if (currentIsSubType.booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSuperTypeOf(DataType other) {
        return super.isSuperTypeOf(other);
    }

    public boolean isSuperSetOf(ChoiceType other) {
        return other.isSubSetOf(this);
    }

    @Override
    public boolean isCompatibleWith(DataType other) {
        if (other instanceof ChoiceType) {
            return this.isSubSetOf((ChoiceType)other) || this.isSuperSetOf((ChoiceType)other);
        }
        for (DataType type : this.types) {
            if (!other.isSubTypeOf(type)) continue;
            return true;
        }
        return super.isCompatibleWith(other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("choice<");
        boolean first = true;
        for (DataType type : this.types) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(type.toString());
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public boolean isGeneric() {
        for (DataType type : this.types) {
            if (!type.isGeneric()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInstantiable(DataType callType, InstantiationContext context) {
        return this.isSuperTypeOf(callType);
    }

    @Override
    public DataType instantiate(InstantiationContext context) {
        return this;
    }
}

