/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.cql.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.hl7.cql.model.ClassTypeElement;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.InstantiationContext;
import org.hl7.cql.model.InvalidRedeclarationException;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.NamedType;
import org.hl7.cql.model.TupleType;
import org.hl7.cql.model.TupleTypeElement;

public class ClassType
extends DataType
implements NamedType {
    private String name;
    private String identifier;
    private String label;
    private boolean retrievable;
    private String primaryCodePath;
    private List<ClassTypeElement> elements = new ArrayList<ClassTypeElement>();
    private List<ClassTypeElement> sortedElements = null;
    private LinkedHashMap<String, ClassTypeElement> baseElementMap = null;
    private TupleType tupleType;

    public ClassType(String name, DataType baseType, Collection<ClassTypeElement> elements) {
        super(baseType);
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        if (elements != null) {
            this.elements.addAll(elements);
        }
    }

    public ClassType() {
        this(null, null, null);
    }

    public ClassType(String name) {
        this(name, null, null);
    }

    public ClassType(String name, DataType baseType) {
        this(name, baseType, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        int qualifierIndex;
        if (this.name != null && (qualifierIndex = this.name.indexOf(46)) > 0) {
            return this.name.substring(0, qualifierIndex);
        }
        return "";
    }

    @Override
    public String getSimpleName() {
        int qualifierIndex;
        if (this.name != null && (qualifierIndex = this.name.indexOf(46)) > 0) {
            return this.name.substring(qualifierIndex + 1);
        }
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isRetrievable() {
        return this.retrievable;
    }

    public void setRetrievable(boolean retrievable) {
        this.retrievable = retrievable;
    }

    public String getPrimaryCodePath() {
        return this.primaryCodePath;
    }

    public void setPrimaryCodePath(String primaryCodePath) {
        this.primaryCodePath = primaryCodePath;
    }

    public List<ClassTypeElement> getElements() {
        return this.elements;
    }

    private LinkedHashMap<String, ClassTypeElement> getBaseElementMap() {
        if (this.baseElementMap == null) {
            this.baseElementMap = new LinkedHashMap();
            if (this.getBaseType() instanceof ClassType) {
                ((ClassType)this.getBaseType()).gatherElements(this.baseElementMap);
            }
        }
        return this.baseElementMap;
    }

    private void gatherElements(LinkedHashMap<String, ClassTypeElement> elementMap) {
        if (this.getBaseType() instanceof ClassType) {
            ((ClassType)this.getBaseType()).gatherElements(elementMap);
        }
        for (ClassTypeElement element : this.elements) {
            elementMap.put(element.getName(), element);
        }
    }

    public List<ClassTypeElement> getAllElements() {
        LinkedHashMap<String, ClassTypeElement> elementMap = new LinkedHashMap<String, ClassTypeElement>(this.getBaseElementMap());
        for (ClassTypeElement el : this.elements) {
            elementMap.put(el.getName(), el);
        }
        return new ArrayList<ClassTypeElement>(elementMap.values());
    }

    private void internalAddElement(ClassTypeElement element) {
        ClassTypeElement existingElement = this.getBaseElementMap().get(element.getName());
        if (!(existingElement == null || element.getType().isSubTypeOf(existingElement.getType()) || existingElement.getType() instanceof ListType && element.getType().isSubTypeOf(((ListType)existingElement.getType()).getElementType()))) {
            throw new InvalidRedeclarationException(this, existingElement, element);
        }
        this.elements.add(element);
    }

    public void addElement(ClassTypeElement element) {
        this.internalAddElement(element);
        this.sortedElements = null;
        this.tupleType = null;
    }

    public void addElements(Collection<ClassTypeElement> elements) {
        for (ClassTypeElement element : elements) {
            this.internalAddElement(element);
        }
        this.sortedElements = null;
        this.tupleType = null;
    }

    private List<ClassTypeElement> getSortedElements() {
        if (this.sortedElements == null) {
            this.sortedElements = new ArrayList<ClassTypeElement>(this.elements);
            Collections.sort(this.sortedElements, (left, right) -> left.getName().compareTo(right.getName()));
        }
        return this.sortedElements;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ClassType) {
            ClassType that = (ClassType)o;
            return this.name.equals(that.name);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String toLabel() {
        return this.label == null ? this.name : this.label;
    }

    public TupleType getTupleType() {
        if (this.tupleType == null) {
            this.tupleType = this.buildTupleType();
        }
        return this.tupleType;
    }

    private void addTupleElements(ClassType classType, LinkedHashMap<String, TupleTypeElement> elements) {
        DataType baseType = classType.getBaseType();
        if (baseType instanceof ClassType) {
            this.addTupleElements((ClassType)baseType, elements);
        }
        for (ClassTypeElement element : classType.getElements()) {
            if (element.isProhibited()) continue;
            TupleTypeElement tupleElement = new TupleTypeElement(element.getName(), element.getType());
            elements.put(tupleElement.getName(), tupleElement);
        }
    }

    private TupleType buildTupleType() {
        LinkedHashMap<String, TupleTypeElement> tupleElements = new LinkedHashMap<String, TupleTypeElement>();
        this.addTupleElements(this, tupleElements);
        return new TupleType(tupleElements.values());
    }

    @Override
    public boolean isCompatibleWith(DataType other) {
        if (other instanceof TupleType) {
            TupleType tupleType = (TupleType)other;
            return this.getTupleType().equals(tupleType);
        }
        return false;
    }

    @Override
    public boolean isGeneric() {
        for (ClassTypeElement e : this.elements) {
            if (!e.getType().isGeneric()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInstantiable(DataType callType, InstantiationContext context) {
        if (callType instanceof ClassType) {
            ClassType classType = (ClassType)callType;
            if (this.elements.size() == classType.elements.size()) {
                List<ClassTypeElement> theseElements = this.getSortedElements();
                List<ClassTypeElement> thoseElements = classType.getSortedElements();
                for (int i = 0; i < theseElements.size(); ++i) {
                    if (theseElements.get(i).getName().equals(thoseElements.get(i).getName()) && theseElements.get(i).getType().isInstantiable(thoseElements.get(i).getType(), context)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public DataType instantiate(InstantiationContext context) {
        if (!this.isGeneric()) {
            return this;
        }
        ClassType result = new ClassType(this.getName(), this.getBaseType());
        for (int i = 0; i < this.elements.size(); ++i) {
            result.addElement(new ClassTypeElement(this.elements.get(i).getName(), this.elements.get(i).getType().instantiate(context)));
        }
        return result;
    }
}

