/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.cql.model;

import org.hl7.cql.model.DataType;
import org.hl7.cql.model.InstantiationContext;
import org.hl7.cql.model.NamedType;

public class SimpleType
extends DataType
implements NamedType {
    private String name;

    public SimpleType(String name, DataType baseType) {
        super(baseType);
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("name");
        }
        this.name = name;
    }

    public SimpleType(String name) {
        this(name, null);
    }

    @Override
    public String getNamespace() {
        int qualifierIndex = this.name.indexOf(46);
        if (qualifierIndex > 0) {
            return this.name.substring(0, qualifierIndex);
        }
        return "";
    }

    @Override
    public String getSimpleName() {
        int qualifierIndex = this.name.indexOf(46);
        if (qualifierIndex > 0) {
            return this.name.substring(qualifierIndex + 1);
        }
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SimpleType) {
            SimpleType that = (SimpleType)o;
            return this.name.equals(that.name);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean isCompatibleWith(DataType other) {
        return this.equals(DataType.ANY) || super.isCompatibleWith(other);
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public boolean isInstantiable(DataType callType, InstantiationContext context) {
        if (this.isSuperTypeOf(callType)) {
            return true;
        }
        boolean isAlreadyInstantiable = false;
        for (SimpleType targetSimpleType : context.getSimpleConversionTargets(callType)) {
            boolean isInstantiable = true;
            if (!isInstantiable) continue;
            if (isAlreadyInstantiable) {
                throw new IllegalArgumentException(String.format("Ambiguous generic instantiation involving %s to %s.", callType.toString(), targetSimpleType.toString()));
            }
            isAlreadyInstantiable = true;
        }
        return isAlreadyInstantiable;
    }

    @Override
    public DataType instantiate(InstantiationContext context) {
        return this;
    }
}

