/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.cql.model;

import java.io.IOException;
import org.hl7.cql.model.ModelIdentifier;
import org.hl7.cql.model.ModelInfoProvider;
import org.hl7.cql.model.NamespaceManager;
import org.hl7.elm_modelinfo.r1.ModelInfo;
import org.hl7.elm_modelinfo.r1.serializing.ModelInfoReaderFactory;

public class SystemModelInfoProvider
implements ModelInfoProvider {
    private NamespaceManager namespaceManager;

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    private boolean isSystemModelIdentifier(ModelIdentifier modelIdentifier) {
        if (this.namespaceManager != null && this.namespaceManager.hasNamespaces()) {
            return modelIdentifier.getId().equals("System") && (modelIdentifier.getSystem() == null || modelIdentifier.getSystem().equals("urn:hl7-org:elm-types:r1"));
        }
        return modelIdentifier.getId().equals("System");
    }

    @Override
    public ModelInfo load(ModelIdentifier modelIdentifier) {
        if (this.isSystemModelIdentifier(modelIdentifier)) {
            try {
                return ModelInfoReaderFactory.getReader("application/xml").read(SystemModelInfoProvider.class.getResourceAsStream("/org/hl7/elm/r1/system-modelinfo.xml"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

