/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.cql.model;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.cql.model.ClassType;
import org.hl7.cql.model.ClassTypeElement;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.TypeParameter;

public class GenericClassSignatureParser {
    public static final CharSequence OPEN_BRACKET = "<";
    public static final CharSequence CLOSE_BRACKET = ">";
    public static final String EXTENDS = "extends";
    private int startPos = 0;
    private int endPos = 0;
    private int bracketCount = 0;
    private int currentBracketPosition = 0;
    private Map<String, DataType> resolvedTypes;
    private String genericSignature;
    private String baseType;
    private String boundGenericTypeName;

    public GenericClassSignatureParser(String genericSignature, String baseType, String boundGenericTypeName, Map<String, DataType> resolvedTypes) {
        this.genericSignature = genericSignature;
        this.resolvedTypes = resolvedTypes;
        this.baseType = baseType;
        this.boundGenericTypeName = boundGenericTypeName;
    }

    public GenericClassSignatureParser(String genericSignature, Map<String, DataType> resolvedTypes) {
        this(genericSignature, null, null, resolvedTypes);
    }

    public String getGenericSignature() {
        return this.genericSignature;
    }

    public void setGenericSignature(String genericSignature) {
        this.genericSignature = genericSignature;
    }

    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public String getBoundGenericTypeName() {
        return this.boundGenericTypeName;
    }

    public void setBoundGenericTypeName(String boundGenericTypeName) {
        this.boundGenericTypeName = boundGenericTypeName;
    }

    public ClassType parseGenericSignature() {
        String genericTypeName = this.genericSignature;
        String[] params = new String[]{};
        if (this.isValidGenericSignature()) {
            genericTypeName = this.genericSignature.substring(0, this.genericSignature.indexOf(60));
            String parameters = this.genericSignature.substring(this.genericSignature.indexOf(60) + 1, this.genericSignature.lastIndexOf(62));
            params = this.escapeNestedCommas(parameters).split(",");
        }
        String baseTypeName = this.baseType;
        String[] baseTypeParameters = null;
        if (this.baseType != null && this.baseType.contains("<")) {
            baseTypeName = this.baseType.substring(0, this.baseType.indexOf(60));
            String baseTypeParameterString = this.baseType.substring(this.baseType.indexOf(60) + 1, this.baseType.lastIndexOf(62));
            baseTypeParameters = this.escapeNestedCommas(baseTypeParameterString).split(",");
        }
        DataType baseDataType = this.resolveTypeName(baseTypeName);
        ClassType genericClassType = new ClassType(genericTypeName, baseDataType);
        for (String param : params) {
            TypeParameter paramType = this.handleParameterDeclaration(this.unescapeNestedCommas(param));
            genericClassType.addGenericParameter(paramType);
        }
        if (baseTypeParameters != null) {
            int index = 0;
            for (String baseTypeParameter : baseTypeParameters) {
                if (baseTypeParameter.length() == 1 && genericClassType.getGenericParameterByIdentifier(baseTypeParameter) == null) {
                    throw new RuntimeException("Cannot resolve symbol " + baseTypeParameter);
                }
                DataType boundType = this.resolveTypeName(this.unescapeNestedCommas(baseTypeParameter));
                ClassType baseTypeClass = (ClassType)baseDataType;
                List<ClassTypeElement> baseClassFields = baseTypeClass.getElements();
                String myParam = baseTypeClass.getGenericParameters().get(index).getIdentifier();
                System.out.println(boundType + " replaces param " + myParam);
                for (ClassTypeElement baseClassField : baseClassFields) {
                    ClassTypeElement myElement = new ClassTypeElement(baseClassField.getName(), boundType);
                    genericClassType.addElement(myElement);
                }
                ++index;
            }
        }
        return genericClassType;
    }

    protected TypeParameter handleParameterDeclaration(String parameterString) {
        String[] paramComponents = parameterString.split("\\s+");
        if (paramComponents.length == 1) {
            return new TypeParameter(StringUtils.trim((String)parameterString), TypeParameter.TypeParameterConstraint.NONE, null);
        }
        if (paramComponents.length == 3) {
            if (paramComponents[1].equalsIgnoreCase(EXTENDS)) {
                return new TypeParameter(paramComponents[0], TypeParameter.TypeParameterConstraint.TYPE, this.resolveTypeName(paramComponents[2]));
            }
            throw new RuntimeException("Invalid parameter syntax: " + parameterString);
        }
        throw new RuntimeException("Invalid parameter syntax: " + parameterString);
    }

    protected DataType resolveTypeName(String parameterType) {
        if (this.isValidGenericSignature(parameterType)) {
            return this.handleBoundType(parameterType);
        }
        if (parameterType == null) {
            return null;
        }
        return this.resolveType(parameterType);
    }

    protected DataType handleBoundType(String boundGenericSignature) {
        ClassType resolvedType = (ClassType)this.resolvedTypes.get(this.escapeNestedAngleBrackets(boundGenericSignature));
        if (resolvedType != null) {
            return resolvedType;
        }
        String genericTypeName = boundGenericSignature.substring(0, boundGenericSignature.indexOf(60));
        resolvedType = (ClassType)this.resolveType(genericTypeName);
        if (resolvedType == null) {
            throw new RuntimeException("Unknown type " + genericTypeName);
        }
        ClassType newType = new ClassType(this.escapeNestedAngleBrackets(boundGenericSignature), resolvedType);
        String parameters = boundGenericSignature.substring(boundGenericSignature.indexOf(60) + 1, boundGenericSignature.lastIndexOf(62));
        String[] params = this.escapeNestedCommas(parameters).split(",");
        int index = 0;
        for (String param : params) {
            DataType boundParam = null;
            boundParam = this.isValidGenericSignature(param = this.unescapeNestedCommas(param)) ? this.handleBoundType(param) : this.resolveType(param);
            TypeParameter typeParameter = resolvedType.getGenericParameters().get(index);
            for (ClassTypeElement classTypeElement : resolvedType.getElements()) {
                if (!(classTypeElement.getType() instanceof TypeParameter) || !((TypeParameter)classTypeElement.getType()).getIdentifier().equalsIgnoreCase(typeParameter.getIdentifier())) continue;
                ClassTypeElement newElement = new ClassTypeElement(classTypeElement.getName(), boundParam);
                newType.addElement(newElement);
            }
            ++index;
        }
        this.resolvedTypes.put(newType.getName(), newType);
        return newType;
    }

    public boolean isValidGenericSignature() {
        return this.isValidGenericSignature(this.genericSignature);
    }

    public boolean isValidGenericSignature(String genericSignature) {
        return this.areBracketsPaired(genericSignature) && this.closingBracketsComeAfterOpeningBrackets(genericSignature);
    }

    private void initializeParser() {
        this.startPos = this.genericSignature.indexOf(60);
        this.endPos = this.genericSignature.lastIndexOf(62);
        this.bracketCount = this.openBracketCount();
    }

    private int openBracketCount() {
        return this.openBracketCount(this.genericSignature);
    }

    private int openBracketCount(String signatureString) {
        int matchCount = 0;
        if (signatureString != null) {
            matchCount = StringUtils.countMatches((CharSequence)signatureString, (CharSequence)OPEN_BRACKET);
        }
        return matchCount;
    }

    private int closeBracketCount() {
        return this.closeBracketCount(this.genericSignature);
    }

    private int closeBracketCount(String signatureString) {
        int matchCount = 0;
        if (signatureString != null) {
            matchCount = StringUtils.countMatches((CharSequence)signatureString, (CharSequence)CLOSE_BRACKET);
        }
        return matchCount;
    }

    private boolean areBracketsPaired() {
        return this.areBracketsPaired(this.genericSignature);
    }

    private boolean areBracketsPaired(String signatureString) {
        boolean paired = false;
        if (signatureString != null) {
            int closeCount;
            int openCount = this.openBracketCount(signatureString);
            paired = openCount == (closeCount = this.closeBracketCount(signatureString)) && openCount > 0;
        }
        return paired;
    }

    private boolean closingBracketsComeAfterOpeningBrackets() {
        return this.closingBracketsComeAfterOpeningBrackets(this.genericSignature);
    }

    private boolean closingBracketsComeAfterOpeningBrackets(String signatureString) {
        return signatureString != null && signatureString.lastIndexOf(60) < signatureString.indexOf(62);
    }

    private String escapeNestedCommas(String signature) {
        char[] signatureCharArray = signature.toCharArray();
        int openBracketCount = 0;
        for (int index = 0; index < signatureCharArray.length; ++index) {
            char c = signatureCharArray[index];
            if (c == '<') {
                ++openBracketCount;
                continue;
            }
            if (c == '>') {
                --openBracketCount;
                continue;
            }
            if (c != ',' || openBracketCount <= 0) continue;
            signatureCharArray[index] = 124;
        }
        return new String(signatureCharArray);
    }

    private String unescapeNestedCommas(String escapedSignature) {
        return escapedSignature.replaceAll("\\|", ",");
    }

    private DataType resolveType(String typeName) {
        DataType type = this.resolvedTypes.get(typeName);
        if (type == null) {
            throw new RuntimeException("Unable to resolve " + typeName);
        }
        return type;
    }

    private String escapeNestedAngleBrackets(String genericSignature) {
        return genericSignature.replaceAll("<", "[").replaceAll(">", "]");
    }
}

