/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.cql.model;

import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.ClassType;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.InstantiationContext;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.SimpleType;
import org.hl7.cql.model.TupleType;

public class TypeParameter
extends DataType {
    private String identifier;
    public TypeParameterConstraint constraint = TypeParameterConstraint.NONE;
    private DataType constraintType;

    public TypeParameter(String identifier) {
        if (identifier == null || identifier.equals("")) {
            throw new IllegalArgumentException("identifier is null");
        }
        this.identifier = identifier;
    }

    public TypeParameter(String identifier, TypeParameterConstraint constraint, DataType constraintType) {
        this(identifier);
        this.constraint = constraint;
        this.constraintType = constraintType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public TypeParameterConstraint getConstraint() {
        return this.constraint;
    }

    public DataType getConstraintType() {
        return this.constraintType;
    }

    public boolean canBind(DataType callType) {
        switch (this.constraint.ordinal()) {
            case 5: {
                return callType instanceof ChoiceType;
            }
            case 3: {
                return callType instanceof TupleType;
            }
            case 4: {
                return callType instanceof IntervalType;
            }
            case 1: {
                return callType instanceof ClassType;
            }
            case 2: {
                return callType instanceof SimpleType && !callType.equals(DataType.ANY);
            }
            case 6: {
                return callType.isSubTypeOf(this.constraintType);
            }
        }
        return true;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof TypeParameter) {
            TypeParameter that = (TypeParameter)o;
            return this.identifier.equals(that.identifier);
        }
        return false;
    }

    public String toString() {
        return this.identifier;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public boolean isInstantiable(DataType callType, InstantiationContext context) {
        return context.isInstantiable(this, callType);
    }

    @Override
    public DataType instantiate(InstantiationContext context) {
        return context.instantiate(this);
    }

    public static enum TypeParameterConstraint {
        NONE,
        CLASS,
        VALUE,
        TUPLE,
        INTERVAL,
        CHOICE,
        TYPE;

    }
}

