/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.cql.model;

import org.hl7.cql.model.DataType;
import org.hl7.cql.model.InstantiationContext;

public class ListType
extends DataType {
    private DataType elementType;

    public ListType(DataType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException("elementType");
        }
        this.elementType = elementType;
    }

    public DataType getElementType() {
        return this.elementType;
    }

    public int hashCode() {
        return 67 * this.elementType.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ListType) {
            ListType that = (ListType)o;
            return this.elementType.equals(that.elementType);
        }
        return false;
    }

    @Override
    public boolean isSubTypeOf(DataType other) {
        if (other instanceof ListType) {
            ListType that = (ListType)other;
            return this.elementType.isSubTypeOf(that.elementType);
        }
        return super.isSubTypeOf(other);
    }

    @Override
    public boolean isSuperTypeOf(DataType other) {
        if (other instanceof ListType) {
            ListType that = (ListType)other;
            return this.elementType.isSuperTypeOf(that.elementType);
        }
        return super.isSuperTypeOf(other);
    }

    public String toString() {
        return String.format("list<%s>", this.elementType.toString());
    }

    @Override
    public String toLabel() {
        return String.format("List of %s", this.elementType.toLabel());
    }

    @Override
    public boolean isGeneric() {
        return this.elementType.isGeneric();
    }

    @Override
    public boolean isInstantiable(DataType callType, InstantiationContext context) {
        if (callType.equals(DataType.ANY)) {
            return this.elementType.isInstantiable(callType, context);
        }
        if (callType instanceof ListType) {
            ListType listType = (ListType)callType;
            return this.elementType.isInstantiable(listType.elementType, context);
        }
        boolean isAlreadyInstantiable = false;
        for (ListType targetListType : context.getListConversionTargets(callType)) {
            boolean isInstantiable = this.elementType.isInstantiable(targetListType.elementType, context);
            if (!isInstantiable) continue;
            if (isAlreadyInstantiable) {
                throw new IllegalArgumentException(String.format("Ambiguous generic instantiation involving %s to %s.", callType.toString(), targetListType.toString()));
            }
            isAlreadyInstantiable = true;
        }
        return isAlreadyInstantiable;
    }

    @Override
    public DataType instantiate(InstantiationContext context) {
        return new ListType(this.elementType.instantiate(context));
    }
}

