/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.AllergyIntoleranceCertainty;
import org.hl7.fhir.AllergyIntoleranceSeverity;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.Duration;
import org.hl7.fhir.Extension;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AllergyIntolerance.Event", propOrder={"substance", "certainty", "manifestation", "description", "onset", "duration", "severity", "exposureRoute", "comment"})
public class AllergyIntoleranceEvent
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected CodeableConcept substance;
    protected AllergyIntoleranceCertainty certainty;
    @XmlElement(required=true)
    protected List<CodeableConcept> manifestation;
    protected String description;
    protected DateTime onset;
    protected Duration duration;
    protected AllergyIntoleranceSeverity severity;
    protected CodeableConcept exposureRoute;
    protected String comment;

    public CodeableConcept getSubstance() {
        return this.substance;
    }

    public void setSubstance(CodeableConcept value) {
        this.substance = value;
    }

    public AllergyIntoleranceCertainty getCertainty() {
        return this.certainty;
    }

    public void setCertainty(AllergyIntoleranceCertainty value) {
        this.certainty = value;
    }

    public List<CodeableConcept> getManifestation() {
        if (this.manifestation == null) {
            this.manifestation = new ArrayList<CodeableConcept>();
        }
        return this.manifestation;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public DateTime getOnset() {
        return this.onset;
    }

    public void setOnset(DateTime value) {
        this.onset = value;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration value) {
        this.duration = value;
    }

    public AllergyIntoleranceSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(AllergyIntoleranceSeverity value) {
        this.severity = value;
    }

    public CodeableConcept getExposureRoute() {
        return this.exposureRoute;
    }

    public void setExposureRoute(CodeableConcept value) {
        this.exposureRoute = value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String value) {
        this.comment = value;
    }

    public AllergyIntoleranceEvent withSubstance(CodeableConcept value) {
        this.setSubstance(value);
        return this;
    }

    public AllergyIntoleranceEvent withCertainty(AllergyIntoleranceCertainty value) {
        this.setCertainty(value);
        return this;
    }

    public AllergyIntoleranceEvent withManifestation(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getManifestation().add(value);
            }
        }
        return this;
    }

    public AllergyIntoleranceEvent withManifestation(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getManifestation().addAll(values);
        }
        return this;
    }

    public AllergyIntoleranceEvent withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public AllergyIntoleranceEvent withOnset(DateTime value) {
        this.setOnset(value);
        return this;
    }

    public AllergyIntoleranceEvent withDuration(Duration value) {
        this.setDuration(value);
        return this;
    }

    public AllergyIntoleranceEvent withSeverity(AllergyIntoleranceSeverity value) {
        this.setSeverity(value);
        return this;
    }

    public AllergyIntoleranceEvent withExposureRoute(CodeableConcept value) {
        this.setExposureRoute(value);
        return this;
    }

    public AllergyIntoleranceEvent withComment(String value) {
        this.setComment(value);
        return this;
    }

    @Override
    public AllergyIntoleranceEvent withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public AllergyIntoleranceEvent withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public AllergyIntoleranceEvent withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public AllergyIntoleranceEvent withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public AllergyIntoleranceEvent withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<CodeableConcept> rhsManifestation;
        if (!(object instanceof AllergyIntoleranceEvent)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        AllergyIntoleranceEvent that = (AllergyIntoleranceEvent)object;
        CodeableConcept lhsSubstance = this.getSubstance();
        CodeableConcept rhsSubstance = that.getSubstance();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"substance", (Object)lhsSubstance), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"substance", (Object)rhsSubstance), (Object)lhsSubstance, (Object)rhsSubstance)) {
            return false;
        }
        AllergyIntoleranceCertainty lhsCertainty = this.getCertainty();
        AllergyIntoleranceCertainty rhsCertainty = that.getCertainty();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"certainty", (Object)lhsCertainty), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"certainty", (Object)rhsCertainty), (Object)lhsCertainty, (Object)rhsCertainty)) {
            return false;
        }
        List<CodeableConcept> lhsManifestation = this.manifestation != null && !this.manifestation.isEmpty() ? this.getManifestation() : null;
        List<CodeableConcept> list = rhsManifestation = that.manifestation != null && !that.manifestation.isEmpty() ? that.getManifestation() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"manifestation", lhsManifestation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"manifestation", rhsManifestation), lhsManifestation, rhsManifestation)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription)) {
            return false;
        }
        DateTime lhsOnset = this.getOnset();
        DateTime rhsOnset = that.getOnset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"onset", (Object)lhsOnset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"onset", (Object)rhsOnset), (Object)lhsOnset, (Object)rhsOnset)) {
            return false;
        }
        Duration lhsDuration = this.getDuration();
        Duration rhsDuration = that.getDuration();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"duration", (Object)lhsDuration), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"duration", (Object)rhsDuration), (Object)lhsDuration, (Object)rhsDuration)) {
            return false;
        }
        AllergyIntoleranceSeverity lhsSeverity = this.getSeverity();
        AllergyIntoleranceSeverity rhsSeverity = that.getSeverity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"severity", (Object)lhsSeverity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"severity", (Object)rhsSeverity), (Object)lhsSeverity, (Object)rhsSeverity)) {
            return false;
        }
        CodeableConcept lhsExposureRoute = this.getExposureRoute();
        CodeableConcept rhsExposureRoute = that.getExposureRoute();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"exposureRoute", (Object)lhsExposureRoute), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"exposureRoute", (Object)rhsExposureRoute), (Object)lhsExposureRoute, (Object)rhsExposureRoute)) {
            return false;
        }
        String lhsComment = this.getComment();
        String rhsComment = that.getComment();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"comment", (Object)lhsComment), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"comment", (Object)rhsComment), (Object)lhsComment, (Object)rhsComment);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theSubstance = this.getSubstance();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"substance", (Object)theSubstance), currentHashCode, (Object)theSubstance);
        AllergyIntoleranceCertainty theCertainty = this.getCertainty();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"certainty", (Object)theCertainty), currentHashCode, (Object)theCertainty);
        List<CodeableConcept> theManifestation = this.manifestation != null && !this.manifestation.isEmpty() ? this.getManifestation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"manifestation", theManifestation), currentHashCode, theManifestation);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription);
        DateTime theOnset = this.getOnset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"onset", (Object)theOnset), currentHashCode, (Object)theOnset);
        Duration theDuration = this.getDuration();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"duration", (Object)theDuration), currentHashCode, (Object)theDuration);
        AllergyIntoleranceSeverity theSeverity = this.getSeverity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"severity", (Object)theSeverity), currentHashCode, (Object)theSeverity);
        CodeableConcept theExposureRoute = this.getExposureRoute();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"exposureRoute", (Object)theExposureRoute), currentHashCode, (Object)theExposureRoute);
        String theComment = this.getComment();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"comment", (Object)theComment), currentHashCode, (Object)theComment);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theSubstance = this.getSubstance();
        strategy.appendField(locator, (Object)this, "substance", buffer, (Object)theSubstance);
        AllergyIntoleranceCertainty theCertainty = this.getCertainty();
        strategy.appendField(locator, (Object)this, "certainty", buffer, (Object)theCertainty);
        List<CodeableConcept> theManifestation = this.manifestation != null && !this.manifestation.isEmpty() ? this.getManifestation() : null;
        strategy.appendField(locator, (Object)this, "manifestation", buffer, theManifestation);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription);
        DateTime theOnset = this.getOnset();
        strategy.appendField(locator, (Object)this, "onset", buffer, (Object)theOnset);
        Duration theDuration = this.getDuration();
        strategy.appendField(locator, (Object)this, "duration", buffer, (Object)theDuration);
        AllergyIntoleranceSeverity theSeverity = this.getSeverity();
        strategy.appendField(locator, (Object)this, "severity", buffer, (Object)theSeverity);
        CodeableConcept theExposureRoute = this.getExposureRoute();
        strategy.appendField(locator, (Object)this, "exposureRoute", buffer, (Object)theExposureRoute);
        String theComment = this.getComment();
        strategy.appendField(locator, (Object)this, "comment", buffer, (Object)theComment);
        return buffer;
    }
}

