/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.AuditEventEvent;
import org.hl7.fhir.AuditEventObject;
import org.hl7.fhir.AuditEventParticipant;
import org.hl7.fhir.AuditEventSource;
import org.hl7.fhir.Code;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AuditEvent", propOrder={"event", "participant", "source", "object"})
public class AuditEvent
extends DomainResource
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected AuditEventEvent event;
    @XmlElement(required=true)
    protected List<AuditEventParticipant> participant;
    @XmlElement(required=true)
    protected AuditEventSource source;
    protected List<AuditEventObject> object;

    public AuditEventEvent getEvent() {
        return this.event;
    }

    public void setEvent(AuditEventEvent value) {
        this.event = value;
    }

    public List<AuditEventParticipant> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<AuditEventParticipant>();
        }
        return this.participant;
    }

    public AuditEventSource getSource() {
        return this.source;
    }

    public void setSource(AuditEventSource value) {
        this.source = value;
    }

    public List<AuditEventObject> getObject() {
        if (this.object == null) {
            this.object = new ArrayList<AuditEventObject>();
        }
        return this.object;
    }

    public AuditEvent withEvent(AuditEventEvent value) {
        this.setEvent(value);
        return this;
    }

    public AuditEvent withParticipant(AuditEventParticipant ... values) {
        if (values != null) {
            for (AuditEventParticipant value : values) {
                this.getParticipant().add(value);
            }
        }
        return this;
    }

    public AuditEvent withParticipant(Collection<AuditEventParticipant> values) {
        if (values != null) {
            this.getParticipant().addAll(values);
        }
        return this;
    }

    public AuditEvent withSource(AuditEventSource value) {
        this.setSource(value);
        return this;
    }

    public AuditEvent withObject(AuditEventObject ... values) {
        if (values != null) {
            for (AuditEventObject value : values) {
                this.getObject().add(value);
            }
        }
        return this;
    }

    public AuditEvent withObject(Collection<AuditEventObject> values) {
        if (values != null) {
            this.getObject().addAll(values);
        }
        return this;
    }

    @Override
    public AuditEvent withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public AuditEvent withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public AuditEvent withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public AuditEvent withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public AuditEvent withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public AuditEvent withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public AuditEvent withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public AuditEvent withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public AuditEvent withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public AuditEvent withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public AuditEvent withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<AuditEventObject> rhsObject;
        List<AuditEventParticipant> rhsParticipant;
        if (!(object instanceof AuditEvent)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        AuditEvent that = (AuditEvent)object;
        AuditEventEvent lhsEvent = this.getEvent();
        AuditEventEvent rhsEvent = that.getEvent();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"event", (Object)lhsEvent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"event", (Object)rhsEvent), (Object)lhsEvent, (Object)rhsEvent)) {
            return false;
        }
        List<AuditEventParticipant> lhsParticipant = this.participant != null && !this.participant.isEmpty() ? this.getParticipant() : null;
        List<AuditEventParticipant> list = rhsParticipant = that.participant != null && !that.participant.isEmpty() ? that.getParticipant() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"participant", lhsParticipant), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"participant", rhsParticipant), lhsParticipant, rhsParticipant)) {
            return false;
        }
        AuditEventSource lhsSource = this.getSource();
        AuditEventSource rhsSource = that.getSource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"source", (Object)lhsSource), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"source", (Object)rhsSource), (Object)lhsSource, (Object)rhsSource)) {
            return false;
        }
        List<AuditEventObject> lhsObject = this.object != null && !this.object.isEmpty() ? this.getObject() : null;
        List<AuditEventObject> list2 = rhsObject = that.object != null && !that.object.isEmpty() ? that.getObject() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"object", lhsObject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"object", rhsObject), lhsObject, rhsObject);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        AuditEventEvent theEvent = this.getEvent();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"event", (Object)theEvent), currentHashCode, (Object)theEvent);
        List<AuditEventParticipant> theParticipant = this.participant != null && !this.participant.isEmpty() ? this.getParticipant() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"participant", theParticipant), currentHashCode, theParticipant);
        AuditEventSource theSource = this.getSource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"source", (Object)theSource), currentHashCode, (Object)theSource);
        List<AuditEventObject> theObject = this.object != null && !this.object.isEmpty() ? this.getObject() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"object", theObject), currentHashCode, theObject);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        AuditEventEvent theEvent = this.getEvent();
        strategy.appendField(locator, (Object)this, "event", buffer, (Object)theEvent);
        List<AuditEventParticipant> theParticipant = this.participant != null && !this.participant.isEmpty() ? this.getParticipant() : null;
        strategy.appendField(locator, (Object)this, "participant", buffer, theParticipant);
        AuditEventSource theSource = this.getSource();
        strategy.appendField(locator, (Object)this, "source", buffer, (Object)theSource);
        List<AuditEventObject> theObject = this.object != null && !this.object.isEmpty() ? this.getObject() : null;
        strategy.appendField(locator, (Object)this, "object", buffer, theObject);
        return buffer;
    }
}

