/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.BundleLink;
import org.hl7.fhir.BundleSearch;
import org.hl7.fhir.BundleTransaction;
import org.hl7.fhir.BundleTransactionResponse;
import org.hl7.fhir.Extension;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Bundle.Entry", propOrder={"base", "link", "resource", "search", "transaction", "transactionResponse"})
public class BundleEntry
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected Uri base;
    protected List<BundleLink> link;
    protected ResourceContainer resource;
    protected BundleSearch search;
    protected BundleTransaction transaction;
    protected BundleTransactionResponse transactionResponse;

    public Uri getBase() {
        return this.base;
    }

    public void setBase(Uri value) {
        this.base = value;
    }

    public List<BundleLink> getLink() {
        if (this.link == null) {
            this.link = new ArrayList<BundleLink>();
        }
        return this.link;
    }

    public ResourceContainer getResource() {
        return this.resource;
    }

    public void setResource(ResourceContainer value) {
        this.resource = value;
    }

    public BundleSearch getSearch() {
        return this.search;
    }

    public void setSearch(BundleSearch value) {
        this.search = value;
    }

    public BundleTransaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(BundleTransaction value) {
        this.transaction = value;
    }

    public BundleTransactionResponse getTransactionResponse() {
        return this.transactionResponse;
    }

    public void setTransactionResponse(BundleTransactionResponse value) {
        this.transactionResponse = value;
    }

    public BundleEntry withBase(Uri value) {
        this.setBase(value);
        return this;
    }

    public BundleEntry withLink(BundleLink ... values) {
        if (values != null) {
            for (BundleLink value : values) {
                this.getLink().add(value);
            }
        }
        return this;
    }

    public BundleEntry withLink(Collection<BundleLink> values) {
        if (values != null) {
            this.getLink().addAll(values);
        }
        return this;
    }

    public BundleEntry withResource(ResourceContainer value) {
        this.setResource(value);
        return this;
    }

    public BundleEntry withSearch(BundleSearch value) {
        this.setSearch(value);
        return this;
    }

    public BundleEntry withTransaction(BundleTransaction value) {
        this.setTransaction(value);
        return this;
    }

    public BundleEntry withTransactionResponse(BundleTransactionResponse value) {
        this.setTransactionResponse(value);
        return this;
    }

    @Override
    public BundleEntry withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public BundleEntry withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public BundleEntry withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public BundleEntry withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public BundleEntry withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<BundleLink> rhsLink;
        if (!(object instanceof BundleEntry)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        BundleEntry that = (BundleEntry)object;
        Uri lhsBase = this.getBase();
        Uri rhsBase = that.getBase();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"base", (Object)lhsBase), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"base", (Object)rhsBase), (Object)lhsBase, (Object)rhsBase)) {
            return false;
        }
        List<BundleLink> lhsLink = this.link != null && !this.link.isEmpty() ? this.getLink() : null;
        List<BundleLink> list = rhsLink = that.link != null && !that.link.isEmpty() ? that.getLink() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"link", lhsLink), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"link", rhsLink), lhsLink, rhsLink)) {
            return false;
        }
        ResourceContainer lhsResource = this.getResource();
        ResourceContainer rhsResource = that.getResource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"resource", (Object)lhsResource), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"resource", (Object)rhsResource), (Object)lhsResource, (Object)rhsResource)) {
            return false;
        }
        BundleSearch lhsSearch = this.getSearch();
        BundleSearch rhsSearch = that.getSearch();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"search", (Object)lhsSearch), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"search", (Object)rhsSearch), (Object)lhsSearch, (Object)rhsSearch)) {
            return false;
        }
        BundleTransaction lhsTransaction = this.getTransaction();
        BundleTransaction rhsTransaction = that.getTransaction();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"transaction", (Object)lhsTransaction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"transaction", (Object)rhsTransaction), (Object)lhsTransaction, (Object)rhsTransaction)) {
            return false;
        }
        BundleTransactionResponse lhsTransactionResponse = this.getTransactionResponse();
        BundleTransactionResponse rhsTransactionResponse = that.getTransactionResponse();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"transactionResponse", (Object)lhsTransactionResponse), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"transactionResponse", (Object)rhsTransactionResponse), (Object)lhsTransactionResponse, (Object)rhsTransactionResponse);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theBase = this.getBase();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"base", (Object)theBase), currentHashCode, (Object)theBase);
        List<BundleLink> theLink = this.link != null && !this.link.isEmpty() ? this.getLink() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"link", theLink), currentHashCode, theLink);
        ResourceContainer theResource = this.getResource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"resource", (Object)theResource), currentHashCode, (Object)theResource);
        BundleSearch theSearch = this.getSearch();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"search", (Object)theSearch), currentHashCode, (Object)theSearch);
        BundleTransaction theTransaction = this.getTransaction();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"transaction", (Object)theTransaction), currentHashCode, (Object)theTransaction);
        BundleTransactionResponse theTransactionResponse = this.getTransactionResponse();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"transactionResponse", (Object)theTransactionResponse), currentHashCode, (Object)theTransactionResponse);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theBase = this.getBase();
        strategy.appendField(locator, (Object)this, "base", buffer, (Object)theBase);
        List<BundleLink> theLink = this.link != null && !this.link.isEmpty() ? this.getLink() : null;
        strategy.appendField(locator, (Object)this, "link", buffer, theLink);
        ResourceContainer theResource = this.getResource();
        strategy.appendField(locator, (Object)this, "resource", buffer, (Object)theResource);
        BundleSearch theSearch = this.getSearch();
        strategy.appendField(locator, (Object)this, "search", buffer, (Object)theSearch);
        BundleTransaction theTransaction = this.getTransaction();
        strategy.appendField(locator, (Object)this, "transaction", buffer, (Object)theTransaction);
        BundleTransactionResponse theTransactionResponse = this.getTransactionResponse();
        strategy.appendField(locator, (Object)this, "transactionResponse", buffer, (Object)theTransactionResponse);
        return buffer;
    }
}

