/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.CarePlanActivityCategory;
import org.hl7.fhir.CarePlanActivityStatus;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Period;
import org.hl7.fhir.Quantity;
import org.hl7.fhir.Reference;
import org.hl7.fhir.String;
import org.hl7.fhir.Timing;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CarePlan.Detail", propOrder={"category", "code", "reasonCodeableConcept", "reasonReference", "goal", "status", "statusReason", "prohibited", "scheduledTiming", "scheduledPeriod", "scheduledString", "location", "performer", "product", "dailyAmount", "quantity", "note"})
public class CarePlanDetail
extends BackboneElement
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected CarePlanActivityCategory category;
    protected CodeableConcept code;
    protected CodeableConcept reasonCodeableConcept;
    protected Reference reasonReference;
    protected List<Reference> goal;
    protected CarePlanActivityStatus status;
    protected CodeableConcept statusReason;
    @XmlElement(required=true)
    protected Boolean prohibited;
    protected Timing scheduledTiming;
    protected Period scheduledPeriod;
    protected String scheduledString;
    protected Reference location;
    protected List<Reference> performer;
    protected Reference product;
    protected Quantity dailyAmount;
    protected Quantity quantity;
    protected String note;

    public CarePlanActivityCategory getCategory() {
        return this.category;
    }

    public void setCategory(CarePlanActivityCategory value) {
        this.category = value;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public void setCode(CodeableConcept value) {
        this.code = value;
    }

    public CodeableConcept getReasonCodeableConcept() {
        return this.reasonCodeableConcept;
    }

    public void setReasonCodeableConcept(CodeableConcept value) {
        this.reasonCodeableConcept = value;
    }

    public Reference getReasonReference() {
        return this.reasonReference;
    }

    public void setReasonReference(Reference value) {
        this.reasonReference = value;
    }

    public List<Reference> getGoal() {
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        return this.goal;
    }

    public CarePlanActivityStatus getStatus() {
        return this.status;
    }

    public void setStatus(CarePlanActivityStatus value) {
        this.status = value;
    }

    public CodeableConcept getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(CodeableConcept value) {
        this.statusReason = value;
    }

    public Boolean getProhibited() {
        return this.prohibited;
    }

    public void setProhibited(Boolean value) {
        this.prohibited = value;
    }

    public Timing getScheduledTiming() {
        return this.scheduledTiming;
    }

    public void setScheduledTiming(Timing value) {
        this.scheduledTiming = value;
    }

    public Period getScheduledPeriod() {
        return this.scheduledPeriod;
    }

    public void setScheduledPeriod(Period value) {
        this.scheduledPeriod = value;
    }

    public String getScheduledString() {
        return this.scheduledString;
    }

    public void setScheduledString(String value) {
        this.scheduledString = value;
    }

    public Reference getLocation() {
        return this.location;
    }

    public void setLocation(Reference value) {
        this.location = value;
    }

    public List<Reference> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        return this.performer;
    }

    public Reference getProduct() {
        return this.product;
    }

    public void setProduct(Reference value) {
        this.product = value;
    }

    public Quantity getDailyAmount() {
        return this.dailyAmount;
    }

    public void setDailyAmount(Quantity value) {
        this.dailyAmount = value;
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Quantity value) {
        this.quantity = value;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String value) {
        this.note = value;
    }

    public CarePlanDetail withCategory(CarePlanActivityCategory value) {
        this.setCategory(value);
        return this;
    }

    public CarePlanDetail withCode(CodeableConcept value) {
        this.setCode(value);
        return this;
    }

    public CarePlanDetail withReasonCodeableConcept(CodeableConcept value) {
        this.setReasonCodeableConcept(value);
        return this;
    }

    public CarePlanDetail withReasonReference(Reference value) {
        this.setReasonReference(value);
        return this;
    }

    public CarePlanDetail withGoal(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getGoal().add(value);
            }
        }
        return this;
    }

    public CarePlanDetail withGoal(Collection<Reference> values) {
        if (values != null) {
            this.getGoal().addAll(values);
        }
        return this;
    }

    public CarePlanDetail withStatus(CarePlanActivityStatus value) {
        this.setStatus(value);
        return this;
    }

    public CarePlanDetail withStatusReason(CodeableConcept value) {
        this.setStatusReason(value);
        return this;
    }

    public CarePlanDetail withProhibited(Boolean value) {
        this.setProhibited(value);
        return this;
    }

    public CarePlanDetail withScheduledTiming(Timing value) {
        this.setScheduledTiming(value);
        return this;
    }

    public CarePlanDetail withScheduledPeriod(Period value) {
        this.setScheduledPeriod(value);
        return this;
    }

    public CarePlanDetail withScheduledString(String value) {
        this.setScheduledString(value);
        return this;
    }

    public CarePlanDetail withLocation(Reference value) {
        this.setLocation(value);
        return this;
    }

    public CarePlanDetail withPerformer(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getPerformer().add(value);
            }
        }
        return this;
    }

    public CarePlanDetail withPerformer(Collection<Reference> values) {
        if (values != null) {
            this.getPerformer().addAll(values);
        }
        return this;
    }

    public CarePlanDetail withProduct(Reference value) {
        this.setProduct(value);
        return this;
    }

    public CarePlanDetail withDailyAmount(Quantity value) {
        this.setDailyAmount(value);
        return this;
    }

    public CarePlanDetail withQuantity(Quantity value) {
        this.setQuantity(value);
        return this;
    }

    public CarePlanDetail withNote(String value) {
        this.setNote(value);
        return this;
    }

    @Override
    public CarePlanDetail withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CarePlanDetail withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CarePlanDetail withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CarePlanDetail withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CarePlanDetail withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Reference> rhsPerformer;
        List<Reference> rhsGoal;
        if (!(object instanceof CarePlanDetail)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        CarePlanDetail that = (CarePlanDetail)object;
        CarePlanActivityCategory lhsCategory = this.getCategory();
        CarePlanActivityCategory rhsCategory = that.getCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"category", (Object)lhsCategory), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"category", (Object)rhsCategory), (Object)lhsCategory, (Object)rhsCategory)) {
            return false;
        }
        CodeableConcept lhsCode = this.getCode();
        CodeableConcept rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode)) {
            return false;
        }
        CodeableConcept lhsReasonCodeableConcept = this.getReasonCodeableConcept();
        CodeableConcept rhsReasonCodeableConcept = that.getReasonCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reasonCodeableConcept", (Object)lhsReasonCodeableConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reasonCodeableConcept", (Object)rhsReasonCodeableConcept), (Object)lhsReasonCodeableConcept, (Object)rhsReasonCodeableConcept)) {
            return false;
        }
        Reference lhsReasonReference = this.getReasonReference();
        Reference rhsReasonReference = that.getReasonReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reasonReference", (Object)lhsReasonReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reasonReference", (Object)rhsReasonReference), (Object)lhsReasonReference, (Object)rhsReasonReference)) {
            return false;
        }
        List<Reference> lhsGoal = this.goal != null && !this.goal.isEmpty() ? this.getGoal() : null;
        List<Reference> list = rhsGoal = that.goal != null && !that.goal.isEmpty() ? that.getGoal() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"goal", lhsGoal), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"goal", rhsGoal), lhsGoal, rhsGoal)) {
            return false;
        }
        CarePlanActivityStatus lhsStatus = this.getStatus();
        CarePlanActivityStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        CodeableConcept lhsStatusReason = this.getStatusReason();
        CodeableConcept rhsStatusReason = that.getStatusReason();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"statusReason", (Object)lhsStatusReason), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"statusReason", (Object)rhsStatusReason), (Object)lhsStatusReason, (Object)rhsStatusReason)) {
            return false;
        }
        Boolean lhsProhibited = this.getProhibited();
        Boolean rhsProhibited = that.getProhibited();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"prohibited", (Object)lhsProhibited), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"prohibited", (Object)rhsProhibited), (Object)lhsProhibited, (Object)rhsProhibited)) {
            return false;
        }
        Timing lhsScheduledTiming = this.getScheduledTiming();
        Timing rhsScheduledTiming = that.getScheduledTiming();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"scheduledTiming", (Object)lhsScheduledTiming), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"scheduledTiming", (Object)rhsScheduledTiming), (Object)lhsScheduledTiming, (Object)rhsScheduledTiming)) {
            return false;
        }
        Period lhsScheduledPeriod = this.getScheduledPeriod();
        Period rhsScheduledPeriod = that.getScheduledPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"scheduledPeriod", (Object)lhsScheduledPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"scheduledPeriod", (Object)rhsScheduledPeriod), (Object)lhsScheduledPeriod, (Object)rhsScheduledPeriod)) {
            return false;
        }
        String lhsScheduledString = this.getScheduledString();
        String rhsScheduledString = that.getScheduledString();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"scheduledString", (Object)lhsScheduledString), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"scheduledString", (Object)rhsScheduledString), (Object)lhsScheduledString, (Object)rhsScheduledString)) {
            return false;
        }
        Reference lhsLocation = this.getLocation();
        Reference rhsLocation = that.getLocation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"location", (Object)lhsLocation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"location", (Object)rhsLocation), (Object)lhsLocation, (Object)rhsLocation)) {
            return false;
        }
        List<Reference> lhsPerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        List<Reference> list2 = rhsPerformer = that.performer != null && !that.performer.isEmpty() ? that.getPerformer() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"performer", lhsPerformer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"performer", rhsPerformer), lhsPerformer, rhsPerformer)) {
            return false;
        }
        Reference lhsProduct = this.getProduct();
        Reference rhsProduct = that.getProduct();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"product", (Object)lhsProduct), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"product", (Object)rhsProduct), (Object)lhsProduct, (Object)rhsProduct)) {
            return false;
        }
        Quantity lhsDailyAmount = this.getDailyAmount();
        Quantity rhsDailyAmount = that.getDailyAmount();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dailyAmount", (Object)lhsDailyAmount), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dailyAmount", (Object)rhsDailyAmount), (Object)lhsDailyAmount, (Object)rhsDailyAmount)) {
            return false;
        }
        Quantity lhsQuantity = this.getQuantity();
        Quantity rhsQuantity = that.getQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"quantity", (Object)lhsQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"quantity", (Object)rhsQuantity), (Object)lhsQuantity, (Object)rhsQuantity)) {
            return false;
        }
        String lhsNote = this.getNote();
        String rhsNote = that.getNote();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"note", (Object)lhsNote), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"note", (Object)rhsNote), (Object)lhsNote, (Object)rhsNote);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CarePlanActivityCategory theCategory = this.getCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"category", (Object)theCategory), currentHashCode, (Object)theCategory);
        CodeableConcept theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"code", (Object)theCode), currentHashCode, (Object)theCode);
        CodeableConcept theReasonCodeableConcept = this.getReasonCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reasonCodeableConcept", (Object)theReasonCodeableConcept), currentHashCode, (Object)theReasonCodeableConcept);
        Reference theReasonReference = this.getReasonReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reasonReference", (Object)theReasonReference), currentHashCode, (Object)theReasonReference);
        List<Reference> theGoal = this.goal != null && !this.goal.isEmpty() ? this.getGoal() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"goal", theGoal), currentHashCode, theGoal);
        CarePlanActivityStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        CodeableConcept theStatusReason = this.getStatusReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"statusReason", (Object)theStatusReason), currentHashCode, (Object)theStatusReason);
        Boolean theProhibited = this.getProhibited();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"prohibited", (Object)theProhibited), currentHashCode, (Object)theProhibited);
        Timing theScheduledTiming = this.getScheduledTiming();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"scheduledTiming", (Object)theScheduledTiming), currentHashCode, (Object)theScheduledTiming);
        Period theScheduledPeriod = this.getScheduledPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"scheduledPeriod", (Object)theScheduledPeriod), currentHashCode, (Object)theScheduledPeriod);
        String theScheduledString = this.getScheduledString();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"scheduledString", (Object)theScheduledString), currentHashCode, (Object)theScheduledString);
        Reference theLocation = this.getLocation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"location", (Object)theLocation), currentHashCode, (Object)theLocation);
        List<Reference> thePerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"performer", thePerformer), currentHashCode, thePerformer);
        Reference theProduct = this.getProduct();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"product", (Object)theProduct), currentHashCode, (Object)theProduct);
        Quantity theDailyAmount = this.getDailyAmount();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dailyAmount", (Object)theDailyAmount), currentHashCode, (Object)theDailyAmount);
        Quantity theQuantity = this.getQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"quantity", (Object)theQuantity), currentHashCode, (Object)theQuantity);
        String theNote = this.getNote();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"note", (Object)theNote), currentHashCode, (Object)theNote);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        CarePlanActivityCategory theCategory = this.getCategory();
        strategy.appendField(locator, (Object)this, "category", buffer, (Object)theCategory);
        CodeableConcept theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode);
        CodeableConcept theReasonCodeableConcept = this.getReasonCodeableConcept();
        strategy.appendField(locator, (Object)this, "reasonCodeableConcept", buffer, (Object)theReasonCodeableConcept);
        Reference theReasonReference = this.getReasonReference();
        strategy.appendField(locator, (Object)this, "reasonReference", buffer, (Object)theReasonReference);
        List<Reference> theGoal = this.goal != null && !this.goal.isEmpty() ? this.getGoal() : null;
        strategy.appendField(locator, (Object)this, "goal", buffer, theGoal);
        CarePlanActivityStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        CodeableConcept theStatusReason = this.getStatusReason();
        strategy.appendField(locator, (Object)this, "statusReason", buffer, (Object)theStatusReason);
        Boolean theProhibited = this.getProhibited();
        strategy.appendField(locator, (Object)this, "prohibited", buffer, (Object)theProhibited);
        Timing theScheduledTiming = this.getScheduledTiming();
        strategy.appendField(locator, (Object)this, "scheduledTiming", buffer, (Object)theScheduledTiming);
        Period theScheduledPeriod = this.getScheduledPeriod();
        strategy.appendField(locator, (Object)this, "scheduledPeriod", buffer, (Object)theScheduledPeriod);
        String theScheduledString = this.getScheduledString();
        strategy.appendField(locator, (Object)this, "scheduledString", buffer, (Object)theScheduledString);
        Reference theLocation = this.getLocation();
        strategy.appendField(locator, (Object)this, "location", buffer, (Object)theLocation);
        List<Reference> thePerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        strategy.appendField(locator, (Object)this, "performer", buffer, thePerformer);
        Reference theProduct = this.getProduct();
        strategy.appendField(locator, (Object)this, "product", buffer, (Object)theProduct);
        Quantity theDailyAmount = this.getDailyAmount();
        strategy.appendField(locator, (Object)this, "dailyAmount", buffer, (Object)theDailyAmount);
        Quantity theQuantity = this.getQuantity();
        strategy.appendField(locator, (Object)this, "quantity", buffer, (Object)theQuantity);
        String theNote = this.getNote();
        strategy.appendField(locator, (Object)this, "note", buffer, (Object)theNote);
        return buffer;
    }
}

