/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.ClaimCoverage;
import org.hl7.fhir.ClaimDiagnosis;
import org.hl7.fhir.ClaimItem;
import org.hl7.fhir.ClaimMissingTeeth;
import org.hl7.fhir.ClaimPayee;
import org.hl7.fhir.ClaimType;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.Date;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.hl7.fhir.Use;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Claim", propOrder={"type", "identifier", "ruleset", "originalRuleset", "created", "target", "provider", "organization", "use", "priority", "fundsReserve", "enterer", "facility", "prescription", "originalPrescription", "payee", "referral", "diagnosis", "condition", "patient", "coverage", "exception", "school", "accident", "accidentType", "interventionException", "item", "additionalMaterials", "missingTeeth"})
public class Claim
extends DomainResource
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected ClaimType type;
    protected List<Identifier> identifier;
    protected Coding ruleset;
    protected Coding originalRuleset;
    protected DateTime created;
    protected Reference target;
    protected Reference provider;
    protected Reference organization;
    protected Use use;
    protected Coding priority;
    protected Coding fundsReserve;
    protected Reference enterer;
    protected Reference facility;
    protected Reference prescription;
    protected Reference originalPrescription;
    protected ClaimPayee payee;
    protected Reference referral;
    protected List<ClaimDiagnosis> diagnosis;
    protected List<Coding> condition;
    @XmlElement(required=true)
    protected Reference patient;
    protected List<ClaimCoverage> coverage;
    protected List<Coding> exception;
    protected String school;
    protected Date accident;
    protected Coding accidentType;
    protected List<Coding> interventionException;
    protected List<ClaimItem> item;
    protected List<Coding> additionalMaterials;
    protected List<ClaimMissingTeeth> missingTeeth;

    public ClaimType getType() {
        return this.type;
    }

    public void setType(ClaimType value) {
        this.type = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Coding getRuleset() {
        return this.ruleset;
    }

    public void setRuleset(Coding value) {
        this.ruleset = value;
    }

    public Coding getOriginalRuleset() {
        return this.originalRuleset;
    }

    public void setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime value) {
        this.created = value;
    }

    public Reference getTarget() {
        return this.target;
    }

    public void setTarget(Reference value) {
        this.target = value;
    }

    public Reference getProvider() {
        return this.provider;
    }

    public void setProvider(Reference value) {
        this.provider = value;
    }

    public Reference getOrganization() {
        return this.organization;
    }

    public void setOrganization(Reference value) {
        this.organization = value;
    }

    public Use getUse() {
        return this.use;
    }

    public void setUse(Use value) {
        this.use = value;
    }

    public Coding getPriority() {
        return this.priority;
    }

    public void setPriority(Coding value) {
        this.priority = value;
    }

    public Coding getFundsReserve() {
        return this.fundsReserve;
    }

    public void setFundsReserve(Coding value) {
        this.fundsReserve = value;
    }

    public Reference getEnterer() {
        return this.enterer;
    }

    public void setEnterer(Reference value) {
        this.enterer = value;
    }

    public Reference getFacility() {
        return this.facility;
    }

    public void setFacility(Reference value) {
        this.facility = value;
    }

    public Reference getPrescription() {
        return this.prescription;
    }

    public void setPrescription(Reference value) {
        this.prescription = value;
    }

    public Reference getOriginalPrescription() {
        return this.originalPrescription;
    }

    public void setOriginalPrescription(Reference value) {
        this.originalPrescription = value;
    }

    public ClaimPayee getPayee() {
        return this.payee;
    }

    public void setPayee(ClaimPayee value) {
        this.payee = value;
    }

    public Reference getReferral() {
        return this.referral;
    }

    public void setReferral(Reference value) {
        this.referral = value;
    }

    public List<ClaimDiagnosis> getDiagnosis() {
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<ClaimDiagnosis>();
        }
        return this.diagnosis;
    }

    public List<Coding> getCondition() {
        if (this.condition == null) {
            this.condition = new ArrayList<Coding>();
        }
        return this.condition;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public List<ClaimCoverage> getCoverage() {
        if (this.coverage == null) {
            this.coverage = new ArrayList<ClaimCoverage>();
        }
        return this.coverage;
    }

    public List<Coding> getException() {
        if (this.exception == null) {
            this.exception = new ArrayList<Coding>();
        }
        return this.exception;
    }

    public String getSchool() {
        return this.school;
    }

    public void setSchool(String value) {
        this.school = value;
    }

    public Date getAccident() {
        return this.accident;
    }

    public void setAccident(Date value) {
        this.accident = value;
    }

    public Coding getAccidentType() {
        return this.accidentType;
    }

    public void setAccidentType(Coding value) {
        this.accidentType = value;
    }

    public List<Coding> getInterventionException() {
        if (this.interventionException == null) {
            this.interventionException = new ArrayList<Coding>();
        }
        return this.interventionException;
    }

    public List<ClaimItem> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<ClaimItem>();
        }
        return this.item;
    }

    public List<Coding> getAdditionalMaterials() {
        if (this.additionalMaterials == null) {
            this.additionalMaterials = new ArrayList<Coding>();
        }
        return this.additionalMaterials;
    }

    public List<ClaimMissingTeeth> getMissingTeeth() {
        if (this.missingTeeth == null) {
            this.missingTeeth = new ArrayList<ClaimMissingTeeth>();
        }
        return this.missingTeeth;
    }

    public Claim withType(ClaimType value) {
        this.setType(value);
        return this;
    }

    public Claim withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Claim withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Claim withRuleset(Coding value) {
        this.setRuleset(value);
        return this;
    }

    public Claim withOriginalRuleset(Coding value) {
        this.setOriginalRuleset(value);
        return this;
    }

    public Claim withCreated(DateTime value) {
        this.setCreated(value);
        return this;
    }

    public Claim withTarget(Reference value) {
        this.setTarget(value);
        return this;
    }

    public Claim withProvider(Reference value) {
        this.setProvider(value);
        return this;
    }

    public Claim withOrganization(Reference value) {
        this.setOrganization(value);
        return this;
    }

    public Claim withUse(Use value) {
        this.setUse(value);
        return this;
    }

    public Claim withPriority(Coding value) {
        this.setPriority(value);
        return this;
    }

    public Claim withFundsReserve(Coding value) {
        this.setFundsReserve(value);
        return this;
    }

    public Claim withEnterer(Reference value) {
        this.setEnterer(value);
        return this;
    }

    public Claim withFacility(Reference value) {
        this.setFacility(value);
        return this;
    }

    public Claim withPrescription(Reference value) {
        this.setPrescription(value);
        return this;
    }

    public Claim withOriginalPrescription(Reference value) {
        this.setOriginalPrescription(value);
        return this;
    }

    public Claim withPayee(ClaimPayee value) {
        this.setPayee(value);
        return this;
    }

    public Claim withReferral(Reference value) {
        this.setReferral(value);
        return this;
    }

    public Claim withDiagnosis(ClaimDiagnosis ... values) {
        if (values != null) {
            for (ClaimDiagnosis value : values) {
                this.getDiagnosis().add(value);
            }
        }
        return this;
    }

    public Claim withDiagnosis(Collection<ClaimDiagnosis> values) {
        if (values != null) {
            this.getDiagnosis().addAll(values);
        }
        return this;
    }

    public Claim withCondition(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getCondition().add(value);
            }
        }
        return this;
    }

    public Claim withCondition(Collection<Coding> values) {
        if (values != null) {
            this.getCondition().addAll(values);
        }
        return this;
    }

    public Claim withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public Claim withCoverage(ClaimCoverage ... values) {
        if (values != null) {
            for (ClaimCoverage value : values) {
                this.getCoverage().add(value);
            }
        }
        return this;
    }

    public Claim withCoverage(Collection<ClaimCoverage> values) {
        if (values != null) {
            this.getCoverage().addAll(values);
        }
        return this;
    }

    public Claim withException(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getException().add(value);
            }
        }
        return this;
    }

    public Claim withException(Collection<Coding> values) {
        if (values != null) {
            this.getException().addAll(values);
        }
        return this;
    }

    public Claim withSchool(String value) {
        this.setSchool(value);
        return this;
    }

    public Claim withAccident(Date value) {
        this.setAccident(value);
        return this;
    }

    public Claim withAccidentType(Coding value) {
        this.setAccidentType(value);
        return this;
    }

    public Claim withInterventionException(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getInterventionException().add(value);
            }
        }
        return this;
    }

    public Claim withInterventionException(Collection<Coding> values) {
        if (values != null) {
            this.getInterventionException().addAll(values);
        }
        return this;
    }

    public Claim withItem(ClaimItem ... values) {
        if (values != null) {
            for (ClaimItem value : values) {
                this.getItem().add(value);
            }
        }
        return this;
    }

    public Claim withItem(Collection<ClaimItem> values) {
        if (values != null) {
            this.getItem().addAll(values);
        }
        return this;
    }

    public Claim withAdditionalMaterials(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getAdditionalMaterials().add(value);
            }
        }
        return this;
    }

    public Claim withAdditionalMaterials(Collection<Coding> values) {
        if (values != null) {
            this.getAdditionalMaterials().addAll(values);
        }
        return this;
    }

    public Claim withMissingTeeth(ClaimMissingTeeth ... values) {
        if (values != null) {
            for (ClaimMissingTeeth value : values) {
                this.getMissingTeeth().add(value);
            }
        }
        return this;
    }

    public Claim withMissingTeeth(Collection<ClaimMissingTeeth> values) {
        if (values != null) {
            this.getMissingTeeth().addAll(values);
        }
        return this;
    }

    @Override
    public Claim withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Claim withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Claim withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Claim withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Claim withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Claim withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Claim withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Claim withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Claim withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Claim withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Claim withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ClaimMissingTeeth> rhsMissingTeeth;
        List<Coding> rhsAdditionalMaterials;
        List<ClaimItem> rhsItem;
        List<Coding> rhsInterventionException;
        List<Coding> rhsException;
        List<ClaimCoverage> rhsCoverage;
        List<Coding> rhsCondition;
        List<ClaimDiagnosis> rhsDiagnosis;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof Claim)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Claim that = (Claim)object;
        ClaimType lhsType = this.getType();
        ClaimType rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        Coding lhsRuleset = this.getRuleset();
        Coding rhsRuleset = that.getRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"ruleset", (Object)lhsRuleset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"ruleset", (Object)rhsRuleset), (Object)lhsRuleset, (Object)rhsRuleset)) {
            return false;
        }
        Coding lhsOriginalRuleset = this.getOriginalRuleset();
        Coding rhsOriginalRuleset = that.getOriginalRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"originalRuleset", (Object)lhsOriginalRuleset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"originalRuleset", (Object)rhsOriginalRuleset), (Object)lhsOriginalRuleset, (Object)rhsOriginalRuleset)) {
            return false;
        }
        DateTime lhsCreated = this.getCreated();
        DateTime rhsCreated = that.getCreated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"created", (Object)lhsCreated), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"created", (Object)rhsCreated), (Object)lhsCreated, (Object)rhsCreated)) {
            return false;
        }
        Reference lhsTarget = this.getTarget();
        Reference rhsTarget = that.getTarget();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"target", (Object)lhsTarget), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"target", (Object)rhsTarget), (Object)lhsTarget, (Object)rhsTarget)) {
            return false;
        }
        Reference lhsProvider = this.getProvider();
        Reference rhsProvider = that.getProvider();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"provider", (Object)lhsProvider), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"provider", (Object)rhsProvider), (Object)lhsProvider, (Object)rhsProvider)) {
            return false;
        }
        Reference lhsOrganization = this.getOrganization();
        Reference rhsOrganization = that.getOrganization();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"organization", (Object)lhsOrganization), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"organization", (Object)rhsOrganization), (Object)lhsOrganization, (Object)rhsOrganization)) {
            return false;
        }
        Use lhsUse = this.getUse();
        Use rhsUse = that.getUse();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"use", (Object)lhsUse), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"use", (Object)rhsUse), (Object)lhsUse, (Object)rhsUse)) {
            return false;
        }
        Coding lhsPriority = this.getPriority();
        Coding rhsPriority = that.getPriority();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"priority", (Object)lhsPriority), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"priority", (Object)rhsPriority), (Object)lhsPriority, (Object)rhsPriority)) {
            return false;
        }
        Coding lhsFundsReserve = this.getFundsReserve();
        Coding rhsFundsReserve = that.getFundsReserve();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"fundsReserve", (Object)lhsFundsReserve), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"fundsReserve", (Object)rhsFundsReserve), (Object)lhsFundsReserve, (Object)rhsFundsReserve)) {
            return false;
        }
        Reference lhsEnterer = this.getEnterer();
        Reference rhsEnterer = that.getEnterer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"enterer", (Object)lhsEnterer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"enterer", (Object)rhsEnterer), (Object)lhsEnterer, (Object)rhsEnterer)) {
            return false;
        }
        Reference lhsFacility = this.getFacility();
        Reference rhsFacility = that.getFacility();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"facility", (Object)lhsFacility), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"facility", (Object)rhsFacility), (Object)lhsFacility, (Object)rhsFacility)) {
            return false;
        }
        Reference lhsPrescription = this.getPrescription();
        Reference rhsPrescription = that.getPrescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"prescription", (Object)lhsPrescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"prescription", (Object)rhsPrescription), (Object)lhsPrescription, (Object)rhsPrescription)) {
            return false;
        }
        Reference lhsOriginalPrescription = this.getOriginalPrescription();
        Reference rhsOriginalPrescription = that.getOriginalPrescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"originalPrescription", (Object)lhsOriginalPrescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"originalPrescription", (Object)rhsOriginalPrescription), (Object)lhsOriginalPrescription, (Object)rhsOriginalPrescription)) {
            return false;
        }
        ClaimPayee lhsPayee = this.getPayee();
        ClaimPayee rhsPayee = that.getPayee();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"payee", (Object)lhsPayee), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"payee", (Object)rhsPayee), (Object)lhsPayee, (Object)rhsPayee)) {
            return false;
        }
        Reference lhsReferral = this.getReferral();
        Reference rhsReferral = that.getReferral();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"referral", (Object)lhsReferral), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"referral", (Object)rhsReferral), (Object)lhsReferral, (Object)rhsReferral)) {
            return false;
        }
        List<ClaimDiagnosis> lhsDiagnosis = this.diagnosis != null && !this.diagnosis.isEmpty() ? this.getDiagnosis() : null;
        List<ClaimDiagnosis> list2 = rhsDiagnosis = that.diagnosis != null && !that.diagnosis.isEmpty() ? that.getDiagnosis() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"diagnosis", lhsDiagnosis), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"diagnosis", rhsDiagnosis), lhsDiagnosis, rhsDiagnosis)) {
            return false;
        }
        List<Coding> lhsCondition = this.condition != null && !this.condition.isEmpty() ? this.getCondition() : null;
        List<Coding> list3 = rhsCondition = that.condition != null && !that.condition.isEmpty() ? that.getCondition() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"condition", lhsCondition), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"condition", rhsCondition), lhsCondition, rhsCondition)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        List<ClaimCoverage> lhsCoverage = this.coverage != null && !this.coverage.isEmpty() ? this.getCoverage() : null;
        List<ClaimCoverage> list4 = rhsCoverage = that.coverage != null && !that.coverage.isEmpty() ? that.getCoverage() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"coverage", lhsCoverage), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"coverage", rhsCoverage), lhsCoverage, rhsCoverage)) {
            return false;
        }
        List<Coding> lhsException = this.exception != null && !this.exception.isEmpty() ? this.getException() : null;
        List<Coding> list5 = rhsException = that.exception != null && !that.exception.isEmpty() ? that.getException() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"exception", lhsException), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"exception", rhsException), lhsException, rhsException)) {
            return false;
        }
        String lhsSchool = this.getSchool();
        String rhsSchool = that.getSchool();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"school", (Object)lhsSchool), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"school", (Object)rhsSchool), (Object)lhsSchool, (Object)rhsSchool)) {
            return false;
        }
        Date lhsAccident = this.getAccident();
        Date rhsAccident = that.getAccident();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"accident", (Object)lhsAccident), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"accident", (Object)rhsAccident), (Object)lhsAccident, (Object)rhsAccident)) {
            return false;
        }
        Coding lhsAccidentType = this.getAccidentType();
        Coding rhsAccidentType = that.getAccidentType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"accidentType", (Object)lhsAccidentType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"accidentType", (Object)rhsAccidentType), (Object)lhsAccidentType, (Object)rhsAccidentType)) {
            return false;
        }
        List<Coding> lhsInterventionException = this.interventionException != null && !this.interventionException.isEmpty() ? this.getInterventionException() : null;
        List<Coding> list6 = rhsInterventionException = that.interventionException != null && !that.interventionException.isEmpty() ? that.getInterventionException() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"interventionException", lhsInterventionException), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"interventionException", rhsInterventionException), lhsInterventionException, rhsInterventionException)) {
            return false;
        }
        List<ClaimItem> lhsItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        List<ClaimItem> list7 = rhsItem = that.item != null && !that.item.isEmpty() ? that.getItem() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"item", lhsItem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"item", rhsItem), lhsItem, rhsItem)) {
            return false;
        }
        List<Coding> lhsAdditionalMaterials = this.additionalMaterials != null && !this.additionalMaterials.isEmpty() ? this.getAdditionalMaterials() : null;
        List<Coding> list8 = rhsAdditionalMaterials = that.additionalMaterials != null && !that.additionalMaterials.isEmpty() ? that.getAdditionalMaterials() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"additionalMaterials", lhsAdditionalMaterials), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"additionalMaterials", rhsAdditionalMaterials), lhsAdditionalMaterials, rhsAdditionalMaterials)) {
            return false;
        }
        List<ClaimMissingTeeth> lhsMissingTeeth = this.missingTeeth != null && !this.missingTeeth.isEmpty() ? this.getMissingTeeth() : null;
        List<ClaimMissingTeeth> list9 = rhsMissingTeeth = that.missingTeeth != null && !that.missingTeeth.isEmpty() ? that.getMissingTeeth() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"missingTeeth", lhsMissingTeeth), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"missingTeeth", rhsMissingTeeth), lhsMissingTeeth, rhsMissingTeeth);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        ClaimType theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        Coding theRuleset = this.getRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"ruleset", (Object)theRuleset), currentHashCode, (Object)theRuleset);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"originalRuleset", (Object)theOriginalRuleset), currentHashCode, (Object)theOriginalRuleset);
        DateTime theCreated = this.getCreated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"created", (Object)theCreated), currentHashCode, (Object)theCreated);
        Reference theTarget = this.getTarget();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"target", (Object)theTarget), currentHashCode, (Object)theTarget);
        Reference theProvider = this.getProvider();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"provider", (Object)theProvider), currentHashCode, (Object)theProvider);
        Reference theOrganization = this.getOrganization();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"organization", (Object)theOrganization), currentHashCode, (Object)theOrganization);
        Use theUse = this.getUse();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"use", (Object)theUse), currentHashCode, (Object)theUse);
        Coding thePriority = this.getPriority();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"priority", (Object)thePriority), currentHashCode, (Object)thePriority);
        Coding theFundsReserve = this.getFundsReserve();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"fundsReserve", (Object)theFundsReserve), currentHashCode, (Object)theFundsReserve);
        Reference theEnterer = this.getEnterer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"enterer", (Object)theEnterer), currentHashCode, (Object)theEnterer);
        Reference theFacility = this.getFacility();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"facility", (Object)theFacility), currentHashCode, (Object)theFacility);
        Reference thePrescription = this.getPrescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"prescription", (Object)thePrescription), currentHashCode, (Object)thePrescription);
        Reference theOriginalPrescription = this.getOriginalPrescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"originalPrescription", (Object)theOriginalPrescription), currentHashCode, (Object)theOriginalPrescription);
        ClaimPayee thePayee = this.getPayee();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"payee", (Object)thePayee), currentHashCode, (Object)thePayee);
        Reference theReferral = this.getReferral();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"referral", (Object)theReferral), currentHashCode, (Object)theReferral);
        List<ClaimDiagnosis> theDiagnosis = this.diagnosis != null && !this.diagnosis.isEmpty() ? this.getDiagnosis() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"diagnosis", theDiagnosis), currentHashCode, theDiagnosis);
        List<Coding> theCondition = this.condition != null && !this.condition.isEmpty() ? this.getCondition() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"condition", theCondition), currentHashCode, theCondition);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        List<ClaimCoverage> theCoverage = this.coverage != null && !this.coverage.isEmpty() ? this.getCoverage() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"coverage", theCoverage), currentHashCode, theCoverage);
        List<Coding> theException = this.exception != null && !this.exception.isEmpty() ? this.getException() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"exception", theException), currentHashCode, theException);
        String theSchool = this.getSchool();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"school", (Object)theSchool), currentHashCode, (Object)theSchool);
        Date theAccident = this.getAccident();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"accident", (Object)theAccident), currentHashCode, (Object)theAccident);
        Coding theAccidentType = this.getAccidentType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"accidentType", (Object)theAccidentType), currentHashCode, (Object)theAccidentType);
        List<Coding> theInterventionException = this.interventionException != null && !this.interventionException.isEmpty() ? this.getInterventionException() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"interventionException", theInterventionException), currentHashCode, theInterventionException);
        List<ClaimItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"item", theItem), currentHashCode, theItem);
        List<Coding> theAdditionalMaterials = this.additionalMaterials != null && !this.additionalMaterials.isEmpty() ? this.getAdditionalMaterials() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"additionalMaterials", theAdditionalMaterials), currentHashCode, theAdditionalMaterials);
        List<ClaimMissingTeeth> theMissingTeeth = this.missingTeeth != null && !this.missingTeeth.isEmpty() ? this.getMissingTeeth() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"missingTeeth", theMissingTeeth), currentHashCode, theMissingTeeth);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        ClaimType theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        Coding theRuleset = this.getRuleset();
        strategy.appendField(locator, (Object)this, "ruleset", buffer, (Object)theRuleset);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        strategy.appendField(locator, (Object)this, "originalRuleset", buffer, (Object)theOriginalRuleset);
        DateTime theCreated = this.getCreated();
        strategy.appendField(locator, (Object)this, "created", buffer, (Object)theCreated);
        Reference theTarget = this.getTarget();
        strategy.appendField(locator, (Object)this, "target", buffer, (Object)theTarget);
        Reference theProvider = this.getProvider();
        strategy.appendField(locator, (Object)this, "provider", buffer, (Object)theProvider);
        Reference theOrganization = this.getOrganization();
        strategy.appendField(locator, (Object)this, "organization", buffer, (Object)theOrganization);
        Use theUse = this.getUse();
        strategy.appendField(locator, (Object)this, "use", buffer, (Object)theUse);
        Coding thePriority = this.getPriority();
        strategy.appendField(locator, (Object)this, "priority", buffer, (Object)thePriority);
        Coding theFundsReserve = this.getFundsReserve();
        strategy.appendField(locator, (Object)this, "fundsReserve", buffer, (Object)theFundsReserve);
        Reference theEnterer = this.getEnterer();
        strategy.appendField(locator, (Object)this, "enterer", buffer, (Object)theEnterer);
        Reference theFacility = this.getFacility();
        strategy.appendField(locator, (Object)this, "facility", buffer, (Object)theFacility);
        Reference thePrescription = this.getPrescription();
        strategy.appendField(locator, (Object)this, "prescription", buffer, (Object)thePrescription);
        Reference theOriginalPrescription = this.getOriginalPrescription();
        strategy.appendField(locator, (Object)this, "originalPrescription", buffer, (Object)theOriginalPrescription);
        ClaimPayee thePayee = this.getPayee();
        strategy.appendField(locator, (Object)this, "payee", buffer, (Object)thePayee);
        Reference theReferral = this.getReferral();
        strategy.appendField(locator, (Object)this, "referral", buffer, (Object)theReferral);
        List<ClaimDiagnosis> theDiagnosis = this.diagnosis != null && !this.diagnosis.isEmpty() ? this.getDiagnosis() : null;
        strategy.appendField(locator, (Object)this, "diagnosis", buffer, theDiagnosis);
        List<Coding> theCondition = this.condition != null && !this.condition.isEmpty() ? this.getCondition() : null;
        strategy.appendField(locator, (Object)this, "condition", buffer, theCondition);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        List<ClaimCoverage> theCoverage = this.coverage != null && !this.coverage.isEmpty() ? this.getCoverage() : null;
        strategy.appendField(locator, (Object)this, "coverage", buffer, theCoverage);
        List<Coding> theException = this.exception != null && !this.exception.isEmpty() ? this.getException() : null;
        strategy.appendField(locator, (Object)this, "exception", buffer, theException);
        String theSchool = this.getSchool();
        strategy.appendField(locator, (Object)this, "school", buffer, (Object)theSchool);
        Date theAccident = this.getAccident();
        strategy.appendField(locator, (Object)this, "accident", buffer, (Object)theAccident);
        Coding theAccidentType = this.getAccidentType();
        strategy.appendField(locator, (Object)this, "accidentType", buffer, (Object)theAccidentType);
        List<Coding> theInterventionException = this.interventionException != null && !this.interventionException.isEmpty() ? this.getInterventionException() : null;
        strategy.appendField(locator, (Object)this, "interventionException", buffer, theInterventionException);
        List<ClaimItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        strategy.appendField(locator, (Object)this, "item", buffer, theItem);
        List<Coding> theAdditionalMaterials = this.additionalMaterials != null && !this.additionalMaterials.isEmpty() ? this.getAdditionalMaterials() : null;
        strategy.appendField(locator, (Object)this, "additionalMaterials", buffer, theAdditionalMaterials);
        List<ClaimMissingTeeth> theMissingTeeth = this.missingTeeth != null && !this.missingTeeth.isEmpty() ? this.getMissingTeeth() : null;
        strategy.appendField(locator, (Object)this, "missingTeeth", buffer, theMissingTeeth);
        return buffer;
    }
}

