/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.ClaimDetail;
import org.hl7.fhir.ClaimProsthesis;
import org.hl7.fhir.Coding;
import org.hl7.fhir.Date;
import org.hl7.fhir.Decimal;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Money;
import org.hl7.fhir.PositiveInt;
import org.hl7.fhir.Quantity;
import org.hl7.fhir.Reference;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Claim.Item", propOrder={"sequence", "type", "provider", "diagnosisLinkId", "service", "serviceDate", "quantity", "unitPrice", "factor", "points", "net", "udi", "bodySite", "subSite", "modifier", "detail", "prosthesis"})
public class ClaimItem
extends BackboneElement
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected PositiveInt sequence;
    @XmlElement(required=true)
    protected Coding type;
    protected Reference provider;
    protected List<PositiveInt> diagnosisLinkId;
    @XmlElement(required=true)
    protected Coding service;
    protected Date serviceDate;
    protected Quantity quantity;
    protected Money unitPrice;
    protected Decimal factor;
    protected Decimal points;
    protected Money net;
    protected Coding udi;
    protected Coding bodySite;
    protected List<Coding> subSite;
    protected List<Coding> modifier;
    protected List<ClaimDetail> detail;
    protected ClaimProsthesis prosthesis;

    public PositiveInt getSequence() {
        return this.sequence;
    }

    public void setSequence(PositiveInt value) {
        this.sequence = value;
    }

    public Coding getType() {
        return this.type;
    }

    public void setType(Coding value) {
        this.type = value;
    }

    public Reference getProvider() {
        return this.provider;
    }

    public void setProvider(Reference value) {
        this.provider = value;
    }

    public List<PositiveInt> getDiagnosisLinkId() {
        if (this.diagnosisLinkId == null) {
            this.diagnosisLinkId = new ArrayList<PositiveInt>();
        }
        return this.diagnosisLinkId;
    }

    public Coding getService() {
        return this.service;
    }

    public void setService(Coding value) {
        this.service = value;
    }

    public Date getServiceDate() {
        return this.serviceDate;
    }

    public void setServiceDate(Date value) {
        this.serviceDate = value;
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Quantity value) {
        this.quantity = value;
    }

    public Money getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(Money value) {
        this.unitPrice = value;
    }

    public Decimal getFactor() {
        return this.factor;
    }

    public void setFactor(Decimal value) {
        this.factor = value;
    }

    public Decimal getPoints() {
        return this.points;
    }

    public void setPoints(Decimal value) {
        this.points = value;
    }

    public Money getNet() {
        return this.net;
    }

    public void setNet(Money value) {
        this.net = value;
    }

    public Coding getUdi() {
        return this.udi;
    }

    public void setUdi(Coding value) {
        this.udi = value;
    }

    public Coding getBodySite() {
        return this.bodySite;
    }

    public void setBodySite(Coding value) {
        this.bodySite = value;
    }

    public List<Coding> getSubSite() {
        if (this.subSite == null) {
            this.subSite = new ArrayList<Coding>();
        }
        return this.subSite;
    }

    public List<Coding> getModifier() {
        if (this.modifier == null) {
            this.modifier = new ArrayList<Coding>();
        }
        return this.modifier;
    }

    public List<ClaimDetail> getDetail() {
        if (this.detail == null) {
            this.detail = new ArrayList<ClaimDetail>();
        }
        return this.detail;
    }

    public ClaimProsthesis getProsthesis() {
        return this.prosthesis;
    }

    public void setProsthesis(ClaimProsthesis value) {
        this.prosthesis = value;
    }

    public ClaimItem withSequence(PositiveInt value) {
        this.setSequence(value);
        return this;
    }

    public ClaimItem withType(Coding value) {
        this.setType(value);
        return this;
    }

    public ClaimItem withProvider(Reference value) {
        this.setProvider(value);
        return this;
    }

    public ClaimItem withDiagnosisLinkId(PositiveInt ... values) {
        if (values != null) {
            for (PositiveInt value : values) {
                this.getDiagnosisLinkId().add(value);
            }
        }
        return this;
    }

    public ClaimItem withDiagnosisLinkId(Collection<PositiveInt> values) {
        if (values != null) {
            this.getDiagnosisLinkId().addAll(values);
        }
        return this;
    }

    public ClaimItem withService(Coding value) {
        this.setService(value);
        return this;
    }

    public ClaimItem withServiceDate(Date value) {
        this.setServiceDate(value);
        return this;
    }

    public ClaimItem withQuantity(Quantity value) {
        this.setQuantity(value);
        return this;
    }

    public ClaimItem withUnitPrice(Money value) {
        this.setUnitPrice(value);
        return this;
    }

    public ClaimItem withFactor(Decimal value) {
        this.setFactor(value);
        return this;
    }

    public ClaimItem withPoints(Decimal value) {
        this.setPoints(value);
        return this;
    }

    public ClaimItem withNet(Money value) {
        this.setNet(value);
        return this;
    }

    public ClaimItem withUdi(Coding value) {
        this.setUdi(value);
        return this;
    }

    public ClaimItem withBodySite(Coding value) {
        this.setBodySite(value);
        return this;
    }

    public ClaimItem withSubSite(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getSubSite().add(value);
            }
        }
        return this;
    }

    public ClaimItem withSubSite(Collection<Coding> values) {
        if (values != null) {
            this.getSubSite().addAll(values);
        }
        return this;
    }

    public ClaimItem withModifier(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getModifier().add(value);
            }
        }
        return this;
    }

    public ClaimItem withModifier(Collection<Coding> values) {
        if (values != null) {
            this.getModifier().addAll(values);
        }
        return this;
    }

    public ClaimItem withDetail(ClaimDetail ... values) {
        if (values != null) {
            for (ClaimDetail value : values) {
                this.getDetail().add(value);
            }
        }
        return this;
    }

    public ClaimItem withDetail(Collection<ClaimDetail> values) {
        if (values != null) {
            this.getDetail().addAll(values);
        }
        return this;
    }

    public ClaimItem withProsthesis(ClaimProsthesis value) {
        this.setProsthesis(value);
        return this;
    }

    @Override
    public ClaimItem withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ClaimItem withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ClaimItem withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ClaimItem withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ClaimItem withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ClaimDetail> rhsDetail;
        List<Coding> rhsModifier;
        List<Coding> rhsSubSite;
        List<PositiveInt> rhsDiagnosisLinkId;
        if (!(object instanceof ClaimItem)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ClaimItem that = (ClaimItem)object;
        PositiveInt lhsSequence = this.getSequence();
        PositiveInt rhsSequence = that.getSequence();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"sequence", (Object)lhsSequence), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"sequence", (Object)rhsSequence), (Object)lhsSequence, (Object)rhsSequence)) {
            return false;
        }
        Coding lhsType = this.getType();
        Coding rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        Reference lhsProvider = this.getProvider();
        Reference rhsProvider = that.getProvider();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"provider", (Object)lhsProvider), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"provider", (Object)rhsProvider), (Object)lhsProvider, (Object)rhsProvider)) {
            return false;
        }
        List<PositiveInt> lhsDiagnosisLinkId = this.diagnosisLinkId != null && !this.diagnosisLinkId.isEmpty() ? this.getDiagnosisLinkId() : null;
        List<PositiveInt> list = rhsDiagnosisLinkId = that.diagnosisLinkId != null && !that.diagnosisLinkId.isEmpty() ? that.getDiagnosisLinkId() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"diagnosisLinkId", lhsDiagnosisLinkId), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"diagnosisLinkId", rhsDiagnosisLinkId), lhsDiagnosisLinkId, rhsDiagnosisLinkId)) {
            return false;
        }
        Coding lhsService = this.getService();
        Coding rhsService = that.getService();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"service", (Object)lhsService), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"service", (Object)rhsService), (Object)lhsService, (Object)rhsService)) {
            return false;
        }
        Date lhsServiceDate = this.getServiceDate();
        Date rhsServiceDate = that.getServiceDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"serviceDate", (Object)lhsServiceDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"serviceDate", (Object)rhsServiceDate), (Object)lhsServiceDate, (Object)rhsServiceDate)) {
            return false;
        }
        Quantity lhsQuantity = this.getQuantity();
        Quantity rhsQuantity = that.getQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"quantity", (Object)lhsQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"quantity", (Object)rhsQuantity), (Object)lhsQuantity, (Object)rhsQuantity)) {
            return false;
        }
        Money lhsUnitPrice = this.getUnitPrice();
        Money rhsUnitPrice = that.getUnitPrice();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"unitPrice", (Object)lhsUnitPrice), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"unitPrice", (Object)rhsUnitPrice), (Object)lhsUnitPrice, (Object)rhsUnitPrice)) {
            return false;
        }
        Decimal lhsFactor = this.getFactor();
        Decimal rhsFactor = that.getFactor();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"factor", (Object)lhsFactor), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"factor", (Object)rhsFactor), (Object)lhsFactor, (Object)rhsFactor)) {
            return false;
        }
        Decimal lhsPoints = this.getPoints();
        Decimal rhsPoints = that.getPoints();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"points", (Object)lhsPoints), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"points", (Object)rhsPoints), (Object)lhsPoints, (Object)rhsPoints)) {
            return false;
        }
        Money lhsNet = this.getNet();
        Money rhsNet = that.getNet();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"net", (Object)lhsNet), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"net", (Object)rhsNet), (Object)lhsNet, (Object)rhsNet)) {
            return false;
        }
        Coding lhsUdi = this.getUdi();
        Coding rhsUdi = that.getUdi();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"udi", (Object)lhsUdi), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"udi", (Object)rhsUdi), (Object)lhsUdi, (Object)rhsUdi)) {
            return false;
        }
        Coding lhsBodySite = this.getBodySite();
        Coding rhsBodySite = that.getBodySite();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"bodySite", (Object)lhsBodySite), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"bodySite", (Object)rhsBodySite), (Object)lhsBodySite, (Object)rhsBodySite)) {
            return false;
        }
        List<Coding> lhsSubSite = this.subSite != null && !this.subSite.isEmpty() ? this.getSubSite() : null;
        List<Coding> list2 = rhsSubSite = that.subSite != null && !that.subSite.isEmpty() ? that.getSubSite() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"subSite", lhsSubSite), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"subSite", rhsSubSite), lhsSubSite, rhsSubSite)) {
            return false;
        }
        List<Coding> lhsModifier = this.modifier != null && !this.modifier.isEmpty() ? this.getModifier() : null;
        List<Coding> list3 = rhsModifier = that.modifier != null && !that.modifier.isEmpty() ? that.getModifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"modifier", lhsModifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"modifier", rhsModifier), lhsModifier, rhsModifier)) {
            return false;
        }
        List<ClaimDetail> lhsDetail = this.detail != null && !this.detail.isEmpty() ? this.getDetail() : null;
        List<ClaimDetail> list4 = rhsDetail = that.detail != null && !that.detail.isEmpty() ? that.getDetail() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"detail", lhsDetail), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"detail", rhsDetail), lhsDetail, rhsDetail)) {
            return false;
        }
        ClaimProsthesis lhsProsthesis = this.getProsthesis();
        ClaimProsthesis rhsProsthesis = that.getProsthesis();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"prosthesis", (Object)lhsProsthesis), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"prosthesis", (Object)rhsProsthesis), (Object)lhsProsthesis, (Object)rhsProsthesis);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        PositiveInt theSequence = this.getSequence();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"sequence", (Object)theSequence), currentHashCode, (Object)theSequence);
        Coding theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"type", (Object)theType), currentHashCode, (Object)theType);
        Reference theProvider = this.getProvider();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"provider", (Object)theProvider), currentHashCode, (Object)theProvider);
        List<PositiveInt> theDiagnosisLinkId = this.diagnosisLinkId != null && !this.diagnosisLinkId.isEmpty() ? this.getDiagnosisLinkId() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"diagnosisLinkId", theDiagnosisLinkId), currentHashCode, theDiagnosisLinkId);
        Coding theService = this.getService();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"service", (Object)theService), currentHashCode, (Object)theService);
        Date theServiceDate = this.getServiceDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"serviceDate", (Object)theServiceDate), currentHashCode, (Object)theServiceDate);
        Quantity theQuantity = this.getQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"quantity", (Object)theQuantity), currentHashCode, (Object)theQuantity);
        Money theUnitPrice = this.getUnitPrice();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"unitPrice", (Object)theUnitPrice), currentHashCode, (Object)theUnitPrice);
        Decimal theFactor = this.getFactor();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"factor", (Object)theFactor), currentHashCode, (Object)theFactor);
        Decimal thePoints = this.getPoints();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"points", (Object)thePoints), currentHashCode, (Object)thePoints);
        Money theNet = this.getNet();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"net", (Object)theNet), currentHashCode, (Object)theNet);
        Coding theUdi = this.getUdi();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"udi", (Object)theUdi), currentHashCode, (Object)theUdi);
        Coding theBodySite = this.getBodySite();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"bodySite", (Object)theBodySite), currentHashCode, (Object)theBodySite);
        List<Coding> theSubSite = this.subSite != null && !this.subSite.isEmpty() ? this.getSubSite() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"subSite", theSubSite), currentHashCode, theSubSite);
        List<Coding> theModifier = this.modifier != null && !this.modifier.isEmpty() ? this.getModifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"modifier", theModifier), currentHashCode, theModifier);
        List<ClaimDetail> theDetail = this.detail != null && !this.detail.isEmpty() ? this.getDetail() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"detail", theDetail), currentHashCode, theDetail);
        ClaimProsthesis theProsthesis = this.getProsthesis();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"prosthesis", (Object)theProsthesis), currentHashCode, (Object)theProsthesis);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        PositiveInt theSequence = this.getSequence();
        strategy.appendField(locator, (Object)this, "sequence", buffer, (Object)theSequence);
        Coding theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        Reference theProvider = this.getProvider();
        strategy.appendField(locator, (Object)this, "provider", buffer, (Object)theProvider);
        List<PositiveInt> theDiagnosisLinkId = this.diagnosisLinkId != null && !this.diagnosisLinkId.isEmpty() ? this.getDiagnosisLinkId() : null;
        strategy.appendField(locator, (Object)this, "diagnosisLinkId", buffer, theDiagnosisLinkId);
        Coding theService = this.getService();
        strategy.appendField(locator, (Object)this, "service", buffer, (Object)theService);
        Date theServiceDate = this.getServiceDate();
        strategy.appendField(locator, (Object)this, "serviceDate", buffer, (Object)theServiceDate);
        Quantity theQuantity = this.getQuantity();
        strategy.appendField(locator, (Object)this, "quantity", buffer, (Object)theQuantity);
        Money theUnitPrice = this.getUnitPrice();
        strategy.appendField(locator, (Object)this, "unitPrice", buffer, (Object)theUnitPrice);
        Decimal theFactor = this.getFactor();
        strategy.appendField(locator, (Object)this, "factor", buffer, (Object)theFactor);
        Decimal thePoints = this.getPoints();
        strategy.appendField(locator, (Object)this, "points", buffer, (Object)thePoints);
        Money theNet = this.getNet();
        strategy.appendField(locator, (Object)this, "net", buffer, (Object)theNet);
        Coding theUdi = this.getUdi();
        strategy.appendField(locator, (Object)this, "udi", buffer, (Object)theUdi);
        Coding theBodySite = this.getBodySite();
        strategy.appendField(locator, (Object)this, "bodySite", buffer, (Object)theBodySite);
        List<Coding> theSubSite = this.subSite != null && !this.subSite.isEmpty() ? this.getSubSite() : null;
        strategy.appendField(locator, (Object)this, "subSite", buffer, theSubSite);
        List<Coding> theModifier = this.modifier != null && !this.modifier.isEmpty() ? this.getModifier() : null;
        strategy.appendField(locator, (Object)this, "modifier", buffer, theModifier);
        List<ClaimDetail> theDetail = this.detail != null && !this.detail.isEmpty() ? this.getDetail() : null;
        strategy.appendField(locator, (Object)this, "detail", buffer, theDetail);
        ClaimProsthesis theProsthesis = this.getProsthesis();
        strategy.appendField(locator, (Object)this, "prosthesis", buffer, (Object)theProsthesis);
        return buffer;
    }
}

