/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Code;
import org.hl7.fhir.ConceptMapDependsOn;
import org.hl7.fhir.ConceptMapMap;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ConceptMap.Element", propOrder={"codeSystem", "code", "dependsOn", "map"})
public class ConceptMapElement
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected Uri codeSystem;
    protected Code code;
    protected List<ConceptMapDependsOn> dependsOn;
    protected List<ConceptMapMap> map;

    public Uri getCodeSystem() {
        return this.codeSystem;
    }

    public void setCodeSystem(Uri value) {
        this.codeSystem = value;
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code value) {
        this.code = value;
    }

    public List<ConceptMapDependsOn> getDependsOn() {
        if (this.dependsOn == null) {
            this.dependsOn = new ArrayList<ConceptMapDependsOn>();
        }
        return this.dependsOn;
    }

    public List<ConceptMapMap> getMap() {
        if (this.map == null) {
            this.map = new ArrayList<ConceptMapMap>();
        }
        return this.map;
    }

    public ConceptMapElement withCodeSystem(Uri value) {
        this.setCodeSystem(value);
        return this;
    }

    public ConceptMapElement withCode(Code value) {
        this.setCode(value);
        return this;
    }

    public ConceptMapElement withDependsOn(ConceptMapDependsOn ... values) {
        if (values != null) {
            for (ConceptMapDependsOn value : values) {
                this.getDependsOn().add(value);
            }
        }
        return this;
    }

    public ConceptMapElement withDependsOn(Collection<ConceptMapDependsOn> values) {
        if (values != null) {
            this.getDependsOn().addAll(values);
        }
        return this;
    }

    public ConceptMapElement withMap(ConceptMapMap ... values) {
        if (values != null) {
            for (ConceptMapMap value : values) {
                this.getMap().add(value);
            }
        }
        return this;
    }

    public ConceptMapElement withMap(Collection<ConceptMapMap> values) {
        if (values != null) {
            this.getMap().addAll(values);
        }
        return this;
    }

    @Override
    public ConceptMapElement withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConceptMapElement withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConceptMapElement withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConceptMapElement withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConceptMapElement withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ConceptMapMap> rhsMap;
        List<ConceptMapDependsOn> rhsDependsOn;
        if (!(object instanceof ConceptMapElement)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ConceptMapElement that = (ConceptMapElement)object;
        Uri lhsCodeSystem = this.getCodeSystem();
        Uri rhsCodeSystem = that.getCodeSystem();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"codeSystem", (Object)lhsCodeSystem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"codeSystem", (Object)rhsCodeSystem), (Object)lhsCodeSystem, (Object)rhsCodeSystem)) {
            return false;
        }
        Code lhsCode = this.getCode();
        Code rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode)) {
            return false;
        }
        List<ConceptMapDependsOn> lhsDependsOn = this.dependsOn != null && !this.dependsOn.isEmpty() ? this.getDependsOn() : null;
        List<ConceptMapDependsOn> list = rhsDependsOn = that.dependsOn != null && !that.dependsOn.isEmpty() ? that.getDependsOn() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dependsOn", lhsDependsOn), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dependsOn", rhsDependsOn), lhsDependsOn, rhsDependsOn)) {
            return false;
        }
        List<ConceptMapMap> lhsMap = this.map != null && !this.map.isEmpty() ? this.getMap() : null;
        List<ConceptMapMap> list2 = rhsMap = that.map != null && !that.map.isEmpty() ? that.getMap() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"map", lhsMap), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"map", rhsMap), lhsMap, rhsMap);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theCodeSystem = this.getCodeSystem();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"codeSystem", (Object)theCodeSystem), currentHashCode, (Object)theCodeSystem);
        Code theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"code", (Object)theCode), currentHashCode, (Object)theCode);
        List<ConceptMapDependsOn> theDependsOn = this.dependsOn != null && !this.dependsOn.isEmpty() ? this.getDependsOn() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dependsOn", theDependsOn), currentHashCode, theDependsOn);
        List<ConceptMapMap> theMap = this.map != null && !this.map.isEmpty() ? this.getMap() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"map", theMap), currentHashCode, theMap);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theCodeSystem = this.getCodeSystem();
        strategy.appendField(locator, (Object)this, "codeSystem", buffer, (Object)theCodeSystem);
        Code theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode);
        List<ConceptMapDependsOn> theDependsOn = this.dependsOn != null && !this.dependsOn.isEmpty() ? this.getDependsOn() : null;
        strategy.appendField(locator, (Object)this, "dependsOn", buffer, theDependsOn);
        List<ConceptMapMap> theMap = this.map != null && !this.map.isEmpty() ? this.getMap() : null;
        strategy.appendField(locator, (Object)this, "map", buffer, theMap);
        return buffer;
    }
}

