/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Code;
import org.hl7.fhir.ConceptMapDependsOn;
import org.hl7.fhir.ConceptMapEquivalence;
import org.hl7.fhir.Extension;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ConceptMap.Map", propOrder={"codeSystem", "code", "equivalence", "comments", "product"})
public class ConceptMapMap
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected Uri codeSystem;
    protected Code code;
    @XmlElement(required=true)
    protected ConceptMapEquivalence equivalence;
    protected String comments;
    protected List<ConceptMapDependsOn> product;

    public Uri getCodeSystem() {
        return this.codeSystem;
    }

    public void setCodeSystem(Uri value) {
        this.codeSystem = value;
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code value) {
        this.code = value;
    }

    public ConceptMapEquivalence getEquivalence() {
        return this.equivalence;
    }

    public void setEquivalence(ConceptMapEquivalence value) {
        this.equivalence = value;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String value) {
        this.comments = value;
    }

    public List<ConceptMapDependsOn> getProduct() {
        if (this.product == null) {
            this.product = new ArrayList<ConceptMapDependsOn>();
        }
        return this.product;
    }

    public ConceptMapMap withCodeSystem(Uri value) {
        this.setCodeSystem(value);
        return this;
    }

    public ConceptMapMap withCode(Code value) {
        this.setCode(value);
        return this;
    }

    public ConceptMapMap withEquivalence(ConceptMapEquivalence value) {
        this.setEquivalence(value);
        return this;
    }

    public ConceptMapMap withComments(String value) {
        this.setComments(value);
        return this;
    }

    public ConceptMapMap withProduct(ConceptMapDependsOn ... values) {
        if (values != null) {
            for (ConceptMapDependsOn value : values) {
                this.getProduct().add(value);
            }
        }
        return this;
    }

    public ConceptMapMap withProduct(Collection<ConceptMapDependsOn> values) {
        if (values != null) {
            this.getProduct().addAll(values);
        }
        return this;
    }

    @Override
    public ConceptMapMap withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConceptMapMap withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConceptMapMap withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConceptMapMap withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConceptMapMap withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ConceptMapDependsOn> rhsProduct;
        if (!(object instanceof ConceptMapMap)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ConceptMapMap that = (ConceptMapMap)object;
        Uri lhsCodeSystem = this.getCodeSystem();
        Uri rhsCodeSystem = that.getCodeSystem();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"codeSystem", (Object)lhsCodeSystem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"codeSystem", (Object)rhsCodeSystem), (Object)lhsCodeSystem, (Object)rhsCodeSystem)) {
            return false;
        }
        Code lhsCode = this.getCode();
        Code rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode)) {
            return false;
        }
        ConceptMapEquivalence lhsEquivalence = this.getEquivalence();
        ConceptMapEquivalence rhsEquivalence = that.getEquivalence();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"equivalence", (Object)lhsEquivalence), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"equivalence", (Object)rhsEquivalence), (Object)lhsEquivalence, (Object)rhsEquivalence)) {
            return false;
        }
        String lhsComments = this.getComments();
        String rhsComments = that.getComments();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"comments", (Object)lhsComments), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"comments", (Object)rhsComments), (Object)lhsComments, (Object)rhsComments)) {
            return false;
        }
        List<ConceptMapDependsOn> lhsProduct = this.product != null && !this.product.isEmpty() ? this.getProduct() : null;
        List<ConceptMapDependsOn> list = rhsProduct = that.product != null && !that.product.isEmpty() ? that.getProduct() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"product", lhsProduct), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"product", rhsProduct), lhsProduct, rhsProduct);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theCodeSystem = this.getCodeSystem();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"codeSystem", (Object)theCodeSystem), currentHashCode, (Object)theCodeSystem);
        Code theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"code", (Object)theCode), currentHashCode, (Object)theCode);
        ConceptMapEquivalence theEquivalence = this.getEquivalence();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"equivalence", (Object)theEquivalence), currentHashCode, (Object)theEquivalence);
        String theComments = this.getComments();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"comments", (Object)theComments), currentHashCode, (Object)theComments);
        List<ConceptMapDependsOn> theProduct = this.product != null && !this.product.isEmpty() ? this.getProduct() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"product", theProduct), currentHashCode, theProduct);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theCodeSystem = this.getCodeSystem();
        strategy.appendField(locator, (Object)this, "codeSystem", buffer, (Object)theCodeSystem);
        Code theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode);
        ConceptMapEquivalence theEquivalence = this.getEquivalence();
        strategy.appendField(locator, (Object)this, "equivalence", buffer, (Object)theEquivalence);
        String theComments = this.getComments();
        strategy.appendField(locator, (Object)this, "comments", buffer, (Object)theComments);
        List<ConceptMapDependsOn> theProduct = this.product != null && !this.product.isEmpty() ? this.getProduct() : null;
        strategy.appendField(locator, (Object)this, "product", buffer, theProduct);
        return buffer;
    }
}

