/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Age;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ConditionClinicalStatus;
import org.hl7.fhir.ConditionDueTo;
import org.hl7.fhir.ConditionEvidence;
import org.hl7.fhir.ConditionLocation;
import org.hl7.fhir.ConditionOccurredFollowing;
import org.hl7.fhir.ConditionStage;
import org.hl7.fhir.Date;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Range;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Condition", propOrder={"identifier", "patient", "encounter", "asserter", "dateAsserted", "code", "category", "clinicalStatus", "severity", "onsetDateTime", "onsetAge", "onsetPeriod", "onsetRange", "onsetString", "abatementDate", "abatementAge", "abatementBoolean", "abatementPeriod", "abatementRange", "abatementString", "stage", "evidence", "location", "dueTo", "occurredFollowing", "notes"})
public class Condition
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected Reference patient;
    protected Reference encounter;
    protected Reference asserter;
    protected Date dateAsserted;
    @XmlElement(required=true)
    protected CodeableConcept code;
    protected CodeableConcept category;
    @XmlElement(required=true)
    protected ConditionClinicalStatus clinicalStatus;
    protected CodeableConcept severity;
    protected DateTime onsetDateTime;
    protected Age onsetAge;
    protected Period onsetPeriod;
    protected Range onsetRange;
    protected String onsetString;
    protected Date abatementDate;
    protected Age abatementAge;
    protected Boolean abatementBoolean;
    protected Period abatementPeriod;
    protected Range abatementRange;
    protected String abatementString;
    protected ConditionStage stage;
    protected List<ConditionEvidence> evidence;
    protected List<ConditionLocation> location;
    protected List<ConditionDueTo> dueTo;
    protected List<ConditionOccurredFollowing> occurredFollowing;
    protected String notes;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public Reference getAsserter() {
        return this.asserter;
    }

    public void setAsserter(Reference value) {
        this.asserter = value;
    }

    public Date getDateAsserted() {
        return this.dateAsserted;
    }

    public void setDateAsserted(Date value) {
        this.dateAsserted = value;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public void setCode(CodeableConcept value) {
        this.code = value;
    }

    public CodeableConcept getCategory() {
        return this.category;
    }

    public void setCategory(CodeableConcept value) {
        this.category = value;
    }

    public ConditionClinicalStatus getClinicalStatus() {
        return this.clinicalStatus;
    }

    public void setClinicalStatus(ConditionClinicalStatus value) {
        this.clinicalStatus = value;
    }

    public CodeableConcept getSeverity() {
        return this.severity;
    }

    public void setSeverity(CodeableConcept value) {
        this.severity = value;
    }

    public DateTime getOnsetDateTime() {
        return this.onsetDateTime;
    }

    public void setOnsetDateTime(DateTime value) {
        this.onsetDateTime = value;
    }

    public Age getOnsetAge() {
        return this.onsetAge;
    }

    public void setOnsetAge(Age value) {
        this.onsetAge = value;
    }

    public Period getOnsetPeriod() {
        return this.onsetPeriod;
    }

    public void setOnsetPeriod(Period value) {
        this.onsetPeriod = value;
    }

    public Range getOnsetRange() {
        return this.onsetRange;
    }

    public void setOnsetRange(Range value) {
        this.onsetRange = value;
    }

    public String getOnsetString() {
        return this.onsetString;
    }

    public void setOnsetString(String value) {
        this.onsetString = value;
    }

    public Date getAbatementDate() {
        return this.abatementDate;
    }

    public void setAbatementDate(Date value) {
        this.abatementDate = value;
    }

    public Age getAbatementAge() {
        return this.abatementAge;
    }

    public void setAbatementAge(Age value) {
        this.abatementAge = value;
    }

    public Boolean getAbatementBoolean() {
        return this.abatementBoolean;
    }

    public void setAbatementBoolean(Boolean value) {
        this.abatementBoolean = value;
    }

    public Period getAbatementPeriod() {
        return this.abatementPeriod;
    }

    public void setAbatementPeriod(Period value) {
        this.abatementPeriod = value;
    }

    public Range getAbatementRange() {
        return this.abatementRange;
    }

    public void setAbatementRange(Range value) {
        this.abatementRange = value;
    }

    public String getAbatementString() {
        return this.abatementString;
    }

    public void setAbatementString(String value) {
        this.abatementString = value;
    }

    public ConditionStage getStage() {
        return this.stage;
    }

    public void setStage(ConditionStage value) {
        this.stage = value;
    }

    public List<ConditionEvidence> getEvidence() {
        if (this.evidence == null) {
            this.evidence = new ArrayList<ConditionEvidence>();
        }
        return this.evidence;
    }

    public List<ConditionLocation> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<ConditionLocation>();
        }
        return this.location;
    }

    public List<ConditionDueTo> getDueTo() {
        if (this.dueTo == null) {
            this.dueTo = new ArrayList<ConditionDueTo>();
        }
        return this.dueTo;
    }

    public List<ConditionOccurredFollowing> getOccurredFollowing() {
        if (this.occurredFollowing == null) {
            this.occurredFollowing = new ArrayList<ConditionOccurredFollowing>();
        }
        return this.occurredFollowing;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String value) {
        this.notes = value;
    }

    public Condition withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Condition withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Condition withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public Condition withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public Condition withAsserter(Reference value) {
        this.setAsserter(value);
        return this;
    }

    public Condition withDateAsserted(Date value) {
        this.setDateAsserted(value);
        return this;
    }

    public Condition withCode(CodeableConcept value) {
        this.setCode(value);
        return this;
    }

    public Condition withCategory(CodeableConcept value) {
        this.setCategory(value);
        return this;
    }

    public Condition withClinicalStatus(ConditionClinicalStatus value) {
        this.setClinicalStatus(value);
        return this;
    }

    public Condition withSeverity(CodeableConcept value) {
        this.setSeverity(value);
        return this;
    }

    public Condition withOnsetDateTime(DateTime value) {
        this.setOnsetDateTime(value);
        return this;
    }

    public Condition withOnsetAge(Age value) {
        this.setOnsetAge(value);
        return this;
    }

    public Condition withOnsetPeriod(Period value) {
        this.setOnsetPeriod(value);
        return this;
    }

    public Condition withOnsetRange(Range value) {
        this.setOnsetRange(value);
        return this;
    }

    public Condition withOnsetString(String value) {
        this.setOnsetString(value);
        return this;
    }

    public Condition withAbatementDate(Date value) {
        this.setAbatementDate(value);
        return this;
    }

    public Condition withAbatementAge(Age value) {
        this.setAbatementAge(value);
        return this;
    }

    public Condition withAbatementBoolean(Boolean value) {
        this.setAbatementBoolean(value);
        return this;
    }

    public Condition withAbatementPeriod(Period value) {
        this.setAbatementPeriod(value);
        return this;
    }

    public Condition withAbatementRange(Range value) {
        this.setAbatementRange(value);
        return this;
    }

    public Condition withAbatementString(String value) {
        this.setAbatementString(value);
        return this;
    }

    public Condition withStage(ConditionStage value) {
        this.setStage(value);
        return this;
    }

    public Condition withEvidence(ConditionEvidence ... values) {
        if (values != null) {
            for (ConditionEvidence value : values) {
                this.getEvidence().add(value);
            }
        }
        return this;
    }

    public Condition withEvidence(Collection<ConditionEvidence> values) {
        if (values != null) {
            this.getEvidence().addAll(values);
        }
        return this;
    }

    public Condition withLocation(ConditionLocation ... values) {
        if (values != null) {
            for (ConditionLocation value : values) {
                this.getLocation().add(value);
            }
        }
        return this;
    }

    public Condition withLocation(Collection<ConditionLocation> values) {
        if (values != null) {
            this.getLocation().addAll(values);
        }
        return this;
    }

    public Condition withDueTo(ConditionDueTo ... values) {
        if (values != null) {
            for (ConditionDueTo value : values) {
                this.getDueTo().add(value);
            }
        }
        return this;
    }

    public Condition withDueTo(Collection<ConditionDueTo> values) {
        if (values != null) {
            this.getDueTo().addAll(values);
        }
        return this;
    }

    public Condition withOccurredFollowing(ConditionOccurredFollowing ... values) {
        if (values != null) {
            for (ConditionOccurredFollowing value : values) {
                this.getOccurredFollowing().add(value);
            }
        }
        return this;
    }

    public Condition withOccurredFollowing(Collection<ConditionOccurredFollowing> values) {
        if (values != null) {
            this.getOccurredFollowing().addAll(values);
        }
        return this;
    }

    public Condition withNotes(String value) {
        this.setNotes(value);
        return this;
    }

    @Override
    public Condition withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Condition withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Condition withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Condition withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Condition withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Condition withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Condition withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Condition withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Condition withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Condition withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Condition withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ConditionOccurredFollowing> rhsOccurredFollowing;
        List<ConditionDueTo> rhsDueTo;
        List<ConditionLocation> rhsLocation;
        List<ConditionEvidence> rhsEvidence;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof Condition)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Condition that = (Condition)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter)) {
            return false;
        }
        Reference lhsAsserter = this.getAsserter();
        Reference rhsAsserter = that.getAsserter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"asserter", (Object)lhsAsserter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"asserter", (Object)rhsAsserter), (Object)lhsAsserter, (Object)rhsAsserter)) {
            return false;
        }
        Date lhsDateAsserted = this.getDateAsserted();
        Date rhsDateAsserted = that.getDateAsserted();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dateAsserted", (Object)lhsDateAsserted), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dateAsserted", (Object)rhsDateAsserted), (Object)lhsDateAsserted, (Object)rhsDateAsserted)) {
            return false;
        }
        CodeableConcept lhsCode = this.getCode();
        CodeableConcept rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode)) {
            return false;
        }
        CodeableConcept lhsCategory = this.getCategory();
        CodeableConcept rhsCategory = that.getCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"category", (Object)lhsCategory), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"category", (Object)rhsCategory), (Object)lhsCategory, (Object)rhsCategory)) {
            return false;
        }
        ConditionClinicalStatus lhsClinicalStatus = this.getClinicalStatus();
        ConditionClinicalStatus rhsClinicalStatus = that.getClinicalStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"clinicalStatus", (Object)lhsClinicalStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"clinicalStatus", (Object)rhsClinicalStatus), (Object)lhsClinicalStatus, (Object)rhsClinicalStatus)) {
            return false;
        }
        CodeableConcept lhsSeverity = this.getSeverity();
        CodeableConcept rhsSeverity = that.getSeverity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"severity", (Object)lhsSeverity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"severity", (Object)rhsSeverity), (Object)lhsSeverity, (Object)rhsSeverity)) {
            return false;
        }
        DateTime lhsOnsetDateTime = this.getOnsetDateTime();
        DateTime rhsOnsetDateTime = that.getOnsetDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"onsetDateTime", (Object)lhsOnsetDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"onsetDateTime", (Object)rhsOnsetDateTime), (Object)lhsOnsetDateTime, (Object)rhsOnsetDateTime)) {
            return false;
        }
        Age lhsOnsetAge = this.getOnsetAge();
        Age rhsOnsetAge = that.getOnsetAge();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"onsetAge", (Object)lhsOnsetAge), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"onsetAge", (Object)rhsOnsetAge), (Object)lhsOnsetAge, (Object)rhsOnsetAge)) {
            return false;
        }
        Period lhsOnsetPeriod = this.getOnsetPeriod();
        Period rhsOnsetPeriod = that.getOnsetPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"onsetPeriod", (Object)lhsOnsetPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"onsetPeriod", (Object)rhsOnsetPeriod), (Object)lhsOnsetPeriod, (Object)rhsOnsetPeriod)) {
            return false;
        }
        Range lhsOnsetRange = this.getOnsetRange();
        Range rhsOnsetRange = that.getOnsetRange();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"onsetRange", (Object)lhsOnsetRange), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"onsetRange", (Object)rhsOnsetRange), (Object)lhsOnsetRange, (Object)rhsOnsetRange)) {
            return false;
        }
        String lhsOnsetString = this.getOnsetString();
        String rhsOnsetString = that.getOnsetString();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"onsetString", (Object)lhsOnsetString), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"onsetString", (Object)rhsOnsetString), (Object)lhsOnsetString, (Object)rhsOnsetString)) {
            return false;
        }
        Date lhsAbatementDate = this.getAbatementDate();
        Date rhsAbatementDate = that.getAbatementDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"abatementDate", (Object)lhsAbatementDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"abatementDate", (Object)rhsAbatementDate), (Object)lhsAbatementDate, (Object)rhsAbatementDate)) {
            return false;
        }
        Age lhsAbatementAge = this.getAbatementAge();
        Age rhsAbatementAge = that.getAbatementAge();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"abatementAge", (Object)lhsAbatementAge), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"abatementAge", (Object)rhsAbatementAge), (Object)lhsAbatementAge, (Object)rhsAbatementAge)) {
            return false;
        }
        Boolean lhsAbatementBoolean = this.getAbatementBoolean();
        Boolean rhsAbatementBoolean = that.getAbatementBoolean();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"abatementBoolean", (Object)lhsAbatementBoolean), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"abatementBoolean", (Object)rhsAbatementBoolean), (Object)lhsAbatementBoolean, (Object)rhsAbatementBoolean)) {
            return false;
        }
        Period lhsAbatementPeriod = this.getAbatementPeriod();
        Period rhsAbatementPeriod = that.getAbatementPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"abatementPeriod", (Object)lhsAbatementPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"abatementPeriod", (Object)rhsAbatementPeriod), (Object)lhsAbatementPeriod, (Object)rhsAbatementPeriod)) {
            return false;
        }
        Range lhsAbatementRange = this.getAbatementRange();
        Range rhsAbatementRange = that.getAbatementRange();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"abatementRange", (Object)lhsAbatementRange), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"abatementRange", (Object)rhsAbatementRange), (Object)lhsAbatementRange, (Object)rhsAbatementRange)) {
            return false;
        }
        String lhsAbatementString = this.getAbatementString();
        String rhsAbatementString = that.getAbatementString();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"abatementString", (Object)lhsAbatementString), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"abatementString", (Object)rhsAbatementString), (Object)lhsAbatementString, (Object)rhsAbatementString)) {
            return false;
        }
        ConditionStage lhsStage = this.getStage();
        ConditionStage rhsStage = that.getStage();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"stage", (Object)lhsStage), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"stage", (Object)rhsStage), (Object)lhsStage, (Object)rhsStage)) {
            return false;
        }
        List<ConditionEvidence> lhsEvidence = this.evidence != null && !this.evidence.isEmpty() ? this.getEvidence() : null;
        List<ConditionEvidence> list2 = rhsEvidence = that.evidence != null && !that.evidence.isEmpty() ? that.getEvidence() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"evidence", lhsEvidence), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"evidence", rhsEvidence), lhsEvidence, rhsEvidence)) {
            return false;
        }
        List<ConditionLocation> lhsLocation = this.location != null && !this.location.isEmpty() ? this.getLocation() : null;
        List<ConditionLocation> list3 = rhsLocation = that.location != null && !that.location.isEmpty() ? that.getLocation() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"location", lhsLocation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"location", rhsLocation), lhsLocation, rhsLocation)) {
            return false;
        }
        List<ConditionDueTo> lhsDueTo = this.dueTo != null && !this.dueTo.isEmpty() ? this.getDueTo() : null;
        List<ConditionDueTo> list4 = rhsDueTo = that.dueTo != null && !that.dueTo.isEmpty() ? that.getDueTo() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dueTo", lhsDueTo), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dueTo", rhsDueTo), lhsDueTo, rhsDueTo)) {
            return false;
        }
        List<ConditionOccurredFollowing> lhsOccurredFollowing = this.occurredFollowing != null && !this.occurredFollowing.isEmpty() ? this.getOccurredFollowing() : null;
        List<ConditionOccurredFollowing> list5 = rhsOccurredFollowing = that.occurredFollowing != null && !that.occurredFollowing.isEmpty() ? that.getOccurredFollowing() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"occurredFollowing", lhsOccurredFollowing), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"occurredFollowing", rhsOccurredFollowing), lhsOccurredFollowing, rhsOccurredFollowing)) {
            return false;
        }
        String lhsNotes = this.getNotes();
        String rhsNotes = that.getNotes();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"notes", (Object)lhsNotes), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"notes", (Object)rhsNotes), (Object)lhsNotes, (Object)rhsNotes);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter);
        Reference theAsserter = this.getAsserter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"asserter", (Object)theAsserter), currentHashCode, (Object)theAsserter);
        Date theDateAsserted = this.getDateAsserted();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dateAsserted", (Object)theDateAsserted), currentHashCode, (Object)theDateAsserted);
        CodeableConcept theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"code", (Object)theCode), currentHashCode, (Object)theCode);
        CodeableConcept theCategory = this.getCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"category", (Object)theCategory), currentHashCode, (Object)theCategory);
        ConditionClinicalStatus theClinicalStatus = this.getClinicalStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"clinicalStatus", (Object)theClinicalStatus), currentHashCode, (Object)theClinicalStatus);
        CodeableConcept theSeverity = this.getSeverity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"severity", (Object)theSeverity), currentHashCode, (Object)theSeverity);
        DateTime theOnsetDateTime = this.getOnsetDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"onsetDateTime", (Object)theOnsetDateTime), currentHashCode, (Object)theOnsetDateTime);
        Age theOnsetAge = this.getOnsetAge();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"onsetAge", (Object)theOnsetAge), currentHashCode, (Object)theOnsetAge);
        Period theOnsetPeriod = this.getOnsetPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"onsetPeriod", (Object)theOnsetPeriod), currentHashCode, (Object)theOnsetPeriod);
        Range theOnsetRange = this.getOnsetRange();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"onsetRange", (Object)theOnsetRange), currentHashCode, (Object)theOnsetRange);
        String theOnsetString = this.getOnsetString();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"onsetString", (Object)theOnsetString), currentHashCode, (Object)theOnsetString);
        Date theAbatementDate = this.getAbatementDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"abatementDate", (Object)theAbatementDate), currentHashCode, (Object)theAbatementDate);
        Age theAbatementAge = this.getAbatementAge();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"abatementAge", (Object)theAbatementAge), currentHashCode, (Object)theAbatementAge);
        Boolean theAbatementBoolean = this.getAbatementBoolean();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"abatementBoolean", (Object)theAbatementBoolean), currentHashCode, (Object)theAbatementBoolean);
        Period theAbatementPeriod = this.getAbatementPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"abatementPeriod", (Object)theAbatementPeriod), currentHashCode, (Object)theAbatementPeriod);
        Range theAbatementRange = this.getAbatementRange();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"abatementRange", (Object)theAbatementRange), currentHashCode, (Object)theAbatementRange);
        String theAbatementString = this.getAbatementString();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"abatementString", (Object)theAbatementString), currentHashCode, (Object)theAbatementString);
        ConditionStage theStage = this.getStage();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"stage", (Object)theStage), currentHashCode, (Object)theStage);
        List<ConditionEvidence> theEvidence = this.evidence != null && !this.evidence.isEmpty() ? this.getEvidence() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"evidence", theEvidence), currentHashCode, theEvidence);
        List<ConditionLocation> theLocation = this.location != null && !this.location.isEmpty() ? this.getLocation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"location", theLocation), currentHashCode, theLocation);
        List<ConditionDueTo> theDueTo = this.dueTo != null && !this.dueTo.isEmpty() ? this.getDueTo() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dueTo", theDueTo), currentHashCode, theDueTo);
        List<ConditionOccurredFollowing> theOccurredFollowing = this.occurredFollowing != null && !this.occurredFollowing.isEmpty() ? this.getOccurredFollowing() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"occurredFollowing", theOccurredFollowing), currentHashCode, theOccurredFollowing);
        String theNotes = this.getNotes();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"notes", (Object)theNotes), currentHashCode, (Object)theNotes);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter);
        Reference theAsserter = this.getAsserter();
        strategy.appendField(locator, (Object)this, "asserter", buffer, (Object)theAsserter);
        Date theDateAsserted = this.getDateAsserted();
        strategy.appendField(locator, (Object)this, "dateAsserted", buffer, (Object)theDateAsserted);
        CodeableConcept theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode);
        CodeableConcept theCategory = this.getCategory();
        strategy.appendField(locator, (Object)this, "category", buffer, (Object)theCategory);
        ConditionClinicalStatus theClinicalStatus = this.getClinicalStatus();
        strategy.appendField(locator, (Object)this, "clinicalStatus", buffer, (Object)theClinicalStatus);
        CodeableConcept theSeverity = this.getSeverity();
        strategy.appendField(locator, (Object)this, "severity", buffer, (Object)theSeverity);
        DateTime theOnsetDateTime = this.getOnsetDateTime();
        strategy.appendField(locator, (Object)this, "onsetDateTime", buffer, (Object)theOnsetDateTime);
        Age theOnsetAge = this.getOnsetAge();
        strategy.appendField(locator, (Object)this, "onsetAge", buffer, (Object)theOnsetAge);
        Period theOnsetPeriod = this.getOnsetPeriod();
        strategy.appendField(locator, (Object)this, "onsetPeriod", buffer, (Object)theOnsetPeriod);
        Range theOnsetRange = this.getOnsetRange();
        strategy.appendField(locator, (Object)this, "onsetRange", buffer, (Object)theOnsetRange);
        String theOnsetString = this.getOnsetString();
        strategy.appendField(locator, (Object)this, "onsetString", buffer, (Object)theOnsetString);
        Date theAbatementDate = this.getAbatementDate();
        strategy.appendField(locator, (Object)this, "abatementDate", buffer, (Object)theAbatementDate);
        Age theAbatementAge = this.getAbatementAge();
        strategy.appendField(locator, (Object)this, "abatementAge", buffer, (Object)theAbatementAge);
        Boolean theAbatementBoolean = this.getAbatementBoolean();
        strategy.appendField(locator, (Object)this, "abatementBoolean", buffer, (Object)theAbatementBoolean);
        Period theAbatementPeriod = this.getAbatementPeriod();
        strategy.appendField(locator, (Object)this, "abatementPeriod", buffer, (Object)theAbatementPeriod);
        Range theAbatementRange = this.getAbatementRange();
        strategy.appendField(locator, (Object)this, "abatementRange", buffer, (Object)theAbatementRange);
        String theAbatementString = this.getAbatementString();
        strategy.appendField(locator, (Object)this, "abatementString", buffer, (Object)theAbatementString);
        ConditionStage theStage = this.getStage();
        strategy.appendField(locator, (Object)this, "stage", buffer, (Object)theStage);
        List<ConditionEvidence> theEvidence = this.evidence != null && !this.evidence.isEmpty() ? this.getEvidence() : null;
        strategy.appendField(locator, (Object)this, "evidence", buffer, theEvidence);
        List<ConditionLocation> theLocation = this.location != null && !this.location.isEmpty() ? this.getLocation() : null;
        strategy.appendField(locator, (Object)this, "location", buffer, theLocation);
        List<ConditionDueTo> theDueTo = this.dueTo != null && !this.dueTo.isEmpty() ? this.getDueTo() : null;
        strategy.appendField(locator, (Object)this, "dueTo", buffer, theDueTo);
        List<ConditionOccurredFollowing> theOccurredFollowing = this.occurredFollowing != null && !this.occurredFollowing.isEmpty() ? this.getOccurredFollowing() : null;
        strategy.appendField(locator, (Object)this, "occurredFollowing", buffer, theOccurredFollowing);
        String theNotes = this.getNotes();
        strategy.appendField(locator, (Object)this, "notes", buffer, (Object)theNotes);
        return buffer;
    }
}

