/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.ConformanceContact;
import org.hl7.fhir.ConformanceDocument;
import org.hl7.fhir.ConformanceImplementation;
import org.hl7.fhir.ConformanceMessaging;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.ConformanceRest;
import org.hl7.fhir.ConformanceSoftware;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Conformance", propOrder={"url", "version", "name", "publisher", "contact", "description", "requirements", "copyright", "status", "experimental", "date", "software", "implementation", "fhirVersion", "acceptUnknown", "format", "profile", "rest", "messaging", "document"})
public class Conformance
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected Uri url;
    protected String version;
    protected String name;
    protected String publisher;
    protected List<ConformanceContact> contact;
    protected String description;
    protected String requirements;
    protected String copyright;
    protected ConformanceResourceStatus status;
    protected Boolean experimental;
    @XmlElement(required=true)
    protected DateTime date;
    protected ConformanceSoftware software;
    protected ConformanceImplementation implementation;
    @XmlElement(required=true)
    protected Id fhirVersion;
    @XmlElement(required=true)
    protected Boolean acceptUnknown;
    @XmlElement(required=true)
    protected List<Code> format;
    protected List<Reference> profile;
    protected List<ConformanceRest> rest;
    protected List<ConformanceMessaging> messaging;
    protected List<ConformanceDocument> document;

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<ConformanceContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ConformanceContact>();
        }
        return this.contact;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String value) {
        this.requirements = value;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String value) {
        this.copyright = value;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean value) {
        this.experimental = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public ConformanceSoftware getSoftware() {
        return this.software;
    }

    public void setSoftware(ConformanceSoftware value) {
        this.software = value;
    }

    public ConformanceImplementation getImplementation() {
        return this.implementation;
    }

    public void setImplementation(ConformanceImplementation value) {
        this.implementation = value;
    }

    public Id getFhirVersion() {
        return this.fhirVersion;
    }

    public void setFhirVersion(Id value) {
        this.fhirVersion = value;
    }

    public Boolean getAcceptUnknown() {
        return this.acceptUnknown;
    }

    public void setAcceptUnknown(Boolean value) {
        this.acceptUnknown = value;
    }

    public List<Code> getFormat() {
        if (this.format == null) {
            this.format = new ArrayList<Code>();
        }
        return this.format;
    }

    public List<Reference> getProfile() {
        if (this.profile == null) {
            this.profile = new ArrayList<Reference>();
        }
        return this.profile;
    }

    public List<ConformanceRest> getRest() {
        if (this.rest == null) {
            this.rest = new ArrayList<ConformanceRest>();
        }
        return this.rest;
    }

    public List<ConformanceMessaging> getMessaging() {
        if (this.messaging == null) {
            this.messaging = new ArrayList<ConformanceMessaging>();
        }
        return this.messaging;
    }

    public List<ConformanceDocument> getDocument() {
        if (this.document == null) {
            this.document = new ArrayList<ConformanceDocument>();
        }
        return this.document;
    }

    public Conformance withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public Conformance withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public Conformance withName(String value) {
        this.setName(value);
        return this;
    }

    public Conformance withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public Conformance withContact(ConformanceContact ... values) {
        if (values != null) {
            for (ConformanceContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public Conformance withContact(Collection<ConformanceContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public Conformance withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public Conformance withRequirements(String value) {
        this.setRequirements(value);
        return this;
    }

    public Conformance withCopyright(String value) {
        this.setCopyright(value);
        return this;
    }

    public Conformance withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public Conformance withExperimental(Boolean value) {
        this.setExperimental(value);
        return this;
    }

    public Conformance withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public Conformance withSoftware(ConformanceSoftware value) {
        this.setSoftware(value);
        return this;
    }

    public Conformance withImplementation(ConformanceImplementation value) {
        this.setImplementation(value);
        return this;
    }

    public Conformance withFhirVersion(Id value) {
        this.setFhirVersion(value);
        return this;
    }

    public Conformance withAcceptUnknown(Boolean value) {
        this.setAcceptUnknown(value);
        return this;
    }

    public Conformance withFormat(Code ... values) {
        if (values != null) {
            for (Code value : values) {
                this.getFormat().add(value);
            }
        }
        return this;
    }

    public Conformance withFormat(Collection<Code> values) {
        if (values != null) {
            this.getFormat().addAll(values);
        }
        return this;
    }

    public Conformance withProfile(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getProfile().add(value);
            }
        }
        return this;
    }

    public Conformance withProfile(Collection<Reference> values) {
        if (values != null) {
            this.getProfile().addAll(values);
        }
        return this;
    }

    public Conformance withRest(ConformanceRest ... values) {
        if (values != null) {
            for (ConformanceRest value : values) {
                this.getRest().add(value);
            }
        }
        return this;
    }

    public Conformance withRest(Collection<ConformanceRest> values) {
        if (values != null) {
            this.getRest().addAll(values);
        }
        return this;
    }

    public Conformance withMessaging(ConformanceMessaging ... values) {
        if (values != null) {
            for (ConformanceMessaging value : values) {
                this.getMessaging().add(value);
            }
        }
        return this;
    }

    public Conformance withMessaging(Collection<ConformanceMessaging> values) {
        if (values != null) {
            this.getMessaging().addAll(values);
        }
        return this;
    }

    public Conformance withDocument(ConformanceDocument ... values) {
        if (values != null) {
            for (ConformanceDocument value : values) {
                this.getDocument().add(value);
            }
        }
        return this;
    }

    public Conformance withDocument(Collection<ConformanceDocument> values) {
        if (values != null) {
            this.getDocument().addAll(values);
        }
        return this;
    }

    @Override
    public Conformance withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Conformance withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Conformance withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Conformance withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Conformance withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Conformance withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Conformance withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Conformance withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Conformance withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Conformance withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Conformance withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ConformanceDocument> rhsDocument;
        List<ConformanceMessaging> rhsMessaging;
        List<ConformanceRest> rhsRest;
        List<Reference> rhsProfile;
        List<Code> rhsFormat;
        List<ConformanceContact> rhsContact;
        if (!(object instanceof Conformance)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Conformance that = (Conformance)object;
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"url", (Object)lhsUrl), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"url", (Object)rhsUrl), (Object)lhsUrl, (Object)rhsUrl)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"version", (Object)lhsVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"version", (Object)rhsVersion), (Object)lhsVersion, (Object)rhsVersion)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"name", (Object)lhsName), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"name", (Object)rhsName), (Object)lhsName, (Object)rhsName)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"publisher", (Object)lhsPublisher), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"publisher", (Object)rhsPublisher), (Object)lhsPublisher, (Object)rhsPublisher)) {
            return false;
        }
        List<ConformanceContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<ConformanceContact> list = rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"contact", lhsContact), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"contact", rhsContact), lhsContact, rhsContact)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription)) {
            return false;
        }
        String lhsRequirements = this.getRequirements();
        String rhsRequirements = that.getRequirements();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requirements", (Object)lhsRequirements), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requirements", (Object)rhsRequirements), (Object)lhsRequirements, (Object)rhsRequirements)) {
            return false;
        }
        String lhsCopyright = this.getCopyright();
        String rhsCopyright = that.getCopyright();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"copyright", (Object)lhsCopyright), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"copyright", (Object)rhsCopyright), (Object)lhsCopyright, (Object)rhsCopyright)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        Boolean lhsExperimental = this.getExperimental();
        Boolean rhsExperimental = that.getExperimental();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"experimental", (Object)lhsExperimental), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"experimental", (Object)rhsExperimental), (Object)lhsExperimental, (Object)rhsExperimental)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate)) {
            return false;
        }
        ConformanceSoftware lhsSoftware = this.getSoftware();
        ConformanceSoftware rhsSoftware = that.getSoftware();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"software", (Object)lhsSoftware), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"software", (Object)rhsSoftware), (Object)lhsSoftware, (Object)rhsSoftware)) {
            return false;
        }
        ConformanceImplementation lhsImplementation = this.getImplementation();
        ConformanceImplementation rhsImplementation = that.getImplementation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"implementation", (Object)lhsImplementation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"implementation", (Object)rhsImplementation), (Object)lhsImplementation, (Object)rhsImplementation)) {
            return false;
        }
        Id lhsFhirVersion = this.getFhirVersion();
        Id rhsFhirVersion = that.getFhirVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"fhirVersion", (Object)lhsFhirVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"fhirVersion", (Object)rhsFhirVersion), (Object)lhsFhirVersion, (Object)rhsFhirVersion)) {
            return false;
        }
        Boolean lhsAcceptUnknown = this.getAcceptUnknown();
        Boolean rhsAcceptUnknown = that.getAcceptUnknown();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"acceptUnknown", (Object)lhsAcceptUnknown), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"acceptUnknown", (Object)rhsAcceptUnknown), (Object)lhsAcceptUnknown, (Object)rhsAcceptUnknown)) {
            return false;
        }
        List<Code> lhsFormat = this.format != null && !this.format.isEmpty() ? this.getFormat() : null;
        List<Code> list2 = rhsFormat = that.format != null && !that.format.isEmpty() ? that.getFormat() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"format", lhsFormat), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"format", rhsFormat), lhsFormat, rhsFormat)) {
            return false;
        }
        List<Reference> lhsProfile = this.profile != null && !this.profile.isEmpty() ? this.getProfile() : null;
        List<Reference> list3 = rhsProfile = that.profile != null && !that.profile.isEmpty() ? that.getProfile() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"profile", lhsProfile), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"profile", rhsProfile), lhsProfile, rhsProfile)) {
            return false;
        }
        List<ConformanceRest> lhsRest = this.rest != null && !this.rest.isEmpty() ? this.getRest() : null;
        List<ConformanceRest> list4 = rhsRest = that.rest != null && !that.rest.isEmpty() ? that.getRest() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"rest", lhsRest), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"rest", rhsRest), lhsRest, rhsRest)) {
            return false;
        }
        List<ConformanceMessaging> lhsMessaging = this.messaging != null && !this.messaging.isEmpty() ? this.getMessaging() : null;
        List<ConformanceMessaging> list5 = rhsMessaging = that.messaging != null && !that.messaging.isEmpty() ? that.getMessaging() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"messaging", lhsMessaging), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"messaging", rhsMessaging), lhsMessaging, rhsMessaging)) {
            return false;
        }
        List<ConformanceDocument> lhsDocument = this.document != null && !this.document.isEmpty() ? this.getDocument() : null;
        List<ConformanceDocument> list6 = rhsDocument = that.document != null && !that.document.isEmpty() ? that.getDocument() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"document", lhsDocument), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"document", rhsDocument), lhsDocument, rhsDocument);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"url", (Object)theUrl), currentHashCode, (Object)theUrl);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"version", (Object)theVersion), currentHashCode, (Object)theVersion);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"name", (Object)theName), currentHashCode, (Object)theName);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"publisher", (Object)thePublisher), currentHashCode, (Object)thePublisher);
        List<ConformanceContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"contact", theContact), currentHashCode, theContact);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription);
        String theRequirements = this.getRequirements();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requirements", (Object)theRequirements), currentHashCode, (Object)theRequirements);
        String theCopyright = this.getCopyright();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"copyright", (Object)theCopyright), currentHashCode, (Object)theCopyright);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        Boolean theExperimental = this.getExperimental();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"experimental", (Object)theExperimental), currentHashCode, (Object)theExperimental);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"date", (Object)theDate), currentHashCode, (Object)theDate);
        ConformanceSoftware theSoftware = this.getSoftware();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"software", (Object)theSoftware), currentHashCode, (Object)theSoftware);
        ConformanceImplementation theImplementation = this.getImplementation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"implementation", (Object)theImplementation), currentHashCode, (Object)theImplementation);
        Id theFhirVersion = this.getFhirVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"fhirVersion", (Object)theFhirVersion), currentHashCode, (Object)theFhirVersion);
        Boolean theAcceptUnknown = this.getAcceptUnknown();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"acceptUnknown", (Object)theAcceptUnknown), currentHashCode, (Object)theAcceptUnknown);
        List<Code> theFormat = this.format != null && !this.format.isEmpty() ? this.getFormat() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"format", theFormat), currentHashCode, theFormat);
        List<Reference> theProfile = this.profile != null && !this.profile.isEmpty() ? this.getProfile() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"profile", theProfile), currentHashCode, theProfile);
        List<ConformanceRest> theRest = this.rest != null && !this.rest.isEmpty() ? this.getRest() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"rest", theRest), currentHashCode, theRest);
        List<ConformanceMessaging> theMessaging = this.messaging != null && !this.messaging.isEmpty() ? this.getMessaging() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"messaging", theMessaging), currentHashCode, theMessaging);
        List<ConformanceDocument> theDocument = this.document != null && !this.document.isEmpty() ? this.getDocument() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"document", theDocument), currentHashCode, theDocument);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, (Object)theUrl);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, (Object)theVersion);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, (Object)theName);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, (Object)thePublisher);
        List<ConformanceContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription);
        String theRequirements = this.getRequirements();
        strategy.appendField(locator, (Object)this, "requirements", buffer, (Object)theRequirements);
        String theCopyright = this.getCopyright();
        strategy.appendField(locator, (Object)this, "copyright", buffer, (Object)theCopyright);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        Boolean theExperimental = this.getExperimental();
        strategy.appendField(locator, (Object)this, "experimental", buffer, (Object)theExperimental);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate);
        ConformanceSoftware theSoftware = this.getSoftware();
        strategy.appendField(locator, (Object)this, "software", buffer, (Object)theSoftware);
        ConformanceImplementation theImplementation = this.getImplementation();
        strategy.appendField(locator, (Object)this, "implementation", buffer, (Object)theImplementation);
        Id theFhirVersion = this.getFhirVersion();
        strategy.appendField(locator, (Object)this, "fhirVersion", buffer, (Object)theFhirVersion);
        Boolean theAcceptUnknown = this.getAcceptUnknown();
        strategy.appendField(locator, (Object)this, "acceptUnknown", buffer, (Object)theAcceptUnknown);
        List<Code> theFormat = this.format != null && !this.format.isEmpty() ? this.getFormat() : null;
        strategy.appendField(locator, (Object)this, "format", buffer, theFormat);
        List<Reference> theProfile = this.profile != null && !this.profile.isEmpty() ? this.getProfile() : null;
        strategy.appendField(locator, (Object)this, "profile", buffer, theProfile);
        List<ConformanceRest> theRest = this.rest != null && !this.rest.isEmpty() ? this.getRest() : null;
        strategy.appendField(locator, (Object)this, "rest", buffer, theRest);
        List<ConformanceMessaging> theMessaging = this.messaging != null && !this.messaging.isEmpty() ? this.getMessaging() : null;
        strategy.appendField(locator, (Object)this, "messaging", buffer, theMessaging);
        List<ConformanceDocument> theDocument = this.document != null && !this.document.isEmpty() ? this.getDocument() : null;
        strategy.appendField(locator, (Object)this, "document", buffer, theDocument);
        return buffer;
    }
}

