/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.ConformanceEventMode;
import org.hl7.fhir.Extension;
import org.hl7.fhir.MessageSignificanceCategory;
import org.hl7.fhir.Reference;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Conformance.Event", propOrder={"code", "category", "mode", "protocol", "focus", "request", "response", "documentation"})
public class ConformanceEvent
extends BackboneElement
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected Coding code;
    protected MessageSignificanceCategory category;
    @XmlElement(required=true)
    protected ConformanceEventMode mode;
    protected List<Coding> protocol;
    @XmlElement(required=true)
    protected Code focus;
    @XmlElement(required=true)
    protected Reference request;
    @XmlElement(required=true)
    protected Reference response;
    protected String documentation;

    public Coding getCode() {
        return this.code;
    }

    public void setCode(Coding value) {
        this.code = value;
    }

    public MessageSignificanceCategory getCategory() {
        return this.category;
    }

    public void setCategory(MessageSignificanceCategory value) {
        this.category = value;
    }

    public ConformanceEventMode getMode() {
        return this.mode;
    }

    public void setMode(ConformanceEventMode value) {
        this.mode = value;
    }

    public List<Coding> getProtocol() {
        if (this.protocol == null) {
            this.protocol = new ArrayList<Coding>();
        }
        return this.protocol;
    }

    public Code getFocus() {
        return this.focus;
    }

    public void setFocus(Code value) {
        this.focus = value;
    }

    public Reference getRequest() {
        return this.request;
    }

    public void setRequest(Reference value) {
        this.request = value;
    }

    public Reference getResponse() {
        return this.response;
    }

    public void setResponse(Reference value) {
        this.response = value;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String value) {
        this.documentation = value;
    }

    public ConformanceEvent withCode(Coding value) {
        this.setCode(value);
        return this;
    }

    public ConformanceEvent withCategory(MessageSignificanceCategory value) {
        this.setCategory(value);
        return this;
    }

    public ConformanceEvent withMode(ConformanceEventMode value) {
        this.setMode(value);
        return this;
    }

    public ConformanceEvent withProtocol(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getProtocol().add(value);
            }
        }
        return this;
    }

    public ConformanceEvent withProtocol(Collection<Coding> values) {
        if (values != null) {
            this.getProtocol().addAll(values);
        }
        return this;
    }

    public ConformanceEvent withFocus(Code value) {
        this.setFocus(value);
        return this;
    }

    public ConformanceEvent withRequest(Reference value) {
        this.setRequest(value);
        return this;
    }

    public ConformanceEvent withResponse(Reference value) {
        this.setResponse(value);
        return this;
    }

    public ConformanceEvent withDocumentation(String value) {
        this.setDocumentation(value);
        return this;
    }

    @Override
    public ConformanceEvent withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConformanceEvent withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceEvent withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConformanceEvent withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceEvent withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Coding> rhsProtocol;
        if (!(object instanceof ConformanceEvent)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ConformanceEvent that = (ConformanceEvent)object;
        Coding lhsCode = this.getCode();
        Coding rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode)) {
            return false;
        }
        MessageSignificanceCategory lhsCategory = this.getCategory();
        MessageSignificanceCategory rhsCategory = that.getCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"category", (Object)lhsCategory), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"category", (Object)rhsCategory), (Object)lhsCategory, (Object)rhsCategory)) {
            return false;
        }
        ConformanceEventMode lhsMode = this.getMode();
        ConformanceEventMode rhsMode = that.getMode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"mode", (Object)lhsMode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"mode", (Object)rhsMode), (Object)lhsMode, (Object)rhsMode)) {
            return false;
        }
        List<Coding> lhsProtocol = this.protocol != null && !this.protocol.isEmpty() ? this.getProtocol() : null;
        List<Coding> list = rhsProtocol = that.protocol != null && !that.protocol.isEmpty() ? that.getProtocol() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"protocol", lhsProtocol), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"protocol", rhsProtocol), lhsProtocol, rhsProtocol)) {
            return false;
        }
        Code lhsFocus = this.getFocus();
        Code rhsFocus = that.getFocus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"focus", (Object)lhsFocus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"focus", (Object)rhsFocus), (Object)lhsFocus, (Object)rhsFocus)) {
            return false;
        }
        Reference lhsRequest = this.getRequest();
        Reference rhsRequest = that.getRequest();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"request", (Object)lhsRequest), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"request", (Object)rhsRequest), (Object)lhsRequest, (Object)rhsRequest)) {
            return false;
        }
        Reference lhsResponse = this.getResponse();
        Reference rhsResponse = that.getResponse();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"response", (Object)lhsResponse), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"response", (Object)rhsResponse), (Object)lhsResponse, (Object)rhsResponse)) {
            return false;
        }
        String lhsDocumentation = this.getDocumentation();
        String rhsDocumentation = that.getDocumentation();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"documentation", (Object)lhsDocumentation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"documentation", (Object)rhsDocumentation), (Object)lhsDocumentation, (Object)rhsDocumentation);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Coding theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"code", (Object)theCode), currentHashCode, (Object)theCode);
        MessageSignificanceCategory theCategory = this.getCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"category", (Object)theCategory), currentHashCode, (Object)theCategory);
        ConformanceEventMode theMode = this.getMode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"mode", (Object)theMode), currentHashCode, (Object)theMode);
        List<Coding> theProtocol = this.protocol != null && !this.protocol.isEmpty() ? this.getProtocol() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"protocol", theProtocol), currentHashCode, theProtocol);
        Code theFocus = this.getFocus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"focus", (Object)theFocus), currentHashCode, (Object)theFocus);
        Reference theRequest = this.getRequest();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"request", (Object)theRequest), currentHashCode, (Object)theRequest);
        Reference theResponse = this.getResponse();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"response", (Object)theResponse), currentHashCode, (Object)theResponse);
        String theDocumentation = this.getDocumentation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"documentation", (Object)theDocumentation), currentHashCode, (Object)theDocumentation);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Coding theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode);
        MessageSignificanceCategory theCategory = this.getCategory();
        strategy.appendField(locator, (Object)this, "category", buffer, (Object)theCategory);
        ConformanceEventMode theMode = this.getMode();
        strategy.appendField(locator, (Object)this, "mode", buffer, (Object)theMode);
        List<Coding> theProtocol = this.protocol != null && !this.protocol.isEmpty() ? this.getProtocol() : null;
        strategy.appendField(locator, (Object)this, "protocol", buffer, theProtocol);
        Code theFocus = this.getFocus();
        strategy.appendField(locator, (Object)this, "focus", buffer, (Object)theFocus);
        Reference theRequest = this.getRequest();
        strategy.appendField(locator, (Object)this, "request", buffer, (Object)theRequest);
        Reference theResponse = this.getResponse();
        strategy.appendField(locator, (Object)this, "response", buffer, (Object)theResponse);
        String theDocumentation = this.getDocumentation();
        strategy.appendField(locator, (Object)this, "documentation", buffer, (Object)theDocumentation);
        return buffer;
    }
}

