/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.ConformanceEvent;
import org.hl7.fhir.Extension;
import org.hl7.fhir.String;
import org.hl7.fhir.UnsignedInt;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Conformance.Messaging", propOrder={"endpoint", "reliableCache", "documentation", "event"})
public class ConformanceMessaging
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected Uri endpoint;
    protected UnsignedInt reliableCache;
    protected String documentation;
    @XmlElement(required=true)
    protected List<ConformanceEvent> event;

    public Uri getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Uri value) {
        this.endpoint = value;
    }

    public UnsignedInt getReliableCache() {
        return this.reliableCache;
    }

    public void setReliableCache(UnsignedInt value) {
        this.reliableCache = value;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String value) {
        this.documentation = value;
    }

    public List<ConformanceEvent> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<ConformanceEvent>();
        }
        return this.event;
    }

    public ConformanceMessaging withEndpoint(Uri value) {
        this.setEndpoint(value);
        return this;
    }

    public ConformanceMessaging withReliableCache(UnsignedInt value) {
        this.setReliableCache(value);
        return this;
    }

    public ConformanceMessaging withDocumentation(String value) {
        this.setDocumentation(value);
        return this;
    }

    public ConformanceMessaging withEvent(ConformanceEvent ... values) {
        if (values != null) {
            for (ConformanceEvent value : values) {
                this.getEvent().add(value);
            }
        }
        return this;
    }

    public ConformanceMessaging withEvent(Collection<ConformanceEvent> values) {
        if (values != null) {
            this.getEvent().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceMessaging withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConformanceMessaging withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceMessaging withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConformanceMessaging withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceMessaging withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ConformanceEvent> rhsEvent;
        if (!(object instanceof ConformanceMessaging)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ConformanceMessaging that = (ConformanceMessaging)object;
        Uri lhsEndpoint = this.getEndpoint();
        Uri rhsEndpoint = that.getEndpoint();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"endpoint", (Object)lhsEndpoint), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"endpoint", (Object)rhsEndpoint), (Object)lhsEndpoint, (Object)rhsEndpoint)) {
            return false;
        }
        UnsignedInt lhsReliableCache = this.getReliableCache();
        UnsignedInt rhsReliableCache = that.getReliableCache();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reliableCache", (Object)lhsReliableCache), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reliableCache", (Object)rhsReliableCache), (Object)lhsReliableCache, (Object)rhsReliableCache)) {
            return false;
        }
        String lhsDocumentation = this.getDocumentation();
        String rhsDocumentation = that.getDocumentation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"documentation", (Object)lhsDocumentation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"documentation", (Object)rhsDocumentation), (Object)lhsDocumentation, (Object)rhsDocumentation)) {
            return false;
        }
        List<ConformanceEvent> lhsEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        List<ConformanceEvent> list = rhsEvent = that.event != null && !that.event.isEmpty() ? that.getEvent() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"event", lhsEvent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"event", rhsEvent), lhsEvent, rhsEvent);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theEndpoint = this.getEndpoint();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"endpoint", (Object)theEndpoint), currentHashCode, (Object)theEndpoint);
        UnsignedInt theReliableCache = this.getReliableCache();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reliableCache", (Object)theReliableCache), currentHashCode, (Object)theReliableCache);
        String theDocumentation = this.getDocumentation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"documentation", (Object)theDocumentation), currentHashCode, (Object)theDocumentation);
        List<ConformanceEvent> theEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"event", theEvent), currentHashCode, theEvent);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theEndpoint = this.getEndpoint();
        strategy.appendField(locator, (Object)this, "endpoint", buffer, (Object)theEndpoint);
        UnsignedInt theReliableCache = this.getReliableCache();
        strategy.appendField(locator, (Object)this, "reliableCache", buffer, (Object)theReliableCache);
        String theDocumentation = this.getDocumentation();
        strategy.appendField(locator, (Object)this, "documentation", buffer, (Object)theDocumentation);
        List<ConformanceEvent> theEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        strategy.appendField(locator, (Object)this, "event", buffer, theEvent);
        return buffer;
    }
}

