/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ConformanceCertificate;
import org.hl7.fhir.Extension;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Conformance.Security", propOrder={"cors", "service", "description", "certificate"})
public class ConformanceSecurity
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected Boolean cors;
    protected List<CodeableConcept> service;
    protected String description;
    protected List<ConformanceCertificate> certificate;

    public Boolean getCors() {
        return this.cors;
    }

    public void setCors(Boolean value) {
        this.cors = value;
    }

    public List<CodeableConcept> getService() {
        if (this.service == null) {
            this.service = new ArrayList<CodeableConcept>();
        }
        return this.service;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<ConformanceCertificate> getCertificate() {
        if (this.certificate == null) {
            this.certificate = new ArrayList<ConformanceCertificate>();
        }
        return this.certificate;
    }

    public ConformanceSecurity withCors(Boolean value) {
        this.setCors(value);
        return this;
    }

    public ConformanceSecurity withService(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getService().add(value);
            }
        }
        return this;
    }

    public ConformanceSecurity withService(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getService().addAll(values);
        }
        return this;
    }

    public ConformanceSecurity withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public ConformanceSecurity withCertificate(ConformanceCertificate ... values) {
        if (values != null) {
            for (ConformanceCertificate value : values) {
                this.getCertificate().add(value);
            }
        }
        return this;
    }

    public ConformanceSecurity withCertificate(Collection<ConformanceCertificate> values) {
        if (values != null) {
            this.getCertificate().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceSecurity withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConformanceSecurity withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceSecurity withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConformanceSecurity withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceSecurity withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ConformanceCertificate> rhsCertificate;
        List<CodeableConcept> rhsService;
        if (!(object instanceof ConformanceSecurity)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ConformanceSecurity that = (ConformanceSecurity)object;
        Boolean lhsCors = this.getCors();
        Boolean rhsCors = that.getCors();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"cors", (Object)lhsCors), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"cors", (Object)rhsCors), (Object)lhsCors, (Object)rhsCors)) {
            return false;
        }
        List<CodeableConcept> lhsService = this.service != null && !this.service.isEmpty() ? this.getService() : null;
        List<CodeableConcept> list = rhsService = that.service != null && !that.service.isEmpty() ? that.getService() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"service", lhsService), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"service", rhsService), lhsService, rhsService)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription)) {
            return false;
        }
        List<ConformanceCertificate> lhsCertificate = this.certificate != null && !this.certificate.isEmpty() ? this.getCertificate() : null;
        List<ConformanceCertificate> list2 = rhsCertificate = that.certificate != null && !that.certificate.isEmpty() ? that.getCertificate() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"certificate", lhsCertificate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"certificate", rhsCertificate), lhsCertificate, rhsCertificate);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Boolean theCors = this.getCors();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"cors", (Object)theCors), currentHashCode, (Object)theCors);
        List<CodeableConcept> theService = this.service != null && !this.service.isEmpty() ? this.getService() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"service", theService), currentHashCode, theService);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription);
        List<ConformanceCertificate> theCertificate = this.certificate != null && !this.certificate.isEmpty() ? this.getCertificate() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"certificate", theCertificate), currentHashCode, theCertificate);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Boolean theCors = this.getCors();
        strategy.appendField(locator, (Object)this, "cors", buffer, (Object)theCors);
        List<CodeableConcept> theService = this.service != null && !this.service.isEmpty() ? this.getService() : null;
        strategy.appendField(locator, (Object)this, "service", buffer, theService);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription);
        List<ConformanceCertificate> theCertificate = this.certificate != null && !this.certificate.isEmpty() ? this.getCertificate() : null;
        strategy.appendField(locator, (Object)this, "certificate", buffer, theCertificate);
        return buffer;
    }
}

