/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.PositiveInt;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Coverage", propOrder={"issuer", "bin", "period", "type", "subscriberId", "identifier", "group", "plan", "subPlan", "dependent", "sequence", "subscriber", "network", "contract"})
public class Coverage
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected Reference issuer;
    protected Identifier bin;
    protected Period period;
    protected Coding type;
    protected Identifier subscriberId;
    protected List<Identifier> identifier;
    protected String group;
    protected String plan;
    protected String subPlan;
    protected PositiveInt dependent;
    protected PositiveInt sequence;
    protected Reference subscriber;
    protected Identifier network;
    protected List<Reference> contract;

    public Reference getIssuer() {
        return this.issuer;
    }

    public void setIssuer(Reference value) {
        this.issuer = value;
    }

    public Identifier getBin() {
        return this.bin;
    }

    public void setBin(Identifier value) {
        this.bin = value;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period value) {
        this.period = value;
    }

    public Coding getType() {
        return this.type;
    }

    public void setType(Coding value) {
        this.type = value;
    }

    public Identifier getSubscriberId() {
        return this.subscriberId;
    }

    public void setSubscriberId(Identifier value) {
        this.subscriberId = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String value) {
        this.group = value;
    }

    public String getPlan() {
        return this.plan;
    }

    public void setPlan(String value) {
        this.plan = value;
    }

    public String getSubPlan() {
        return this.subPlan;
    }

    public void setSubPlan(String value) {
        this.subPlan = value;
    }

    public PositiveInt getDependent() {
        return this.dependent;
    }

    public void setDependent(PositiveInt value) {
        this.dependent = value;
    }

    public PositiveInt getSequence() {
        return this.sequence;
    }

    public void setSequence(PositiveInt value) {
        this.sequence = value;
    }

    public Reference getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(Reference value) {
        this.subscriber = value;
    }

    public Identifier getNetwork() {
        return this.network;
    }

    public void setNetwork(Identifier value) {
        this.network = value;
    }

    public List<Reference> getContract() {
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        return this.contract;
    }

    public Coverage withIssuer(Reference value) {
        this.setIssuer(value);
        return this;
    }

    public Coverage withBin(Identifier value) {
        this.setBin(value);
        return this;
    }

    public Coverage withPeriod(Period value) {
        this.setPeriod(value);
        return this;
    }

    public Coverage withType(Coding value) {
        this.setType(value);
        return this;
    }

    public Coverage withSubscriberId(Identifier value) {
        this.setSubscriberId(value);
        return this;
    }

    public Coverage withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Coverage withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Coverage withGroup(String value) {
        this.setGroup(value);
        return this;
    }

    public Coverage withPlan(String value) {
        this.setPlan(value);
        return this;
    }

    public Coverage withSubPlan(String value) {
        this.setSubPlan(value);
        return this;
    }

    public Coverage withDependent(PositiveInt value) {
        this.setDependent(value);
        return this;
    }

    public Coverage withSequence(PositiveInt value) {
        this.setSequence(value);
        return this;
    }

    public Coverage withSubscriber(Reference value) {
        this.setSubscriber(value);
        return this;
    }

    public Coverage withNetwork(Identifier value) {
        this.setNetwork(value);
        return this;
    }

    public Coverage withContract(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getContract().add(value);
            }
        }
        return this;
    }

    public Coverage withContract(Collection<Reference> values) {
        if (values != null) {
            this.getContract().addAll(values);
        }
        return this;
    }

    @Override
    public Coverage withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Coverage withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Coverage withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Coverage withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Coverage withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Coverage withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Coverage withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Coverage withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Coverage withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Coverage withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Coverage withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Reference> rhsContract;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof Coverage)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Coverage that = (Coverage)object;
        Reference lhsIssuer = this.getIssuer();
        Reference rhsIssuer = that.getIssuer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"issuer", (Object)lhsIssuer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"issuer", (Object)rhsIssuer), (Object)lhsIssuer, (Object)rhsIssuer)) {
            return false;
        }
        Identifier lhsBin = this.getBin();
        Identifier rhsBin = that.getBin();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"bin", (Object)lhsBin), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"bin", (Object)rhsBin), (Object)lhsBin, (Object)rhsBin)) {
            return false;
        }
        Period lhsPeriod = this.getPeriod();
        Period rhsPeriod = that.getPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"period", (Object)lhsPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"period", (Object)rhsPeriod), (Object)lhsPeriod, (Object)rhsPeriod)) {
            return false;
        }
        Coding lhsType = this.getType();
        Coding rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        Identifier lhsSubscriberId = this.getSubscriberId();
        Identifier rhsSubscriberId = that.getSubscriberId();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subscriberId", (Object)lhsSubscriberId), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subscriberId", (Object)rhsSubscriberId), (Object)lhsSubscriberId, (Object)rhsSubscriberId)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        String lhsGroup = this.getGroup();
        String rhsGroup = that.getGroup();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"group", (Object)lhsGroup), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"group", (Object)rhsGroup), (Object)lhsGroup, (Object)rhsGroup)) {
            return false;
        }
        String lhsPlan = this.getPlan();
        String rhsPlan = that.getPlan();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"plan", (Object)lhsPlan), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"plan", (Object)rhsPlan), (Object)lhsPlan, (Object)rhsPlan)) {
            return false;
        }
        String lhsSubPlan = this.getSubPlan();
        String rhsSubPlan = that.getSubPlan();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subPlan", (Object)lhsSubPlan), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subPlan", (Object)rhsSubPlan), (Object)lhsSubPlan, (Object)rhsSubPlan)) {
            return false;
        }
        PositiveInt lhsDependent = this.getDependent();
        PositiveInt rhsDependent = that.getDependent();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dependent", (Object)lhsDependent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dependent", (Object)rhsDependent), (Object)lhsDependent, (Object)rhsDependent)) {
            return false;
        }
        PositiveInt lhsSequence = this.getSequence();
        PositiveInt rhsSequence = that.getSequence();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"sequence", (Object)lhsSequence), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"sequence", (Object)rhsSequence), (Object)lhsSequence, (Object)rhsSequence)) {
            return false;
        }
        Reference lhsSubscriber = this.getSubscriber();
        Reference rhsSubscriber = that.getSubscriber();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subscriber", (Object)lhsSubscriber), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subscriber", (Object)rhsSubscriber), (Object)lhsSubscriber, (Object)rhsSubscriber)) {
            return false;
        }
        Identifier lhsNetwork = this.getNetwork();
        Identifier rhsNetwork = that.getNetwork();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"network", (Object)lhsNetwork), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"network", (Object)rhsNetwork), (Object)lhsNetwork, (Object)rhsNetwork)) {
            return false;
        }
        List<Reference> lhsContract = this.contract != null && !this.contract.isEmpty() ? this.getContract() : null;
        List<Reference> list2 = rhsContract = that.contract != null && !that.contract.isEmpty() ? that.getContract() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"contract", lhsContract), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"contract", rhsContract), lhsContract, rhsContract);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Reference theIssuer = this.getIssuer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"issuer", (Object)theIssuer), currentHashCode, (Object)theIssuer);
        Identifier theBin = this.getBin();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"bin", (Object)theBin), currentHashCode, (Object)theBin);
        Period thePeriod = this.getPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"period", (Object)thePeriod), currentHashCode, (Object)thePeriod);
        Coding theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType);
        Identifier theSubscriberId = this.getSubscriberId();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subscriberId", (Object)theSubscriberId), currentHashCode, (Object)theSubscriberId);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        String theGroup = this.getGroup();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"group", (Object)theGroup), currentHashCode, (Object)theGroup);
        String thePlan = this.getPlan();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"plan", (Object)thePlan), currentHashCode, (Object)thePlan);
        String theSubPlan = this.getSubPlan();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subPlan", (Object)theSubPlan), currentHashCode, (Object)theSubPlan);
        PositiveInt theDependent = this.getDependent();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dependent", (Object)theDependent), currentHashCode, (Object)theDependent);
        PositiveInt theSequence = this.getSequence();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"sequence", (Object)theSequence), currentHashCode, (Object)theSequence);
        Reference theSubscriber = this.getSubscriber();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subscriber", (Object)theSubscriber), currentHashCode, (Object)theSubscriber);
        Identifier theNetwork = this.getNetwork();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"network", (Object)theNetwork), currentHashCode, (Object)theNetwork);
        List<Reference> theContract = this.contract != null && !this.contract.isEmpty() ? this.getContract() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"contract", theContract), currentHashCode, theContract);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Reference theIssuer = this.getIssuer();
        strategy.appendField(locator, (Object)this, "issuer", buffer, (Object)theIssuer);
        Identifier theBin = this.getBin();
        strategy.appendField(locator, (Object)this, "bin", buffer, (Object)theBin);
        Period thePeriod = this.getPeriod();
        strategy.appendField(locator, (Object)this, "period", buffer, (Object)thePeriod);
        Coding theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        Identifier theSubscriberId = this.getSubscriberId();
        strategy.appendField(locator, (Object)this, "subscriberId", buffer, (Object)theSubscriberId);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        String theGroup = this.getGroup();
        strategy.appendField(locator, (Object)this, "group", buffer, (Object)theGroup);
        String thePlan = this.getPlan();
        strategy.appendField(locator, (Object)this, "plan", buffer, (Object)thePlan);
        String theSubPlan = this.getSubPlan();
        strategy.appendField(locator, (Object)this, "subPlan", buffer, (Object)theSubPlan);
        PositiveInt theDependent = this.getDependent();
        strategy.appendField(locator, (Object)this, "dependent", buffer, (Object)theDependent);
        PositiveInt theSequence = this.getSequence();
        strategy.appendField(locator, (Object)this, "sequence", buffer, (Object)theSequence);
        Reference theSubscriber = this.getSubscriber();
        strategy.appendField(locator, (Object)this, "subscriber", buffer, (Object)theSubscriber);
        Identifier theNetwork = this.getNetwork();
        strategy.appendField(locator, (Object)this, "network", buffer, (Object)theNetwork);
        List<Reference> theContract = this.contract != null && !this.contract.isEmpty() ? this.getContract() : null;
        strategy.appendField(locator, (Object)this, "contract", buffer, theContract);
        return buffer;
    }
}

