/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ContactPoint;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DeviceStatus;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Device", propOrder={"identifier", "type", "status", "manufacturer", "model", "version", "manufactureDate", "expiry", "udi", "lotNumber", "owner", "location", "patient", "contact", "url"})
public class Device
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected CodeableConcept type;
    protected DeviceStatus status;
    protected String manufacturer;
    protected String model;
    protected String version;
    protected DateTime manufactureDate;
    protected DateTime expiry;
    protected String udi;
    protected String lotNumber;
    protected Reference owner;
    protected Reference location;
    protected Reference patient;
    protected List<ContactPoint> contact;
    protected Uri url;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public DeviceStatus getStatus() {
        return this.status;
    }

    public void setStatus(DeviceStatus value) {
        this.status = value;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String value) {
        this.manufacturer = value;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String value) {
        this.model = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public DateTime getManufactureDate() {
        return this.manufactureDate;
    }

    public void setManufactureDate(DateTime value) {
        this.manufactureDate = value;
    }

    public DateTime getExpiry() {
        return this.expiry;
    }

    public void setExpiry(DateTime value) {
        this.expiry = value;
    }

    public String getUdi() {
        return this.udi;
    }

    public void setUdi(String value) {
        this.udi = value;
    }

    public String getLotNumber() {
        return this.lotNumber;
    }

    public void setLotNumber(String value) {
        this.lotNumber = value;
    }

    public Reference getOwner() {
        return this.owner;
    }

    public void setOwner(Reference value) {
        this.owner = value;
    }

    public Reference getLocation() {
        return this.location;
    }

    public void setLocation(Reference value) {
        this.location = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public List<ContactPoint> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        return this.contact;
    }

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public Device withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Device withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Device withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public Device withStatus(DeviceStatus value) {
        this.setStatus(value);
        return this;
    }

    public Device withManufacturer(String value) {
        this.setManufacturer(value);
        return this;
    }

    public Device withModel(String value) {
        this.setModel(value);
        return this;
    }

    public Device withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public Device withManufactureDate(DateTime value) {
        this.setManufactureDate(value);
        return this;
    }

    public Device withExpiry(DateTime value) {
        this.setExpiry(value);
        return this;
    }

    public Device withUdi(String value) {
        this.setUdi(value);
        return this;
    }

    public Device withLotNumber(String value) {
        this.setLotNumber(value);
        return this;
    }

    public Device withOwner(Reference value) {
        this.setOwner(value);
        return this;
    }

    public Device withLocation(Reference value) {
        this.setLocation(value);
        return this;
    }

    public Device withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public Device withContact(ContactPoint ... values) {
        if (values != null) {
            for (ContactPoint value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public Device withContact(Collection<ContactPoint> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public Device withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    @Override
    public Device withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Device withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Device withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Device withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Device withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Device withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Device withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Device withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Device withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Device withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Device withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ContactPoint> rhsContact;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof Device)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Device that = (Device)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        DeviceStatus lhsStatus = this.getStatus();
        DeviceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        String lhsManufacturer = this.getManufacturer();
        String rhsManufacturer = that.getManufacturer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"manufacturer", (Object)lhsManufacturer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"manufacturer", (Object)rhsManufacturer), (Object)lhsManufacturer, (Object)rhsManufacturer)) {
            return false;
        }
        String lhsModel = this.getModel();
        String rhsModel = that.getModel();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"model", (Object)lhsModel), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"model", (Object)rhsModel), (Object)lhsModel, (Object)rhsModel)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"version", (Object)lhsVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"version", (Object)rhsVersion), (Object)lhsVersion, (Object)rhsVersion)) {
            return false;
        }
        DateTime lhsManufactureDate = this.getManufactureDate();
        DateTime rhsManufactureDate = that.getManufactureDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"manufactureDate", (Object)lhsManufactureDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"manufactureDate", (Object)rhsManufactureDate), (Object)lhsManufactureDate, (Object)rhsManufactureDate)) {
            return false;
        }
        DateTime lhsExpiry = this.getExpiry();
        DateTime rhsExpiry = that.getExpiry();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"expiry", (Object)lhsExpiry), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"expiry", (Object)rhsExpiry), (Object)lhsExpiry, (Object)rhsExpiry)) {
            return false;
        }
        String lhsUdi = this.getUdi();
        String rhsUdi = that.getUdi();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"udi", (Object)lhsUdi), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"udi", (Object)rhsUdi), (Object)lhsUdi, (Object)rhsUdi)) {
            return false;
        }
        String lhsLotNumber = this.getLotNumber();
        String rhsLotNumber = that.getLotNumber();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"lotNumber", (Object)lhsLotNumber), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"lotNumber", (Object)rhsLotNumber), (Object)lhsLotNumber, (Object)rhsLotNumber)) {
            return false;
        }
        Reference lhsOwner = this.getOwner();
        Reference rhsOwner = that.getOwner();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"owner", (Object)lhsOwner), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"owner", (Object)rhsOwner), (Object)lhsOwner, (Object)rhsOwner)) {
            return false;
        }
        Reference lhsLocation = this.getLocation();
        Reference rhsLocation = that.getLocation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"location", (Object)lhsLocation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"location", (Object)rhsLocation), (Object)lhsLocation, (Object)rhsLocation)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        List<ContactPoint> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<ContactPoint> list2 = rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"contact", lhsContact), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"contact", rhsContact), lhsContact, rhsContact)) {
            return false;
        }
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"url", (Object)lhsUrl), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"url", (Object)rhsUrl), (Object)lhsUrl, (Object)rhsUrl);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType);
        DeviceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        String theManufacturer = this.getManufacturer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"manufacturer", (Object)theManufacturer), currentHashCode, (Object)theManufacturer);
        String theModel = this.getModel();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"model", (Object)theModel), currentHashCode, (Object)theModel);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"version", (Object)theVersion), currentHashCode, (Object)theVersion);
        DateTime theManufactureDate = this.getManufactureDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"manufactureDate", (Object)theManufactureDate), currentHashCode, (Object)theManufactureDate);
        DateTime theExpiry = this.getExpiry();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"expiry", (Object)theExpiry), currentHashCode, (Object)theExpiry);
        String theUdi = this.getUdi();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"udi", (Object)theUdi), currentHashCode, (Object)theUdi);
        String theLotNumber = this.getLotNumber();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"lotNumber", (Object)theLotNumber), currentHashCode, (Object)theLotNumber);
        Reference theOwner = this.getOwner();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"owner", (Object)theOwner), currentHashCode, (Object)theOwner);
        Reference theLocation = this.getLocation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"location", (Object)theLocation), currentHashCode, (Object)theLocation);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        List<ContactPoint> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"contact", theContact), currentHashCode, theContact);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"url", (Object)theUrl), currentHashCode, (Object)theUrl);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        DeviceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        String theManufacturer = this.getManufacturer();
        strategy.appendField(locator, (Object)this, "manufacturer", buffer, (Object)theManufacturer);
        String theModel = this.getModel();
        strategy.appendField(locator, (Object)this, "model", buffer, (Object)theModel);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, (Object)theVersion);
        DateTime theManufactureDate = this.getManufactureDate();
        strategy.appendField(locator, (Object)this, "manufactureDate", buffer, (Object)theManufactureDate);
        DateTime theExpiry = this.getExpiry();
        strategy.appendField(locator, (Object)this, "expiry", buffer, (Object)theExpiry);
        String theUdi = this.getUdi();
        strategy.appendField(locator, (Object)this, "udi", buffer, (Object)theUdi);
        String theLotNumber = this.getLotNumber();
        strategy.appendField(locator, (Object)this, "lotNumber", buffer, (Object)theLotNumber);
        Reference theOwner = this.getOwner();
        strategy.appendField(locator, (Object)this, "owner", buffer, (Object)theOwner);
        Reference theLocation = this.getLocation();
        strategy.appendField(locator, (Object)this, "location", buffer, (Object)theLocation);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        List<ContactPoint> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, (Object)theUrl);
        return buffer;
    }
}

