/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Attachment;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DiagnosticReportImage;
import org.hl7.fhir.DiagnosticReportStatus;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DiagnosticReport", propOrder={"name", "status", "issued", "subject", "performer", "encounter", "identifier", "requestDetail", "serviceCategory", "diagnosticDateTime", "diagnosticPeriod", "specimen", "result", "imagingStudy", "image", "conclusion", "codedDiagnosis", "presentedForm"})
public class DiagnosticReport
extends DomainResource
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected CodeableConcept name;
    @XmlElement(required=true)
    protected DiagnosticReportStatus status;
    @XmlElement(required=true)
    protected DateTime issued;
    @XmlElement(required=true)
    protected Reference subject;
    @XmlElement(required=true)
    protected Reference performer;
    protected Reference encounter;
    protected List<Identifier> identifier;
    protected List<Reference> requestDetail;
    protected CodeableConcept serviceCategory;
    protected DateTime diagnosticDateTime;
    protected Period diagnosticPeriod;
    protected List<Reference> specimen;
    protected List<Reference> result;
    protected List<Reference> imagingStudy;
    protected List<DiagnosticReportImage> image;
    protected String conclusion;
    protected List<CodeableConcept> codedDiagnosis;
    protected List<Attachment> presentedForm;

    public CodeableConcept getName() {
        return this.name;
    }

    public void setName(CodeableConcept value) {
        this.name = value;
    }

    public DiagnosticReportStatus getStatus() {
        return this.status;
    }

    public void setStatus(DiagnosticReportStatus value) {
        this.status = value;
    }

    public DateTime getIssued() {
        return this.issued;
    }

    public void setIssued(DateTime value) {
        this.issued = value;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public Reference getPerformer() {
        return this.performer;
    }

    public void setPerformer(Reference value) {
        this.performer = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public List<Reference> getRequestDetail() {
        if (this.requestDetail == null) {
            this.requestDetail = new ArrayList<Reference>();
        }
        return this.requestDetail;
    }

    public CodeableConcept getServiceCategory() {
        return this.serviceCategory;
    }

    public void setServiceCategory(CodeableConcept value) {
        this.serviceCategory = value;
    }

    public DateTime getDiagnosticDateTime() {
        return this.diagnosticDateTime;
    }

    public void setDiagnosticDateTime(DateTime value) {
        this.diagnosticDateTime = value;
    }

    public Period getDiagnosticPeriod() {
        return this.diagnosticPeriod;
    }

    public void setDiagnosticPeriod(Period value) {
        this.diagnosticPeriod = value;
    }

    public List<Reference> getSpecimen() {
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        return this.specimen;
    }

    public List<Reference> getResult() {
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        return this.result;
    }

    public List<Reference> getImagingStudy() {
        if (this.imagingStudy == null) {
            this.imagingStudy = new ArrayList<Reference>();
        }
        return this.imagingStudy;
    }

    public List<DiagnosticReportImage> getImage() {
        if (this.image == null) {
            this.image = new ArrayList<DiagnosticReportImage>();
        }
        return this.image;
    }

    public String getConclusion() {
        return this.conclusion;
    }

    public void setConclusion(String value) {
        this.conclusion = value;
    }

    public List<CodeableConcept> getCodedDiagnosis() {
        if (this.codedDiagnosis == null) {
            this.codedDiagnosis = new ArrayList<CodeableConcept>();
        }
        return this.codedDiagnosis;
    }

    public List<Attachment> getPresentedForm() {
        if (this.presentedForm == null) {
            this.presentedForm = new ArrayList<Attachment>();
        }
        return this.presentedForm;
    }

    public DiagnosticReport withName(CodeableConcept value) {
        this.setName(value);
        return this;
    }

    public DiagnosticReport withStatus(DiagnosticReportStatus value) {
        this.setStatus(value);
        return this;
    }

    public DiagnosticReport withIssued(DateTime value) {
        this.setIssued(value);
        return this;
    }

    public DiagnosticReport withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public DiagnosticReport withPerformer(Reference value) {
        this.setPerformer(value);
        return this;
    }

    public DiagnosticReport withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public DiagnosticReport withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public DiagnosticReport withRequestDetail(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getRequestDetail().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withRequestDetail(Collection<Reference> values) {
        if (values != null) {
            this.getRequestDetail().addAll(values);
        }
        return this;
    }

    public DiagnosticReport withServiceCategory(CodeableConcept value) {
        this.setServiceCategory(value);
        return this;
    }

    public DiagnosticReport withDiagnosticDateTime(DateTime value) {
        this.setDiagnosticDateTime(value);
        return this;
    }

    public DiagnosticReport withDiagnosticPeriod(Period value) {
        this.setDiagnosticPeriod(value);
        return this;
    }

    public DiagnosticReport withSpecimen(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getSpecimen().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withSpecimen(Collection<Reference> values) {
        if (values != null) {
            this.getSpecimen().addAll(values);
        }
        return this;
    }

    public DiagnosticReport withResult(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getResult().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withResult(Collection<Reference> values) {
        if (values != null) {
            this.getResult().addAll(values);
        }
        return this;
    }

    public DiagnosticReport withImagingStudy(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getImagingStudy().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withImagingStudy(Collection<Reference> values) {
        if (values != null) {
            this.getImagingStudy().addAll(values);
        }
        return this;
    }

    public DiagnosticReport withImage(DiagnosticReportImage ... values) {
        if (values != null) {
            for (DiagnosticReportImage value : values) {
                this.getImage().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withImage(Collection<DiagnosticReportImage> values) {
        if (values != null) {
            this.getImage().addAll(values);
        }
        return this;
    }

    public DiagnosticReport withConclusion(String value) {
        this.setConclusion(value);
        return this;
    }

    public DiagnosticReport withCodedDiagnosis(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getCodedDiagnosis().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withCodedDiagnosis(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getCodedDiagnosis().addAll(values);
        }
        return this;
    }

    public DiagnosticReport withPresentedForm(Attachment ... values) {
        if (values != null) {
            for (Attachment value : values) {
                this.getPresentedForm().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withPresentedForm(Collection<Attachment> values) {
        if (values != null) {
            this.getPresentedForm().addAll(values);
        }
        return this;
    }

    @Override
    public DiagnosticReport withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public DiagnosticReport withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public DiagnosticReport withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public DiagnosticReport withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DiagnosticReport withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DiagnosticReport withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DiagnosticReport withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DiagnosticReport withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public DiagnosticReport withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public DiagnosticReport withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public DiagnosticReport withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Attachment> rhsPresentedForm;
        List<CodeableConcept> rhsCodedDiagnosis;
        List<DiagnosticReportImage> rhsImage;
        List<Reference> rhsImagingStudy;
        List<Reference> rhsResult;
        List<Reference> rhsSpecimen;
        List<Reference> rhsRequestDetail;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof DiagnosticReport)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        DiagnosticReport that = (DiagnosticReport)object;
        CodeableConcept lhsName = this.getName();
        CodeableConcept rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"name", (Object)lhsName), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"name", (Object)rhsName), (Object)lhsName, (Object)rhsName)) {
            return false;
        }
        DiagnosticReportStatus lhsStatus = this.getStatus();
        DiagnosticReportStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        DateTime lhsIssued = this.getIssued();
        DateTime rhsIssued = that.getIssued();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"issued", (Object)lhsIssued), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"issued", (Object)rhsIssued), (Object)lhsIssued, (Object)rhsIssued)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject)) {
            return false;
        }
        Reference lhsPerformer = this.getPerformer();
        Reference rhsPerformer = that.getPerformer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"performer", (Object)lhsPerformer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"performer", (Object)rhsPerformer), (Object)lhsPerformer, (Object)rhsPerformer)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        List<Reference> lhsRequestDetail = this.requestDetail != null && !this.requestDetail.isEmpty() ? this.getRequestDetail() : null;
        List<Reference> list2 = rhsRequestDetail = that.requestDetail != null && !that.requestDetail.isEmpty() ? that.getRequestDetail() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requestDetail", lhsRequestDetail), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requestDetail", rhsRequestDetail), lhsRequestDetail, rhsRequestDetail)) {
            return false;
        }
        CodeableConcept lhsServiceCategory = this.getServiceCategory();
        CodeableConcept rhsServiceCategory = that.getServiceCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"serviceCategory", (Object)lhsServiceCategory), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"serviceCategory", (Object)rhsServiceCategory), (Object)lhsServiceCategory, (Object)rhsServiceCategory)) {
            return false;
        }
        DateTime lhsDiagnosticDateTime = this.getDiagnosticDateTime();
        DateTime rhsDiagnosticDateTime = that.getDiagnosticDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"diagnosticDateTime", (Object)lhsDiagnosticDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"diagnosticDateTime", (Object)rhsDiagnosticDateTime), (Object)lhsDiagnosticDateTime, (Object)rhsDiagnosticDateTime)) {
            return false;
        }
        Period lhsDiagnosticPeriod = this.getDiagnosticPeriod();
        Period rhsDiagnosticPeriod = that.getDiagnosticPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"diagnosticPeriod", (Object)lhsDiagnosticPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"diagnosticPeriod", (Object)rhsDiagnosticPeriod), (Object)lhsDiagnosticPeriod, (Object)rhsDiagnosticPeriod)) {
            return false;
        }
        List<Reference> lhsSpecimen = this.specimen != null && !this.specimen.isEmpty() ? this.getSpecimen() : null;
        List<Reference> list3 = rhsSpecimen = that.specimen != null && !that.specimen.isEmpty() ? that.getSpecimen() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"specimen", lhsSpecimen), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"specimen", rhsSpecimen), lhsSpecimen, rhsSpecimen)) {
            return false;
        }
        List<Reference> lhsResult = this.result != null && !this.result.isEmpty() ? this.getResult() : null;
        List<Reference> list4 = rhsResult = that.result != null && !that.result.isEmpty() ? that.getResult() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"result", lhsResult), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"result", rhsResult), lhsResult, rhsResult)) {
            return false;
        }
        List<Reference> lhsImagingStudy = this.imagingStudy != null && !this.imagingStudy.isEmpty() ? this.getImagingStudy() : null;
        List<Reference> list5 = rhsImagingStudy = that.imagingStudy != null && !that.imagingStudy.isEmpty() ? that.getImagingStudy() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"imagingStudy", lhsImagingStudy), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"imagingStudy", rhsImagingStudy), lhsImagingStudy, rhsImagingStudy)) {
            return false;
        }
        List<DiagnosticReportImage> lhsImage = this.image != null && !this.image.isEmpty() ? this.getImage() : null;
        List<DiagnosticReportImage> list6 = rhsImage = that.image != null && !that.image.isEmpty() ? that.getImage() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"image", lhsImage), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"image", rhsImage), lhsImage, rhsImage)) {
            return false;
        }
        String lhsConclusion = this.getConclusion();
        String rhsConclusion = that.getConclusion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"conclusion", (Object)lhsConclusion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"conclusion", (Object)rhsConclusion), (Object)lhsConclusion, (Object)rhsConclusion)) {
            return false;
        }
        List<CodeableConcept> lhsCodedDiagnosis = this.codedDiagnosis != null && !this.codedDiagnosis.isEmpty() ? this.getCodedDiagnosis() : null;
        List<CodeableConcept> list7 = rhsCodedDiagnosis = that.codedDiagnosis != null && !that.codedDiagnosis.isEmpty() ? that.getCodedDiagnosis() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"codedDiagnosis", lhsCodedDiagnosis), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"codedDiagnosis", rhsCodedDiagnosis), lhsCodedDiagnosis, rhsCodedDiagnosis)) {
            return false;
        }
        List<Attachment> lhsPresentedForm = this.presentedForm != null && !this.presentedForm.isEmpty() ? this.getPresentedForm() : null;
        List<Attachment> list8 = rhsPresentedForm = that.presentedForm != null && !that.presentedForm.isEmpty() ? that.getPresentedForm() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"presentedForm", lhsPresentedForm), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"presentedForm", rhsPresentedForm), lhsPresentedForm, rhsPresentedForm);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"name", (Object)theName), currentHashCode, (Object)theName);
        DiagnosticReportStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        DateTime theIssued = this.getIssued();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"issued", (Object)theIssued), currentHashCode, (Object)theIssued);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject);
        Reference thePerformer = this.getPerformer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"performer", (Object)thePerformer), currentHashCode, (Object)thePerformer);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        List<Reference> theRequestDetail = this.requestDetail != null && !this.requestDetail.isEmpty() ? this.getRequestDetail() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requestDetail", theRequestDetail), currentHashCode, theRequestDetail);
        CodeableConcept theServiceCategory = this.getServiceCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"serviceCategory", (Object)theServiceCategory), currentHashCode, (Object)theServiceCategory);
        DateTime theDiagnosticDateTime = this.getDiagnosticDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"diagnosticDateTime", (Object)theDiagnosticDateTime), currentHashCode, (Object)theDiagnosticDateTime);
        Period theDiagnosticPeriod = this.getDiagnosticPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"diagnosticPeriod", (Object)theDiagnosticPeriod), currentHashCode, (Object)theDiagnosticPeriod);
        List<Reference> theSpecimen = this.specimen != null && !this.specimen.isEmpty() ? this.getSpecimen() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"specimen", theSpecimen), currentHashCode, theSpecimen);
        List<Reference> theResult = this.result != null && !this.result.isEmpty() ? this.getResult() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"result", theResult), currentHashCode, theResult);
        List<Reference> theImagingStudy = this.imagingStudy != null && !this.imagingStudy.isEmpty() ? this.getImagingStudy() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"imagingStudy", theImagingStudy), currentHashCode, theImagingStudy);
        List<DiagnosticReportImage> theImage = this.image != null && !this.image.isEmpty() ? this.getImage() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"image", theImage), currentHashCode, theImage);
        String theConclusion = this.getConclusion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"conclusion", (Object)theConclusion), currentHashCode, (Object)theConclusion);
        List<CodeableConcept> theCodedDiagnosis = this.codedDiagnosis != null && !this.codedDiagnosis.isEmpty() ? this.getCodedDiagnosis() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"codedDiagnosis", theCodedDiagnosis), currentHashCode, theCodedDiagnosis);
        List<Attachment> thePresentedForm = this.presentedForm != null && !this.presentedForm.isEmpty() ? this.getPresentedForm() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"presentedForm", thePresentedForm), currentHashCode, thePresentedForm);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, (Object)theName);
        DiagnosticReportStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        DateTime theIssued = this.getIssued();
        strategy.appendField(locator, (Object)this, "issued", buffer, (Object)theIssued);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject);
        Reference thePerformer = this.getPerformer();
        strategy.appendField(locator, (Object)this, "performer", buffer, (Object)thePerformer);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        List<Reference> theRequestDetail = this.requestDetail != null && !this.requestDetail.isEmpty() ? this.getRequestDetail() : null;
        strategy.appendField(locator, (Object)this, "requestDetail", buffer, theRequestDetail);
        CodeableConcept theServiceCategory = this.getServiceCategory();
        strategy.appendField(locator, (Object)this, "serviceCategory", buffer, (Object)theServiceCategory);
        DateTime theDiagnosticDateTime = this.getDiagnosticDateTime();
        strategy.appendField(locator, (Object)this, "diagnosticDateTime", buffer, (Object)theDiagnosticDateTime);
        Period theDiagnosticPeriod = this.getDiagnosticPeriod();
        strategy.appendField(locator, (Object)this, "diagnosticPeriod", buffer, (Object)theDiagnosticPeriod);
        List<Reference> theSpecimen = this.specimen != null && !this.specimen.isEmpty() ? this.getSpecimen() : null;
        strategy.appendField(locator, (Object)this, "specimen", buffer, theSpecimen);
        List<Reference> theResult = this.result != null && !this.result.isEmpty() ? this.getResult() : null;
        strategy.appendField(locator, (Object)this, "result", buffer, theResult);
        List<Reference> theImagingStudy = this.imagingStudy != null && !this.imagingStudy.isEmpty() ? this.getImagingStudy() : null;
        strategy.appendField(locator, (Object)this, "imagingStudy", buffer, theImagingStudy);
        List<DiagnosticReportImage> theImage = this.image != null && !this.image.isEmpty() ? this.getImage() : null;
        strategy.appendField(locator, (Object)this, "image", buffer, theImage);
        String theConclusion = this.getConclusion();
        strategy.appendField(locator, (Object)this, "conclusion", buffer, (Object)theConclusion);
        List<CodeableConcept> theCodedDiagnosis = this.codedDiagnosis != null && !this.codedDiagnosis.isEmpty() ? this.getCodedDiagnosis() : null;
        strategy.appendField(locator, (Object)this, "codedDiagnosis", buffer, theCodedDiagnosis);
        List<Attachment> thePresentedForm = this.presentedForm != null && !this.presentedForm.isEmpty() ? this.getPresentedForm() : null;
        strategy.appendField(locator, (Object)this, "presentedForm", buffer, thePresentedForm);
        return buffer;
    }
}

