/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Attachment;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DocumentReferenceContext;
import org.hl7.fhir.DocumentReferenceRelatesTo;
import org.hl7.fhir.DocumentReferenceStatus;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Instant;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DocumentReference", propOrder={"masterIdentifier", "identifier", "subject", "type", "clazz", "format", "author", "custodian", "authenticator", "created", "indexed", "status", "docStatus", "relatesTo", "description", "confidentiality", "content", "context"})
public class DocumentReference
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected Identifier masterIdentifier;
    protected List<Identifier> identifier;
    protected Reference subject;
    @XmlElement(required=true)
    protected CodeableConcept type;
    @XmlElement(name="class")
    protected CodeableConcept clazz;
    protected List<Uri> format;
    @XmlElement(required=true)
    protected List<Reference> author;
    protected Reference custodian;
    protected Reference authenticator;
    protected DateTime created;
    @XmlElement(required=true)
    protected Instant indexed;
    @XmlElement(required=true)
    protected DocumentReferenceStatus status;
    protected CodeableConcept docStatus;
    protected List<DocumentReferenceRelatesTo> relatesTo;
    protected String description;
    protected List<CodeableConcept> confidentiality;
    @XmlElement(required=true)
    protected List<Attachment> content;
    protected DocumentReferenceContext context;

    public Identifier getMasterIdentifier() {
        return this.masterIdentifier;
    }

    public void setMasterIdentifier(Identifier value) {
        this.masterIdentifier = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public CodeableConcept getClazz() {
        return this.clazz;
    }

    public void setClazz(CodeableConcept value) {
        this.clazz = value;
    }

    public List<Uri> getFormat() {
        if (this.format == null) {
            this.format = new ArrayList<Uri>();
        }
        return this.format;
    }

    public List<Reference> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        return this.author;
    }

    public Reference getCustodian() {
        return this.custodian;
    }

    public void setCustodian(Reference value) {
        this.custodian = value;
    }

    public Reference getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Reference value) {
        this.authenticator = value;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime value) {
        this.created = value;
    }

    public Instant getIndexed() {
        return this.indexed;
    }

    public void setIndexed(Instant value) {
        this.indexed = value;
    }

    public DocumentReferenceStatus getStatus() {
        return this.status;
    }

    public void setStatus(DocumentReferenceStatus value) {
        this.status = value;
    }

    public CodeableConcept getDocStatus() {
        return this.docStatus;
    }

    public void setDocStatus(CodeableConcept value) {
        this.docStatus = value;
    }

    public List<DocumentReferenceRelatesTo> getRelatesTo() {
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<DocumentReferenceRelatesTo>();
        }
        return this.relatesTo;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<CodeableConcept> getConfidentiality() {
        if (this.confidentiality == null) {
            this.confidentiality = new ArrayList<CodeableConcept>();
        }
        return this.confidentiality;
    }

    public List<Attachment> getContent() {
        if (this.content == null) {
            this.content = new ArrayList<Attachment>();
        }
        return this.content;
    }

    public DocumentReferenceContext getContext() {
        return this.context;
    }

    public void setContext(DocumentReferenceContext value) {
        this.context = value;
    }

    public DocumentReference withMasterIdentifier(Identifier value) {
        this.setMasterIdentifier(value);
        return this;
    }

    public DocumentReference withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public DocumentReference withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public DocumentReference withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public DocumentReference withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public DocumentReference withClazz(CodeableConcept value) {
        this.setClazz(value);
        return this;
    }

    public DocumentReference withFormat(Uri ... values) {
        if (values != null) {
            for (Uri value : values) {
                this.getFormat().add(value);
            }
        }
        return this;
    }

    public DocumentReference withFormat(Collection<Uri> values) {
        if (values != null) {
            this.getFormat().addAll(values);
        }
        return this;
    }

    public DocumentReference withAuthor(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAuthor().add(value);
            }
        }
        return this;
    }

    public DocumentReference withAuthor(Collection<Reference> values) {
        if (values != null) {
            this.getAuthor().addAll(values);
        }
        return this;
    }

    public DocumentReference withCustodian(Reference value) {
        this.setCustodian(value);
        return this;
    }

    public DocumentReference withAuthenticator(Reference value) {
        this.setAuthenticator(value);
        return this;
    }

    public DocumentReference withCreated(DateTime value) {
        this.setCreated(value);
        return this;
    }

    public DocumentReference withIndexed(Instant value) {
        this.setIndexed(value);
        return this;
    }

    public DocumentReference withStatus(DocumentReferenceStatus value) {
        this.setStatus(value);
        return this;
    }

    public DocumentReference withDocStatus(CodeableConcept value) {
        this.setDocStatus(value);
        return this;
    }

    public DocumentReference withRelatesTo(DocumentReferenceRelatesTo ... values) {
        if (values != null) {
            for (DocumentReferenceRelatesTo value : values) {
                this.getRelatesTo().add(value);
            }
        }
        return this;
    }

    public DocumentReference withRelatesTo(Collection<DocumentReferenceRelatesTo> values) {
        if (values != null) {
            this.getRelatesTo().addAll(values);
        }
        return this;
    }

    public DocumentReference withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public DocumentReference withConfidentiality(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getConfidentiality().add(value);
            }
        }
        return this;
    }

    public DocumentReference withConfidentiality(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getConfidentiality().addAll(values);
        }
        return this;
    }

    public DocumentReference withContent(Attachment ... values) {
        if (values != null) {
            for (Attachment value : values) {
                this.getContent().add(value);
            }
        }
        return this;
    }

    public DocumentReference withContent(Collection<Attachment> values) {
        if (values != null) {
            this.getContent().addAll(values);
        }
        return this;
    }

    public DocumentReference withContext(DocumentReferenceContext value) {
        this.setContext(value);
        return this;
    }

    @Override
    public DocumentReference withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public DocumentReference withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public DocumentReference withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public DocumentReference withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DocumentReference withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DocumentReference withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DocumentReference withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DocumentReference withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public DocumentReference withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public DocumentReference withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public DocumentReference withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Attachment> rhsContent;
        List<CodeableConcept> rhsConfidentiality;
        List<DocumentReferenceRelatesTo> rhsRelatesTo;
        List<Reference> rhsAuthor;
        List<Uri> rhsFormat;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof DocumentReference)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        DocumentReference that = (DocumentReference)object;
        Identifier lhsMasterIdentifier = this.getMasterIdentifier();
        Identifier rhsMasterIdentifier = that.getMasterIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"masterIdentifier", (Object)lhsMasterIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"masterIdentifier", (Object)rhsMasterIdentifier), (Object)lhsMasterIdentifier, (Object)rhsMasterIdentifier)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        CodeableConcept lhsClazz = this.getClazz();
        CodeableConcept rhsClazz = that.getClazz();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"clazz", (Object)lhsClazz), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"clazz", (Object)rhsClazz), (Object)lhsClazz, (Object)rhsClazz)) {
            return false;
        }
        List<Uri> lhsFormat = this.format != null && !this.format.isEmpty() ? this.getFormat() : null;
        List<Uri> list2 = rhsFormat = that.format != null && !that.format.isEmpty() ? that.getFormat() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"format", lhsFormat), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"format", rhsFormat), lhsFormat, rhsFormat)) {
            return false;
        }
        List<Reference> lhsAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        List<Reference> list3 = rhsAuthor = that.author != null && !that.author.isEmpty() ? that.getAuthor() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"author", lhsAuthor), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"author", rhsAuthor), lhsAuthor, rhsAuthor)) {
            return false;
        }
        Reference lhsCustodian = this.getCustodian();
        Reference rhsCustodian = that.getCustodian();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"custodian", (Object)lhsCustodian), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"custodian", (Object)rhsCustodian), (Object)lhsCustodian, (Object)rhsCustodian)) {
            return false;
        }
        Reference lhsAuthenticator = this.getAuthenticator();
        Reference rhsAuthenticator = that.getAuthenticator();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"authenticator", (Object)lhsAuthenticator), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"authenticator", (Object)rhsAuthenticator), (Object)lhsAuthenticator, (Object)rhsAuthenticator)) {
            return false;
        }
        DateTime lhsCreated = this.getCreated();
        DateTime rhsCreated = that.getCreated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"created", (Object)lhsCreated), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"created", (Object)rhsCreated), (Object)lhsCreated, (Object)rhsCreated)) {
            return false;
        }
        Instant lhsIndexed = this.getIndexed();
        Instant rhsIndexed = that.getIndexed();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"indexed", (Object)lhsIndexed), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"indexed", (Object)rhsIndexed), (Object)lhsIndexed, (Object)rhsIndexed)) {
            return false;
        }
        DocumentReferenceStatus lhsStatus = this.getStatus();
        DocumentReferenceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        CodeableConcept lhsDocStatus = this.getDocStatus();
        CodeableConcept rhsDocStatus = that.getDocStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"docStatus", (Object)lhsDocStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"docStatus", (Object)rhsDocStatus), (Object)lhsDocStatus, (Object)rhsDocStatus)) {
            return false;
        }
        List<DocumentReferenceRelatesTo> lhsRelatesTo = this.relatesTo != null && !this.relatesTo.isEmpty() ? this.getRelatesTo() : null;
        List<DocumentReferenceRelatesTo> list4 = rhsRelatesTo = that.relatesTo != null && !that.relatesTo.isEmpty() ? that.getRelatesTo() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"relatesTo", lhsRelatesTo), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"relatesTo", rhsRelatesTo), lhsRelatesTo, rhsRelatesTo)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription)) {
            return false;
        }
        List<CodeableConcept> lhsConfidentiality = this.confidentiality != null && !this.confidentiality.isEmpty() ? this.getConfidentiality() : null;
        List<CodeableConcept> list5 = rhsConfidentiality = that.confidentiality != null && !that.confidentiality.isEmpty() ? that.getConfidentiality() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"confidentiality", lhsConfidentiality), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"confidentiality", rhsConfidentiality), lhsConfidentiality, rhsConfidentiality)) {
            return false;
        }
        List<Attachment> lhsContent = this.content != null && !this.content.isEmpty() ? this.getContent() : null;
        List<Attachment> list6 = rhsContent = that.content != null && !that.content.isEmpty() ? that.getContent() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"content", lhsContent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"content", rhsContent), lhsContent, rhsContent)) {
            return false;
        }
        DocumentReferenceContext lhsContext = this.getContext();
        DocumentReferenceContext rhsContext = that.getContext();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"context", (Object)lhsContext), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"context", (Object)rhsContext), (Object)lhsContext, (Object)rhsContext);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theMasterIdentifier = this.getMasterIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"masterIdentifier", (Object)theMasterIdentifier), currentHashCode, (Object)theMasterIdentifier);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType);
        CodeableConcept theClazz = this.getClazz();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"clazz", (Object)theClazz), currentHashCode, (Object)theClazz);
        List<Uri> theFormat = this.format != null && !this.format.isEmpty() ? this.getFormat() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"format", theFormat), currentHashCode, theFormat);
        List<Reference> theAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"author", theAuthor), currentHashCode, theAuthor);
        Reference theCustodian = this.getCustodian();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"custodian", (Object)theCustodian), currentHashCode, (Object)theCustodian);
        Reference theAuthenticator = this.getAuthenticator();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"authenticator", (Object)theAuthenticator), currentHashCode, (Object)theAuthenticator);
        DateTime theCreated = this.getCreated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"created", (Object)theCreated), currentHashCode, (Object)theCreated);
        Instant theIndexed = this.getIndexed();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"indexed", (Object)theIndexed), currentHashCode, (Object)theIndexed);
        DocumentReferenceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        CodeableConcept theDocStatus = this.getDocStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"docStatus", (Object)theDocStatus), currentHashCode, (Object)theDocStatus);
        List<DocumentReferenceRelatesTo> theRelatesTo = this.relatesTo != null && !this.relatesTo.isEmpty() ? this.getRelatesTo() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"relatesTo", theRelatesTo), currentHashCode, theRelatesTo);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription);
        List<CodeableConcept> theConfidentiality = this.confidentiality != null && !this.confidentiality.isEmpty() ? this.getConfidentiality() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"confidentiality", theConfidentiality), currentHashCode, theConfidentiality);
        List<Attachment> theContent = this.content != null && !this.content.isEmpty() ? this.getContent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"content", theContent), currentHashCode, theContent);
        DocumentReferenceContext theContext = this.getContext();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"context", (Object)theContext), currentHashCode, (Object)theContext);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theMasterIdentifier = this.getMasterIdentifier();
        strategy.appendField(locator, (Object)this, "masterIdentifier", buffer, (Object)theMasterIdentifier);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        CodeableConcept theClazz = this.getClazz();
        strategy.appendField(locator, (Object)this, "clazz", buffer, (Object)theClazz);
        List<Uri> theFormat = this.format != null && !this.format.isEmpty() ? this.getFormat() : null;
        strategy.appendField(locator, (Object)this, "format", buffer, theFormat);
        List<Reference> theAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        strategy.appendField(locator, (Object)this, "author", buffer, theAuthor);
        Reference theCustodian = this.getCustodian();
        strategy.appendField(locator, (Object)this, "custodian", buffer, (Object)theCustodian);
        Reference theAuthenticator = this.getAuthenticator();
        strategy.appendField(locator, (Object)this, "authenticator", buffer, (Object)theAuthenticator);
        DateTime theCreated = this.getCreated();
        strategy.appendField(locator, (Object)this, "created", buffer, (Object)theCreated);
        Instant theIndexed = this.getIndexed();
        strategy.appendField(locator, (Object)this, "indexed", buffer, (Object)theIndexed);
        DocumentReferenceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        CodeableConcept theDocStatus = this.getDocStatus();
        strategy.appendField(locator, (Object)this, "docStatus", buffer, (Object)theDocStatus);
        List<DocumentReferenceRelatesTo> theRelatesTo = this.relatesTo != null && !this.relatesTo.isEmpty() ? this.getRelatesTo() : null;
        strategy.appendField(locator, (Object)this, "relatesTo", buffer, theRelatesTo);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription);
        List<CodeableConcept> theConfidentiality = this.confidentiality != null && !this.confidentiality.isEmpty() ? this.getConfidentiality() : null;
        strategy.appendField(locator, (Object)this, "confidentiality", buffer, theConfidentiality);
        List<Attachment> theContent = this.content != null && !this.content.isEmpty() ? this.getContent() : null;
        strategy.appendField(locator, (Object)this, "content", buffer, theContent);
        DocumentReferenceContext theContext = this.getContext();
        strategy.appendField(locator, (Object)this, "context", buffer, (Object)theContext);
        return buffer;
    }
}

