/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.AggregationMode;
import org.hl7.fhir.Code;
import org.hl7.fhir.Element;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ElementDefinition.Type", propOrder={"code", "profile", "aggregation"})
public class ElementDefinitionType
extends Element
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected Code code;
    protected Uri profile;
    protected List<AggregationMode> aggregation;

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code value) {
        this.code = value;
    }

    public Uri getProfile() {
        return this.profile;
    }

    public void setProfile(Uri value) {
        this.profile = value;
    }

    public List<AggregationMode> getAggregation() {
        if (this.aggregation == null) {
            this.aggregation = new ArrayList<AggregationMode>();
        }
        return this.aggregation;
    }

    public ElementDefinitionType withCode(Code value) {
        this.setCode(value);
        return this;
    }

    public ElementDefinitionType withProfile(Uri value) {
        this.setProfile(value);
        return this;
    }

    public ElementDefinitionType withAggregation(AggregationMode ... values) {
        if (values != null) {
            for (AggregationMode value : values) {
                this.getAggregation().add(value);
            }
        }
        return this;
    }

    public ElementDefinitionType withAggregation(Collection<AggregationMode> values) {
        if (values != null) {
            this.getAggregation().addAll(values);
        }
        return this;
    }

    @Override
    public ElementDefinitionType withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ElementDefinitionType withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ElementDefinitionType withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<AggregationMode> rhsAggregation;
        if (!(object instanceof ElementDefinitionType)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ElementDefinitionType that = (ElementDefinitionType)object;
        Code lhsCode = this.getCode();
        Code rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode)) {
            return false;
        }
        Uri lhsProfile = this.getProfile();
        Uri rhsProfile = that.getProfile();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"profile", (Object)lhsProfile), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"profile", (Object)rhsProfile), (Object)lhsProfile, (Object)rhsProfile)) {
            return false;
        }
        List<AggregationMode> lhsAggregation = this.aggregation != null && !this.aggregation.isEmpty() ? this.getAggregation() : null;
        List<AggregationMode> list = rhsAggregation = that.aggregation != null && !that.aggregation.isEmpty() ? that.getAggregation() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"aggregation", lhsAggregation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"aggregation", rhsAggregation), lhsAggregation, rhsAggregation);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Code theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"code", (Object)theCode), currentHashCode, (Object)theCode);
        Uri theProfile = this.getProfile();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"profile", (Object)theProfile), currentHashCode, (Object)theProfile);
        List<AggregationMode> theAggregation = this.aggregation != null && !this.aggregation.isEmpty() ? this.getAggregation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"aggregation", theAggregation), currentHashCode, theAggregation);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Code theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode);
        Uri theProfile = this.getProfile();
        strategy.appendField(locator, (Object)this, "profile", buffer, (Object)theProfile);
        List<AggregationMode> theAggregation = this.aggregation != null && !this.aggregation.isEmpty() ? this.getAggregation() : null;
        strategy.appendField(locator, (Object)this, "aggregation", buffer, theAggregation);
        return buffer;
    }
}

