/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Reference;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Encounter.Hospitalization", propOrder={"preAdmissionIdentifier", "origin", "admitSource", "dietPreference", "specialCourtesy", "specialArrangement", "destination", "dischargeDisposition", "dischargeDiagnosis", "reAdmission"})
public class EncounterHospitalization
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected Identifier preAdmissionIdentifier;
    protected Reference origin;
    protected CodeableConcept admitSource;
    protected CodeableConcept dietPreference;
    protected List<CodeableConcept> specialCourtesy;
    protected List<CodeableConcept> specialArrangement;
    protected Reference destination;
    protected CodeableConcept dischargeDisposition;
    protected Reference dischargeDiagnosis;
    protected Boolean reAdmission;

    public Identifier getPreAdmissionIdentifier() {
        return this.preAdmissionIdentifier;
    }

    public void setPreAdmissionIdentifier(Identifier value) {
        this.preAdmissionIdentifier = value;
    }

    public Reference getOrigin() {
        return this.origin;
    }

    public void setOrigin(Reference value) {
        this.origin = value;
    }

    public CodeableConcept getAdmitSource() {
        return this.admitSource;
    }

    public void setAdmitSource(CodeableConcept value) {
        this.admitSource = value;
    }

    public CodeableConcept getDietPreference() {
        return this.dietPreference;
    }

    public void setDietPreference(CodeableConcept value) {
        this.dietPreference = value;
    }

    public List<CodeableConcept> getSpecialCourtesy() {
        if (this.specialCourtesy == null) {
            this.specialCourtesy = new ArrayList<CodeableConcept>();
        }
        return this.specialCourtesy;
    }

    public List<CodeableConcept> getSpecialArrangement() {
        if (this.specialArrangement == null) {
            this.specialArrangement = new ArrayList<CodeableConcept>();
        }
        return this.specialArrangement;
    }

    public Reference getDestination() {
        return this.destination;
    }

    public void setDestination(Reference value) {
        this.destination = value;
    }

    public CodeableConcept getDischargeDisposition() {
        return this.dischargeDisposition;
    }

    public void setDischargeDisposition(CodeableConcept value) {
        this.dischargeDisposition = value;
    }

    public Reference getDischargeDiagnosis() {
        return this.dischargeDiagnosis;
    }

    public void setDischargeDiagnosis(Reference value) {
        this.dischargeDiagnosis = value;
    }

    public Boolean getReAdmission() {
        return this.reAdmission;
    }

    public void setReAdmission(Boolean value) {
        this.reAdmission = value;
    }

    public EncounterHospitalization withPreAdmissionIdentifier(Identifier value) {
        this.setPreAdmissionIdentifier(value);
        return this;
    }

    public EncounterHospitalization withOrigin(Reference value) {
        this.setOrigin(value);
        return this;
    }

    public EncounterHospitalization withAdmitSource(CodeableConcept value) {
        this.setAdmitSource(value);
        return this;
    }

    public EncounterHospitalization withDietPreference(CodeableConcept value) {
        this.setDietPreference(value);
        return this;
    }

    public EncounterHospitalization withSpecialCourtesy(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getSpecialCourtesy().add(value);
            }
        }
        return this;
    }

    public EncounterHospitalization withSpecialCourtesy(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getSpecialCourtesy().addAll(values);
        }
        return this;
    }

    public EncounterHospitalization withSpecialArrangement(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getSpecialArrangement().add(value);
            }
        }
        return this;
    }

    public EncounterHospitalization withSpecialArrangement(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getSpecialArrangement().addAll(values);
        }
        return this;
    }

    public EncounterHospitalization withDestination(Reference value) {
        this.setDestination(value);
        return this;
    }

    public EncounterHospitalization withDischargeDisposition(CodeableConcept value) {
        this.setDischargeDisposition(value);
        return this;
    }

    public EncounterHospitalization withDischargeDiagnosis(Reference value) {
        this.setDischargeDiagnosis(value);
        return this;
    }

    public EncounterHospitalization withReAdmission(Boolean value) {
        this.setReAdmission(value);
        return this;
    }

    @Override
    public EncounterHospitalization withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EncounterHospitalization withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EncounterHospitalization withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EncounterHospitalization withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EncounterHospitalization withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<CodeableConcept> rhsSpecialArrangement;
        List<CodeableConcept> rhsSpecialCourtesy;
        if (!(object instanceof EncounterHospitalization)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        EncounterHospitalization that = (EncounterHospitalization)object;
        Identifier lhsPreAdmissionIdentifier = this.getPreAdmissionIdentifier();
        Identifier rhsPreAdmissionIdentifier = that.getPreAdmissionIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"preAdmissionIdentifier", (Object)lhsPreAdmissionIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"preAdmissionIdentifier", (Object)rhsPreAdmissionIdentifier), (Object)lhsPreAdmissionIdentifier, (Object)rhsPreAdmissionIdentifier)) {
            return false;
        }
        Reference lhsOrigin = this.getOrigin();
        Reference rhsOrigin = that.getOrigin();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"origin", (Object)lhsOrigin), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"origin", (Object)rhsOrigin), (Object)lhsOrigin, (Object)rhsOrigin)) {
            return false;
        }
        CodeableConcept lhsAdmitSource = this.getAdmitSource();
        CodeableConcept rhsAdmitSource = that.getAdmitSource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"admitSource", (Object)lhsAdmitSource), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"admitSource", (Object)rhsAdmitSource), (Object)lhsAdmitSource, (Object)rhsAdmitSource)) {
            return false;
        }
        CodeableConcept lhsDietPreference = this.getDietPreference();
        CodeableConcept rhsDietPreference = that.getDietPreference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dietPreference", (Object)lhsDietPreference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dietPreference", (Object)rhsDietPreference), (Object)lhsDietPreference, (Object)rhsDietPreference)) {
            return false;
        }
        List<CodeableConcept> lhsSpecialCourtesy = this.specialCourtesy != null && !this.specialCourtesy.isEmpty() ? this.getSpecialCourtesy() : null;
        List<CodeableConcept> list = rhsSpecialCourtesy = that.specialCourtesy != null && !that.specialCourtesy.isEmpty() ? that.getSpecialCourtesy() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"specialCourtesy", lhsSpecialCourtesy), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"specialCourtesy", rhsSpecialCourtesy), lhsSpecialCourtesy, rhsSpecialCourtesy)) {
            return false;
        }
        List<CodeableConcept> lhsSpecialArrangement = this.specialArrangement != null && !this.specialArrangement.isEmpty() ? this.getSpecialArrangement() : null;
        List<CodeableConcept> list2 = rhsSpecialArrangement = that.specialArrangement != null && !that.specialArrangement.isEmpty() ? that.getSpecialArrangement() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"specialArrangement", lhsSpecialArrangement), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"specialArrangement", rhsSpecialArrangement), lhsSpecialArrangement, rhsSpecialArrangement)) {
            return false;
        }
        Reference lhsDestination = this.getDestination();
        Reference rhsDestination = that.getDestination();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"destination", (Object)lhsDestination), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"destination", (Object)rhsDestination), (Object)lhsDestination, (Object)rhsDestination)) {
            return false;
        }
        CodeableConcept lhsDischargeDisposition = this.getDischargeDisposition();
        CodeableConcept rhsDischargeDisposition = that.getDischargeDisposition();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dischargeDisposition", (Object)lhsDischargeDisposition), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dischargeDisposition", (Object)rhsDischargeDisposition), (Object)lhsDischargeDisposition, (Object)rhsDischargeDisposition)) {
            return false;
        }
        Reference lhsDischargeDiagnosis = this.getDischargeDiagnosis();
        Reference rhsDischargeDiagnosis = that.getDischargeDiagnosis();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dischargeDiagnosis", (Object)lhsDischargeDiagnosis), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dischargeDiagnosis", (Object)rhsDischargeDiagnosis), (Object)lhsDischargeDiagnosis, (Object)rhsDischargeDiagnosis)) {
            return false;
        }
        Boolean lhsReAdmission = this.getReAdmission();
        Boolean rhsReAdmission = that.getReAdmission();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reAdmission", (Object)lhsReAdmission), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reAdmission", (Object)rhsReAdmission), (Object)lhsReAdmission, (Object)rhsReAdmission);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier thePreAdmissionIdentifier = this.getPreAdmissionIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"preAdmissionIdentifier", (Object)thePreAdmissionIdentifier), currentHashCode, (Object)thePreAdmissionIdentifier);
        Reference theOrigin = this.getOrigin();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"origin", (Object)theOrigin), currentHashCode, (Object)theOrigin);
        CodeableConcept theAdmitSource = this.getAdmitSource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"admitSource", (Object)theAdmitSource), currentHashCode, (Object)theAdmitSource);
        CodeableConcept theDietPreference = this.getDietPreference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dietPreference", (Object)theDietPreference), currentHashCode, (Object)theDietPreference);
        List<CodeableConcept> theSpecialCourtesy = this.specialCourtesy != null && !this.specialCourtesy.isEmpty() ? this.getSpecialCourtesy() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"specialCourtesy", theSpecialCourtesy), currentHashCode, theSpecialCourtesy);
        List<CodeableConcept> theSpecialArrangement = this.specialArrangement != null && !this.specialArrangement.isEmpty() ? this.getSpecialArrangement() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"specialArrangement", theSpecialArrangement), currentHashCode, theSpecialArrangement);
        Reference theDestination = this.getDestination();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"destination", (Object)theDestination), currentHashCode, (Object)theDestination);
        CodeableConcept theDischargeDisposition = this.getDischargeDisposition();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dischargeDisposition", (Object)theDischargeDisposition), currentHashCode, (Object)theDischargeDisposition);
        Reference theDischargeDiagnosis = this.getDischargeDiagnosis();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dischargeDiagnosis", (Object)theDischargeDiagnosis), currentHashCode, (Object)theDischargeDiagnosis);
        Boolean theReAdmission = this.getReAdmission();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reAdmission", (Object)theReAdmission), currentHashCode, (Object)theReAdmission);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier thePreAdmissionIdentifier = this.getPreAdmissionIdentifier();
        strategy.appendField(locator, (Object)this, "preAdmissionIdentifier", buffer, (Object)thePreAdmissionIdentifier);
        Reference theOrigin = this.getOrigin();
        strategy.appendField(locator, (Object)this, "origin", buffer, (Object)theOrigin);
        CodeableConcept theAdmitSource = this.getAdmitSource();
        strategy.appendField(locator, (Object)this, "admitSource", buffer, (Object)theAdmitSource);
        CodeableConcept theDietPreference = this.getDietPreference();
        strategy.appendField(locator, (Object)this, "dietPreference", buffer, (Object)theDietPreference);
        List<CodeableConcept> theSpecialCourtesy = this.specialCourtesy != null && !this.specialCourtesy.isEmpty() ? this.getSpecialCourtesy() : null;
        strategy.appendField(locator, (Object)this, "specialCourtesy", buffer, theSpecialCourtesy);
        List<CodeableConcept> theSpecialArrangement = this.specialArrangement != null && !this.specialArrangement.isEmpty() ? this.getSpecialArrangement() : null;
        strategy.appendField(locator, (Object)this, "specialArrangement", buffer, theSpecialArrangement);
        Reference theDestination = this.getDestination();
        strategy.appendField(locator, (Object)this, "destination", buffer, (Object)theDestination);
        CodeableConcept theDischargeDisposition = this.getDischargeDisposition();
        strategy.appendField(locator, (Object)this, "dischargeDisposition", buffer, (Object)theDischargeDisposition);
        Reference theDischargeDiagnosis = this.getDischargeDiagnosis();
        strategy.appendField(locator, (Object)this, "dischargeDiagnosis", buffer, (Object)theDischargeDiagnosis);
        Boolean theReAdmission = this.getReAdmission();
        strategy.appendField(locator, (Object)this, "reAdmission", buffer, (Object)theReAdmission);
        return buffer;
    }
}

