/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EpisodeOfCare.CareTeam", propOrder={"member", "role", "period"})
public class EpisodeOfCareCareTeam
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected Reference member;
    protected List<CodeableConcept> role;
    protected Period period;

    public Reference getMember() {
        return this.member;
    }

    public void setMember(Reference value) {
        this.member = value;
    }

    public List<CodeableConcept> getRole() {
        if (this.role == null) {
            this.role = new ArrayList<CodeableConcept>();
        }
        return this.role;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period value) {
        this.period = value;
    }

    public EpisodeOfCareCareTeam withMember(Reference value) {
        this.setMember(value);
        return this;
    }

    public EpisodeOfCareCareTeam withRole(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getRole().add(value);
            }
        }
        return this;
    }

    public EpisodeOfCareCareTeam withRole(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getRole().addAll(values);
        }
        return this;
    }

    public EpisodeOfCareCareTeam withPeriod(Period value) {
        this.setPeriod(value);
        return this;
    }

    @Override
    public EpisodeOfCareCareTeam withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EpisodeOfCareCareTeam withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EpisodeOfCareCareTeam withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EpisodeOfCareCareTeam withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EpisodeOfCareCareTeam withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<CodeableConcept> rhsRole;
        if (!(object instanceof EpisodeOfCareCareTeam)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        EpisodeOfCareCareTeam that = (EpisodeOfCareCareTeam)object;
        Reference lhsMember = this.getMember();
        Reference rhsMember = that.getMember();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"member", (Object)lhsMember), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"member", (Object)rhsMember), (Object)lhsMember, (Object)rhsMember)) {
            return false;
        }
        List<CodeableConcept> lhsRole = this.role != null && !this.role.isEmpty() ? this.getRole() : null;
        List<CodeableConcept> list = rhsRole = that.role != null && !that.role.isEmpty() ? that.getRole() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"role", lhsRole), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"role", rhsRole), lhsRole, rhsRole)) {
            return false;
        }
        Period lhsPeriod = this.getPeriod();
        Period rhsPeriod = that.getPeriod();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"period", (Object)lhsPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"period", (Object)rhsPeriod), (Object)lhsPeriod, (Object)rhsPeriod);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Reference theMember = this.getMember();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"member", (Object)theMember), currentHashCode, (Object)theMember);
        List<CodeableConcept> theRole = this.role != null && !this.role.isEmpty() ? this.getRole() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"role", theRole), currentHashCode, theRole);
        Period thePeriod = this.getPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"period", (Object)thePeriod), currentHashCode, (Object)thePeriod);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Reference theMember = this.getMember();
        strategy.appendField(locator, (Object)this, "member", buffer, (Object)theMember);
        List<CodeableConcept> theRole = this.role != null && !this.role.isEmpty() ? this.getRole() : null;
        strategy.appendField(locator, (Object)this, "role", buffer, theRole);
        Period thePeriod = this.getPeriod();
        strategy.appendField(locator, (Object)this, "period", buffer, (Object)thePeriod);
        return buffer;
    }
}

