/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.GroupCharacteristic;
import org.hl7.fhir.GroupType;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.UnsignedInt;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Group", propOrder={"identifier", "type", "actual", "code", "name", "quantity", "characteristic", "member"})
public class Group
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected Identifier identifier;
    @XmlElement(required=true)
    protected GroupType type;
    @XmlElement(required=true)
    protected Boolean actual;
    protected CodeableConcept code;
    protected String name;
    protected UnsignedInt quantity;
    protected List<GroupCharacteristic> characteristic;
    protected List<Reference> member;

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public GroupType getType() {
        return this.type;
    }

    public void setType(GroupType value) {
        this.type = value;
    }

    public Boolean getActual() {
        return this.actual;
    }

    public void setActual(Boolean value) {
        this.actual = value;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public void setCode(CodeableConcept value) {
        this.code = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public UnsignedInt getQuantity() {
        return this.quantity;
    }

    public void setQuantity(UnsignedInt value) {
        this.quantity = value;
    }

    public List<GroupCharacteristic> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<GroupCharacteristic>();
        }
        return this.characteristic;
    }

    public List<Reference> getMember() {
        if (this.member == null) {
            this.member = new ArrayList<Reference>();
        }
        return this.member;
    }

    public Group withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public Group withType(GroupType value) {
        this.setType(value);
        return this;
    }

    public Group withActual(Boolean value) {
        this.setActual(value);
        return this;
    }

    public Group withCode(CodeableConcept value) {
        this.setCode(value);
        return this;
    }

    public Group withName(String value) {
        this.setName(value);
        return this;
    }

    public Group withQuantity(UnsignedInt value) {
        this.setQuantity(value);
        return this;
    }

    public Group withCharacteristic(GroupCharacteristic ... values) {
        if (values != null) {
            for (GroupCharacteristic value : values) {
                this.getCharacteristic().add(value);
            }
        }
        return this;
    }

    public Group withCharacteristic(Collection<GroupCharacteristic> values) {
        if (values != null) {
            this.getCharacteristic().addAll(values);
        }
        return this;
    }

    public Group withMember(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getMember().add(value);
            }
        }
        return this;
    }

    public Group withMember(Collection<Reference> values) {
        if (values != null) {
            this.getMember().addAll(values);
        }
        return this;
    }

    @Override
    public Group withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Group withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Group withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Group withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Group withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Group withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Group withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Group withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Group withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Group withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Group withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Reference> rhsMember;
        List<GroupCharacteristic> rhsCharacteristic;
        if (!(object instanceof Group)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Group that = (Group)object;
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier)) {
            return false;
        }
        GroupType lhsType = this.getType();
        GroupType rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        Boolean lhsActual = this.getActual();
        Boolean rhsActual = that.getActual();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"actual", (Object)lhsActual), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"actual", (Object)rhsActual), (Object)lhsActual, (Object)rhsActual)) {
            return false;
        }
        CodeableConcept lhsCode = this.getCode();
        CodeableConcept rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"name", (Object)lhsName), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"name", (Object)rhsName), (Object)lhsName, (Object)rhsName)) {
            return false;
        }
        UnsignedInt lhsQuantity = this.getQuantity();
        UnsignedInt rhsQuantity = that.getQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"quantity", (Object)lhsQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"quantity", (Object)rhsQuantity), (Object)lhsQuantity, (Object)rhsQuantity)) {
            return false;
        }
        List<GroupCharacteristic> lhsCharacteristic = this.characteristic != null && !this.characteristic.isEmpty() ? this.getCharacteristic() : null;
        List<GroupCharacteristic> list = rhsCharacteristic = that.characteristic != null && !that.characteristic.isEmpty() ? that.getCharacteristic() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"characteristic", lhsCharacteristic), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"characteristic", rhsCharacteristic), lhsCharacteristic, rhsCharacteristic)) {
            return false;
        }
        List<Reference> lhsMember = this.member != null && !this.member.isEmpty() ? this.getMember() : null;
        List<Reference> list2 = rhsMember = that.member != null && !that.member.isEmpty() ? that.getMember() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"member", lhsMember), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"member", rhsMember), lhsMember, rhsMember);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier);
        GroupType theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType);
        Boolean theActual = this.getActual();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"actual", (Object)theActual), currentHashCode, (Object)theActual);
        CodeableConcept theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"code", (Object)theCode), currentHashCode, (Object)theCode);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"name", (Object)theName), currentHashCode, (Object)theName);
        UnsignedInt theQuantity = this.getQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"quantity", (Object)theQuantity), currentHashCode, (Object)theQuantity);
        List<GroupCharacteristic> theCharacteristic = this.characteristic != null && !this.characteristic.isEmpty() ? this.getCharacteristic() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"characteristic", theCharacteristic), currentHashCode, theCharacteristic);
        List<Reference> theMember = this.member != null && !this.member.isEmpty() ? this.getMember() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"member", theMember), currentHashCode, theMember);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier);
        GroupType theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        Boolean theActual = this.getActual();
        strategy.appendField(locator, (Object)this, "actual", buffer, (Object)theActual);
        CodeableConcept theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, (Object)theName);
        UnsignedInt theQuantity = this.getQuantity();
        strategy.appendField(locator, (Object)this, "quantity", buffer, (Object)theQuantity);
        List<GroupCharacteristic> theCharacteristic = this.characteristic != null && !this.characteristic.isEmpty() ? this.getCharacteristic() : null;
        strategy.appendField(locator, (Object)this, "characteristic", buffer, theCharacteristic);
        List<Reference> theMember = this.member != null && !this.member.isEmpty() ? this.getMember() : null;
        strategy.appendField(locator, (Object)this, "member", buffer, theMember);
        return buffer;
    }
}

