/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Extension;
import org.hl7.fhir.ImagingObjectSelectionFrames;
import org.hl7.fhir.Oid;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ImagingObjectSelection.Instance", propOrder={"sopClass", "uid", "url", "frames"})
public class ImagingObjectSelectionInstance
extends BackboneElement
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected Oid sopClass;
    @XmlElement(required=true)
    protected Oid uid;
    @XmlElement(required=true)
    protected Uri url;
    protected List<ImagingObjectSelectionFrames> frames;

    public Oid getSopClass() {
        return this.sopClass;
    }

    public void setSopClass(Oid value) {
        this.sopClass = value;
    }

    public Oid getUid() {
        return this.uid;
    }

    public void setUid(Oid value) {
        this.uid = value;
    }

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public List<ImagingObjectSelectionFrames> getFrames() {
        if (this.frames == null) {
            this.frames = new ArrayList<ImagingObjectSelectionFrames>();
        }
        return this.frames;
    }

    public ImagingObjectSelectionInstance withSopClass(Oid value) {
        this.setSopClass(value);
        return this;
    }

    public ImagingObjectSelectionInstance withUid(Oid value) {
        this.setUid(value);
        return this;
    }

    public ImagingObjectSelectionInstance withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public ImagingObjectSelectionInstance withFrames(ImagingObjectSelectionFrames ... values) {
        if (values != null) {
            for (ImagingObjectSelectionFrames value : values) {
                this.getFrames().add(value);
            }
        }
        return this;
    }

    public ImagingObjectSelectionInstance withFrames(Collection<ImagingObjectSelectionFrames> values) {
        if (values != null) {
            this.getFrames().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingObjectSelectionInstance withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImagingObjectSelectionInstance withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingObjectSelectionInstance withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImagingObjectSelectionInstance withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingObjectSelectionInstance withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ImagingObjectSelectionFrames> rhsFrames;
        if (!(object instanceof ImagingObjectSelectionInstance)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ImagingObjectSelectionInstance that = (ImagingObjectSelectionInstance)object;
        Oid lhsSopClass = this.getSopClass();
        Oid rhsSopClass = that.getSopClass();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"sopClass", (Object)lhsSopClass), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"sopClass", (Object)rhsSopClass), (Object)lhsSopClass, (Object)rhsSopClass)) {
            return false;
        }
        Oid lhsUid = this.getUid();
        Oid rhsUid = that.getUid();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"uid", (Object)lhsUid), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"uid", (Object)rhsUid), (Object)lhsUid, (Object)rhsUid)) {
            return false;
        }
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"url", (Object)lhsUrl), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"url", (Object)rhsUrl), (Object)lhsUrl, (Object)rhsUrl)) {
            return false;
        }
        List<ImagingObjectSelectionFrames> lhsFrames = this.frames != null && !this.frames.isEmpty() ? this.getFrames() : null;
        List<ImagingObjectSelectionFrames> list = rhsFrames = that.frames != null && !that.frames.isEmpty() ? that.getFrames() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"frames", lhsFrames), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"frames", rhsFrames), lhsFrames, rhsFrames);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Oid theSopClass = this.getSopClass();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"sopClass", (Object)theSopClass), currentHashCode, (Object)theSopClass);
        Oid theUid = this.getUid();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"uid", (Object)theUid), currentHashCode, (Object)theUid);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"url", (Object)theUrl), currentHashCode, (Object)theUrl);
        List<ImagingObjectSelectionFrames> theFrames = this.frames != null && !this.frames.isEmpty() ? this.getFrames() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"frames", theFrames), currentHashCode, theFrames);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Oid theSopClass = this.getSopClass();
        strategy.appendField(locator, (Object)this, "sopClass", buffer, (Object)theSopClass);
        Oid theUid = this.getUid();
        strategy.appendField(locator, (Object)this, "uid", buffer, (Object)theUid);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, (Object)theUrl);
        List<ImagingObjectSelectionFrames> theFrames = this.frames != null && !this.frames.isEmpty() ? this.getFrames() : null;
        strategy.appendField(locator, (Object)this, "frames", buffer, theFrames);
        return buffer;
    }
}

