/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.MedicationAdministrationDosage;
import org.hl7.fhir.MedicationAdministrationStatus;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MedicationAdministration", propOrder={"identifier", "status", "patient", "practitioner", "encounter", "prescription", "wasNotGiven", "reasonNotGiven", "reasonGiven", "effectiveTimeDateTime", "effectiveTimePeriod", "medication", "device", "note", "dosage"})
public class MedicationAdministration
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected MedicationAdministrationStatus status;
    @XmlElement(required=true)
    protected Reference patient;
    protected Reference practitioner;
    protected Reference encounter;
    protected Reference prescription;
    protected Boolean wasNotGiven;
    protected List<CodeableConcept> reasonNotGiven;
    protected List<CodeableConcept> reasonGiven;
    protected DateTime effectiveTimeDateTime;
    protected Period effectiveTimePeriod;
    protected Reference medication;
    protected List<Reference> device;
    protected String note;
    protected MedicationAdministrationDosage dosage;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationAdministrationStatus getStatus() {
        return this.status;
    }

    public void setStatus(MedicationAdministrationStatus value) {
        this.status = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getPractitioner() {
        return this.practitioner;
    }

    public void setPractitioner(Reference value) {
        this.practitioner = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public Reference getPrescription() {
        return this.prescription;
    }

    public void setPrescription(Reference value) {
        this.prescription = value;
    }

    public Boolean getWasNotGiven() {
        return this.wasNotGiven;
    }

    public void setWasNotGiven(Boolean value) {
        this.wasNotGiven = value;
    }

    public List<CodeableConcept> getReasonNotGiven() {
        if (this.reasonNotGiven == null) {
            this.reasonNotGiven = new ArrayList<CodeableConcept>();
        }
        return this.reasonNotGiven;
    }

    public List<CodeableConcept> getReasonGiven() {
        if (this.reasonGiven == null) {
            this.reasonGiven = new ArrayList<CodeableConcept>();
        }
        return this.reasonGiven;
    }

    public DateTime getEffectiveTimeDateTime() {
        return this.effectiveTimeDateTime;
    }

    public void setEffectiveTimeDateTime(DateTime value) {
        this.effectiveTimeDateTime = value;
    }

    public Period getEffectiveTimePeriod() {
        return this.effectiveTimePeriod;
    }

    public void setEffectiveTimePeriod(Period value) {
        this.effectiveTimePeriod = value;
    }

    public Reference getMedication() {
        return this.medication;
    }

    public void setMedication(Reference value) {
        this.medication = value;
    }

    public List<Reference> getDevice() {
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        return this.device;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String value) {
        this.note = value;
    }

    public MedicationAdministrationDosage getDosage() {
        return this.dosage;
    }

    public void setDosage(MedicationAdministrationDosage value) {
        this.dosage = value;
    }

    public MedicationAdministration withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public MedicationAdministration withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public MedicationAdministration withStatus(MedicationAdministrationStatus value) {
        this.setStatus(value);
        return this;
    }

    public MedicationAdministration withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public MedicationAdministration withPractitioner(Reference value) {
        this.setPractitioner(value);
        return this;
    }

    public MedicationAdministration withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public MedicationAdministration withPrescription(Reference value) {
        this.setPrescription(value);
        return this;
    }

    public MedicationAdministration withWasNotGiven(Boolean value) {
        this.setWasNotGiven(value);
        return this;
    }

    public MedicationAdministration withReasonNotGiven(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getReasonNotGiven().add(value);
            }
        }
        return this;
    }

    public MedicationAdministration withReasonNotGiven(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getReasonNotGiven().addAll(values);
        }
        return this;
    }

    public MedicationAdministration withReasonGiven(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getReasonGiven().add(value);
            }
        }
        return this;
    }

    public MedicationAdministration withReasonGiven(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getReasonGiven().addAll(values);
        }
        return this;
    }

    public MedicationAdministration withEffectiveTimeDateTime(DateTime value) {
        this.setEffectiveTimeDateTime(value);
        return this;
    }

    public MedicationAdministration withEffectiveTimePeriod(Period value) {
        this.setEffectiveTimePeriod(value);
        return this;
    }

    public MedicationAdministration withMedication(Reference value) {
        this.setMedication(value);
        return this;
    }

    public MedicationAdministration withDevice(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getDevice().add(value);
            }
        }
        return this;
    }

    public MedicationAdministration withDevice(Collection<Reference> values) {
        if (values != null) {
            this.getDevice().addAll(values);
        }
        return this;
    }

    public MedicationAdministration withNote(String value) {
        this.setNote(value);
        return this;
    }

    public MedicationAdministration withDosage(MedicationAdministrationDosage value) {
        this.setDosage(value);
        return this;
    }

    @Override
    public MedicationAdministration withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public MedicationAdministration withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationAdministration withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationAdministration withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationAdministration withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationAdministration withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationAdministration withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationAdministration withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public MedicationAdministration withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public MedicationAdministration withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public MedicationAdministration withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Reference> rhsDevice;
        List<CodeableConcept> rhsReasonGiven;
        List<CodeableConcept> rhsReasonNotGiven;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof MedicationAdministration)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationAdministration that = (MedicationAdministration)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        MedicationAdministrationStatus lhsStatus = this.getStatus();
        MedicationAdministrationStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        Reference lhsPractitioner = this.getPractitioner();
        Reference rhsPractitioner = that.getPractitioner();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"practitioner", (Object)lhsPractitioner), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"practitioner", (Object)rhsPractitioner), (Object)lhsPractitioner, (Object)rhsPractitioner)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter)) {
            return false;
        }
        Reference lhsPrescription = this.getPrescription();
        Reference rhsPrescription = that.getPrescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"prescription", (Object)lhsPrescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"prescription", (Object)rhsPrescription), (Object)lhsPrescription, (Object)rhsPrescription)) {
            return false;
        }
        Boolean lhsWasNotGiven = this.getWasNotGiven();
        Boolean rhsWasNotGiven = that.getWasNotGiven();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"wasNotGiven", (Object)lhsWasNotGiven), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"wasNotGiven", (Object)rhsWasNotGiven), (Object)lhsWasNotGiven, (Object)rhsWasNotGiven)) {
            return false;
        }
        List<CodeableConcept> lhsReasonNotGiven = this.reasonNotGiven != null && !this.reasonNotGiven.isEmpty() ? this.getReasonNotGiven() : null;
        List<CodeableConcept> list2 = rhsReasonNotGiven = that.reasonNotGiven != null && !that.reasonNotGiven.isEmpty() ? that.getReasonNotGiven() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reasonNotGiven", lhsReasonNotGiven), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reasonNotGiven", rhsReasonNotGiven), lhsReasonNotGiven, rhsReasonNotGiven)) {
            return false;
        }
        List<CodeableConcept> lhsReasonGiven = this.reasonGiven != null && !this.reasonGiven.isEmpty() ? this.getReasonGiven() : null;
        List<CodeableConcept> list3 = rhsReasonGiven = that.reasonGiven != null && !that.reasonGiven.isEmpty() ? that.getReasonGiven() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reasonGiven", lhsReasonGiven), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reasonGiven", rhsReasonGiven), lhsReasonGiven, rhsReasonGiven)) {
            return false;
        }
        DateTime lhsEffectiveTimeDateTime = this.getEffectiveTimeDateTime();
        DateTime rhsEffectiveTimeDateTime = that.getEffectiveTimeDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"effectiveTimeDateTime", (Object)lhsEffectiveTimeDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"effectiveTimeDateTime", (Object)rhsEffectiveTimeDateTime), (Object)lhsEffectiveTimeDateTime, (Object)rhsEffectiveTimeDateTime)) {
            return false;
        }
        Period lhsEffectiveTimePeriod = this.getEffectiveTimePeriod();
        Period rhsEffectiveTimePeriod = that.getEffectiveTimePeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"effectiveTimePeriod", (Object)lhsEffectiveTimePeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"effectiveTimePeriod", (Object)rhsEffectiveTimePeriod), (Object)lhsEffectiveTimePeriod, (Object)rhsEffectiveTimePeriod)) {
            return false;
        }
        Reference lhsMedication = this.getMedication();
        Reference rhsMedication = that.getMedication();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"medication", (Object)lhsMedication), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"medication", (Object)rhsMedication), (Object)lhsMedication, (Object)rhsMedication)) {
            return false;
        }
        List<Reference> lhsDevice = this.device != null && !this.device.isEmpty() ? this.getDevice() : null;
        List<Reference> list4 = rhsDevice = that.device != null && !that.device.isEmpty() ? that.getDevice() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"device", lhsDevice), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"device", rhsDevice), lhsDevice, rhsDevice)) {
            return false;
        }
        String lhsNote = this.getNote();
        String rhsNote = that.getNote();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"note", (Object)lhsNote), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"note", (Object)rhsNote), (Object)lhsNote, (Object)rhsNote)) {
            return false;
        }
        MedicationAdministrationDosage lhsDosage = this.getDosage();
        MedicationAdministrationDosage rhsDosage = that.getDosage();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dosage", (Object)lhsDosage), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dosage", (Object)rhsDosage), (Object)lhsDosage, (Object)rhsDosage);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        MedicationAdministrationStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        Reference thePractitioner = this.getPractitioner();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"practitioner", (Object)thePractitioner), currentHashCode, (Object)thePractitioner);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter);
        Reference thePrescription = this.getPrescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"prescription", (Object)thePrescription), currentHashCode, (Object)thePrescription);
        Boolean theWasNotGiven = this.getWasNotGiven();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"wasNotGiven", (Object)theWasNotGiven), currentHashCode, (Object)theWasNotGiven);
        List<CodeableConcept> theReasonNotGiven = this.reasonNotGiven != null && !this.reasonNotGiven.isEmpty() ? this.getReasonNotGiven() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reasonNotGiven", theReasonNotGiven), currentHashCode, theReasonNotGiven);
        List<CodeableConcept> theReasonGiven = this.reasonGiven != null && !this.reasonGiven.isEmpty() ? this.getReasonGiven() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reasonGiven", theReasonGiven), currentHashCode, theReasonGiven);
        DateTime theEffectiveTimeDateTime = this.getEffectiveTimeDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"effectiveTimeDateTime", (Object)theEffectiveTimeDateTime), currentHashCode, (Object)theEffectiveTimeDateTime);
        Period theEffectiveTimePeriod = this.getEffectiveTimePeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"effectiveTimePeriod", (Object)theEffectiveTimePeriod), currentHashCode, (Object)theEffectiveTimePeriod);
        Reference theMedication = this.getMedication();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"medication", (Object)theMedication), currentHashCode, (Object)theMedication);
        List<Reference> theDevice = this.device != null && !this.device.isEmpty() ? this.getDevice() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"device", theDevice), currentHashCode, theDevice);
        String theNote = this.getNote();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"note", (Object)theNote), currentHashCode, (Object)theNote);
        MedicationAdministrationDosage theDosage = this.getDosage();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dosage", (Object)theDosage), currentHashCode, (Object)theDosage);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        MedicationAdministrationStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        Reference thePractitioner = this.getPractitioner();
        strategy.appendField(locator, (Object)this, "practitioner", buffer, (Object)thePractitioner);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter);
        Reference thePrescription = this.getPrescription();
        strategy.appendField(locator, (Object)this, "prescription", buffer, (Object)thePrescription);
        Boolean theWasNotGiven = this.getWasNotGiven();
        strategy.appendField(locator, (Object)this, "wasNotGiven", buffer, (Object)theWasNotGiven);
        List<CodeableConcept> theReasonNotGiven = this.reasonNotGiven != null && !this.reasonNotGiven.isEmpty() ? this.getReasonNotGiven() : null;
        strategy.appendField(locator, (Object)this, "reasonNotGiven", buffer, theReasonNotGiven);
        List<CodeableConcept> theReasonGiven = this.reasonGiven != null && !this.reasonGiven.isEmpty() ? this.getReasonGiven() : null;
        strategy.appendField(locator, (Object)this, "reasonGiven", buffer, theReasonGiven);
        DateTime theEffectiveTimeDateTime = this.getEffectiveTimeDateTime();
        strategy.appendField(locator, (Object)this, "effectiveTimeDateTime", buffer, (Object)theEffectiveTimeDateTime);
        Period theEffectiveTimePeriod = this.getEffectiveTimePeriod();
        strategy.appendField(locator, (Object)this, "effectiveTimePeriod", buffer, (Object)theEffectiveTimePeriod);
        Reference theMedication = this.getMedication();
        strategy.appendField(locator, (Object)this, "medication", buffer, (Object)theMedication);
        List<Reference> theDevice = this.device != null && !this.device.isEmpty() ? this.getDevice() : null;
        strategy.appendField(locator, (Object)this, "device", buffer, theDevice);
        String theNote = this.getNote();
        strategy.appendField(locator, (Object)this, "note", buffer, (Object)theNote);
        MedicationAdministrationDosage theDosage = this.getDosage();
        strategy.appendField(locator, (Object)this, "dosage", buffer, (Object)theDosage);
        return buffer;
    }
}

