/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.MedicationDispenseDosageInstruction;
import org.hl7.fhir.MedicationDispenseStatus;
import org.hl7.fhir.MedicationDispenseSubstitution;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Quantity;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MedicationDispense", propOrder={"identifier", "status", "patient", "dispenser", "authorizingPrescription", "type", "quantity", "daysSupply", "medication", "whenPrepared", "whenHandedOver", "destination", "receiver", "note", "dosageInstruction", "substitution"})
public class MedicationDispense
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected Identifier identifier;
    protected MedicationDispenseStatus status;
    protected Reference patient;
    protected Reference dispenser;
    protected List<Reference> authorizingPrescription;
    protected CodeableConcept type;
    protected Quantity quantity;
    protected Quantity daysSupply;
    protected Reference medication;
    protected DateTime whenPrepared;
    protected DateTime whenHandedOver;
    protected Reference destination;
    protected List<Reference> receiver;
    protected String note;
    protected List<MedicationDispenseDosageInstruction> dosageInstruction;
    protected MedicationDispenseSubstitution substitution;

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public MedicationDispenseStatus getStatus() {
        return this.status;
    }

    public void setStatus(MedicationDispenseStatus value) {
        this.status = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getDispenser() {
        return this.dispenser;
    }

    public void setDispenser(Reference value) {
        this.dispenser = value;
    }

    public List<Reference> getAuthorizingPrescription() {
        if (this.authorizingPrescription == null) {
            this.authorizingPrescription = new ArrayList<Reference>();
        }
        return this.authorizingPrescription;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Quantity value) {
        this.quantity = value;
    }

    public Quantity getDaysSupply() {
        return this.daysSupply;
    }

    public void setDaysSupply(Quantity value) {
        this.daysSupply = value;
    }

    public Reference getMedication() {
        return this.medication;
    }

    public void setMedication(Reference value) {
        this.medication = value;
    }

    public DateTime getWhenPrepared() {
        return this.whenPrepared;
    }

    public void setWhenPrepared(DateTime value) {
        this.whenPrepared = value;
    }

    public DateTime getWhenHandedOver() {
        return this.whenHandedOver;
    }

    public void setWhenHandedOver(DateTime value) {
        this.whenHandedOver = value;
    }

    public Reference getDestination() {
        return this.destination;
    }

    public void setDestination(Reference value) {
        this.destination = value;
    }

    public List<Reference> getReceiver() {
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        return this.receiver;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String value) {
        this.note = value;
    }

    public List<MedicationDispenseDosageInstruction> getDosageInstruction() {
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<MedicationDispenseDosageInstruction>();
        }
        return this.dosageInstruction;
    }

    public MedicationDispenseSubstitution getSubstitution() {
        return this.substitution;
    }

    public void setSubstitution(MedicationDispenseSubstitution value) {
        this.substitution = value;
    }

    public MedicationDispense withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public MedicationDispense withStatus(MedicationDispenseStatus value) {
        this.setStatus(value);
        return this;
    }

    public MedicationDispense withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public MedicationDispense withDispenser(Reference value) {
        this.setDispenser(value);
        return this;
    }

    public MedicationDispense withAuthorizingPrescription(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAuthorizingPrescription().add(value);
            }
        }
        return this;
    }

    public MedicationDispense withAuthorizingPrescription(Collection<Reference> values) {
        if (values != null) {
            this.getAuthorizingPrescription().addAll(values);
        }
        return this;
    }

    public MedicationDispense withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public MedicationDispense withQuantity(Quantity value) {
        this.setQuantity(value);
        return this;
    }

    public MedicationDispense withDaysSupply(Quantity value) {
        this.setDaysSupply(value);
        return this;
    }

    public MedicationDispense withMedication(Reference value) {
        this.setMedication(value);
        return this;
    }

    public MedicationDispense withWhenPrepared(DateTime value) {
        this.setWhenPrepared(value);
        return this;
    }

    public MedicationDispense withWhenHandedOver(DateTime value) {
        this.setWhenHandedOver(value);
        return this;
    }

    public MedicationDispense withDestination(Reference value) {
        this.setDestination(value);
        return this;
    }

    public MedicationDispense withReceiver(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getReceiver().add(value);
            }
        }
        return this;
    }

    public MedicationDispense withReceiver(Collection<Reference> values) {
        if (values != null) {
            this.getReceiver().addAll(values);
        }
        return this;
    }

    public MedicationDispense withNote(String value) {
        this.setNote(value);
        return this;
    }

    public MedicationDispense withDosageInstruction(MedicationDispenseDosageInstruction ... values) {
        if (values != null) {
            for (MedicationDispenseDosageInstruction value : values) {
                this.getDosageInstruction().add(value);
            }
        }
        return this;
    }

    public MedicationDispense withDosageInstruction(Collection<MedicationDispenseDosageInstruction> values) {
        if (values != null) {
            this.getDosageInstruction().addAll(values);
        }
        return this;
    }

    public MedicationDispense withSubstitution(MedicationDispenseSubstitution value) {
        this.setSubstitution(value);
        return this;
    }

    @Override
    public MedicationDispense withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public MedicationDispense withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationDispense withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationDispense withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationDispense withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationDispense withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationDispense withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationDispense withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public MedicationDispense withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public MedicationDispense withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public MedicationDispense withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<MedicationDispenseDosageInstruction> rhsDosageInstruction;
        List<Reference> rhsReceiver;
        List<Reference> rhsAuthorizingPrescription;
        if (!(object instanceof MedicationDispense)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationDispense that = (MedicationDispense)object;
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier)) {
            return false;
        }
        MedicationDispenseStatus lhsStatus = this.getStatus();
        MedicationDispenseStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        Reference lhsDispenser = this.getDispenser();
        Reference rhsDispenser = that.getDispenser();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dispenser", (Object)lhsDispenser), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dispenser", (Object)rhsDispenser), (Object)lhsDispenser, (Object)rhsDispenser)) {
            return false;
        }
        List<Reference> lhsAuthorizingPrescription = this.authorizingPrescription != null && !this.authorizingPrescription.isEmpty() ? this.getAuthorizingPrescription() : null;
        List<Reference> list = rhsAuthorizingPrescription = that.authorizingPrescription != null && !that.authorizingPrescription.isEmpty() ? that.getAuthorizingPrescription() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"authorizingPrescription", lhsAuthorizingPrescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"authorizingPrescription", rhsAuthorizingPrescription), lhsAuthorizingPrescription, rhsAuthorizingPrescription)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        Quantity lhsQuantity = this.getQuantity();
        Quantity rhsQuantity = that.getQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"quantity", (Object)lhsQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"quantity", (Object)rhsQuantity), (Object)lhsQuantity, (Object)rhsQuantity)) {
            return false;
        }
        Quantity lhsDaysSupply = this.getDaysSupply();
        Quantity rhsDaysSupply = that.getDaysSupply();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"daysSupply", (Object)lhsDaysSupply), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"daysSupply", (Object)rhsDaysSupply), (Object)lhsDaysSupply, (Object)rhsDaysSupply)) {
            return false;
        }
        Reference lhsMedication = this.getMedication();
        Reference rhsMedication = that.getMedication();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"medication", (Object)lhsMedication), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"medication", (Object)rhsMedication), (Object)lhsMedication, (Object)rhsMedication)) {
            return false;
        }
        DateTime lhsWhenPrepared = this.getWhenPrepared();
        DateTime rhsWhenPrepared = that.getWhenPrepared();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"whenPrepared", (Object)lhsWhenPrepared), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"whenPrepared", (Object)rhsWhenPrepared), (Object)lhsWhenPrepared, (Object)rhsWhenPrepared)) {
            return false;
        }
        DateTime lhsWhenHandedOver = this.getWhenHandedOver();
        DateTime rhsWhenHandedOver = that.getWhenHandedOver();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"whenHandedOver", (Object)lhsWhenHandedOver), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"whenHandedOver", (Object)rhsWhenHandedOver), (Object)lhsWhenHandedOver, (Object)rhsWhenHandedOver)) {
            return false;
        }
        Reference lhsDestination = this.getDestination();
        Reference rhsDestination = that.getDestination();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"destination", (Object)lhsDestination), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"destination", (Object)rhsDestination), (Object)lhsDestination, (Object)rhsDestination)) {
            return false;
        }
        List<Reference> lhsReceiver = this.receiver != null && !this.receiver.isEmpty() ? this.getReceiver() : null;
        List<Reference> list2 = rhsReceiver = that.receiver != null && !that.receiver.isEmpty() ? that.getReceiver() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"receiver", lhsReceiver), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"receiver", rhsReceiver), lhsReceiver, rhsReceiver)) {
            return false;
        }
        String lhsNote = this.getNote();
        String rhsNote = that.getNote();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"note", (Object)lhsNote), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"note", (Object)rhsNote), (Object)lhsNote, (Object)rhsNote)) {
            return false;
        }
        List<MedicationDispenseDosageInstruction> lhsDosageInstruction = this.dosageInstruction != null && !this.dosageInstruction.isEmpty() ? this.getDosageInstruction() : null;
        List<MedicationDispenseDosageInstruction> list3 = rhsDosageInstruction = that.dosageInstruction != null && !that.dosageInstruction.isEmpty() ? that.getDosageInstruction() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dosageInstruction", lhsDosageInstruction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dosageInstruction", rhsDosageInstruction), lhsDosageInstruction, rhsDosageInstruction)) {
            return false;
        }
        MedicationDispenseSubstitution lhsSubstitution = this.getSubstitution();
        MedicationDispenseSubstitution rhsSubstitution = that.getSubstitution();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"substitution", (Object)lhsSubstitution), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"substitution", (Object)rhsSubstitution), (Object)lhsSubstitution, (Object)rhsSubstitution);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier);
        MedicationDispenseStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        Reference theDispenser = this.getDispenser();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dispenser", (Object)theDispenser), currentHashCode, (Object)theDispenser);
        List<Reference> theAuthorizingPrescription = this.authorizingPrescription != null && !this.authorizingPrescription.isEmpty() ? this.getAuthorizingPrescription() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"authorizingPrescription", theAuthorizingPrescription), currentHashCode, theAuthorizingPrescription);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType);
        Quantity theQuantity = this.getQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"quantity", (Object)theQuantity), currentHashCode, (Object)theQuantity);
        Quantity theDaysSupply = this.getDaysSupply();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"daysSupply", (Object)theDaysSupply), currentHashCode, (Object)theDaysSupply);
        Reference theMedication = this.getMedication();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"medication", (Object)theMedication), currentHashCode, (Object)theMedication);
        DateTime theWhenPrepared = this.getWhenPrepared();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"whenPrepared", (Object)theWhenPrepared), currentHashCode, (Object)theWhenPrepared);
        DateTime theWhenHandedOver = this.getWhenHandedOver();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"whenHandedOver", (Object)theWhenHandedOver), currentHashCode, (Object)theWhenHandedOver);
        Reference theDestination = this.getDestination();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"destination", (Object)theDestination), currentHashCode, (Object)theDestination);
        List<Reference> theReceiver = this.receiver != null && !this.receiver.isEmpty() ? this.getReceiver() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"receiver", theReceiver), currentHashCode, theReceiver);
        String theNote = this.getNote();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"note", (Object)theNote), currentHashCode, (Object)theNote);
        List<MedicationDispenseDosageInstruction> theDosageInstruction = this.dosageInstruction != null && !this.dosageInstruction.isEmpty() ? this.getDosageInstruction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dosageInstruction", theDosageInstruction), currentHashCode, theDosageInstruction);
        MedicationDispenseSubstitution theSubstitution = this.getSubstitution();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"substitution", (Object)theSubstitution), currentHashCode, (Object)theSubstitution);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier);
        MedicationDispenseStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        Reference theDispenser = this.getDispenser();
        strategy.appendField(locator, (Object)this, "dispenser", buffer, (Object)theDispenser);
        List<Reference> theAuthorizingPrescription = this.authorizingPrescription != null && !this.authorizingPrescription.isEmpty() ? this.getAuthorizingPrescription() : null;
        strategy.appendField(locator, (Object)this, "authorizingPrescription", buffer, theAuthorizingPrescription);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        Quantity theQuantity = this.getQuantity();
        strategy.appendField(locator, (Object)this, "quantity", buffer, (Object)theQuantity);
        Quantity theDaysSupply = this.getDaysSupply();
        strategy.appendField(locator, (Object)this, "daysSupply", buffer, (Object)theDaysSupply);
        Reference theMedication = this.getMedication();
        strategy.appendField(locator, (Object)this, "medication", buffer, (Object)theMedication);
        DateTime theWhenPrepared = this.getWhenPrepared();
        strategy.appendField(locator, (Object)this, "whenPrepared", buffer, (Object)theWhenPrepared);
        DateTime theWhenHandedOver = this.getWhenHandedOver();
        strategy.appendField(locator, (Object)this, "whenHandedOver", buffer, (Object)theWhenHandedOver);
        Reference theDestination = this.getDestination();
        strategy.appendField(locator, (Object)this, "destination", buffer, (Object)theDestination);
        List<Reference> theReceiver = this.receiver != null && !this.receiver.isEmpty() ? this.getReceiver() : null;
        strategy.appendField(locator, (Object)this, "receiver", buffer, theReceiver);
        String theNote = this.getNote();
        strategy.appendField(locator, (Object)this, "note", buffer, (Object)theNote);
        List<MedicationDispenseDosageInstruction> theDosageInstruction = this.dosageInstruction != null && !this.dosageInstruction.isEmpty() ? this.getDosageInstruction() : null;
        strategy.appendField(locator, (Object)this, "dosageInstruction", buffer, theDosageInstruction);
        MedicationDispenseSubstitution theSubstitution = this.getSubstitution();
        strategy.appendField(locator, (Object)this, "substitution", buffer, (Object)theSubstitution);
        return buffer;
    }
}

