/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.MedicationPrescriptionDispense;
import org.hl7.fhir.MedicationPrescriptionDosageInstruction;
import org.hl7.fhir.MedicationPrescriptionStatus;
import org.hl7.fhir.MedicationPrescriptionSubstitution;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MedicationPrescription", propOrder={"identifier", "dateWritten", "status", "patient", "prescriber", "encounter", "reasonCodeableConcept", "reasonReference", "note", "medication", "dosageInstruction", "dispense", "substitution"})
public class MedicationPrescription
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    protected DateTime dateWritten;
    protected MedicationPrescriptionStatus status;
    protected Reference patient;
    protected Reference prescriber;
    protected Reference encounter;
    protected CodeableConcept reasonCodeableConcept;
    protected Reference reasonReference;
    protected String note;
    protected Reference medication;
    protected List<MedicationPrescriptionDosageInstruction> dosageInstruction;
    protected MedicationPrescriptionDispense dispense;
    protected MedicationPrescriptionSubstitution substitution;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DateTime getDateWritten() {
        return this.dateWritten;
    }

    public void setDateWritten(DateTime value) {
        this.dateWritten = value;
    }

    public MedicationPrescriptionStatus getStatus() {
        return this.status;
    }

    public void setStatus(MedicationPrescriptionStatus value) {
        this.status = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getPrescriber() {
        return this.prescriber;
    }

    public void setPrescriber(Reference value) {
        this.prescriber = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public CodeableConcept getReasonCodeableConcept() {
        return this.reasonCodeableConcept;
    }

    public void setReasonCodeableConcept(CodeableConcept value) {
        this.reasonCodeableConcept = value;
    }

    public Reference getReasonReference() {
        return this.reasonReference;
    }

    public void setReasonReference(Reference value) {
        this.reasonReference = value;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String value) {
        this.note = value;
    }

    public Reference getMedication() {
        return this.medication;
    }

    public void setMedication(Reference value) {
        this.medication = value;
    }

    public List<MedicationPrescriptionDosageInstruction> getDosageInstruction() {
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<MedicationPrescriptionDosageInstruction>();
        }
        return this.dosageInstruction;
    }

    public MedicationPrescriptionDispense getDispense() {
        return this.dispense;
    }

    public void setDispense(MedicationPrescriptionDispense value) {
        this.dispense = value;
    }

    public MedicationPrescriptionSubstitution getSubstitution() {
        return this.substitution;
    }

    public void setSubstitution(MedicationPrescriptionSubstitution value) {
        this.substitution = value;
    }

    public MedicationPrescription withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public MedicationPrescription withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public MedicationPrescription withDateWritten(DateTime value) {
        this.setDateWritten(value);
        return this;
    }

    public MedicationPrescription withStatus(MedicationPrescriptionStatus value) {
        this.setStatus(value);
        return this;
    }

    public MedicationPrescription withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public MedicationPrescription withPrescriber(Reference value) {
        this.setPrescriber(value);
        return this;
    }

    public MedicationPrescription withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public MedicationPrescription withReasonCodeableConcept(CodeableConcept value) {
        this.setReasonCodeableConcept(value);
        return this;
    }

    public MedicationPrescription withReasonReference(Reference value) {
        this.setReasonReference(value);
        return this;
    }

    public MedicationPrescription withNote(String value) {
        this.setNote(value);
        return this;
    }

    public MedicationPrescription withMedication(Reference value) {
        this.setMedication(value);
        return this;
    }

    public MedicationPrescription withDosageInstruction(MedicationPrescriptionDosageInstruction ... values) {
        if (values != null) {
            for (MedicationPrescriptionDosageInstruction value : values) {
                this.getDosageInstruction().add(value);
            }
        }
        return this;
    }

    public MedicationPrescription withDosageInstruction(Collection<MedicationPrescriptionDosageInstruction> values) {
        if (values != null) {
            this.getDosageInstruction().addAll(values);
        }
        return this;
    }

    public MedicationPrescription withDispense(MedicationPrescriptionDispense value) {
        this.setDispense(value);
        return this;
    }

    public MedicationPrescription withSubstitution(MedicationPrescriptionSubstitution value) {
        this.setSubstitution(value);
        return this;
    }

    @Override
    public MedicationPrescription withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public MedicationPrescription withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationPrescription withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationPrescription withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationPrescription withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationPrescription withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationPrescription withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationPrescription withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public MedicationPrescription withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public MedicationPrescription withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public MedicationPrescription withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<MedicationPrescriptionDosageInstruction> rhsDosageInstruction;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof MedicationPrescription)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationPrescription that = (MedicationPrescription)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        DateTime lhsDateWritten = this.getDateWritten();
        DateTime rhsDateWritten = that.getDateWritten();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dateWritten", (Object)lhsDateWritten), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dateWritten", (Object)rhsDateWritten), (Object)lhsDateWritten, (Object)rhsDateWritten)) {
            return false;
        }
        MedicationPrescriptionStatus lhsStatus = this.getStatus();
        MedicationPrescriptionStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        Reference lhsPrescriber = this.getPrescriber();
        Reference rhsPrescriber = that.getPrescriber();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"prescriber", (Object)lhsPrescriber), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"prescriber", (Object)rhsPrescriber), (Object)lhsPrescriber, (Object)rhsPrescriber)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter)) {
            return false;
        }
        CodeableConcept lhsReasonCodeableConcept = this.getReasonCodeableConcept();
        CodeableConcept rhsReasonCodeableConcept = that.getReasonCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reasonCodeableConcept", (Object)lhsReasonCodeableConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reasonCodeableConcept", (Object)rhsReasonCodeableConcept), (Object)lhsReasonCodeableConcept, (Object)rhsReasonCodeableConcept)) {
            return false;
        }
        Reference lhsReasonReference = this.getReasonReference();
        Reference rhsReasonReference = that.getReasonReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reasonReference", (Object)lhsReasonReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reasonReference", (Object)rhsReasonReference), (Object)lhsReasonReference, (Object)rhsReasonReference)) {
            return false;
        }
        String lhsNote = this.getNote();
        String rhsNote = that.getNote();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"note", (Object)lhsNote), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"note", (Object)rhsNote), (Object)lhsNote, (Object)rhsNote)) {
            return false;
        }
        Reference lhsMedication = this.getMedication();
        Reference rhsMedication = that.getMedication();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"medication", (Object)lhsMedication), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"medication", (Object)rhsMedication), (Object)lhsMedication, (Object)rhsMedication)) {
            return false;
        }
        List<MedicationPrescriptionDosageInstruction> lhsDosageInstruction = this.dosageInstruction != null && !this.dosageInstruction.isEmpty() ? this.getDosageInstruction() : null;
        List<MedicationPrescriptionDosageInstruction> list2 = rhsDosageInstruction = that.dosageInstruction != null && !that.dosageInstruction.isEmpty() ? that.getDosageInstruction() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dosageInstruction", lhsDosageInstruction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dosageInstruction", rhsDosageInstruction), lhsDosageInstruction, rhsDosageInstruction)) {
            return false;
        }
        MedicationPrescriptionDispense lhsDispense = this.getDispense();
        MedicationPrescriptionDispense rhsDispense = that.getDispense();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dispense", (Object)lhsDispense), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dispense", (Object)rhsDispense), (Object)lhsDispense, (Object)rhsDispense)) {
            return false;
        }
        MedicationPrescriptionSubstitution lhsSubstitution = this.getSubstitution();
        MedicationPrescriptionSubstitution rhsSubstitution = that.getSubstitution();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"substitution", (Object)lhsSubstitution), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"substitution", (Object)rhsSubstitution), (Object)lhsSubstitution, (Object)rhsSubstitution);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        DateTime theDateWritten = this.getDateWritten();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dateWritten", (Object)theDateWritten), currentHashCode, (Object)theDateWritten);
        MedicationPrescriptionStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        Reference thePrescriber = this.getPrescriber();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"prescriber", (Object)thePrescriber), currentHashCode, (Object)thePrescriber);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter);
        CodeableConcept theReasonCodeableConcept = this.getReasonCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reasonCodeableConcept", (Object)theReasonCodeableConcept), currentHashCode, (Object)theReasonCodeableConcept);
        Reference theReasonReference = this.getReasonReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reasonReference", (Object)theReasonReference), currentHashCode, (Object)theReasonReference);
        String theNote = this.getNote();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"note", (Object)theNote), currentHashCode, (Object)theNote);
        Reference theMedication = this.getMedication();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"medication", (Object)theMedication), currentHashCode, (Object)theMedication);
        List<MedicationPrescriptionDosageInstruction> theDosageInstruction = this.dosageInstruction != null && !this.dosageInstruction.isEmpty() ? this.getDosageInstruction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dosageInstruction", theDosageInstruction), currentHashCode, theDosageInstruction);
        MedicationPrescriptionDispense theDispense = this.getDispense();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dispense", (Object)theDispense), currentHashCode, (Object)theDispense);
        MedicationPrescriptionSubstitution theSubstitution = this.getSubstitution();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"substitution", (Object)theSubstitution), currentHashCode, (Object)theSubstitution);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        DateTime theDateWritten = this.getDateWritten();
        strategy.appendField(locator, (Object)this, "dateWritten", buffer, (Object)theDateWritten);
        MedicationPrescriptionStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        Reference thePrescriber = this.getPrescriber();
        strategy.appendField(locator, (Object)this, "prescriber", buffer, (Object)thePrescriber);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter);
        CodeableConcept theReasonCodeableConcept = this.getReasonCodeableConcept();
        strategy.appendField(locator, (Object)this, "reasonCodeableConcept", buffer, (Object)theReasonCodeableConcept);
        Reference theReasonReference = this.getReasonReference();
        strategy.appendField(locator, (Object)this, "reasonReference", buffer, (Object)theReasonReference);
        String theNote = this.getNote();
        strategy.appendField(locator, (Object)this, "note", buffer, (Object)theNote);
        Reference theMedication = this.getMedication();
        strategy.appendField(locator, (Object)this, "medication", buffer, (Object)theMedication);
        List<MedicationPrescriptionDosageInstruction> theDosageInstruction = this.dosageInstruction != null && !this.dosageInstruction.isEmpty() ? this.getDosageInstruction() : null;
        strategy.appendField(locator, (Object)this, "dosageInstruction", buffer, theDosageInstruction);
        MedicationPrescriptionDispense theDispense = this.getDispense();
        strategy.appendField(locator, (Object)this, "dispense", buffer, (Object)theDispense);
        MedicationPrescriptionSubstitution theSubstitution = this.getSubstitution();
        strategy.appendField(locator, (Object)this, "substitution", buffer, (Object)theSubstitution);
        return buffer;
    }
}

