/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Duration;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Period;
import org.hl7.fhir.PositiveInt;
import org.hl7.fhir.Quantity;
import org.hl7.fhir.Reference;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MedicationPrescription.Dispense", propOrder={"medication", "validityPeriod", "numberOfRepeatsAllowed", "quantity", "expectedSupplyDuration"})
public class MedicationPrescriptionDispense
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected Reference medication;
    protected Period validityPeriod;
    protected PositiveInt numberOfRepeatsAllowed;
    protected Quantity quantity;
    protected Duration expectedSupplyDuration;

    public Reference getMedication() {
        return this.medication;
    }

    public void setMedication(Reference value) {
        this.medication = value;
    }

    public Period getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(Period value) {
        this.validityPeriod = value;
    }

    public PositiveInt getNumberOfRepeatsAllowed() {
        return this.numberOfRepeatsAllowed;
    }

    public void setNumberOfRepeatsAllowed(PositiveInt value) {
        this.numberOfRepeatsAllowed = value;
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Quantity value) {
        this.quantity = value;
    }

    public Duration getExpectedSupplyDuration() {
        return this.expectedSupplyDuration;
    }

    public void setExpectedSupplyDuration(Duration value) {
        this.expectedSupplyDuration = value;
    }

    public MedicationPrescriptionDispense withMedication(Reference value) {
        this.setMedication(value);
        return this;
    }

    public MedicationPrescriptionDispense withValidityPeriod(Period value) {
        this.setValidityPeriod(value);
        return this;
    }

    public MedicationPrescriptionDispense withNumberOfRepeatsAllowed(PositiveInt value) {
        this.setNumberOfRepeatsAllowed(value);
        return this;
    }

    public MedicationPrescriptionDispense withQuantity(Quantity value) {
        this.setQuantity(value);
        return this;
    }

    public MedicationPrescriptionDispense withExpectedSupplyDuration(Duration value) {
        this.setExpectedSupplyDuration(value);
        return this;
    }

    @Override
    public MedicationPrescriptionDispense withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationPrescriptionDispense withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationPrescriptionDispense withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationPrescriptionDispense withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationPrescriptionDispense withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof MedicationPrescriptionDispense)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationPrescriptionDispense that = (MedicationPrescriptionDispense)object;
        Reference lhsMedication = this.getMedication();
        Reference rhsMedication = that.getMedication();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"medication", (Object)lhsMedication), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"medication", (Object)rhsMedication), (Object)lhsMedication, (Object)rhsMedication)) {
            return false;
        }
        Period lhsValidityPeriod = this.getValidityPeriod();
        Period rhsValidityPeriod = that.getValidityPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"validityPeriod", (Object)lhsValidityPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"validityPeriod", (Object)rhsValidityPeriod), (Object)lhsValidityPeriod, (Object)rhsValidityPeriod)) {
            return false;
        }
        PositiveInt lhsNumberOfRepeatsAllowed = this.getNumberOfRepeatsAllowed();
        PositiveInt rhsNumberOfRepeatsAllowed = that.getNumberOfRepeatsAllowed();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"numberOfRepeatsAllowed", (Object)lhsNumberOfRepeatsAllowed), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"numberOfRepeatsAllowed", (Object)rhsNumberOfRepeatsAllowed), (Object)lhsNumberOfRepeatsAllowed, (Object)rhsNumberOfRepeatsAllowed)) {
            return false;
        }
        Quantity lhsQuantity = this.getQuantity();
        Quantity rhsQuantity = that.getQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"quantity", (Object)lhsQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"quantity", (Object)rhsQuantity), (Object)lhsQuantity, (Object)rhsQuantity)) {
            return false;
        }
        Duration lhsExpectedSupplyDuration = this.getExpectedSupplyDuration();
        Duration rhsExpectedSupplyDuration = that.getExpectedSupplyDuration();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"expectedSupplyDuration", (Object)lhsExpectedSupplyDuration), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"expectedSupplyDuration", (Object)rhsExpectedSupplyDuration), (Object)lhsExpectedSupplyDuration, (Object)rhsExpectedSupplyDuration);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Reference theMedication = this.getMedication();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"medication", (Object)theMedication), currentHashCode, (Object)theMedication);
        Period theValidityPeriod = this.getValidityPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"validityPeriod", (Object)theValidityPeriod), currentHashCode, (Object)theValidityPeriod);
        PositiveInt theNumberOfRepeatsAllowed = this.getNumberOfRepeatsAllowed();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"numberOfRepeatsAllowed", (Object)theNumberOfRepeatsAllowed), currentHashCode, (Object)theNumberOfRepeatsAllowed);
        Quantity theQuantity = this.getQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"quantity", (Object)theQuantity), currentHashCode, (Object)theQuantity);
        Duration theExpectedSupplyDuration = this.getExpectedSupplyDuration();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"expectedSupplyDuration", (Object)theExpectedSupplyDuration), currentHashCode, (Object)theExpectedSupplyDuration);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Reference theMedication = this.getMedication();
        strategy.appendField(locator, (Object)this, "medication", buffer, (Object)theMedication);
        Period theValidityPeriod = this.getValidityPeriod();
        strategy.appendField(locator, (Object)this, "validityPeriod", buffer, (Object)theValidityPeriod);
        PositiveInt theNumberOfRepeatsAllowed = this.getNumberOfRepeatsAllowed();
        strategy.appendField(locator, (Object)this, "numberOfRepeatsAllowed", buffer, (Object)theNumberOfRepeatsAllowed);
        Quantity theQuantity = this.getQuantity();
        strategy.appendField(locator, (Object)this, "quantity", buffer, (Object)theQuantity);
        Duration theExpectedSupplyDuration = this.getExpectedSupplyDuration();
        strategy.appendField(locator, (Object)this, "expectedSupplyDuration", buffer, (Object)theExpectedSupplyDuration);
        return buffer;
    }
}

