/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.MedicationStatementDosage;
import org.hl7.fhir.MedicationStatementStatus;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MedicationStatement", propOrder={"identifier", "patient", "informationSource", "dateAsserted", "status", "wasNotGiven", "reasonNotGiven", "reasonForUseCodeableConcept", "reasonForUseReference", "effectiveDateTime", "effectivePeriod", "note", "medication", "dosage"})
public class MedicationStatement
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    protected Reference patient;
    protected Reference informationSource;
    protected DateTime dateAsserted;
    @XmlElement(required=true)
    protected MedicationStatementStatus status;
    protected Boolean wasNotGiven;
    protected List<CodeableConcept> reasonNotGiven;
    protected CodeableConcept reasonForUseCodeableConcept;
    protected Reference reasonForUseReference;
    protected DateTime effectiveDateTime;
    protected Period effectivePeriod;
    protected String note;
    protected Reference medication;
    protected List<MedicationStatementDosage> dosage;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getInformationSource() {
        return this.informationSource;
    }

    public void setInformationSource(Reference value) {
        this.informationSource = value;
    }

    public DateTime getDateAsserted() {
        return this.dateAsserted;
    }

    public void setDateAsserted(DateTime value) {
        this.dateAsserted = value;
    }

    public MedicationStatementStatus getStatus() {
        return this.status;
    }

    public void setStatus(MedicationStatementStatus value) {
        this.status = value;
    }

    public Boolean getWasNotGiven() {
        return this.wasNotGiven;
    }

    public void setWasNotGiven(Boolean value) {
        this.wasNotGiven = value;
    }

    public List<CodeableConcept> getReasonNotGiven() {
        if (this.reasonNotGiven == null) {
            this.reasonNotGiven = new ArrayList<CodeableConcept>();
        }
        return this.reasonNotGiven;
    }

    public CodeableConcept getReasonForUseCodeableConcept() {
        return this.reasonForUseCodeableConcept;
    }

    public void setReasonForUseCodeableConcept(CodeableConcept value) {
        this.reasonForUseCodeableConcept = value;
    }

    public Reference getReasonForUseReference() {
        return this.reasonForUseReference;
    }

    public void setReasonForUseReference(Reference value) {
        this.reasonForUseReference = value;
    }

    public DateTime getEffectiveDateTime() {
        return this.effectiveDateTime;
    }

    public void setEffectiveDateTime(DateTime value) {
        this.effectiveDateTime = value;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public void setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String value) {
        this.note = value;
    }

    public Reference getMedication() {
        return this.medication;
    }

    public void setMedication(Reference value) {
        this.medication = value;
    }

    public List<MedicationStatementDosage> getDosage() {
        if (this.dosage == null) {
            this.dosage = new ArrayList<MedicationStatementDosage>();
        }
        return this.dosage;
    }

    public MedicationStatement withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public MedicationStatement withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public MedicationStatement withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public MedicationStatement withInformationSource(Reference value) {
        this.setInformationSource(value);
        return this;
    }

    public MedicationStatement withDateAsserted(DateTime value) {
        this.setDateAsserted(value);
        return this;
    }

    public MedicationStatement withStatus(MedicationStatementStatus value) {
        this.setStatus(value);
        return this;
    }

    public MedicationStatement withWasNotGiven(Boolean value) {
        this.setWasNotGiven(value);
        return this;
    }

    public MedicationStatement withReasonNotGiven(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getReasonNotGiven().add(value);
            }
        }
        return this;
    }

    public MedicationStatement withReasonNotGiven(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getReasonNotGiven().addAll(values);
        }
        return this;
    }

    public MedicationStatement withReasonForUseCodeableConcept(CodeableConcept value) {
        this.setReasonForUseCodeableConcept(value);
        return this;
    }

    public MedicationStatement withReasonForUseReference(Reference value) {
        this.setReasonForUseReference(value);
        return this;
    }

    public MedicationStatement withEffectiveDateTime(DateTime value) {
        this.setEffectiveDateTime(value);
        return this;
    }

    public MedicationStatement withEffectivePeriod(Period value) {
        this.setEffectivePeriod(value);
        return this;
    }

    public MedicationStatement withNote(String value) {
        this.setNote(value);
        return this;
    }

    public MedicationStatement withMedication(Reference value) {
        this.setMedication(value);
        return this;
    }

    public MedicationStatement withDosage(MedicationStatementDosage ... values) {
        if (values != null) {
            for (MedicationStatementDosage value : values) {
                this.getDosage().add(value);
            }
        }
        return this;
    }

    public MedicationStatement withDosage(Collection<MedicationStatementDosage> values) {
        if (values != null) {
            this.getDosage().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationStatement withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public MedicationStatement withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationStatement withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationStatement withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationStatement withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationStatement withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationStatement withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationStatement withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public MedicationStatement withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public MedicationStatement withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public MedicationStatement withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<MedicationStatementDosage> rhsDosage;
        List<CodeableConcept> rhsReasonNotGiven;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof MedicationStatement)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationStatement that = (MedicationStatement)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        Reference lhsInformationSource = this.getInformationSource();
        Reference rhsInformationSource = that.getInformationSource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"informationSource", (Object)lhsInformationSource), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"informationSource", (Object)rhsInformationSource), (Object)lhsInformationSource, (Object)rhsInformationSource)) {
            return false;
        }
        DateTime lhsDateAsserted = this.getDateAsserted();
        DateTime rhsDateAsserted = that.getDateAsserted();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dateAsserted", (Object)lhsDateAsserted), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dateAsserted", (Object)rhsDateAsserted), (Object)lhsDateAsserted, (Object)rhsDateAsserted)) {
            return false;
        }
        MedicationStatementStatus lhsStatus = this.getStatus();
        MedicationStatementStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        Boolean lhsWasNotGiven = this.getWasNotGiven();
        Boolean rhsWasNotGiven = that.getWasNotGiven();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"wasNotGiven", (Object)lhsWasNotGiven), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"wasNotGiven", (Object)rhsWasNotGiven), (Object)lhsWasNotGiven, (Object)rhsWasNotGiven)) {
            return false;
        }
        List<CodeableConcept> lhsReasonNotGiven = this.reasonNotGiven != null && !this.reasonNotGiven.isEmpty() ? this.getReasonNotGiven() : null;
        List<CodeableConcept> list2 = rhsReasonNotGiven = that.reasonNotGiven != null && !that.reasonNotGiven.isEmpty() ? that.getReasonNotGiven() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reasonNotGiven", lhsReasonNotGiven), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reasonNotGiven", rhsReasonNotGiven), lhsReasonNotGiven, rhsReasonNotGiven)) {
            return false;
        }
        CodeableConcept lhsReasonForUseCodeableConcept = this.getReasonForUseCodeableConcept();
        CodeableConcept rhsReasonForUseCodeableConcept = that.getReasonForUseCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reasonForUseCodeableConcept", (Object)lhsReasonForUseCodeableConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reasonForUseCodeableConcept", (Object)rhsReasonForUseCodeableConcept), (Object)lhsReasonForUseCodeableConcept, (Object)rhsReasonForUseCodeableConcept)) {
            return false;
        }
        Reference lhsReasonForUseReference = this.getReasonForUseReference();
        Reference rhsReasonForUseReference = that.getReasonForUseReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reasonForUseReference", (Object)lhsReasonForUseReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reasonForUseReference", (Object)rhsReasonForUseReference), (Object)lhsReasonForUseReference, (Object)rhsReasonForUseReference)) {
            return false;
        }
        DateTime lhsEffectiveDateTime = this.getEffectiveDateTime();
        DateTime rhsEffectiveDateTime = that.getEffectiveDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"effectiveDateTime", (Object)lhsEffectiveDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"effectiveDateTime", (Object)rhsEffectiveDateTime), (Object)lhsEffectiveDateTime, (Object)rhsEffectiveDateTime)) {
            return false;
        }
        Period lhsEffectivePeriod = this.getEffectivePeriod();
        Period rhsEffectivePeriod = that.getEffectivePeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"effectivePeriod", (Object)lhsEffectivePeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"effectivePeriod", (Object)rhsEffectivePeriod), (Object)lhsEffectivePeriod, (Object)rhsEffectivePeriod)) {
            return false;
        }
        String lhsNote = this.getNote();
        String rhsNote = that.getNote();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"note", (Object)lhsNote), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"note", (Object)rhsNote), (Object)lhsNote, (Object)rhsNote)) {
            return false;
        }
        Reference lhsMedication = this.getMedication();
        Reference rhsMedication = that.getMedication();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"medication", (Object)lhsMedication), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"medication", (Object)rhsMedication), (Object)lhsMedication, (Object)rhsMedication)) {
            return false;
        }
        List<MedicationStatementDosage> lhsDosage = this.dosage != null && !this.dosage.isEmpty() ? this.getDosage() : null;
        List<MedicationStatementDosage> list3 = rhsDosage = that.dosage != null && !that.dosage.isEmpty() ? that.getDosage() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dosage", lhsDosage), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dosage", rhsDosage), lhsDosage, rhsDosage);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        Reference theInformationSource = this.getInformationSource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"informationSource", (Object)theInformationSource), currentHashCode, (Object)theInformationSource);
        DateTime theDateAsserted = this.getDateAsserted();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dateAsserted", (Object)theDateAsserted), currentHashCode, (Object)theDateAsserted);
        MedicationStatementStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        Boolean theWasNotGiven = this.getWasNotGiven();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"wasNotGiven", (Object)theWasNotGiven), currentHashCode, (Object)theWasNotGiven);
        List<CodeableConcept> theReasonNotGiven = this.reasonNotGiven != null && !this.reasonNotGiven.isEmpty() ? this.getReasonNotGiven() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reasonNotGiven", theReasonNotGiven), currentHashCode, theReasonNotGiven);
        CodeableConcept theReasonForUseCodeableConcept = this.getReasonForUseCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reasonForUseCodeableConcept", (Object)theReasonForUseCodeableConcept), currentHashCode, (Object)theReasonForUseCodeableConcept);
        Reference theReasonForUseReference = this.getReasonForUseReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reasonForUseReference", (Object)theReasonForUseReference), currentHashCode, (Object)theReasonForUseReference);
        DateTime theEffectiveDateTime = this.getEffectiveDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"effectiveDateTime", (Object)theEffectiveDateTime), currentHashCode, (Object)theEffectiveDateTime);
        Period theEffectivePeriod = this.getEffectivePeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"effectivePeriod", (Object)theEffectivePeriod), currentHashCode, (Object)theEffectivePeriod);
        String theNote = this.getNote();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"note", (Object)theNote), currentHashCode, (Object)theNote);
        Reference theMedication = this.getMedication();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"medication", (Object)theMedication), currentHashCode, (Object)theMedication);
        List<MedicationStatementDosage> theDosage = this.dosage != null && !this.dosage.isEmpty() ? this.getDosage() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dosage", theDosage), currentHashCode, theDosage);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        Reference theInformationSource = this.getInformationSource();
        strategy.appendField(locator, (Object)this, "informationSource", buffer, (Object)theInformationSource);
        DateTime theDateAsserted = this.getDateAsserted();
        strategy.appendField(locator, (Object)this, "dateAsserted", buffer, (Object)theDateAsserted);
        MedicationStatementStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        Boolean theWasNotGiven = this.getWasNotGiven();
        strategy.appendField(locator, (Object)this, "wasNotGiven", buffer, (Object)theWasNotGiven);
        List<CodeableConcept> theReasonNotGiven = this.reasonNotGiven != null && !this.reasonNotGiven.isEmpty() ? this.getReasonNotGiven() : null;
        strategy.appendField(locator, (Object)this, "reasonNotGiven", buffer, theReasonNotGiven);
        CodeableConcept theReasonForUseCodeableConcept = this.getReasonForUseCodeableConcept();
        strategy.appendField(locator, (Object)this, "reasonForUseCodeableConcept", buffer, (Object)theReasonForUseCodeableConcept);
        Reference theReasonForUseReference = this.getReasonForUseReference();
        strategy.appendField(locator, (Object)this, "reasonForUseReference", buffer, (Object)theReasonForUseReference);
        DateTime theEffectiveDateTime = this.getEffectiveDateTime();
        strategy.appendField(locator, (Object)this, "effectiveDateTime", buffer, (Object)theEffectiveDateTime);
        Period theEffectivePeriod = this.getEffectivePeriod();
        strategy.appendField(locator, (Object)this, "effectivePeriod", buffer, (Object)theEffectivePeriod);
        String theNote = this.getNote();
        strategy.appendField(locator, (Object)this, "note", buffer, (Object)theNote);
        Reference theMedication = this.getMedication();
        strategy.appendField(locator, (Object)this, "medication", buffer, (Object)theMedication);
        List<MedicationStatementDosage> theDosage = this.dosage != null && !this.dosage.isEmpty() ? this.getDosage() : null;
        strategy.appendField(locator, (Object)this, "dosage", buffer, theDosage);
        return buffer;
    }
}

