/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Instant;
import org.hl7.fhir.MessageHeaderDestination;
import org.hl7.fhir.MessageHeaderResponse;
import org.hl7.fhir.MessageHeaderSource;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MessageHeader", propOrder={"identifier", "timestamp", "event", "response", "source", "destination", "enterer", "author", "receiver", "responsible", "reason", "data"})
public class MessageHeader
extends DomainResource
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected Id identifier;
    @XmlElement(required=true)
    protected Instant timestamp;
    @XmlElement(required=true)
    protected Coding event;
    protected MessageHeaderResponse response;
    @XmlElement(required=true)
    protected MessageHeaderSource source;
    protected List<MessageHeaderDestination> destination;
    protected Reference enterer;
    protected Reference author;
    protected Reference receiver;
    protected Reference responsible;
    protected CodeableConcept reason;
    protected List<Reference> data;

    public Id getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Id value) {
        this.identifier = value;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Instant value) {
        this.timestamp = value;
    }

    public Coding getEvent() {
        return this.event;
    }

    public void setEvent(Coding value) {
        this.event = value;
    }

    public MessageHeaderResponse getResponse() {
        return this.response;
    }

    public void setResponse(MessageHeaderResponse value) {
        this.response = value;
    }

    public MessageHeaderSource getSource() {
        return this.source;
    }

    public void setSource(MessageHeaderSource value) {
        this.source = value;
    }

    public List<MessageHeaderDestination> getDestination() {
        if (this.destination == null) {
            this.destination = new ArrayList<MessageHeaderDestination>();
        }
        return this.destination;
    }

    public Reference getEnterer() {
        return this.enterer;
    }

    public void setEnterer(Reference value) {
        this.enterer = value;
    }

    public Reference getAuthor() {
        return this.author;
    }

    public void setAuthor(Reference value) {
        this.author = value;
    }

    public Reference getReceiver() {
        return this.receiver;
    }

    public void setReceiver(Reference value) {
        this.receiver = value;
    }

    public Reference getResponsible() {
        return this.responsible;
    }

    public void setResponsible(Reference value) {
        this.responsible = value;
    }

    public CodeableConcept getReason() {
        return this.reason;
    }

    public void setReason(CodeableConcept value) {
        this.reason = value;
    }

    public List<Reference> getData() {
        if (this.data == null) {
            this.data = new ArrayList<Reference>();
        }
        return this.data;
    }

    public MessageHeader withIdentifier(Id value) {
        this.setIdentifier(value);
        return this;
    }

    public MessageHeader withTimestamp(Instant value) {
        this.setTimestamp(value);
        return this;
    }

    public MessageHeader withEvent(Coding value) {
        this.setEvent(value);
        return this;
    }

    public MessageHeader withResponse(MessageHeaderResponse value) {
        this.setResponse(value);
        return this;
    }

    public MessageHeader withSource(MessageHeaderSource value) {
        this.setSource(value);
        return this;
    }

    public MessageHeader withDestination(MessageHeaderDestination ... values) {
        if (values != null) {
            for (MessageHeaderDestination value : values) {
                this.getDestination().add(value);
            }
        }
        return this;
    }

    public MessageHeader withDestination(Collection<MessageHeaderDestination> values) {
        if (values != null) {
            this.getDestination().addAll(values);
        }
        return this;
    }

    public MessageHeader withEnterer(Reference value) {
        this.setEnterer(value);
        return this;
    }

    public MessageHeader withAuthor(Reference value) {
        this.setAuthor(value);
        return this;
    }

    public MessageHeader withReceiver(Reference value) {
        this.setReceiver(value);
        return this;
    }

    public MessageHeader withResponsible(Reference value) {
        this.setResponsible(value);
        return this;
    }

    public MessageHeader withReason(CodeableConcept value) {
        this.setReason(value);
        return this;
    }

    public MessageHeader withData(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getData().add(value);
            }
        }
        return this;
    }

    public MessageHeader withData(Collection<Reference> values) {
        if (values != null) {
            this.getData().addAll(values);
        }
        return this;
    }

    @Override
    public MessageHeader withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public MessageHeader withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public MessageHeader withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public MessageHeader withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MessageHeader withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MessageHeader withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MessageHeader withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MessageHeader withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public MessageHeader withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public MessageHeader withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public MessageHeader withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Reference> rhsData;
        List<MessageHeaderDestination> rhsDestination;
        if (!(object instanceof MessageHeader)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MessageHeader that = (MessageHeader)object;
        Id lhsIdentifier = this.getIdentifier();
        Id rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier)) {
            return false;
        }
        Instant lhsTimestamp = this.getTimestamp();
        Instant rhsTimestamp = that.getTimestamp();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"timestamp", (Object)lhsTimestamp), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"timestamp", (Object)rhsTimestamp), (Object)lhsTimestamp, (Object)rhsTimestamp)) {
            return false;
        }
        Coding lhsEvent = this.getEvent();
        Coding rhsEvent = that.getEvent();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"event", (Object)lhsEvent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"event", (Object)rhsEvent), (Object)lhsEvent, (Object)rhsEvent)) {
            return false;
        }
        MessageHeaderResponse lhsResponse = this.getResponse();
        MessageHeaderResponse rhsResponse = that.getResponse();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"response", (Object)lhsResponse), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"response", (Object)rhsResponse), (Object)lhsResponse, (Object)rhsResponse)) {
            return false;
        }
        MessageHeaderSource lhsSource = this.getSource();
        MessageHeaderSource rhsSource = that.getSource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"source", (Object)lhsSource), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"source", (Object)rhsSource), (Object)lhsSource, (Object)rhsSource)) {
            return false;
        }
        List<MessageHeaderDestination> lhsDestination = this.destination != null && !this.destination.isEmpty() ? this.getDestination() : null;
        List<MessageHeaderDestination> list = rhsDestination = that.destination != null && !that.destination.isEmpty() ? that.getDestination() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"destination", lhsDestination), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"destination", rhsDestination), lhsDestination, rhsDestination)) {
            return false;
        }
        Reference lhsEnterer = this.getEnterer();
        Reference rhsEnterer = that.getEnterer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"enterer", (Object)lhsEnterer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"enterer", (Object)rhsEnterer), (Object)lhsEnterer, (Object)rhsEnterer)) {
            return false;
        }
        Reference lhsAuthor = this.getAuthor();
        Reference rhsAuthor = that.getAuthor();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"author", (Object)lhsAuthor), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"author", (Object)rhsAuthor), (Object)lhsAuthor, (Object)rhsAuthor)) {
            return false;
        }
        Reference lhsReceiver = this.getReceiver();
        Reference rhsReceiver = that.getReceiver();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"receiver", (Object)lhsReceiver), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"receiver", (Object)rhsReceiver), (Object)lhsReceiver, (Object)rhsReceiver)) {
            return false;
        }
        Reference lhsResponsible = this.getResponsible();
        Reference rhsResponsible = that.getResponsible();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"responsible", (Object)lhsResponsible), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"responsible", (Object)rhsResponsible), (Object)lhsResponsible, (Object)rhsResponsible)) {
            return false;
        }
        CodeableConcept lhsReason = this.getReason();
        CodeableConcept rhsReason = that.getReason();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reason", (Object)lhsReason), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reason", (Object)rhsReason), (Object)lhsReason, (Object)rhsReason)) {
            return false;
        }
        List<Reference> lhsData = this.data != null && !this.data.isEmpty() ? this.getData() : null;
        List<Reference> list2 = rhsData = that.data != null && !that.data.isEmpty() ? that.getData() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"data", lhsData), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"data", rhsData), lhsData, rhsData);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Id theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier);
        Instant theTimestamp = this.getTimestamp();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"timestamp", (Object)theTimestamp), currentHashCode, (Object)theTimestamp);
        Coding theEvent = this.getEvent();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"event", (Object)theEvent), currentHashCode, (Object)theEvent);
        MessageHeaderResponse theResponse = this.getResponse();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"response", (Object)theResponse), currentHashCode, (Object)theResponse);
        MessageHeaderSource theSource = this.getSource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"source", (Object)theSource), currentHashCode, (Object)theSource);
        List<MessageHeaderDestination> theDestination = this.destination != null && !this.destination.isEmpty() ? this.getDestination() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"destination", theDestination), currentHashCode, theDestination);
        Reference theEnterer = this.getEnterer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"enterer", (Object)theEnterer), currentHashCode, (Object)theEnterer);
        Reference theAuthor = this.getAuthor();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"author", (Object)theAuthor), currentHashCode, (Object)theAuthor);
        Reference theReceiver = this.getReceiver();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"receiver", (Object)theReceiver), currentHashCode, (Object)theReceiver);
        Reference theResponsible = this.getResponsible();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"responsible", (Object)theResponsible), currentHashCode, (Object)theResponsible);
        CodeableConcept theReason = this.getReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reason", (Object)theReason), currentHashCode, (Object)theReason);
        List<Reference> theData = this.data != null && !this.data.isEmpty() ? this.getData() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"data", theData), currentHashCode, theData);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Id theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier);
        Instant theTimestamp = this.getTimestamp();
        strategy.appendField(locator, (Object)this, "timestamp", buffer, (Object)theTimestamp);
        Coding theEvent = this.getEvent();
        strategy.appendField(locator, (Object)this, "event", buffer, (Object)theEvent);
        MessageHeaderResponse theResponse = this.getResponse();
        strategy.appendField(locator, (Object)this, "response", buffer, (Object)theResponse);
        MessageHeaderSource theSource = this.getSource();
        strategy.appendField(locator, (Object)this, "source", buffer, (Object)theSource);
        List<MessageHeaderDestination> theDestination = this.destination != null && !this.destination.isEmpty() ? this.getDestination() : null;
        strategy.appendField(locator, (Object)this, "destination", buffer, theDestination);
        Reference theEnterer = this.getEnterer();
        strategy.appendField(locator, (Object)this, "enterer", buffer, (Object)theEnterer);
        Reference theAuthor = this.getAuthor();
        strategy.appendField(locator, (Object)this, "author", buffer, (Object)theAuthor);
        Reference theReceiver = this.getReceiver();
        strategy.appendField(locator, (Object)this, "receiver", buffer, (Object)theReceiver);
        Reference theResponsible = this.getResponsible();
        strategy.appendField(locator, (Object)this, "responsible", buffer, (Object)theResponsible);
        CodeableConcept theReason = this.getReason();
        strategy.appendField(locator, (Object)this, "reason", buffer, (Object)theReason);
        List<Reference> theData = this.data != null && !this.data.isEmpty() ? this.getData() : null;
        strategy.appendField(locator, (Object)this, "data", buffer, theData);
        return buffer;
    }
}

