/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Attachment;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Instant;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ObservationReferenceRange;
import org.hl7.fhir.ObservationRelated;
import org.hl7.fhir.ObservationReliability;
import org.hl7.fhir.ObservationStatus;
import org.hl7.fhir.Period;
import org.hl7.fhir.Quantity;
import org.hl7.fhir.Range;
import org.hl7.fhir.Ratio;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.SampledData;
import org.hl7.fhir.String;
import org.hl7.fhir.Time;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Observation", propOrder={"code", "valueQuantity", "valueCodeableConcept", "valueString", "valueRange", "valueRatio", "valueSampledData", "valueAttachment", "valueTime", "valueDateTime", "valuePeriod", "dataAbsentReason", "interpretation", "comments", "appliesDateTime", "appliesPeriod", "issued", "status", "reliability", "bodySiteCodeableConcept", "bodySiteReference", "method", "identifier", "subject", "specimen", "performer", "device", "encounter", "referenceRange", "related"})
public class Observation
extends DomainResource
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected CodeableConcept code;
    protected Quantity valueQuantity;
    protected CodeableConcept valueCodeableConcept;
    protected String valueString;
    protected Range valueRange;
    protected Ratio valueRatio;
    protected SampledData valueSampledData;
    protected Attachment valueAttachment;
    protected Time valueTime;
    protected DateTime valueDateTime;
    protected Period valuePeriod;
    protected CodeableConcept dataAbsentReason;
    protected CodeableConcept interpretation;
    protected String comments;
    protected DateTime appliesDateTime;
    protected Period appliesPeriod;
    protected Instant issued;
    @XmlElement(required=true)
    protected ObservationStatus status;
    protected ObservationReliability reliability;
    protected CodeableConcept bodySiteCodeableConcept;
    protected Reference bodySiteReference;
    protected CodeableConcept method;
    protected List<Identifier> identifier;
    protected Reference subject;
    protected Reference specimen;
    protected List<Reference> performer;
    protected Reference device;
    protected Reference encounter;
    protected List<ObservationReferenceRange> referenceRange;
    protected List<ObservationRelated> related;

    public CodeableConcept getCode() {
        return this.code;
    }

    public void setCode(CodeableConcept value) {
        this.code = value;
    }

    public Quantity getValueQuantity() {
        return this.valueQuantity;
    }

    public void setValueQuantity(Quantity value) {
        this.valueQuantity = value;
    }

    public CodeableConcept getValueCodeableConcept() {
        return this.valueCodeableConcept;
    }

    public void setValueCodeableConcept(CodeableConcept value) {
        this.valueCodeableConcept = value;
    }

    public String getValueString() {
        return this.valueString;
    }

    public void setValueString(String value) {
        this.valueString = value;
    }

    public Range getValueRange() {
        return this.valueRange;
    }

    public void setValueRange(Range value) {
        this.valueRange = value;
    }

    public Ratio getValueRatio() {
        return this.valueRatio;
    }

    public void setValueRatio(Ratio value) {
        this.valueRatio = value;
    }

    public SampledData getValueSampledData() {
        return this.valueSampledData;
    }

    public void setValueSampledData(SampledData value) {
        this.valueSampledData = value;
    }

    public Attachment getValueAttachment() {
        return this.valueAttachment;
    }

    public void setValueAttachment(Attachment value) {
        this.valueAttachment = value;
    }

    public Time getValueTime() {
        return this.valueTime;
    }

    public void setValueTime(Time value) {
        this.valueTime = value;
    }

    public DateTime getValueDateTime() {
        return this.valueDateTime;
    }

    public void setValueDateTime(DateTime value) {
        this.valueDateTime = value;
    }

    public Period getValuePeriod() {
        return this.valuePeriod;
    }

    public void setValuePeriod(Period value) {
        this.valuePeriod = value;
    }

    public CodeableConcept getDataAbsentReason() {
        return this.dataAbsentReason;
    }

    public void setDataAbsentReason(CodeableConcept value) {
        this.dataAbsentReason = value;
    }

    public CodeableConcept getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(CodeableConcept value) {
        this.interpretation = value;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String value) {
        this.comments = value;
    }

    public DateTime getAppliesDateTime() {
        return this.appliesDateTime;
    }

    public void setAppliesDateTime(DateTime value) {
        this.appliesDateTime = value;
    }

    public Period getAppliesPeriod() {
        return this.appliesPeriod;
    }

    public void setAppliesPeriod(Period value) {
        this.appliesPeriod = value;
    }

    public Instant getIssued() {
        return this.issued;
    }

    public void setIssued(Instant value) {
        this.issued = value;
    }

    public ObservationStatus getStatus() {
        return this.status;
    }

    public void setStatus(ObservationStatus value) {
        this.status = value;
    }

    public ObservationReliability getReliability() {
        return this.reliability;
    }

    public void setReliability(ObservationReliability value) {
        this.reliability = value;
    }

    public CodeableConcept getBodySiteCodeableConcept() {
        return this.bodySiteCodeableConcept;
    }

    public void setBodySiteCodeableConcept(CodeableConcept value) {
        this.bodySiteCodeableConcept = value;
    }

    public Reference getBodySiteReference() {
        return this.bodySiteReference;
    }

    public void setBodySiteReference(Reference value) {
        this.bodySiteReference = value;
    }

    public CodeableConcept getMethod() {
        return this.method;
    }

    public void setMethod(CodeableConcept value) {
        this.method = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public Reference getSpecimen() {
        return this.specimen;
    }

    public void setSpecimen(Reference value) {
        this.specimen = value;
    }

    public List<Reference> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        return this.performer;
    }

    public Reference getDevice() {
        return this.device;
    }

    public void setDevice(Reference value) {
        this.device = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public List<ObservationReferenceRange> getReferenceRange() {
        if (this.referenceRange == null) {
            this.referenceRange = new ArrayList<ObservationReferenceRange>();
        }
        return this.referenceRange;
    }

    public List<ObservationRelated> getRelated() {
        if (this.related == null) {
            this.related = new ArrayList<ObservationRelated>();
        }
        return this.related;
    }

    public Observation withCode(CodeableConcept value) {
        this.setCode(value);
        return this;
    }

    public Observation withValueQuantity(Quantity value) {
        this.setValueQuantity(value);
        return this;
    }

    public Observation withValueCodeableConcept(CodeableConcept value) {
        this.setValueCodeableConcept(value);
        return this;
    }

    public Observation withValueString(String value) {
        this.setValueString(value);
        return this;
    }

    public Observation withValueRange(Range value) {
        this.setValueRange(value);
        return this;
    }

    public Observation withValueRatio(Ratio value) {
        this.setValueRatio(value);
        return this;
    }

    public Observation withValueSampledData(SampledData value) {
        this.setValueSampledData(value);
        return this;
    }

    public Observation withValueAttachment(Attachment value) {
        this.setValueAttachment(value);
        return this;
    }

    public Observation withValueTime(Time value) {
        this.setValueTime(value);
        return this;
    }

    public Observation withValueDateTime(DateTime value) {
        this.setValueDateTime(value);
        return this;
    }

    public Observation withValuePeriod(Period value) {
        this.setValuePeriod(value);
        return this;
    }

    public Observation withDataAbsentReason(CodeableConcept value) {
        this.setDataAbsentReason(value);
        return this;
    }

    public Observation withInterpretation(CodeableConcept value) {
        this.setInterpretation(value);
        return this;
    }

    public Observation withComments(String value) {
        this.setComments(value);
        return this;
    }

    public Observation withAppliesDateTime(DateTime value) {
        this.setAppliesDateTime(value);
        return this;
    }

    public Observation withAppliesPeriod(Period value) {
        this.setAppliesPeriod(value);
        return this;
    }

    public Observation withIssued(Instant value) {
        this.setIssued(value);
        return this;
    }

    public Observation withStatus(ObservationStatus value) {
        this.setStatus(value);
        return this;
    }

    public Observation withReliability(ObservationReliability value) {
        this.setReliability(value);
        return this;
    }

    public Observation withBodySiteCodeableConcept(CodeableConcept value) {
        this.setBodySiteCodeableConcept(value);
        return this;
    }

    public Observation withBodySiteReference(Reference value) {
        this.setBodySiteReference(value);
        return this;
    }

    public Observation withMethod(CodeableConcept value) {
        this.setMethod(value);
        return this;
    }

    public Observation withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Observation withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Observation withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public Observation withSpecimen(Reference value) {
        this.setSpecimen(value);
        return this;
    }

    public Observation withPerformer(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getPerformer().add(value);
            }
        }
        return this;
    }

    public Observation withPerformer(Collection<Reference> values) {
        if (values != null) {
            this.getPerformer().addAll(values);
        }
        return this;
    }

    public Observation withDevice(Reference value) {
        this.setDevice(value);
        return this;
    }

    public Observation withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public Observation withReferenceRange(ObservationReferenceRange ... values) {
        if (values != null) {
            for (ObservationReferenceRange value : values) {
                this.getReferenceRange().add(value);
            }
        }
        return this;
    }

    public Observation withReferenceRange(Collection<ObservationReferenceRange> values) {
        if (values != null) {
            this.getReferenceRange().addAll(values);
        }
        return this;
    }

    public Observation withRelated(ObservationRelated ... values) {
        if (values != null) {
            for (ObservationRelated value : values) {
                this.getRelated().add(value);
            }
        }
        return this;
    }

    public Observation withRelated(Collection<ObservationRelated> values) {
        if (values != null) {
            this.getRelated().addAll(values);
        }
        return this;
    }

    @Override
    public Observation withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Observation withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Observation withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Observation withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Observation withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Observation withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Observation withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Observation withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Observation withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Observation withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Observation withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ObservationRelated> rhsRelated;
        List<ObservationReferenceRange> rhsReferenceRange;
        List<Reference> rhsPerformer;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof Observation)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Observation that = (Observation)object;
        CodeableConcept lhsCode = this.getCode();
        CodeableConcept rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode)) {
            return false;
        }
        Quantity lhsValueQuantity = this.getValueQuantity();
        Quantity rhsValueQuantity = that.getValueQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueQuantity", (Object)lhsValueQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueQuantity", (Object)rhsValueQuantity), (Object)lhsValueQuantity, (Object)rhsValueQuantity)) {
            return false;
        }
        CodeableConcept lhsValueCodeableConcept = this.getValueCodeableConcept();
        CodeableConcept rhsValueCodeableConcept = that.getValueCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueCodeableConcept", (Object)lhsValueCodeableConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueCodeableConcept", (Object)rhsValueCodeableConcept), (Object)lhsValueCodeableConcept, (Object)rhsValueCodeableConcept)) {
            return false;
        }
        String lhsValueString = this.getValueString();
        String rhsValueString = that.getValueString();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueString", (Object)lhsValueString), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueString", (Object)rhsValueString), (Object)lhsValueString, (Object)rhsValueString)) {
            return false;
        }
        Range lhsValueRange = this.getValueRange();
        Range rhsValueRange = that.getValueRange();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueRange", (Object)lhsValueRange), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueRange", (Object)rhsValueRange), (Object)lhsValueRange, (Object)rhsValueRange)) {
            return false;
        }
        Ratio lhsValueRatio = this.getValueRatio();
        Ratio rhsValueRatio = that.getValueRatio();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueRatio", (Object)lhsValueRatio), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueRatio", (Object)rhsValueRatio), (Object)lhsValueRatio, (Object)rhsValueRatio)) {
            return false;
        }
        SampledData lhsValueSampledData = this.getValueSampledData();
        SampledData rhsValueSampledData = that.getValueSampledData();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueSampledData", (Object)lhsValueSampledData), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueSampledData", (Object)rhsValueSampledData), (Object)lhsValueSampledData, (Object)rhsValueSampledData)) {
            return false;
        }
        Attachment lhsValueAttachment = this.getValueAttachment();
        Attachment rhsValueAttachment = that.getValueAttachment();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueAttachment", (Object)lhsValueAttachment), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueAttachment", (Object)rhsValueAttachment), (Object)lhsValueAttachment, (Object)rhsValueAttachment)) {
            return false;
        }
        Time lhsValueTime = this.getValueTime();
        Time rhsValueTime = that.getValueTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueTime", (Object)lhsValueTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueTime", (Object)rhsValueTime), (Object)lhsValueTime, (Object)rhsValueTime)) {
            return false;
        }
        DateTime lhsValueDateTime = this.getValueDateTime();
        DateTime rhsValueDateTime = that.getValueDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueDateTime", (Object)lhsValueDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueDateTime", (Object)rhsValueDateTime), (Object)lhsValueDateTime, (Object)rhsValueDateTime)) {
            return false;
        }
        Period lhsValuePeriod = this.getValuePeriod();
        Period rhsValuePeriod = that.getValuePeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valuePeriod", (Object)lhsValuePeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valuePeriod", (Object)rhsValuePeriod), (Object)lhsValuePeriod, (Object)rhsValuePeriod)) {
            return false;
        }
        CodeableConcept lhsDataAbsentReason = this.getDataAbsentReason();
        CodeableConcept rhsDataAbsentReason = that.getDataAbsentReason();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dataAbsentReason", (Object)lhsDataAbsentReason), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dataAbsentReason", (Object)rhsDataAbsentReason), (Object)lhsDataAbsentReason, (Object)rhsDataAbsentReason)) {
            return false;
        }
        CodeableConcept lhsInterpretation = this.getInterpretation();
        CodeableConcept rhsInterpretation = that.getInterpretation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"interpretation", (Object)lhsInterpretation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"interpretation", (Object)rhsInterpretation), (Object)lhsInterpretation, (Object)rhsInterpretation)) {
            return false;
        }
        String lhsComments = this.getComments();
        String rhsComments = that.getComments();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"comments", (Object)lhsComments), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"comments", (Object)rhsComments), (Object)lhsComments, (Object)rhsComments)) {
            return false;
        }
        DateTime lhsAppliesDateTime = this.getAppliesDateTime();
        DateTime rhsAppliesDateTime = that.getAppliesDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"appliesDateTime", (Object)lhsAppliesDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"appliesDateTime", (Object)rhsAppliesDateTime), (Object)lhsAppliesDateTime, (Object)rhsAppliesDateTime)) {
            return false;
        }
        Period lhsAppliesPeriod = this.getAppliesPeriod();
        Period rhsAppliesPeriod = that.getAppliesPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"appliesPeriod", (Object)lhsAppliesPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"appliesPeriod", (Object)rhsAppliesPeriod), (Object)lhsAppliesPeriod, (Object)rhsAppliesPeriod)) {
            return false;
        }
        Instant lhsIssued = this.getIssued();
        Instant rhsIssued = that.getIssued();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"issued", (Object)lhsIssued), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"issued", (Object)rhsIssued), (Object)lhsIssued, (Object)rhsIssued)) {
            return false;
        }
        ObservationStatus lhsStatus = this.getStatus();
        ObservationStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        ObservationReliability lhsReliability = this.getReliability();
        ObservationReliability rhsReliability = that.getReliability();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reliability", (Object)lhsReliability), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reliability", (Object)rhsReliability), (Object)lhsReliability, (Object)rhsReliability)) {
            return false;
        }
        CodeableConcept lhsBodySiteCodeableConcept = this.getBodySiteCodeableConcept();
        CodeableConcept rhsBodySiteCodeableConcept = that.getBodySiteCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"bodySiteCodeableConcept", (Object)lhsBodySiteCodeableConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"bodySiteCodeableConcept", (Object)rhsBodySiteCodeableConcept), (Object)lhsBodySiteCodeableConcept, (Object)rhsBodySiteCodeableConcept)) {
            return false;
        }
        Reference lhsBodySiteReference = this.getBodySiteReference();
        Reference rhsBodySiteReference = that.getBodySiteReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"bodySiteReference", (Object)lhsBodySiteReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"bodySiteReference", (Object)rhsBodySiteReference), (Object)lhsBodySiteReference, (Object)rhsBodySiteReference)) {
            return false;
        }
        CodeableConcept lhsMethod = this.getMethod();
        CodeableConcept rhsMethod = that.getMethod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"method", (Object)lhsMethod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"method", (Object)rhsMethod), (Object)lhsMethod, (Object)rhsMethod)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject)) {
            return false;
        }
        Reference lhsSpecimen = this.getSpecimen();
        Reference rhsSpecimen = that.getSpecimen();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"specimen", (Object)lhsSpecimen), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"specimen", (Object)rhsSpecimen), (Object)lhsSpecimen, (Object)rhsSpecimen)) {
            return false;
        }
        List<Reference> lhsPerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        List<Reference> list2 = rhsPerformer = that.performer != null && !that.performer.isEmpty() ? that.getPerformer() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"performer", lhsPerformer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"performer", rhsPerformer), lhsPerformer, rhsPerformer)) {
            return false;
        }
        Reference lhsDevice = this.getDevice();
        Reference rhsDevice = that.getDevice();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"device", (Object)lhsDevice), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"device", (Object)rhsDevice), (Object)lhsDevice, (Object)rhsDevice)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter)) {
            return false;
        }
        List<ObservationReferenceRange> lhsReferenceRange = this.referenceRange != null && !this.referenceRange.isEmpty() ? this.getReferenceRange() : null;
        List<ObservationReferenceRange> list3 = rhsReferenceRange = that.referenceRange != null && !that.referenceRange.isEmpty() ? that.getReferenceRange() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"referenceRange", lhsReferenceRange), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"referenceRange", rhsReferenceRange), lhsReferenceRange, rhsReferenceRange)) {
            return false;
        }
        List<ObservationRelated> lhsRelated = this.related != null && !this.related.isEmpty() ? this.getRelated() : null;
        List<ObservationRelated> list4 = rhsRelated = that.related != null && !that.related.isEmpty() ? that.getRelated() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"related", lhsRelated), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"related", rhsRelated), lhsRelated, rhsRelated);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"code", (Object)theCode), currentHashCode, (Object)theCode);
        Quantity theValueQuantity = this.getValueQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueQuantity", (Object)theValueQuantity), currentHashCode, (Object)theValueQuantity);
        CodeableConcept theValueCodeableConcept = this.getValueCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueCodeableConcept", (Object)theValueCodeableConcept), currentHashCode, (Object)theValueCodeableConcept);
        String theValueString = this.getValueString();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueString", (Object)theValueString), currentHashCode, (Object)theValueString);
        Range theValueRange = this.getValueRange();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueRange", (Object)theValueRange), currentHashCode, (Object)theValueRange);
        Ratio theValueRatio = this.getValueRatio();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueRatio", (Object)theValueRatio), currentHashCode, (Object)theValueRatio);
        SampledData theValueSampledData = this.getValueSampledData();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueSampledData", (Object)theValueSampledData), currentHashCode, (Object)theValueSampledData);
        Attachment theValueAttachment = this.getValueAttachment();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueAttachment", (Object)theValueAttachment), currentHashCode, (Object)theValueAttachment);
        Time theValueTime = this.getValueTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueTime", (Object)theValueTime), currentHashCode, (Object)theValueTime);
        DateTime theValueDateTime = this.getValueDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueDateTime", (Object)theValueDateTime), currentHashCode, (Object)theValueDateTime);
        Period theValuePeriod = this.getValuePeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valuePeriod", (Object)theValuePeriod), currentHashCode, (Object)theValuePeriod);
        CodeableConcept theDataAbsentReason = this.getDataAbsentReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dataAbsentReason", (Object)theDataAbsentReason), currentHashCode, (Object)theDataAbsentReason);
        CodeableConcept theInterpretation = this.getInterpretation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"interpretation", (Object)theInterpretation), currentHashCode, (Object)theInterpretation);
        String theComments = this.getComments();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"comments", (Object)theComments), currentHashCode, (Object)theComments);
        DateTime theAppliesDateTime = this.getAppliesDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"appliesDateTime", (Object)theAppliesDateTime), currentHashCode, (Object)theAppliesDateTime);
        Period theAppliesPeriod = this.getAppliesPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"appliesPeriod", (Object)theAppliesPeriod), currentHashCode, (Object)theAppliesPeriod);
        Instant theIssued = this.getIssued();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"issued", (Object)theIssued), currentHashCode, (Object)theIssued);
        ObservationStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        ObservationReliability theReliability = this.getReliability();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reliability", (Object)theReliability), currentHashCode, (Object)theReliability);
        CodeableConcept theBodySiteCodeableConcept = this.getBodySiteCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"bodySiteCodeableConcept", (Object)theBodySiteCodeableConcept), currentHashCode, (Object)theBodySiteCodeableConcept);
        Reference theBodySiteReference = this.getBodySiteReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"bodySiteReference", (Object)theBodySiteReference), currentHashCode, (Object)theBodySiteReference);
        CodeableConcept theMethod = this.getMethod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"method", (Object)theMethod), currentHashCode, (Object)theMethod);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject);
        Reference theSpecimen = this.getSpecimen();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"specimen", (Object)theSpecimen), currentHashCode, (Object)theSpecimen);
        List<Reference> thePerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"performer", thePerformer), currentHashCode, thePerformer);
        Reference theDevice = this.getDevice();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"device", (Object)theDevice), currentHashCode, (Object)theDevice);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter);
        List<ObservationReferenceRange> theReferenceRange = this.referenceRange != null && !this.referenceRange.isEmpty() ? this.getReferenceRange() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"referenceRange", theReferenceRange), currentHashCode, theReferenceRange);
        List<ObservationRelated> theRelated = this.related != null && !this.related.isEmpty() ? this.getRelated() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"related", theRelated), currentHashCode, theRelated);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode);
        Quantity theValueQuantity = this.getValueQuantity();
        strategy.appendField(locator, (Object)this, "valueQuantity", buffer, (Object)theValueQuantity);
        CodeableConcept theValueCodeableConcept = this.getValueCodeableConcept();
        strategy.appendField(locator, (Object)this, "valueCodeableConcept", buffer, (Object)theValueCodeableConcept);
        String theValueString = this.getValueString();
        strategy.appendField(locator, (Object)this, "valueString", buffer, (Object)theValueString);
        Range theValueRange = this.getValueRange();
        strategy.appendField(locator, (Object)this, "valueRange", buffer, (Object)theValueRange);
        Ratio theValueRatio = this.getValueRatio();
        strategy.appendField(locator, (Object)this, "valueRatio", buffer, (Object)theValueRatio);
        SampledData theValueSampledData = this.getValueSampledData();
        strategy.appendField(locator, (Object)this, "valueSampledData", buffer, (Object)theValueSampledData);
        Attachment theValueAttachment = this.getValueAttachment();
        strategy.appendField(locator, (Object)this, "valueAttachment", buffer, (Object)theValueAttachment);
        Time theValueTime = this.getValueTime();
        strategy.appendField(locator, (Object)this, "valueTime", buffer, (Object)theValueTime);
        DateTime theValueDateTime = this.getValueDateTime();
        strategy.appendField(locator, (Object)this, "valueDateTime", buffer, (Object)theValueDateTime);
        Period theValuePeriod = this.getValuePeriod();
        strategy.appendField(locator, (Object)this, "valuePeriod", buffer, (Object)theValuePeriod);
        CodeableConcept theDataAbsentReason = this.getDataAbsentReason();
        strategy.appendField(locator, (Object)this, "dataAbsentReason", buffer, (Object)theDataAbsentReason);
        CodeableConcept theInterpretation = this.getInterpretation();
        strategy.appendField(locator, (Object)this, "interpretation", buffer, (Object)theInterpretation);
        String theComments = this.getComments();
        strategy.appendField(locator, (Object)this, "comments", buffer, (Object)theComments);
        DateTime theAppliesDateTime = this.getAppliesDateTime();
        strategy.appendField(locator, (Object)this, "appliesDateTime", buffer, (Object)theAppliesDateTime);
        Period theAppliesPeriod = this.getAppliesPeriod();
        strategy.appendField(locator, (Object)this, "appliesPeriod", buffer, (Object)theAppliesPeriod);
        Instant theIssued = this.getIssued();
        strategy.appendField(locator, (Object)this, "issued", buffer, (Object)theIssued);
        ObservationStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        ObservationReliability theReliability = this.getReliability();
        strategy.appendField(locator, (Object)this, "reliability", buffer, (Object)theReliability);
        CodeableConcept theBodySiteCodeableConcept = this.getBodySiteCodeableConcept();
        strategy.appendField(locator, (Object)this, "bodySiteCodeableConcept", buffer, (Object)theBodySiteCodeableConcept);
        Reference theBodySiteReference = this.getBodySiteReference();
        strategy.appendField(locator, (Object)this, "bodySiteReference", buffer, (Object)theBodySiteReference);
        CodeableConcept theMethod = this.getMethod();
        strategy.appendField(locator, (Object)this, "method", buffer, (Object)theMethod);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject);
        Reference theSpecimen = this.getSpecimen();
        strategy.appendField(locator, (Object)this, "specimen", buffer, (Object)theSpecimen);
        List<Reference> thePerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        strategy.appendField(locator, (Object)this, "performer", buffer, thePerformer);
        Reference theDevice = this.getDevice();
        strategy.appendField(locator, (Object)this, "device", buffer, (Object)theDevice);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter);
        List<ObservationReferenceRange> theReferenceRange = this.referenceRange != null && !this.referenceRange.isEmpty() ? this.getReferenceRange() : null;
        strategy.appendField(locator, (Object)this, "referenceRange", buffer, theReferenceRange);
        List<ObservationRelated> theRelated = this.related != null && !this.related.isEmpty() ? this.getRelated() : null;
        strategy.appendField(locator, (Object)this, "related", buffer, theRelated);
        return buffer;
    }
}

