/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.OperationDefinitionContact;
import org.hl7.fhir.OperationDefinitionParameter;
import org.hl7.fhir.OperationKind;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="OperationDefinition", propOrder={"url", "version", "name", "publisher", "contact", "description", "requirements", "status", "experimental", "date", "kind", "idempotent", "code", "notes", "base", "system", "type", "instance", "parameter"})
public class OperationDefinition
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected Uri url;
    protected String version;
    @XmlElement(required=true)
    protected String name;
    protected String publisher;
    protected List<OperationDefinitionContact> contact;
    protected String description;
    protected String requirements;
    @XmlElement(required=true)
    protected ConformanceResourceStatus status;
    protected Boolean experimental;
    protected DateTime date;
    @XmlElement(required=true)
    protected OperationKind kind;
    protected Boolean idempotent;
    @XmlElement(required=true)
    protected Code code;
    protected String notes;
    protected Reference base;
    @XmlElement(required=true)
    protected Boolean system;
    protected List<Code> type;
    @XmlElement(required=true)
    protected Boolean instance;
    protected List<OperationDefinitionParameter> parameter;

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<OperationDefinitionContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<OperationDefinitionContact>();
        }
        return this.contact;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String value) {
        this.requirements = value;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean value) {
        this.experimental = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public OperationKind getKind() {
        return this.kind;
    }

    public void setKind(OperationKind value) {
        this.kind = value;
    }

    public Boolean getIdempotent() {
        return this.idempotent;
    }

    public void setIdempotent(Boolean value) {
        this.idempotent = value;
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code value) {
        this.code = value;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String value) {
        this.notes = value;
    }

    public Reference getBase() {
        return this.base;
    }

    public void setBase(Reference value) {
        this.base = value;
    }

    public Boolean getSystem() {
        return this.system;
    }

    public void setSystem(Boolean value) {
        this.system = value;
    }

    public List<Code> getType() {
        if (this.type == null) {
            this.type = new ArrayList<Code>();
        }
        return this.type;
    }

    public Boolean getInstance() {
        return this.instance;
    }

    public void setInstance(Boolean value) {
        this.instance = value;
    }

    public List<OperationDefinitionParameter> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<OperationDefinitionParameter>();
        }
        return this.parameter;
    }

    public OperationDefinition withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public OperationDefinition withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public OperationDefinition withName(String value) {
        this.setName(value);
        return this;
    }

    public OperationDefinition withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public OperationDefinition withContact(OperationDefinitionContact ... values) {
        if (values != null) {
            for (OperationDefinitionContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public OperationDefinition withContact(Collection<OperationDefinitionContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public OperationDefinition withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public OperationDefinition withRequirements(String value) {
        this.setRequirements(value);
        return this;
    }

    public OperationDefinition withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public OperationDefinition withExperimental(Boolean value) {
        this.setExperimental(value);
        return this;
    }

    public OperationDefinition withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public OperationDefinition withKind(OperationKind value) {
        this.setKind(value);
        return this;
    }

    public OperationDefinition withIdempotent(Boolean value) {
        this.setIdempotent(value);
        return this;
    }

    public OperationDefinition withCode(Code value) {
        this.setCode(value);
        return this;
    }

    public OperationDefinition withNotes(String value) {
        this.setNotes(value);
        return this;
    }

    public OperationDefinition withBase(Reference value) {
        this.setBase(value);
        return this;
    }

    public OperationDefinition withSystem(Boolean value) {
        this.setSystem(value);
        return this;
    }

    public OperationDefinition withType(Code ... values) {
        if (values != null) {
            for (Code value : values) {
                this.getType().add(value);
            }
        }
        return this;
    }

    public OperationDefinition withType(Collection<Code> values) {
        if (values != null) {
            this.getType().addAll(values);
        }
        return this;
    }

    public OperationDefinition withInstance(Boolean value) {
        this.setInstance(value);
        return this;
    }

    public OperationDefinition withParameter(OperationDefinitionParameter ... values) {
        if (values != null) {
            for (OperationDefinitionParameter value : values) {
                this.getParameter().add(value);
            }
        }
        return this;
    }

    public OperationDefinition withParameter(Collection<OperationDefinitionParameter> values) {
        if (values != null) {
            this.getParameter().addAll(values);
        }
        return this;
    }

    @Override
    public OperationDefinition withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public OperationDefinition withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public OperationDefinition withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public OperationDefinition withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public OperationDefinition withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public OperationDefinition withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public OperationDefinition withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public OperationDefinition withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public OperationDefinition withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public OperationDefinition withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public OperationDefinition withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<OperationDefinitionParameter> rhsParameter;
        List<Code> rhsType;
        List<OperationDefinitionContact> rhsContact;
        if (!(object instanceof OperationDefinition)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        OperationDefinition that = (OperationDefinition)object;
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"url", (Object)lhsUrl), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"url", (Object)rhsUrl), (Object)lhsUrl, (Object)rhsUrl)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"version", (Object)lhsVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"version", (Object)rhsVersion), (Object)lhsVersion, (Object)rhsVersion)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"name", (Object)lhsName), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"name", (Object)rhsName), (Object)lhsName, (Object)rhsName)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"publisher", (Object)lhsPublisher), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"publisher", (Object)rhsPublisher), (Object)lhsPublisher, (Object)rhsPublisher)) {
            return false;
        }
        List<OperationDefinitionContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<OperationDefinitionContact> list = rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"contact", lhsContact), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"contact", rhsContact), lhsContact, rhsContact)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription)) {
            return false;
        }
        String lhsRequirements = this.getRequirements();
        String rhsRequirements = that.getRequirements();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requirements", (Object)lhsRequirements), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requirements", (Object)rhsRequirements), (Object)lhsRequirements, (Object)rhsRequirements)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        Boolean lhsExperimental = this.getExperimental();
        Boolean rhsExperimental = that.getExperimental();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"experimental", (Object)lhsExperimental), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"experimental", (Object)rhsExperimental), (Object)lhsExperimental, (Object)rhsExperimental)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate)) {
            return false;
        }
        OperationKind lhsKind = this.getKind();
        OperationKind rhsKind = that.getKind();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"kind", (Object)lhsKind), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"kind", (Object)rhsKind), (Object)lhsKind, (Object)rhsKind)) {
            return false;
        }
        Boolean lhsIdempotent = this.getIdempotent();
        Boolean rhsIdempotent = that.getIdempotent();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"idempotent", (Object)lhsIdempotent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"idempotent", (Object)rhsIdempotent), (Object)lhsIdempotent, (Object)rhsIdempotent)) {
            return false;
        }
        Code lhsCode = this.getCode();
        Code rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode)) {
            return false;
        }
        String lhsNotes = this.getNotes();
        String rhsNotes = that.getNotes();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"notes", (Object)lhsNotes), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"notes", (Object)rhsNotes), (Object)lhsNotes, (Object)rhsNotes)) {
            return false;
        }
        Reference lhsBase = this.getBase();
        Reference rhsBase = that.getBase();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"base", (Object)lhsBase), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"base", (Object)rhsBase), (Object)lhsBase, (Object)rhsBase)) {
            return false;
        }
        Boolean lhsSystem = this.getSystem();
        Boolean rhsSystem = that.getSystem();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"system", (Object)lhsSystem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"system", (Object)rhsSystem), (Object)lhsSystem, (Object)rhsSystem)) {
            return false;
        }
        List<Code> lhsType = this.type != null && !this.type.isEmpty() ? this.getType() : null;
        List<Code> list2 = rhsType = that.type != null && !that.type.isEmpty() ? that.getType() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", rhsType), lhsType, rhsType)) {
            return false;
        }
        Boolean lhsInstance = this.getInstance();
        Boolean rhsInstance = that.getInstance();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"instance", (Object)lhsInstance), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"instance", (Object)rhsInstance), (Object)lhsInstance, (Object)rhsInstance)) {
            return false;
        }
        List<OperationDefinitionParameter> lhsParameter = this.parameter != null && !this.parameter.isEmpty() ? this.getParameter() : null;
        List<OperationDefinitionParameter> list3 = rhsParameter = that.parameter != null && !that.parameter.isEmpty() ? that.getParameter() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"parameter", lhsParameter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"parameter", rhsParameter), lhsParameter, rhsParameter);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"url", (Object)theUrl), currentHashCode, (Object)theUrl);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"version", (Object)theVersion), currentHashCode, (Object)theVersion);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"name", (Object)theName), currentHashCode, (Object)theName);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"publisher", (Object)thePublisher), currentHashCode, (Object)thePublisher);
        List<OperationDefinitionContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"contact", theContact), currentHashCode, theContact);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription);
        String theRequirements = this.getRequirements();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requirements", (Object)theRequirements), currentHashCode, (Object)theRequirements);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        Boolean theExperimental = this.getExperimental();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"experimental", (Object)theExperimental), currentHashCode, (Object)theExperimental);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"date", (Object)theDate), currentHashCode, (Object)theDate);
        OperationKind theKind = this.getKind();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"kind", (Object)theKind), currentHashCode, (Object)theKind);
        Boolean theIdempotent = this.getIdempotent();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"idempotent", (Object)theIdempotent), currentHashCode, (Object)theIdempotent);
        Code theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"code", (Object)theCode), currentHashCode, (Object)theCode);
        String theNotes = this.getNotes();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"notes", (Object)theNotes), currentHashCode, (Object)theNotes);
        Reference theBase = this.getBase();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"base", (Object)theBase), currentHashCode, (Object)theBase);
        Boolean theSystem = this.getSystem();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"system", (Object)theSystem), currentHashCode, (Object)theSystem);
        List<Code> theType = this.type != null && !this.type.isEmpty() ? this.getType() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", theType), currentHashCode, theType);
        Boolean theInstance = this.getInstance();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"instance", (Object)theInstance), currentHashCode, (Object)theInstance);
        List<OperationDefinitionParameter> theParameter = this.parameter != null && !this.parameter.isEmpty() ? this.getParameter() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"parameter", theParameter), currentHashCode, theParameter);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, (Object)theUrl);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, (Object)theVersion);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, (Object)theName);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, (Object)thePublisher);
        List<OperationDefinitionContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription);
        String theRequirements = this.getRequirements();
        strategy.appendField(locator, (Object)this, "requirements", buffer, (Object)theRequirements);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        Boolean theExperimental = this.getExperimental();
        strategy.appendField(locator, (Object)this, "experimental", buffer, (Object)theExperimental);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate);
        OperationKind theKind = this.getKind();
        strategy.appendField(locator, (Object)this, "kind", buffer, (Object)theKind);
        Boolean theIdempotent = this.getIdempotent();
        strategy.appendField(locator, (Object)this, "idempotent", buffer, (Object)theIdempotent);
        Code theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode);
        String theNotes = this.getNotes();
        strategy.appendField(locator, (Object)this, "notes", buffer, (Object)theNotes);
        Reference theBase = this.getBase();
        strategy.appendField(locator, (Object)this, "base", buffer, (Object)theBase);
        Boolean theSystem = this.getSystem();
        strategy.appendField(locator, (Object)this, "system", buffer, (Object)theSystem);
        List<Code> theType = this.type != null && !this.type.isEmpty() ? this.getType() : null;
        strategy.appendField(locator, (Object)this, "type", buffer, theType);
        Boolean theInstance = this.getInstance();
        strategy.appendField(locator, (Object)this, "instance", buffer, (Object)theInstance);
        List<OperationDefinitionParameter> theParameter = this.parameter != null && !this.parameter.isEmpty() ? this.getParameter() : null;
        strategy.appendField(locator, (Object)this, "parameter", buffer, theParameter);
        return buffer;
    }
}

