/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Address;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ContactPoint;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.OrganizationContact;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Organization", propOrder={"identifier", "name", "type", "telecom", "address", "partOf", "contact", "active"})
public class Organization
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    protected String name;
    protected CodeableConcept type;
    protected List<ContactPoint> telecom;
    protected List<Address> address;
    protected Reference partOf;
    protected List<OrganizationContact> contact;
    protected Boolean active;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public List<Address> getAddress() {
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        return this.address;
    }

    public Reference getPartOf() {
        return this.partOf;
    }

    public void setPartOf(Reference value) {
        this.partOf = value;
    }

    public List<OrganizationContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<OrganizationContact>();
        }
        return this.contact;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean value) {
        this.active = value;
    }

    public Organization withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Organization withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Organization withName(String value) {
        this.setName(value);
        return this;
    }

    public Organization withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public Organization withTelecom(ContactPoint ... values) {
        if (values != null) {
            for (ContactPoint value : values) {
                this.getTelecom().add(value);
            }
        }
        return this;
    }

    public Organization withTelecom(Collection<ContactPoint> values) {
        if (values != null) {
            this.getTelecom().addAll(values);
        }
        return this;
    }

    public Organization withAddress(Address ... values) {
        if (values != null) {
            for (Address value : values) {
                this.getAddress().add(value);
            }
        }
        return this;
    }

    public Organization withAddress(Collection<Address> values) {
        if (values != null) {
            this.getAddress().addAll(values);
        }
        return this;
    }

    public Organization withPartOf(Reference value) {
        this.setPartOf(value);
        return this;
    }

    public Organization withContact(OrganizationContact ... values) {
        if (values != null) {
            for (OrganizationContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public Organization withContact(Collection<OrganizationContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public Organization withActive(Boolean value) {
        this.setActive(value);
        return this;
    }

    @Override
    public Organization withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Organization withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Organization withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Organization withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Organization withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Organization withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Organization withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Organization withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Organization withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Organization withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Organization withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<OrganizationContact> rhsContact;
        List<Address> rhsAddress;
        List<ContactPoint> rhsTelecom;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof Organization)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Organization that = (Organization)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"name", (Object)lhsName), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"name", (Object)rhsName), (Object)lhsName, (Object)rhsName)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        List<ContactPoint> lhsTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        List<ContactPoint> list2 = rhsTelecom = that.telecom != null && !that.telecom.isEmpty() ? that.getTelecom() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"telecom", lhsTelecom), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"telecom", rhsTelecom), lhsTelecom, rhsTelecom)) {
            return false;
        }
        List<Address> lhsAddress = this.address != null && !this.address.isEmpty() ? this.getAddress() : null;
        List<Address> list3 = rhsAddress = that.address != null && !that.address.isEmpty() ? that.getAddress() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"address", lhsAddress), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"address", rhsAddress), lhsAddress, rhsAddress)) {
            return false;
        }
        Reference lhsPartOf = this.getPartOf();
        Reference rhsPartOf = that.getPartOf();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"partOf", (Object)lhsPartOf), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"partOf", (Object)rhsPartOf), (Object)lhsPartOf, (Object)rhsPartOf)) {
            return false;
        }
        List<OrganizationContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<OrganizationContact> list4 = rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"contact", lhsContact), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"contact", rhsContact), lhsContact, rhsContact)) {
            return false;
        }
        Boolean lhsActive = this.getActive();
        Boolean rhsActive = that.getActive();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"active", (Object)lhsActive), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"active", (Object)rhsActive), (Object)lhsActive, (Object)rhsActive);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"name", (Object)theName), currentHashCode, (Object)theName);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType);
        List<ContactPoint> theTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"telecom", theTelecom), currentHashCode, theTelecom);
        List<Address> theAddress = this.address != null && !this.address.isEmpty() ? this.getAddress() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"address", theAddress), currentHashCode, theAddress);
        Reference thePartOf = this.getPartOf();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"partOf", (Object)thePartOf), currentHashCode, (Object)thePartOf);
        List<OrganizationContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"contact", theContact), currentHashCode, theContact);
        Boolean theActive = this.getActive();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"active", (Object)theActive), currentHashCode, (Object)theActive);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, (Object)theName);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        List<ContactPoint> theTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        strategy.appendField(locator, (Object)this, "telecom", buffer, theTelecom);
        List<Address> theAddress = this.address != null && !this.address.isEmpty() ? this.getAddress() : null;
        strategy.appendField(locator, (Object)this, "address", buffer, theAddress);
        Reference thePartOf = this.getPartOf();
        strategy.appendField(locator, (Object)this, "partOf", buffer, (Object)thePartOf);
        List<OrganizationContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact);
        Boolean theActive = this.getActive();
        strategy.appendField(locator, (Object)this, "active", buffer, (Object)theActive);
        return buffer;
    }
}

