/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.ProcedureBodySite;
import org.hl7.fhir.ProcedureDevice;
import org.hl7.fhir.ProcedurePerformer;
import org.hl7.fhir.ProcedureRelatedItem;
import org.hl7.fhir.ProcedureStatus;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Procedure", propOrder={"identifier", "patient", "status", "category", "type", "bodySite", "indication", "performer", "performedDateTime", "performedPeriod", "encounter", "location", "outcome", "report", "complication", "followUp", "relatedItem", "notes", "device", "used"})
public class Procedure
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected Reference patient;
    @XmlElement(required=true)
    protected ProcedureStatus status;
    protected CodeableConcept category;
    @XmlElement(required=true)
    protected CodeableConcept type;
    protected List<ProcedureBodySite> bodySite;
    protected List<CodeableConcept> indication;
    protected List<ProcedurePerformer> performer;
    protected DateTime performedDateTime;
    protected Period performedPeriod;
    protected Reference encounter;
    protected Reference location;
    protected CodeableConcept outcome;
    protected List<Reference> report;
    protected List<CodeableConcept> complication;
    protected List<CodeableConcept> followUp;
    protected List<ProcedureRelatedItem> relatedItem;
    protected String notes;
    protected List<ProcedureDevice> device;
    protected List<Reference> used;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public ProcedureStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProcedureStatus value) {
        this.status = value;
    }

    public CodeableConcept getCategory() {
        return this.category;
    }

    public void setCategory(CodeableConcept value) {
        this.category = value;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public List<ProcedureBodySite> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<ProcedureBodySite>();
        }
        return this.bodySite;
    }

    public List<CodeableConcept> getIndication() {
        if (this.indication == null) {
            this.indication = new ArrayList<CodeableConcept>();
        }
        return this.indication;
    }

    public List<ProcedurePerformer> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<ProcedurePerformer>();
        }
        return this.performer;
    }

    public DateTime getPerformedDateTime() {
        return this.performedDateTime;
    }

    public void setPerformedDateTime(DateTime value) {
        this.performedDateTime = value;
    }

    public Period getPerformedPeriod() {
        return this.performedPeriod;
    }

    public void setPerformedPeriod(Period value) {
        this.performedPeriod = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public Reference getLocation() {
        return this.location;
    }

    public void setLocation(Reference value) {
        this.location = value;
    }

    public CodeableConcept getOutcome() {
        return this.outcome;
    }

    public void setOutcome(CodeableConcept value) {
        this.outcome = value;
    }

    public List<Reference> getReport() {
        if (this.report == null) {
            this.report = new ArrayList<Reference>();
        }
        return this.report;
    }

    public List<CodeableConcept> getComplication() {
        if (this.complication == null) {
            this.complication = new ArrayList<CodeableConcept>();
        }
        return this.complication;
    }

    public List<CodeableConcept> getFollowUp() {
        if (this.followUp == null) {
            this.followUp = new ArrayList<CodeableConcept>();
        }
        return this.followUp;
    }

    public List<ProcedureRelatedItem> getRelatedItem() {
        if (this.relatedItem == null) {
            this.relatedItem = new ArrayList<ProcedureRelatedItem>();
        }
        return this.relatedItem;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String value) {
        this.notes = value;
    }

    public List<ProcedureDevice> getDevice() {
        if (this.device == null) {
            this.device = new ArrayList<ProcedureDevice>();
        }
        return this.device;
    }

    public List<Reference> getUsed() {
        if (this.used == null) {
            this.used = new ArrayList<Reference>();
        }
        return this.used;
    }

    public Procedure withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Procedure withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Procedure withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public Procedure withStatus(ProcedureStatus value) {
        this.setStatus(value);
        return this;
    }

    public Procedure withCategory(CodeableConcept value) {
        this.setCategory(value);
        return this;
    }

    public Procedure withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public Procedure withBodySite(ProcedureBodySite ... values) {
        if (values != null) {
            for (ProcedureBodySite value : values) {
                this.getBodySite().add(value);
            }
        }
        return this;
    }

    public Procedure withBodySite(Collection<ProcedureBodySite> values) {
        if (values != null) {
            this.getBodySite().addAll(values);
        }
        return this;
    }

    public Procedure withIndication(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getIndication().add(value);
            }
        }
        return this;
    }

    public Procedure withIndication(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getIndication().addAll(values);
        }
        return this;
    }

    public Procedure withPerformer(ProcedurePerformer ... values) {
        if (values != null) {
            for (ProcedurePerformer value : values) {
                this.getPerformer().add(value);
            }
        }
        return this;
    }

    public Procedure withPerformer(Collection<ProcedurePerformer> values) {
        if (values != null) {
            this.getPerformer().addAll(values);
        }
        return this;
    }

    public Procedure withPerformedDateTime(DateTime value) {
        this.setPerformedDateTime(value);
        return this;
    }

    public Procedure withPerformedPeriod(Period value) {
        this.setPerformedPeriod(value);
        return this;
    }

    public Procedure withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public Procedure withLocation(Reference value) {
        this.setLocation(value);
        return this;
    }

    public Procedure withOutcome(CodeableConcept value) {
        this.setOutcome(value);
        return this;
    }

    public Procedure withReport(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getReport().add(value);
            }
        }
        return this;
    }

    public Procedure withReport(Collection<Reference> values) {
        if (values != null) {
            this.getReport().addAll(values);
        }
        return this;
    }

    public Procedure withComplication(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getComplication().add(value);
            }
        }
        return this;
    }

    public Procedure withComplication(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getComplication().addAll(values);
        }
        return this;
    }

    public Procedure withFollowUp(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getFollowUp().add(value);
            }
        }
        return this;
    }

    public Procedure withFollowUp(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getFollowUp().addAll(values);
        }
        return this;
    }

    public Procedure withRelatedItem(ProcedureRelatedItem ... values) {
        if (values != null) {
            for (ProcedureRelatedItem value : values) {
                this.getRelatedItem().add(value);
            }
        }
        return this;
    }

    public Procedure withRelatedItem(Collection<ProcedureRelatedItem> values) {
        if (values != null) {
            this.getRelatedItem().addAll(values);
        }
        return this;
    }

    public Procedure withNotes(String value) {
        this.setNotes(value);
        return this;
    }

    public Procedure withDevice(ProcedureDevice ... values) {
        if (values != null) {
            for (ProcedureDevice value : values) {
                this.getDevice().add(value);
            }
        }
        return this;
    }

    public Procedure withDevice(Collection<ProcedureDevice> values) {
        if (values != null) {
            this.getDevice().addAll(values);
        }
        return this;
    }

    public Procedure withUsed(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getUsed().add(value);
            }
        }
        return this;
    }

    public Procedure withUsed(Collection<Reference> values) {
        if (values != null) {
            this.getUsed().addAll(values);
        }
        return this;
    }

    @Override
    public Procedure withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Procedure withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Procedure withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Procedure withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Procedure withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Procedure withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Procedure withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Procedure withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Procedure withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Procedure withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Procedure withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Reference> rhsUsed;
        List<ProcedureDevice> rhsDevice;
        List<ProcedureRelatedItem> rhsRelatedItem;
        List<CodeableConcept> rhsFollowUp;
        List<CodeableConcept> rhsComplication;
        List<Reference> rhsReport;
        List<ProcedurePerformer> rhsPerformer;
        List<CodeableConcept> rhsIndication;
        List<ProcedureBodySite> rhsBodySite;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof Procedure)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Procedure that = (Procedure)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        ProcedureStatus lhsStatus = this.getStatus();
        ProcedureStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        CodeableConcept lhsCategory = this.getCategory();
        CodeableConcept rhsCategory = that.getCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"category", (Object)lhsCategory), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"category", (Object)rhsCategory), (Object)lhsCategory, (Object)rhsCategory)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        List<ProcedureBodySite> lhsBodySite = this.bodySite != null && !this.bodySite.isEmpty() ? this.getBodySite() : null;
        List<ProcedureBodySite> list2 = rhsBodySite = that.bodySite != null && !that.bodySite.isEmpty() ? that.getBodySite() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"bodySite", lhsBodySite), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"bodySite", rhsBodySite), lhsBodySite, rhsBodySite)) {
            return false;
        }
        List<CodeableConcept> lhsIndication = this.indication != null && !this.indication.isEmpty() ? this.getIndication() : null;
        List<CodeableConcept> list3 = rhsIndication = that.indication != null && !that.indication.isEmpty() ? that.getIndication() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"indication", lhsIndication), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"indication", rhsIndication), lhsIndication, rhsIndication)) {
            return false;
        }
        List<ProcedurePerformer> lhsPerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        List<ProcedurePerformer> list4 = rhsPerformer = that.performer != null && !that.performer.isEmpty() ? that.getPerformer() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"performer", lhsPerformer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"performer", rhsPerformer), lhsPerformer, rhsPerformer)) {
            return false;
        }
        DateTime lhsPerformedDateTime = this.getPerformedDateTime();
        DateTime rhsPerformedDateTime = that.getPerformedDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"performedDateTime", (Object)lhsPerformedDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"performedDateTime", (Object)rhsPerformedDateTime), (Object)lhsPerformedDateTime, (Object)rhsPerformedDateTime)) {
            return false;
        }
        Period lhsPerformedPeriod = this.getPerformedPeriod();
        Period rhsPerformedPeriod = that.getPerformedPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"performedPeriod", (Object)lhsPerformedPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"performedPeriod", (Object)rhsPerformedPeriod), (Object)lhsPerformedPeriod, (Object)rhsPerformedPeriod)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter)) {
            return false;
        }
        Reference lhsLocation = this.getLocation();
        Reference rhsLocation = that.getLocation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"location", (Object)lhsLocation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"location", (Object)rhsLocation), (Object)lhsLocation, (Object)rhsLocation)) {
            return false;
        }
        CodeableConcept lhsOutcome = this.getOutcome();
        CodeableConcept rhsOutcome = that.getOutcome();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"outcome", (Object)lhsOutcome), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"outcome", (Object)rhsOutcome), (Object)lhsOutcome, (Object)rhsOutcome)) {
            return false;
        }
        List<Reference> lhsReport = this.report != null && !this.report.isEmpty() ? this.getReport() : null;
        List<Reference> list5 = rhsReport = that.report != null && !that.report.isEmpty() ? that.getReport() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"report", lhsReport), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"report", rhsReport), lhsReport, rhsReport)) {
            return false;
        }
        List<CodeableConcept> lhsComplication = this.complication != null && !this.complication.isEmpty() ? this.getComplication() : null;
        List<CodeableConcept> list6 = rhsComplication = that.complication != null && !that.complication.isEmpty() ? that.getComplication() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"complication", lhsComplication), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"complication", rhsComplication), lhsComplication, rhsComplication)) {
            return false;
        }
        List<CodeableConcept> lhsFollowUp = this.followUp != null && !this.followUp.isEmpty() ? this.getFollowUp() : null;
        List<CodeableConcept> list7 = rhsFollowUp = that.followUp != null && !that.followUp.isEmpty() ? that.getFollowUp() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"followUp", lhsFollowUp), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"followUp", rhsFollowUp), lhsFollowUp, rhsFollowUp)) {
            return false;
        }
        List<ProcedureRelatedItem> lhsRelatedItem = this.relatedItem != null && !this.relatedItem.isEmpty() ? this.getRelatedItem() : null;
        List<ProcedureRelatedItem> list8 = rhsRelatedItem = that.relatedItem != null && !that.relatedItem.isEmpty() ? that.getRelatedItem() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"relatedItem", lhsRelatedItem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"relatedItem", rhsRelatedItem), lhsRelatedItem, rhsRelatedItem)) {
            return false;
        }
        String lhsNotes = this.getNotes();
        String rhsNotes = that.getNotes();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"notes", (Object)lhsNotes), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"notes", (Object)rhsNotes), (Object)lhsNotes, (Object)rhsNotes)) {
            return false;
        }
        List<ProcedureDevice> lhsDevice = this.device != null && !this.device.isEmpty() ? this.getDevice() : null;
        List<ProcedureDevice> list9 = rhsDevice = that.device != null && !that.device.isEmpty() ? that.getDevice() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"device", lhsDevice), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"device", rhsDevice), lhsDevice, rhsDevice)) {
            return false;
        }
        List<Reference> lhsUsed = this.used != null && !this.used.isEmpty() ? this.getUsed() : null;
        List<Reference> list10 = rhsUsed = that.used != null && !that.used.isEmpty() ? that.getUsed() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"used", lhsUsed), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"used", rhsUsed), lhsUsed, rhsUsed);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        ProcedureStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        CodeableConcept theCategory = this.getCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"category", (Object)theCategory), currentHashCode, (Object)theCategory);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType);
        List<ProcedureBodySite> theBodySite = this.bodySite != null && !this.bodySite.isEmpty() ? this.getBodySite() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"bodySite", theBodySite), currentHashCode, theBodySite);
        List<CodeableConcept> theIndication = this.indication != null && !this.indication.isEmpty() ? this.getIndication() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"indication", theIndication), currentHashCode, theIndication);
        List<ProcedurePerformer> thePerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"performer", thePerformer), currentHashCode, thePerformer);
        DateTime thePerformedDateTime = this.getPerformedDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"performedDateTime", (Object)thePerformedDateTime), currentHashCode, (Object)thePerformedDateTime);
        Period thePerformedPeriod = this.getPerformedPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"performedPeriod", (Object)thePerformedPeriod), currentHashCode, (Object)thePerformedPeriod);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter);
        Reference theLocation = this.getLocation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"location", (Object)theLocation), currentHashCode, (Object)theLocation);
        CodeableConcept theOutcome = this.getOutcome();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"outcome", (Object)theOutcome), currentHashCode, (Object)theOutcome);
        List<Reference> theReport = this.report != null && !this.report.isEmpty() ? this.getReport() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"report", theReport), currentHashCode, theReport);
        List<CodeableConcept> theComplication = this.complication != null && !this.complication.isEmpty() ? this.getComplication() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"complication", theComplication), currentHashCode, theComplication);
        List<CodeableConcept> theFollowUp = this.followUp != null && !this.followUp.isEmpty() ? this.getFollowUp() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"followUp", theFollowUp), currentHashCode, theFollowUp);
        List<ProcedureRelatedItem> theRelatedItem = this.relatedItem != null && !this.relatedItem.isEmpty() ? this.getRelatedItem() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"relatedItem", theRelatedItem), currentHashCode, theRelatedItem);
        String theNotes = this.getNotes();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"notes", (Object)theNotes), currentHashCode, (Object)theNotes);
        List<ProcedureDevice> theDevice = this.device != null && !this.device.isEmpty() ? this.getDevice() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"device", theDevice), currentHashCode, theDevice);
        List<Reference> theUsed = this.used != null && !this.used.isEmpty() ? this.getUsed() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"used", theUsed), currentHashCode, theUsed);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        ProcedureStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        CodeableConcept theCategory = this.getCategory();
        strategy.appendField(locator, (Object)this, "category", buffer, (Object)theCategory);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        List<ProcedureBodySite> theBodySite = this.bodySite != null && !this.bodySite.isEmpty() ? this.getBodySite() : null;
        strategy.appendField(locator, (Object)this, "bodySite", buffer, theBodySite);
        List<CodeableConcept> theIndication = this.indication != null && !this.indication.isEmpty() ? this.getIndication() : null;
        strategy.appendField(locator, (Object)this, "indication", buffer, theIndication);
        List<ProcedurePerformer> thePerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        strategy.appendField(locator, (Object)this, "performer", buffer, thePerformer);
        DateTime thePerformedDateTime = this.getPerformedDateTime();
        strategy.appendField(locator, (Object)this, "performedDateTime", buffer, (Object)thePerformedDateTime);
        Period thePerformedPeriod = this.getPerformedPeriod();
        strategy.appendField(locator, (Object)this, "performedPeriod", buffer, (Object)thePerformedPeriod);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter);
        Reference theLocation = this.getLocation();
        strategy.appendField(locator, (Object)this, "location", buffer, (Object)theLocation);
        CodeableConcept theOutcome = this.getOutcome();
        strategy.appendField(locator, (Object)this, "outcome", buffer, (Object)theOutcome);
        List<Reference> theReport = this.report != null && !this.report.isEmpty() ? this.getReport() : null;
        strategy.appendField(locator, (Object)this, "report", buffer, theReport);
        List<CodeableConcept> theComplication = this.complication != null && !this.complication.isEmpty() ? this.getComplication() : null;
        strategy.appendField(locator, (Object)this, "complication", buffer, theComplication);
        List<CodeableConcept> theFollowUp = this.followUp != null && !this.followUp.isEmpty() ? this.getFollowUp() : null;
        strategy.appendField(locator, (Object)this, "followUp", buffer, theFollowUp);
        List<ProcedureRelatedItem> theRelatedItem = this.relatedItem != null && !this.relatedItem.isEmpty() ? this.getRelatedItem() : null;
        strategy.appendField(locator, (Object)this, "relatedItem", buffer, theRelatedItem);
        String theNotes = this.getNotes();
        strategy.appendField(locator, (Object)this, "notes", buffer, (Object)theNotes);
        List<ProcedureDevice> theDevice = this.device != null && !this.device.isEmpty() ? this.getDevice() : null;
        strategy.appendField(locator, (Object)this, "device", buffer, theDevice);
        List<Reference> theUsed = this.used != null && !this.used.isEmpty() ? this.getUsed() : null;
        strategy.appendField(locator, (Object)this, "used", buffer, theUsed);
        return buffer;
    }
}

