/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.ProcedureRequestBodySite;
import org.hl7.fhir.ProcedureRequestPriority;
import org.hl7.fhir.ProcedureRequestStatus;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Timing;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ProcedureRequest", propOrder={"identifier", "subject", "type", "bodySite", "indication", "timingDateTime", "timingPeriod", "timingTiming", "encounter", "performer", "status", "notes", "asNeededBoolean", "asNeededCodeableConcept", "orderedOn", "orderer", "priority"})
public class ProcedureRequest
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected Reference subject;
    @XmlElement(required=true)
    protected CodeableConcept type;
    protected List<ProcedureRequestBodySite> bodySite;
    protected List<CodeableConcept> indication;
    protected DateTime timingDateTime;
    protected Period timingPeriod;
    protected Timing timingTiming;
    protected Reference encounter;
    protected Reference performer;
    protected ProcedureRequestStatus status;
    protected List<String> notes;
    protected Boolean asNeededBoolean;
    protected CodeableConcept asNeededCodeableConcept;
    protected DateTime orderedOn;
    protected Reference orderer;
    protected ProcedureRequestPriority priority;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public List<ProcedureRequestBodySite> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<ProcedureRequestBodySite>();
        }
        return this.bodySite;
    }

    public List<CodeableConcept> getIndication() {
        if (this.indication == null) {
            this.indication = new ArrayList<CodeableConcept>();
        }
        return this.indication;
    }

    public DateTime getTimingDateTime() {
        return this.timingDateTime;
    }

    public void setTimingDateTime(DateTime value) {
        this.timingDateTime = value;
    }

    public Period getTimingPeriod() {
        return this.timingPeriod;
    }

    public void setTimingPeriod(Period value) {
        this.timingPeriod = value;
    }

    public Timing getTimingTiming() {
        return this.timingTiming;
    }

    public void setTimingTiming(Timing value) {
        this.timingTiming = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public Reference getPerformer() {
        return this.performer;
    }

    public void setPerformer(Reference value) {
        this.performer = value;
    }

    public ProcedureRequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProcedureRequestStatus value) {
        this.status = value;
    }

    public List<String> getNotes() {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        return this.notes;
    }

    public Boolean getAsNeededBoolean() {
        return this.asNeededBoolean;
    }

    public void setAsNeededBoolean(Boolean value) {
        this.asNeededBoolean = value;
    }

    public CodeableConcept getAsNeededCodeableConcept() {
        return this.asNeededCodeableConcept;
    }

    public void setAsNeededCodeableConcept(CodeableConcept value) {
        this.asNeededCodeableConcept = value;
    }

    public DateTime getOrderedOn() {
        return this.orderedOn;
    }

    public void setOrderedOn(DateTime value) {
        this.orderedOn = value;
    }

    public Reference getOrderer() {
        return this.orderer;
    }

    public void setOrderer(Reference value) {
        this.orderer = value;
    }

    public ProcedureRequestPriority getPriority() {
        return this.priority;
    }

    public void setPriority(ProcedureRequestPriority value) {
        this.priority = value;
    }

    public ProcedureRequest withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public ProcedureRequest withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public ProcedureRequest withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public ProcedureRequest withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public ProcedureRequest withBodySite(ProcedureRequestBodySite ... values) {
        if (values != null) {
            for (ProcedureRequestBodySite value : values) {
                this.getBodySite().add(value);
            }
        }
        return this;
    }

    public ProcedureRequest withBodySite(Collection<ProcedureRequestBodySite> values) {
        if (values != null) {
            this.getBodySite().addAll(values);
        }
        return this;
    }

    public ProcedureRequest withIndication(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getIndication().add(value);
            }
        }
        return this;
    }

    public ProcedureRequest withIndication(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getIndication().addAll(values);
        }
        return this;
    }

    public ProcedureRequest withTimingDateTime(DateTime value) {
        this.setTimingDateTime(value);
        return this;
    }

    public ProcedureRequest withTimingPeriod(Period value) {
        this.setTimingPeriod(value);
        return this;
    }

    public ProcedureRequest withTimingTiming(Timing value) {
        this.setTimingTiming(value);
        return this;
    }

    public ProcedureRequest withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public ProcedureRequest withPerformer(Reference value) {
        this.setPerformer(value);
        return this;
    }

    public ProcedureRequest withStatus(ProcedureRequestStatus value) {
        this.setStatus(value);
        return this;
    }

    public ProcedureRequest withNotes(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getNotes().add(value);
            }
        }
        return this;
    }

    public ProcedureRequest withNotes(Collection<String> values) {
        if (values != null) {
            this.getNotes().addAll(values);
        }
        return this;
    }

    public ProcedureRequest withAsNeededBoolean(Boolean value) {
        this.setAsNeededBoolean(value);
        return this;
    }

    public ProcedureRequest withAsNeededCodeableConcept(CodeableConcept value) {
        this.setAsNeededCodeableConcept(value);
        return this;
    }

    public ProcedureRequest withOrderedOn(DateTime value) {
        this.setOrderedOn(value);
        return this;
    }

    public ProcedureRequest withOrderer(Reference value) {
        this.setOrderer(value);
        return this;
    }

    public ProcedureRequest withPriority(ProcedureRequestPriority value) {
        this.setPriority(value);
        return this;
    }

    @Override
    public ProcedureRequest withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public ProcedureRequest withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public ProcedureRequest withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public ProcedureRequest withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ProcedureRequest withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ProcedureRequest withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ProcedureRequest withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ProcedureRequest withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public ProcedureRequest withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public ProcedureRequest withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public ProcedureRequest withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<String> rhsNotes;
        List<CodeableConcept> rhsIndication;
        List<ProcedureRequestBodySite> rhsBodySite;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof ProcedureRequest)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ProcedureRequest that = (ProcedureRequest)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        List<ProcedureRequestBodySite> lhsBodySite = this.bodySite != null && !this.bodySite.isEmpty() ? this.getBodySite() : null;
        List<ProcedureRequestBodySite> list2 = rhsBodySite = that.bodySite != null && !that.bodySite.isEmpty() ? that.getBodySite() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"bodySite", lhsBodySite), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"bodySite", rhsBodySite), lhsBodySite, rhsBodySite)) {
            return false;
        }
        List<CodeableConcept> lhsIndication = this.indication != null && !this.indication.isEmpty() ? this.getIndication() : null;
        List<CodeableConcept> list3 = rhsIndication = that.indication != null && !that.indication.isEmpty() ? that.getIndication() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"indication", lhsIndication), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"indication", rhsIndication), lhsIndication, rhsIndication)) {
            return false;
        }
        DateTime lhsTimingDateTime = this.getTimingDateTime();
        DateTime rhsTimingDateTime = that.getTimingDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"timingDateTime", (Object)lhsTimingDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"timingDateTime", (Object)rhsTimingDateTime), (Object)lhsTimingDateTime, (Object)rhsTimingDateTime)) {
            return false;
        }
        Period lhsTimingPeriod = this.getTimingPeriod();
        Period rhsTimingPeriod = that.getTimingPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"timingPeriod", (Object)lhsTimingPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"timingPeriod", (Object)rhsTimingPeriod), (Object)lhsTimingPeriod, (Object)rhsTimingPeriod)) {
            return false;
        }
        Timing lhsTimingTiming = this.getTimingTiming();
        Timing rhsTimingTiming = that.getTimingTiming();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"timingTiming", (Object)lhsTimingTiming), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"timingTiming", (Object)rhsTimingTiming), (Object)lhsTimingTiming, (Object)rhsTimingTiming)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter)) {
            return false;
        }
        Reference lhsPerformer = this.getPerformer();
        Reference rhsPerformer = that.getPerformer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"performer", (Object)lhsPerformer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"performer", (Object)rhsPerformer), (Object)lhsPerformer, (Object)rhsPerformer)) {
            return false;
        }
        ProcedureRequestStatus lhsStatus = this.getStatus();
        ProcedureRequestStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        List<String> lhsNotes = this.notes != null && !this.notes.isEmpty() ? this.getNotes() : null;
        List<String> list4 = rhsNotes = that.notes != null && !that.notes.isEmpty() ? that.getNotes() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"notes", lhsNotes), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"notes", rhsNotes), lhsNotes, rhsNotes)) {
            return false;
        }
        Boolean lhsAsNeededBoolean = this.getAsNeededBoolean();
        Boolean rhsAsNeededBoolean = that.getAsNeededBoolean();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"asNeededBoolean", (Object)lhsAsNeededBoolean), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"asNeededBoolean", (Object)rhsAsNeededBoolean), (Object)lhsAsNeededBoolean, (Object)rhsAsNeededBoolean)) {
            return false;
        }
        CodeableConcept lhsAsNeededCodeableConcept = this.getAsNeededCodeableConcept();
        CodeableConcept rhsAsNeededCodeableConcept = that.getAsNeededCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"asNeededCodeableConcept", (Object)lhsAsNeededCodeableConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"asNeededCodeableConcept", (Object)rhsAsNeededCodeableConcept), (Object)lhsAsNeededCodeableConcept, (Object)rhsAsNeededCodeableConcept)) {
            return false;
        }
        DateTime lhsOrderedOn = this.getOrderedOn();
        DateTime rhsOrderedOn = that.getOrderedOn();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"orderedOn", (Object)lhsOrderedOn), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"orderedOn", (Object)rhsOrderedOn), (Object)lhsOrderedOn, (Object)rhsOrderedOn)) {
            return false;
        }
        Reference lhsOrderer = this.getOrderer();
        Reference rhsOrderer = that.getOrderer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"orderer", (Object)lhsOrderer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"orderer", (Object)rhsOrderer), (Object)lhsOrderer, (Object)rhsOrderer)) {
            return false;
        }
        ProcedureRequestPriority lhsPriority = this.getPriority();
        ProcedureRequestPriority rhsPriority = that.getPriority();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"priority", (Object)lhsPriority), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"priority", (Object)rhsPriority), (Object)lhsPriority, (Object)rhsPriority);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType);
        List<ProcedureRequestBodySite> theBodySite = this.bodySite != null && !this.bodySite.isEmpty() ? this.getBodySite() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"bodySite", theBodySite), currentHashCode, theBodySite);
        List<CodeableConcept> theIndication = this.indication != null && !this.indication.isEmpty() ? this.getIndication() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"indication", theIndication), currentHashCode, theIndication);
        DateTime theTimingDateTime = this.getTimingDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"timingDateTime", (Object)theTimingDateTime), currentHashCode, (Object)theTimingDateTime);
        Period theTimingPeriod = this.getTimingPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"timingPeriod", (Object)theTimingPeriod), currentHashCode, (Object)theTimingPeriod);
        Timing theTimingTiming = this.getTimingTiming();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"timingTiming", (Object)theTimingTiming), currentHashCode, (Object)theTimingTiming);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter);
        Reference thePerformer = this.getPerformer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"performer", (Object)thePerformer), currentHashCode, (Object)thePerformer);
        ProcedureRequestStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        List<String> theNotes = this.notes != null && !this.notes.isEmpty() ? this.getNotes() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"notes", theNotes), currentHashCode, theNotes);
        Boolean theAsNeededBoolean = this.getAsNeededBoolean();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"asNeededBoolean", (Object)theAsNeededBoolean), currentHashCode, (Object)theAsNeededBoolean);
        CodeableConcept theAsNeededCodeableConcept = this.getAsNeededCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"asNeededCodeableConcept", (Object)theAsNeededCodeableConcept), currentHashCode, (Object)theAsNeededCodeableConcept);
        DateTime theOrderedOn = this.getOrderedOn();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"orderedOn", (Object)theOrderedOn), currentHashCode, (Object)theOrderedOn);
        Reference theOrderer = this.getOrderer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"orderer", (Object)theOrderer), currentHashCode, (Object)theOrderer);
        ProcedureRequestPriority thePriority = this.getPriority();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"priority", (Object)thePriority), currentHashCode, (Object)thePriority);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        List<ProcedureRequestBodySite> theBodySite = this.bodySite != null && !this.bodySite.isEmpty() ? this.getBodySite() : null;
        strategy.appendField(locator, (Object)this, "bodySite", buffer, theBodySite);
        List<CodeableConcept> theIndication = this.indication != null && !this.indication.isEmpty() ? this.getIndication() : null;
        strategy.appendField(locator, (Object)this, "indication", buffer, theIndication);
        DateTime theTimingDateTime = this.getTimingDateTime();
        strategy.appendField(locator, (Object)this, "timingDateTime", buffer, (Object)theTimingDateTime);
        Period theTimingPeriod = this.getTimingPeriod();
        strategy.appendField(locator, (Object)this, "timingPeriod", buffer, (Object)theTimingPeriod);
        Timing theTimingTiming = this.getTimingTiming();
        strategy.appendField(locator, (Object)this, "timingTiming", buffer, (Object)theTimingTiming);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter);
        Reference thePerformer = this.getPerformer();
        strategy.appendField(locator, (Object)this, "performer", buffer, (Object)thePerformer);
        ProcedureRequestStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        List<String> theNotes = this.notes != null && !this.notes.isEmpty() ? this.getNotes() : null;
        strategy.appendField(locator, (Object)this, "notes", buffer, theNotes);
        Boolean theAsNeededBoolean = this.getAsNeededBoolean();
        strategy.appendField(locator, (Object)this, "asNeededBoolean", buffer, (Object)theAsNeededBoolean);
        CodeableConcept theAsNeededCodeableConcept = this.getAsNeededCodeableConcept();
        strategy.appendField(locator, (Object)this, "asNeededCodeableConcept", buffer, (Object)theAsNeededCodeableConcept);
        DateTime theOrderedOn = this.getOrderedOn();
        strategy.appendField(locator, (Object)this, "orderedOn", buffer, (Object)theOrderedOn);
        Reference theOrderer = this.getOrderer();
        strategy.appendField(locator, (Object)this, "orderer", buffer, (Object)theOrderer);
        ProcedureRequestPriority thePriority = this.getPriority();
        strategy.appendField(locator, (Object)this, "priority", buffer, (Object)thePriority);
        return buffer;
    }
}

