/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.ActionList;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.ProcessRequestItem;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ProcessRequest", propOrder={"action", "identifier", "ruleset", "originalRuleset", "created", "target", "provider", "organization", "request", "response", "nullify", "reference", "item", "include", "exclude", "period"})
public class ProcessRequest
extends DomainResource
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected ActionList action;
    protected List<Identifier> identifier;
    protected Coding ruleset;
    protected Coding originalRuleset;
    protected DateTime created;
    protected Reference target;
    protected Reference provider;
    protected Reference organization;
    protected Reference request;
    protected Reference response;
    protected Boolean nullify;
    protected String reference;
    protected List<ProcessRequestItem> item;
    protected List<String> include;
    protected List<String> exclude;
    protected Period period;

    public ActionList getAction() {
        return this.action;
    }

    public void setAction(ActionList value) {
        this.action = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Coding getRuleset() {
        return this.ruleset;
    }

    public void setRuleset(Coding value) {
        this.ruleset = value;
    }

    public Coding getOriginalRuleset() {
        return this.originalRuleset;
    }

    public void setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime value) {
        this.created = value;
    }

    public Reference getTarget() {
        return this.target;
    }

    public void setTarget(Reference value) {
        this.target = value;
    }

    public Reference getProvider() {
        return this.provider;
    }

    public void setProvider(Reference value) {
        this.provider = value;
    }

    public Reference getOrganization() {
        return this.organization;
    }

    public void setOrganization(Reference value) {
        this.organization = value;
    }

    public Reference getRequest() {
        return this.request;
    }

    public void setRequest(Reference value) {
        this.request = value;
    }

    public Reference getResponse() {
        return this.response;
    }

    public void setResponse(Reference value) {
        this.response = value;
    }

    public Boolean getNullify() {
        return this.nullify;
    }

    public void setNullify(Boolean value) {
        this.nullify = value;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String value) {
        this.reference = value;
    }

    public List<ProcessRequestItem> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<ProcessRequestItem>();
        }
        return this.item;
    }

    public List<String> getInclude() {
        if (this.include == null) {
            this.include = new ArrayList<String>();
        }
        return this.include;
    }

    public List<String> getExclude() {
        if (this.exclude == null) {
            this.exclude = new ArrayList<String>();
        }
        return this.exclude;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period value) {
        this.period = value;
    }

    public ProcessRequest withAction(ActionList value) {
        this.setAction(value);
        return this;
    }

    public ProcessRequest withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public ProcessRequest withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public ProcessRequest withRuleset(Coding value) {
        this.setRuleset(value);
        return this;
    }

    public ProcessRequest withOriginalRuleset(Coding value) {
        this.setOriginalRuleset(value);
        return this;
    }

    public ProcessRequest withCreated(DateTime value) {
        this.setCreated(value);
        return this;
    }

    public ProcessRequest withTarget(Reference value) {
        this.setTarget(value);
        return this;
    }

    public ProcessRequest withProvider(Reference value) {
        this.setProvider(value);
        return this;
    }

    public ProcessRequest withOrganization(Reference value) {
        this.setOrganization(value);
        return this;
    }

    public ProcessRequest withRequest(Reference value) {
        this.setRequest(value);
        return this;
    }

    public ProcessRequest withResponse(Reference value) {
        this.setResponse(value);
        return this;
    }

    public ProcessRequest withNullify(Boolean value) {
        this.setNullify(value);
        return this;
    }

    public ProcessRequest withReference(String value) {
        this.setReference(value);
        return this;
    }

    public ProcessRequest withItem(ProcessRequestItem ... values) {
        if (values != null) {
            for (ProcessRequestItem value : values) {
                this.getItem().add(value);
            }
        }
        return this;
    }

    public ProcessRequest withItem(Collection<ProcessRequestItem> values) {
        if (values != null) {
            this.getItem().addAll(values);
        }
        return this;
    }

    public ProcessRequest withInclude(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getInclude().add(value);
            }
        }
        return this;
    }

    public ProcessRequest withInclude(Collection<String> values) {
        if (values != null) {
            this.getInclude().addAll(values);
        }
        return this;
    }

    public ProcessRequest withExclude(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getExclude().add(value);
            }
        }
        return this;
    }

    public ProcessRequest withExclude(Collection<String> values) {
        if (values != null) {
            this.getExclude().addAll(values);
        }
        return this;
    }

    public ProcessRequest withPeriod(Period value) {
        this.setPeriod(value);
        return this;
    }

    @Override
    public ProcessRequest withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public ProcessRequest withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public ProcessRequest withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public ProcessRequest withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ProcessRequest withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ProcessRequest withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ProcessRequest withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ProcessRequest withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public ProcessRequest withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public ProcessRequest withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public ProcessRequest withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<String> rhsExclude;
        List<String> rhsInclude;
        List<ProcessRequestItem> rhsItem;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof ProcessRequest)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ProcessRequest that = (ProcessRequest)object;
        ActionList lhsAction = this.getAction();
        ActionList rhsAction = that.getAction();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"action", (Object)lhsAction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"action", (Object)rhsAction), (Object)lhsAction, (Object)rhsAction)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        Coding lhsRuleset = this.getRuleset();
        Coding rhsRuleset = that.getRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"ruleset", (Object)lhsRuleset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"ruleset", (Object)rhsRuleset), (Object)lhsRuleset, (Object)rhsRuleset)) {
            return false;
        }
        Coding lhsOriginalRuleset = this.getOriginalRuleset();
        Coding rhsOriginalRuleset = that.getOriginalRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"originalRuleset", (Object)lhsOriginalRuleset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"originalRuleset", (Object)rhsOriginalRuleset), (Object)lhsOriginalRuleset, (Object)rhsOriginalRuleset)) {
            return false;
        }
        DateTime lhsCreated = this.getCreated();
        DateTime rhsCreated = that.getCreated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"created", (Object)lhsCreated), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"created", (Object)rhsCreated), (Object)lhsCreated, (Object)rhsCreated)) {
            return false;
        }
        Reference lhsTarget = this.getTarget();
        Reference rhsTarget = that.getTarget();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"target", (Object)lhsTarget), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"target", (Object)rhsTarget), (Object)lhsTarget, (Object)rhsTarget)) {
            return false;
        }
        Reference lhsProvider = this.getProvider();
        Reference rhsProvider = that.getProvider();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"provider", (Object)lhsProvider), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"provider", (Object)rhsProvider), (Object)lhsProvider, (Object)rhsProvider)) {
            return false;
        }
        Reference lhsOrganization = this.getOrganization();
        Reference rhsOrganization = that.getOrganization();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"organization", (Object)lhsOrganization), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"organization", (Object)rhsOrganization), (Object)lhsOrganization, (Object)rhsOrganization)) {
            return false;
        }
        Reference lhsRequest = this.getRequest();
        Reference rhsRequest = that.getRequest();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"request", (Object)lhsRequest), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"request", (Object)rhsRequest), (Object)lhsRequest, (Object)rhsRequest)) {
            return false;
        }
        Reference lhsResponse = this.getResponse();
        Reference rhsResponse = that.getResponse();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"response", (Object)lhsResponse), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"response", (Object)rhsResponse), (Object)lhsResponse, (Object)rhsResponse)) {
            return false;
        }
        Boolean lhsNullify = this.getNullify();
        Boolean rhsNullify = that.getNullify();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"nullify", (Object)lhsNullify), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"nullify", (Object)rhsNullify), (Object)lhsNullify, (Object)rhsNullify)) {
            return false;
        }
        String lhsReference = this.getReference();
        String rhsReference = that.getReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reference", (Object)lhsReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reference", (Object)rhsReference), (Object)lhsReference, (Object)rhsReference)) {
            return false;
        }
        List<ProcessRequestItem> lhsItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        List<ProcessRequestItem> list2 = rhsItem = that.item != null && !that.item.isEmpty() ? that.getItem() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"item", lhsItem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"item", rhsItem), lhsItem, rhsItem)) {
            return false;
        }
        List<String> lhsInclude = this.include != null && !this.include.isEmpty() ? this.getInclude() : null;
        List<String> list3 = rhsInclude = that.include != null && !that.include.isEmpty() ? that.getInclude() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"include", lhsInclude), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"include", rhsInclude), lhsInclude, rhsInclude)) {
            return false;
        }
        List<String> lhsExclude = this.exclude != null && !this.exclude.isEmpty() ? this.getExclude() : null;
        List<String> list4 = rhsExclude = that.exclude != null && !that.exclude.isEmpty() ? that.getExclude() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"exclude", lhsExclude), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"exclude", rhsExclude), lhsExclude, rhsExclude)) {
            return false;
        }
        Period lhsPeriod = this.getPeriod();
        Period rhsPeriod = that.getPeriod();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"period", (Object)lhsPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"period", (Object)rhsPeriod), (Object)lhsPeriod, (Object)rhsPeriod);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        ActionList theAction = this.getAction();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"action", (Object)theAction), currentHashCode, (Object)theAction);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        Coding theRuleset = this.getRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"ruleset", (Object)theRuleset), currentHashCode, (Object)theRuleset);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"originalRuleset", (Object)theOriginalRuleset), currentHashCode, (Object)theOriginalRuleset);
        DateTime theCreated = this.getCreated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"created", (Object)theCreated), currentHashCode, (Object)theCreated);
        Reference theTarget = this.getTarget();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"target", (Object)theTarget), currentHashCode, (Object)theTarget);
        Reference theProvider = this.getProvider();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"provider", (Object)theProvider), currentHashCode, (Object)theProvider);
        Reference theOrganization = this.getOrganization();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"organization", (Object)theOrganization), currentHashCode, (Object)theOrganization);
        Reference theRequest = this.getRequest();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"request", (Object)theRequest), currentHashCode, (Object)theRequest);
        Reference theResponse = this.getResponse();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"response", (Object)theResponse), currentHashCode, (Object)theResponse);
        Boolean theNullify = this.getNullify();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"nullify", (Object)theNullify), currentHashCode, (Object)theNullify);
        String theReference = this.getReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reference", (Object)theReference), currentHashCode, (Object)theReference);
        List<ProcessRequestItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"item", theItem), currentHashCode, theItem);
        List<String> theInclude = this.include != null && !this.include.isEmpty() ? this.getInclude() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"include", theInclude), currentHashCode, theInclude);
        List<String> theExclude = this.exclude != null && !this.exclude.isEmpty() ? this.getExclude() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"exclude", theExclude), currentHashCode, theExclude);
        Period thePeriod = this.getPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"period", (Object)thePeriod), currentHashCode, (Object)thePeriod);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        ActionList theAction = this.getAction();
        strategy.appendField(locator, (Object)this, "action", buffer, (Object)theAction);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        Coding theRuleset = this.getRuleset();
        strategy.appendField(locator, (Object)this, "ruleset", buffer, (Object)theRuleset);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        strategy.appendField(locator, (Object)this, "originalRuleset", buffer, (Object)theOriginalRuleset);
        DateTime theCreated = this.getCreated();
        strategy.appendField(locator, (Object)this, "created", buffer, (Object)theCreated);
        Reference theTarget = this.getTarget();
        strategy.appendField(locator, (Object)this, "target", buffer, (Object)theTarget);
        Reference theProvider = this.getProvider();
        strategy.appendField(locator, (Object)this, "provider", buffer, (Object)theProvider);
        Reference theOrganization = this.getOrganization();
        strategy.appendField(locator, (Object)this, "organization", buffer, (Object)theOrganization);
        Reference theRequest = this.getRequest();
        strategy.appendField(locator, (Object)this, "request", buffer, (Object)theRequest);
        Reference theResponse = this.getResponse();
        strategy.appendField(locator, (Object)this, "response", buffer, (Object)theResponse);
        Boolean theNullify = this.getNullify();
        strategy.appendField(locator, (Object)this, "nullify", buffer, (Object)theNullify);
        String theReference = this.getReference();
        strategy.appendField(locator, (Object)this, "reference", buffer, (Object)theReference);
        List<ProcessRequestItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        strategy.appendField(locator, (Object)this, "item", buffer, theItem);
        List<String> theInclude = this.include != null && !this.include.isEmpty() ? this.getInclude() : null;
        strategy.appendField(locator, (Object)this, "include", buffer, theInclude);
        List<String> theExclude = this.exclude != null && !this.exclude.isEmpty() ? this.getExclude() : null;
        strategy.appendField(locator, (Object)this, "exclude", buffer, theExclude);
        Period thePeriod = this.getPeriod();
        strategy.appendField(locator, (Object)this, "period", buffer, (Object)thePeriod);
        return buffer;
    }
}

