/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ProcessResponseNotes;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ProcessResponse", propOrder={"identifier", "request", "outcome", "disposition", "ruleset", "originalRuleset", "created", "organization", "requestProvider", "requestOrganization", "form", "notes", "error"})
public class ProcessResponse
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    protected Reference request;
    protected Coding outcome;
    protected String disposition;
    protected Coding ruleset;
    protected Coding originalRuleset;
    protected DateTime created;
    protected Reference organization;
    protected Reference requestProvider;
    protected Reference requestOrganization;
    protected Coding form;
    protected List<ProcessResponseNotes> notes;
    protected List<Coding> error;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getRequest() {
        return this.request;
    }

    public void setRequest(Reference value) {
        this.request = value;
    }

    public Coding getOutcome() {
        return this.outcome;
    }

    public void setOutcome(Coding value) {
        this.outcome = value;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public void setDisposition(String value) {
        this.disposition = value;
    }

    public Coding getRuleset() {
        return this.ruleset;
    }

    public void setRuleset(Coding value) {
        this.ruleset = value;
    }

    public Coding getOriginalRuleset() {
        return this.originalRuleset;
    }

    public void setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime value) {
        this.created = value;
    }

    public Reference getOrganization() {
        return this.organization;
    }

    public void setOrganization(Reference value) {
        this.organization = value;
    }

    public Reference getRequestProvider() {
        return this.requestProvider;
    }

    public void setRequestProvider(Reference value) {
        this.requestProvider = value;
    }

    public Reference getRequestOrganization() {
        return this.requestOrganization;
    }

    public void setRequestOrganization(Reference value) {
        this.requestOrganization = value;
    }

    public Coding getForm() {
        return this.form;
    }

    public void setForm(Coding value) {
        this.form = value;
    }

    public List<ProcessResponseNotes> getNotes() {
        if (this.notes == null) {
            this.notes = new ArrayList<ProcessResponseNotes>();
        }
        return this.notes;
    }

    public List<Coding> getError() {
        if (this.error == null) {
            this.error = new ArrayList<Coding>();
        }
        return this.error;
    }

    public ProcessResponse withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public ProcessResponse withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public ProcessResponse withRequest(Reference value) {
        this.setRequest(value);
        return this;
    }

    public ProcessResponse withOutcome(Coding value) {
        this.setOutcome(value);
        return this;
    }

    public ProcessResponse withDisposition(String value) {
        this.setDisposition(value);
        return this;
    }

    public ProcessResponse withRuleset(Coding value) {
        this.setRuleset(value);
        return this;
    }

    public ProcessResponse withOriginalRuleset(Coding value) {
        this.setOriginalRuleset(value);
        return this;
    }

    public ProcessResponse withCreated(DateTime value) {
        this.setCreated(value);
        return this;
    }

    public ProcessResponse withOrganization(Reference value) {
        this.setOrganization(value);
        return this;
    }

    public ProcessResponse withRequestProvider(Reference value) {
        this.setRequestProvider(value);
        return this;
    }

    public ProcessResponse withRequestOrganization(Reference value) {
        this.setRequestOrganization(value);
        return this;
    }

    public ProcessResponse withForm(Coding value) {
        this.setForm(value);
        return this;
    }

    public ProcessResponse withNotes(ProcessResponseNotes ... values) {
        if (values != null) {
            for (ProcessResponseNotes value : values) {
                this.getNotes().add(value);
            }
        }
        return this;
    }

    public ProcessResponse withNotes(Collection<ProcessResponseNotes> values) {
        if (values != null) {
            this.getNotes().addAll(values);
        }
        return this;
    }

    public ProcessResponse withError(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getError().add(value);
            }
        }
        return this;
    }

    public ProcessResponse withError(Collection<Coding> values) {
        if (values != null) {
            this.getError().addAll(values);
        }
        return this;
    }

    @Override
    public ProcessResponse withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public ProcessResponse withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public ProcessResponse withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public ProcessResponse withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ProcessResponse withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ProcessResponse withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ProcessResponse withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ProcessResponse withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public ProcessResponse withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public ProcessResponse withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public ProcessResponse withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Coding> rhsError;
        List<ProcessResponseNotes> rhsNotes;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof ProcessResponse)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ProcessResponse that = (ProcessResponse)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        Reference lhsRequest = this.getRequest();
        Reference rhsRequest = that.getRequest();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"request", (Object)lhsRequest), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"request", (Object)rhsRequest), (Object)lhsRequest, (Object)rhsRequest)) {
            return false;
        }
        Coding lhsOutcome = this.getOutcome();
        Coding rhsOutcome = that.getOutcome();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"outcome", (Object)lhsOutcome), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"outcome", (Object)rhsOutcome), (Object)lhsOutcome, (Object)rhsOutcome)) {
            return false;
        }
        String lhsDisposition = this.getDisposition();
        String rhsDisposition = that.getDisposition();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"disposition", (Object)lhsDisposition), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"disposition", (Object)rhsDisposition), (Object)lhsDisposition, (Object)rhsDisposition)) {
            return false;
        }
        Coding lhsRuleset = this.getRuleset();
        Coding rhsRuleset = that.getRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"ruleset", (Object)lhsRuleset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"ruleset", (Object)rhsRuleset), (Object)lhsRuleset, (Object)rhsRuleset)) {
            return false;
        }
        Coding lhsOriginalRuleset = this.getOriginalRuleset();
        Coding rhsOriginalRuleset = that.getOriginalRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"originalRuleset", (Object)lhsOriginalRuleset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"originalRuleset", (Object)rhsOriginalRuleset), (Object)lhsOriginalRuleset, (Object)rhsOriginalRuleset)) {
            return false;
        }
        DateTime lhsCreated = this.getCreated();
        DateTime rhsCreated = that.getCreated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"created", (Object)lhsCreated), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"created", (Object)rhsCreated), (Object)lhsCreated, (Object)rhsCreated)) {
            return false;
        }
        Reference lhsOrganization = this.getOrganization();
        Reference rhsOrganization = that.getOrganization();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"organization", (Object)lhsOrganization), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"organization", (Object)rhsOrganization), (Object)lhsOrganization, (Object)rhsOrganization)) {
            return false;
        }
        Reference lhsRequestProvider = this.getRequestProvider();
        Reference rhsRequestProvider = that.getRequestProvider();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requestProvider", (Object)lhsRequestProvider), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requestProvider", (Object)rhsRequestProvider), (Object)lhsRequestProvider, (Object)rhsRequestProvider)) {
            return false;
        }
        Reference lhsRequestOrganization = this.getRequestOrganization();
        Reference rhsRequestOrganization = that.getRequestOrganization();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requestOrganization", (Object)lhsRequestOrganization), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requestOrganization", (Object)rhsRequestOrganization), (Object)lhsRequestOrganization, (Object)rhsRequestOrganization)) {
            return false;
        }
        Coding lhsForm = this.getForm();
        Coding rhsForm = that.getForm();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"form", (Object)lhsForm), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"form", (Object)rhsForm), (Object)lhsForm, (Object)rhsForm)) {
            return false;
        }
        List<ProcessResponseNotes> lhsNotes = this.notes != null && !this.notes.isEmpty() ? this.getNotes() : null;
        List<ProcessResponseNotes> list2 = rhsNotes = that.notes != null && !that.notes.isEmpty() ? that.getNotes() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"notes", lhsNotes), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"notes", rhsNotes), lhsNotes, rhsNotes)) {
            return false;
        }
        List<Coding> lhsError = this.error != null && !this.error.isEmpty() ? this.getError() : null;
        List<Coding> list3 = rhsError = that.error != null && !that.error.isEmpty() ? that.getError() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"error", lhsError), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"error", rhsError), lhsError, rhsError);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        Reference theRequest = this.getRequest();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"request", (Object)theRequest), currentHashCode, (Object)theRequest);
        Coding theOutcome = this.getOutcome();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"outcome", (Object)theOutcome), currentHashCode, (Object)theOutcome);
        String theDisposition = this.getDisposition();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"disposition", (Object)theDisposition), currentHashCode, (Object)theDisposition);
        Coding theRuleset = this.getRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"ruleset", (Object)theRuleset), currentHashCode, (Object)theRuleset);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"originalRuleset", (Object)theOriginalRuleset), currentHashCode, (Object)theOriginalRuleset);
        DateTime theCreated = this.getCreated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"created", (Object)theCreated), currentHashCode, (Object)theCreated);
        Reference theOrganization = this.getOrganization();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"organization", (Object)theOrganization), currentHashCode, (Object)theOrganization);
        Reference theRequestProvider = this.getRequestProvider();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requestProvider", (Object)theRequestProvider), currentHashCode, (Object)theRequestProvider);
        Reference theRequestOrganization = this.getRequestOrganization();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requestOrganization", (Object)theRequestOrganization), currentHashCode, (Object)theRequestOrganization);
        Coding theForm = this.getForm();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"form", (Object)theForm), currentHashCode, (Object)theForm);
        List<ProcessResponseNotes> theNotes = this.notes != null && !this.notes.isEmpty() ? this.getNotes() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"notes", theNotes), currentHashCode, theNotes);
        List<Coding> theError = this.error != null && !this.error.isEmpty() ? this.getError() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"error", theError), currentHashCode, theError);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        Reference theRequest = this.getRequest();
        strategy.appendField(locator, (Object)this, "request", buffer, (Object)theRequest);
        Coding theOutcome = this.getOutcome();
        strategy.appendField(locator, (Object)this, "outcome", buffer, (Object)theOutcome);
        String theDisposition = this.getDisposition();
        strategy.appendField(locator, (Object)this, "disposition", buffer, (Object)theDisposition);
        Coding theRuleset = this.getRuleset();
        strategy.appendField(locator, (Object)this, "ruleset", buffer, (Object)theRuleset);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        strategy.appendField(locator, (Object)this, "originalRuleset", buffer, (Object)theOriginalRuleset);
        DateTime theCreated = this.getCreated();
        strategy.appendField(locator, (Object)this, "created", buffer, (Object)theCreated);
        Reference theOrganization = this.getOrganization();
        strategy.appendField(locator, (Object)this, "organization", buffer, (Object)theOrganization);
        Reference theRequestProvider = this.getRequestProvider();
        strategy.appendField(locator, (Object)this, "requestProvider", buffer, (Object)theRequestProvider);
        Reference theRequestOrganization = this.getRequestOrganization();
        strategy.appendField(locator, (Object)this, "requestOrganization", buffer, (Object)theRequestOrganization);
        Coding theForm = this.getForm();
        strategy.appendField(locator, (Object)this, "form", buffer, (Object)theForm);
        List<ProcessResponseNotes> theNotes = this.notes != null && !this.notes.isEmpty() ? this.getNotes() : null;
        strategy.appendField(locator, (Object)this, "notes", buffer, theNotes);
        List<Coding> theError = this.error != null && !this.error.isEmpty() ? this.getError() : null;
        strategy.appendField(locator, (Object)this, "error", buffer, theError);
        return buffer;
    }
}

