/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Instant;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.ProvenanceAgent;
import org.hl7.fhir.ProvenanceEntity;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Signature;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Provenance", propOrder={"target", "period", "recorded", "reason", "location", "policy", "agent", "entity", "signature"})
public class Provenance
extends DomainResource
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected List<Reference> target;
    protected Period period;
    @XmlElement(required=true)
    protected Instant recorded;
    protected CodeableConcept reason;
    protected Reference location;
    protected List<Uri> policy;
    protected List<ProvenanceAgent> agent;
    protected List<ProvenanceEntity> entity;
    protected List<Signature> signature;

    public List<Reference> getTarget() {
        if (this.target == null) {
            this.target = new ArrayList<Reference>();
        }
        return this.target;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period value) {
        this.period = value;
    }

    public Instant getRecorded() {
        return this.recorded;
    }

    public void setRecorded(Instant value) {
        this.recorded = value;
    }

    public CodeableConcept getReason() {
        return this.reason;
    }

    public void setReason(CodeableConcept value) {
        this.reason = value;
    }

    public Reference getLocation() {
        return this.location;
    }

    public void setLocation(Reference value) {
        this.location = value;
    }

    public List<Uri> getPolicy() {
        if (this.policy == null) {
            this.policy = new ArrayList<Uri>();
        }
        return this.policy;
    }

    public List<ProvenanceAgent> getAgent() {
        if (this.agent == null) {
            this.agent = new ArrayList<ProvenanceAgent>();
        }
        return this.agent;
    }

    public List<ProvenanceEntity> getEntity() {
        if (this.entity == null) {
            this.entity = new ArrayList<ProvenanceEntity>();
        }
        return this.entity;
    }

    public List<Signature> getSignature() {
        if (this.signature == null) {
            this.signature = new ArrayList<Signature>();
        }
        return this.signature;
    }

    public Provenance withTarget(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getTarget().add(value);
            }
        }
        return this;
    }

    public Provenance withTarget(Collection<Reference> values) {
        if (values != null) {
            this.getTarget().addAll(values);
        }
        return this;
    }

    public Provenance withPeriod(Period value) {
        this.setPeriod(value);
        return this;
    }

    public Provenance withRecorded(Instant value) {
        this.setRecorded(value);
        return this;
    }

    public Provenance withReason(CodeableConcept value) {
        this.setReason(value);
        return this;
    }

    public Provenance withLocation(Reference value) {
        this.setLocation(value);
        return this;
    }

    public Provenance withPolicy(Uri ... values) {
        if (values != null) {
            for (Uri value : values) {
                this.getPolicy().add(value);
            }
        }
        return this;
    }

    public Provenance withPolicy(Collection<Uri> values) {
        if (values != null) {
            this.getPolicy().addAll(values);
        }
        return this;
    }

    public Provenance withAgent(ProvenanceAgent ... values) {
        if (values != null) {
            for (ProvenanceAgent value : values) {
                this.getAgent().add(value);
            }
        }
        return this;
    }

    public Provenance withAgent(Collection<ProvenanceAgent> values) {
        if (values != null) {
            this.getAgent().addAll(values);
        }
        return this;
    }

    public Provenance withEntity(ProvenanceEntity ... values) {
        if (values != null) {
            for (ProvenanceEntity value : values) {
                this.getEntity().add(value);
            }
        }
        return this;
    }

    public Provenance withEntity(Collection<ProvenanceEntity> values) {
        if (values != null) {
            this.getEntity().addAll(values);
        }
        return this;
    }

    public Provenance withSignature(Signature ... values) {
        if (values != null) {
            for (Signature value : values) {
                this.getSignature().add(value);
            }
        }
        return this;
    }

    public Provenance withSignature(Collection<Signature> values) {
        if (values != null) {
            this.getSignature().addAll(values);
        }
        return this;
    }

    @Override
    public Provenance withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Provenance withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Provenance withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Provenance withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Provenance withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Provenance withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Provenance withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Provenance withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Provenance withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Provenance withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Provenance withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Signature> rhsSignature;
        List<ProvenanceEntity> rhsEntity;
        List<ProvenanceAgent> rhsAgent;
        List<Uri> rhsPolicy;
        List<Reference> rhsTarget;
        if (!(object instanceof Provenance)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Provenance that = (Provenance)object;
        List<Reference> lhsTarget = this.target != null && !this.target.isEmpty() ? this.getTarget() : null;
        List<Reference> list = rhsTarget = that.target != null && !that.target.isEmpty() ? that.getTarget() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"target", lhsTarget), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"target", rhsTarget), lhsTarget, rhsTarget)) {
            return false;
        }
        Period lhsPeriod = this.getPeriod();
        Period rhsPeriod = that.getPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"period", (Object)lhsPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"period", (Object)rhsPeriod), (Object)lhsPeriod, (Object)rhsPeriod)) {
            return false;
        }
        Instant lhsRecorded = this.getRecorded();
        Instant rhsRecorded = that.getRecorded();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"recorded", (Object)lhsRecorded), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"recorded", (Object)rhsRecorded), (Object)lhsRecorded, (Object)rhsRecorded)) {
            return false;
        }
        CodeableConcept lhsReason = this.getReason();
        CodeableConcept rhsReason = that.getReason();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reason", (Object)lhsReason), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reason", (Object)rhsReason), (Object)lhsReason, (Object)rhsReason)) {
            return false;
        }
        Reference lhsLocation = this.getLocation();
        Reference rhsLocation = that.getLocation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"location", (Object)lhsLocation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"location", (Object)rhsLocation), (Object)lhsLocation, (Object)rhsLocation)) {
            return false;
        }
        List<Uri> lhsPolicy = this.policy != null && !this.policy.isEmpty() ? this.getPolicy() : null;
        List<Uri> list2 = rhsPolicy = that.policy != null && !that.policy.isEmpty() ? that.getPolicy() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"policy", lhsPolicy), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"policy", rhsPolicy), lhsPolicy, rhsPolicy)) {
            return false;
        }
        List<ProvenanceAgent> lhsAgent = this.agent != null && !this.agent.isEmpty() ? this.getAgent() : null;
        List<ProvenanceAgent> list3 = rhsAgent = that.agent != null && !that.agent.isEmpty() ? that.getAgent() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"agent", lhsAgent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"agent", rhsAgent), lhsAgent, rhsAgent)) {
            return false;
        }
        List<ProvenanceEntity> lhsEntity = this.entity != null && !this.entity.isEmpty() ? this.getEntity() : null;
        List<ProvenanceEntity> list4 = rhsEntity = that.entity != null && !that.entity.isEmpty() ? that.getEntity() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"entity", lhsEntity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"entity", rhsEntity), lhsEntity, rhsEntity)) {
            return false;
        }
        List<Signature> lhsSignature = this.signature != null && !this.signature.isEmpty() ? this.getSignature() : null;
        List<Signature> list5 = rhsSignature = that.signature != null && !that.signature.isEmpty() ? that.getSignature() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"signature", lhsSignature), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"signature", rhsSignature), lhsSignature, rhsSignature);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Reference> theTarget = this.target != null && !this.target.isEmpty() ? this.getTarget() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"target", theTarget), currentHashCode, theTarget);
        Period thePeriod = this.getPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"period", (Object)thePeriod), currentHashCode, (Object)thePeriod);
        Instant theRecorded = this.getRecorded();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"recorded", (Object)theRecorded), currentHashCode, (Object)theRecorded);
        CodeableConcept theReason = this.getReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reason", (Object)theReason), currentHashCode, (Object)theReason);
        Reference theLocation = this.getLocation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"location", (Object)theLocation), currentHashCode, (Object)theLocation);
        List<Uri> thePolicy = this.policy != null && !this.policy.isEmpty() ? this.getPolicy() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"policy", thePolicy), currentHashCode, thePolicy);
        List<ProvenanceAgent> theAgent = this.agent != null && !this.agent.isEmpty() ? this.getAgent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"agent", theAgent), currentHashCode, theAgent);
        List<ProvenanceEntity> theEntity = this.entity != null && !this.entity.isEmpty() ? this.getEntity() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"entity", theEntity), currentHashCode, theEntity);
        List<Signature> theSignature = this.signature != null && !this.signature.isEmpty() ? this.getSignature() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"signature", theSignature), currentHashCode, theSignature);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Reference> theTarget = this.target != null && !this.target.isEmpty() ? this.getTarget() : null;
        strategy.appendField(locator, (Object)this, "target", buffer, theTarget);
        Period thePeriod = this.getPeriod();
        strategy.appendField(locator, (Object)this, "period", buffer, (Object)thePeriod);
        Instant theRecorded = this.getRecorded();
        strategy.appendField(locator, (Object)this, "recorded", buffer, (Object)theRecorded);
        CodeableConcept theReason = this.getReason();
        strategy.appendField(locator, (Object)this, "reason", buffer, (Object)theReason);
        Reference theLocation = this.getLocation();
        strategy.appendField(locator, (Object)this, "location", buffer, (Object)theLocation);
        List<Uri> thePolicy = this.policy != null && !this.policy.isEmpty() ? this.getPolicy() : null;
        strategy.appendField(locator, (Object)this, "policy", buffer, thePolicy);
        List<ProvenanceAgent> theAgent = this.agent != null && !this.agent.isEmpty() ? this.getAgent() : null;
        strategy.appendField(locator, (Object)this, "agent", buffer, theAgent);
        List<ProvenanceEntity> theEntity = this.entity != null && !this.entity.isEmpty() ? this.getEntity() : null;
        strategy.appendField(locator, (Object)this, "entity", buffer, theEntity);
        List<Signature> theSignature = this.signature != null && !this.signature.isEmpty() ? this.getSignature() : null;
        strategy.appendField(locator, (Object)this, "signature", buffer, theSignature);
        return buffer;
    }
}

