/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Coding;
import org.hl7.fhir.Extension;
import org.hl7.fhir.QuestionnaireQuestion;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Questionnaire.Group", propOrder={"linkId", "title", "concept", "text", "required", "repeats", "group", "question"})
public class QuestionnaireGroup
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected String linkId;
    protected String title;
    protected List<Coding> concept;
    protected String text;
    protected Boolean required;
    protected Boolean repeats;
    protected List<QuestionnaireGroup> group;
    protected List<QuestionnaireQuestion> question;

    public String getLinkId() {
        return this.linkId;
    }

    public void setLinkId(String value) {
        this.linkId = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public List<Coding> getConcept() {
        if (this.concept == null) {
            this.concept = new ArrayList<Coding>();
        }
        return this.concept;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        this.text = value;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean value) {
        this.required = value;
    }

    public Boolean getRepeats() {
        return this.repeats;
    }

    public void setRepeats(Boolean value) {
        this.repeats = value;
    }

    public List<QuestionnaireGroup> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<QuestionnaireGroup>();
        }
        return this.group;
    }

    public List<QuestionnaireQuestion> getQuestion() {
        if (this.question == null) {
            this.question = new ArrayList<QuestionnaireQuestion>();
        }
        return this.question;
    }

    public QuestionnaireGroup withLinkId(String value) {
        this.setLinkId(value);
        return this;
    }

    public QuestionnaireGroup withTitle(String value) {
        this.setTitle(value);
        return this;
    }

    public QuestionnaireGroup withConcept(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getConcept().add(value);
            }
        }
        return this;
    }

    public QuestionnaireGroup withConcept(Collection<Coding> values) {
        if (values != null) {
            this.getConcept().addAll(values);
        }
        return this;
    }

    public QuestionnaireGroup withText(String value) {
        this.setText(value);
        return this;
    }

    public QuestionnaireGroup withRequired(Boolean value) {
        this.setRequired(value);
        return this;
    }

    public QuestionnaireGroup withRepeats(Boolean value) {
        this.setRepeats(value);
        return this;
    }

    public QuestionnaireGroup withGroup(QuestionnaireGroup ... values) {
        if (values != null) {
            for (QuestionnaireGroup value : values) {
                this.getGroup().add(value);
            }
        }
        return this;
    }

    public QuestionnaireGroup withGroup(Collection<QuestionnaireGroup> values) {
        if (values != null) {
            this.getGroup().addAll(values);
        }
        return this;
    }

    public QuestionnaireGroup withQuestion(QuestionnaireQuestion ... values) {
        if (values != null) {
            for (QuestionnaireQuestion value : values) {
                this.getQuestion().add(value);
            }
        }
        return this;
    }

    public QuestionnaireGroup withQuestion(Collection<QuestionnaireQuestion> values) {
        if (values != null) {
            this.getQuestion().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireGroup withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public QuestionnaireGroup withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireGroup withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public QuestionnaireGroup withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireGroup withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<QuestionnaireQuestion> rhsQuestion;
        List<QuestionnaireGroup> rhsGroup;
        List<Coding> rhsConcept;
        if (!(object instanceof QuestionnaireGroup)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        QuestionnaireGroup that = (QuestionnaireGroup)object;
        String lhsLinkId = this.getLinkId();
        String rhsLinkId = that.getLinkId();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"linkId", (Object)lhsLinkId), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"linkId", (Object)rhsLinkId), (Object)lhsLinkId, (Object)rhsLinkId)) {
            return false;
        }
        String lhsTitle = this.getTitle();
        String rhsTitle = that.getTitle();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"title", (Object)lhsTitle), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"title", (Object)rhsTitle), (Object)lhsTitle, (Object)rhsTitle)) {
            return false;
        }
        List<Coding> lhsConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        List<Coding> list = rhsConcept = that.concept != null && !that.concept.isEmpty() ? that.getConcept() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"concept", lhsConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"concept", rhsConcept), lhsConcept, rhsConcept)) {
            return false;
        }
        String lhsText = this.getText();
        String rhsText = that.getText();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"text", (Object)lhsText), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"text", (Object)rhsText), (Object)lhsText, (Object)rhsText)) {
            return false;
        }
        Boolean lhsRequired = this.getRequired();
        Boolean rhsRequired = that.getRequired();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"required", (Object)lhsRequired), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"required", (Object)rhsRequired), (Object)lhsRequired, (Object)rhsRequired)) {
            return false;
        }
        Boolean lhsRepeats = this.getRepeats();
        Boolean rhsRepeats = that.getRepeats();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"repeats", (Object)lhsRepeats), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"repeats", (Object)rhsRepeats), (Object)lhsRepeats, (Object)rhsRepeats)) {
            return false;
        }
        List<QuestionnaireGroup> lhsGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        List<QuestionnaireGroup> list2 = rhsGroup = that.group != null && !that.group.isEmpty() ? that.getGroup() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"group", lhsGroup), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"group", rhsGroup), lhsGroup, rhsGroup)) {
            return false;
        }
        List<QuestionnaireQuestion> lhsQuestion = this.question != null && !this.question.isEmpty() ? this.getQuestion() : null;
        List<QuestionnaireQuestion> list3 = rhsQuestion = that.question != null && !that.question.isEmpty() ? that.getQuestion() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"question", lhsQuestion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"question", rhsQuestion), lhsQuestion, rhsQuestion);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        String theLinkId = this.getLinkId();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"linkId", (Object)theLinkId), currentHashCode, (Object)theLinkId);
        String theTitle = this.getTitle();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"title", (Object)theTitle), currentHashCode, (Object)theTitle);
        List<Coding> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"concept", theConcept), currentHashCode, theConcept);
        String theText = this.getText();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"text", (Object)theText), currentHashCode, (Object)theText);
        Boolean theRequired = this.getRequired();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"required", (Object)theRequired), currentHashCode, (Object)theRequired);
        Boolean theRepeats = this.getRepeats();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"repeats", (Object)theRepeats), currentHashCode, (Object)theRepeats);
        List<QuestionnaireGroup> theGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"group", theGroup), currentHashCode, theGroup);
        List<QuestionnaireQuestion> theQuestion = this.question != null && !this.question.isEmpty() ? this.getQuestion() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"question", theQuestion), currentHashCode, theQuestion);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        String theLinkId = this.getLinkId();
        strategy.appendField(locator, (Object)this, "linkId", buffer, (Object)theLinkId);
        String theTitle = this.getTitle();
        strategy.appendField(locator, (Object)this, "title", buffer, (Object)theTitle);
        List<Coding> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        strategy.appendField(locator, (Object)this, "concept", buffer, theConcept);
        String theText = this.getText();
        strategy.appendField(locator, (Object)this, "text", buffer, (Object)theText);
        Boolean theRequired = this.getRequired();
        strategy.appendField(locator, (Object)this, "required", buffer, (Object)theRequired);
        Boolean theRepeats = this.getRepeats();
        strategy.appendField(locator, (Object)this, "repeats", buffer, (Object)theRepeats);
        List<QuestionnaireGroup> theGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        strategy.appendField(locator, (Object)this, "group", buffer, theGroup);
        List<QuestionnaireQuestion> theQuestion = this.question != null && !this.question.isEmpty() ? this.getQuestion() : null;
        strategy.appendField(locator, (Object)this, "question", buffer, theQuestion);
        return buffer;
    }
}

