/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.AnswerFormat;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Coding;
import org.hl7.fhir.Extension;
import org.hl7.fhir.QuestionnaireGroup;
import org.hl7.fhir.Reference;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Questionnaire.Question", propOrder={"linkId", "concept", "text", "type", "required", "repeats", "options", "group"})
public class QuestionnaireQuestion
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected String linkId;
    protected List<Coding> concept;
    protected String text;
    protected AnswerFormat type;
    protected Boolean required;
    protected Boolean repeats;
    protected Reference options;
    protected List<QuestionnaireGroup> group;

    public String getLinkId() {
        return this.linkId;
    }

    public void setLinkId(String value) {
        this.linkId = value;
    }

    public List<Coding> getConcept() {
        if (this.concept == null) {
            this.concept = new ArrayList<Coding>();
        }
        return this.concept;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        this.text = value;
    }

    public AnswerFormat getType() {
        return this.type;
    }

    public void setType(AnswerFormat value) {
        this.type = value;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean value) {
        this.required = value;
    }

    public Boolean getRepeats() {
        return this.repeats;
    }

    public void setRepeats(Boolean value) {
        this.repeats = value;
    }

    public Reference getOptions() {
        return this.options;
    }

    public void setOptions(Reference value) {
        this.options = value;
    }

    public List<QuestionnaireGroup> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<QuestionnaireGroup>();
        }
        return this.group;
    }

    public QuestionnaireQuestion withLinkId(String value) {
        this.setLinkId(value);
        return this;
    }

    public QuestionnaireQuestion withConcept(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getConcept().add(value);
            }
        }
        return this;
    }

    public QuestionnaireQuestion withConcept(Collection<Coding> values) {
        if (values != null) {
            this.getConcept().addAll(values);
        }
        return this;
    }

    public QuestionnaireQuestion withText(String value) {
        this.setText(value);
        return this;
    }

    public QuestionnaireQuestion withType(AnswerFormat value) {
        this.setType(value);
        return this;
    }

    public QuestionnaireQuestion withRequired(Boolean value) {
        this.setRequired(value);
        return this;
    }

    public QuestionnaireQuestion withRepeats(Boolean value) {
        this.setRepeats(value);
        return this;
    }

    public QuestionnaireQuestion withOptions(Reference value) {
        this.setOptions(value);
        return this;
    }

    public QuestionnaireQuestion withGroup(QuestionnaireGroup ... values) {
        if (values != null) {
            for (QuestionnaireGroup value : values) {
                this.getGroup().add(value);
            }
        }
        return this;
    }

    public QuestionnaireQuestion withGroup(Collection<QuestionnaireGroup> values) {
        if (values != null) {
            this.getGroup().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireQuestion withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public QuestionnaireQuestion withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireQuestion withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public QuestionnaireQuestion withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireQuestion withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<QuestionnaireGroup> rhsGroup;
        List<Coding> rhsConcept;
        if (!(object instanceof QuestionnaireQuestion)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        QuestionnaireQuestion that = (QuestionnaireQuestion)object;
        String lhsLinkId = this.getLinkId();
        String rhsLinkId = that.getLinkId();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"linkId", (Object)lhsLinkId), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"linkId", (Object)rhsLinkId), (Object)lhsLinkId, (Object)rhsLinkId)) {
            return false;
        }
        List<Coding> lhsConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        List<Coding> list = rhsConcept = that.concept != null && !that.concept.isEmpty() ? that.getConcept() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"concept", lhsConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"concept", rhsConcept), lhsConcept, rhsConcept)) {
            return false;
        }
        String lhsText = this.getText();
        String rhsText = that.getText();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"text", (Object)lhsText), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"text", (Object)rhsText), (Object)lhsText, (Object)rhsText)) {
            return false;
        }
        AnswerFormat lhsType = this.getType();
        AnswerFormat rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        Boolean lhsRequired = this.getRequired();
        Boolean rhsRequired = that.getRequired();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"required", (Object)lhsRequired), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"required", (Object)rhsRequired), (Object)lhsRequired, (Object)rhsRequired)) {
            return false;
        }
        Boolean lhsRepeats = this.getRepeats();
        Boolean rhsRepeats = that.getRepeats();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"repeats", (Object)lhsRepeats), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"repeats", (Object)rhsRepeats), (Object)lhsRepeats, (Object)rhsRepeats)) {
            return false;
        }
        Reference lhsOptions = this.getOptions();
        Reference rhsOptions = that.getOptions();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"options", (Object)lhsOptions), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"options", (Object)rhsOptions), (Object)lhsOptions, (Object)rhsOptions)) {
            return false;
        }
        List<QuestionnaireGroup> lhsGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        List<QuestionnaireGroup> list2 = rhsGroup = that.group != null && !that.group.isEmpty() ? that.getGroup() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"group", lhsGroup), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"group", rhsGroup), lhsGroup, rhsGroup);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        String theLinkId = this.getLinkId();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"linkId", (Object)theLinkId), currentHashCode, (Object)theLinkId);
        List<Coding> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"concept", theConcept), currentHashCode, theConcept);
        String theText = this.getText();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"text", (Object)theText), currentHashCode, (Object)theText);
        AnswerFormat theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType);
        Boolean theRequired = this.getRequired();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"required", (Object)theRequired), currentHashCode, (Object)theRequired);
        Boolean theRepeats = this.getRepeats();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"repeats", (Object)theRepeats), currentHashCode, (Object)theRepeats);
        Reference theOptions = this.getOptions();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"options", (Object)theOptions), currentHashCode, (Object)theOptions);
        List<QuestionnaireGroup> theGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"group", theGroup), currentHashCode, theGroup);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        String theLinkId = this.getLinkId();
        strategy.appendField(locator, (Object)this, "linkId", buffer, (Object)theLinkId);
        List<Coding> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        strategy.appendField(locator, (Object)this, "concept", buffer, theConcept);
        String theText = this.getText();
        strategy.appendField(locator, (Object)this, "text", buffer, (Object)theText);
        AnswerFormat theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        Boolean theRequired = this.getRequired();
        strategy.appendField(locator, (Object)this, "required", buffer, (Object)theRequired);
        Boolean theRepeats = this.getRepeats();
        strategy.appendField(locator, (Object)this, "repeats", buffer, (Object)theRepeats);
        Reference theOptions = this.getOptions();
        strategy.appendField(locator, (Object)this, "options", buffer, (Object)theOptions);
        List<QuestionnaireGroup> theGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        strategy.appendField(locator, (Object)this, "group", buffer, theGroup);
        return buffer;
    }
}

