/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ReferralStatus;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ReferralRequest", propOrder={"status", "identifier", "type", "specialty", "priority", "patient", "requester", "recipient", "encounter", "dateSent", "reason", "description", "serviceRequested", "supportingInformation", "fulfillmentTime"})
public class ReferralRequest
extends DomainResource
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected ReferralStatus status;
    protected List<Identifier> identifier;
    protected CodeableConcept type;
    protected CodeableConcept specialty;
    protected CodeableConcept priority;
    protected Reference patient;
    protected Reference requester;
    protected List<Reference> recipient;
    protected Reference encounter;
    protected DateTime dateSent;
    protected CodeableConcept reason;
    protected String description;
    protected List<CodeableConcept> serviceRequested;
    protected List<Reference> supportingInformation;
    protected Period fulfillmentTime;

    public ReferralStatus getStatus() {
        return this.status;
    }

    public void setStatus(ReferralStatus value) {
        this.status = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public CodeableConcept getSpecialty() {
        return this.specialty;
    }

    public void setSpecialty(CodeableConcept value) {
        this.specialty = value;
    }

    public CodeableConcept getPriority() {
        return this.priority;
    }

    public void setPriority(CodeableConcept value) {
        this.priority = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getRequester() {
        return this.requester;
    }

    public void setRequester(Reference value) {
        this.requester = value;
    }

    public List<Reference> getRecipient() {
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        return this.recipient;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public DateTime getDateSent() {
        return this.dateSent;
    }

    public void setDateSent(DateTime value) {
        this.dateSent = value;
    }

    public CodeableConcept getReason() {
        return this.reason;
    }

    public void setReason(CodeableConcept value) {
        this.reason = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<CodeableConcept> getServiceRequested() {
        if (this.serviceRequested == null) {
            this.serviceRequested = new ArrayList<CodeableConcept>();
        }
        return this.serviceRequested;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public Period getFulfillmentTime() {
        return this.fulfillmentTime;
    }

    public void setFulfillmentTime(Period value) {
        this.fulfillmentTime = value;
    }

    public ReferralRequest withStatus(ReferralStatus value) {
        this.setStatus(value);
        return this;
    }

    public ReferralRequest withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public ReferralRequest withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public ReferralRequest withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public ReferralRequest withSpecialty(CodeableConcept value) {
        this.setSpecialty(value);
        return this;
    }

    public ReferralRequest withPriority(CodeableConcept value) {
        this.setPriority(value);
        return this;
    }

    public ReferralRequest withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public ReferralRequest withRequester(Reference value) {
        this.setRequester(value);
        return this;
    }

    public ReferralRequest withRecipient(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getRecipient().add(value);
            }
        }
        return this;
    }

    public ReferralRequest withRecipient(Collection<Reference> values) {
        if (values != null) {
            this.getRecipient().addAll(values);
        }
        return this;
    }

    public ReferralRequest withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public ReferralRequest withDateSent(DateTime value) {
        this.setDateSent(value);
        return this;
    }

    public ReferralRequest withReason(CodeableConcept value) {
        this.setReason(value);
        return this;
    }

    public ReferralRequest withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public ReferralRequest withServiceRequested(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getServiceRequested().add(value);
            }
        }
        return this;
    }

    public ReferralRequest withServiceRequested(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getServiceRequested().addAll(values);
        }
        return this;
    }

    public ReferralRequest withSupportingInformation(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getSupportingInformation().add(value);
            }
        }
        return this;
    }

    public ReferralRequest withSupportingInformation(Collection<Reference> values) {
        if (values != null) {
            this.getSupportingInformation().addAll(values);
        }
        return this;
    }

    public ReferralRequest withFulfillmentTime(Period value) {
        this.setFulfillmentTime(value);
        return this;
    }

    @Override
    public ReferralRequest withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public ReferralRequest withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public ReferralRequest withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public ReferralRequest withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ReferralRequest withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ReferralRequest withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ReferralRequest withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ReferralRequest withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public ReferralRequest withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public ReferralRequest withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public ReferralRequest withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Reference> rhsSupportingInformation;
        List<CodeableConcept> rhsServiceRequested;
        List<Reference> rhsRecipient;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof ReferralRequest)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ReferralRequest that = (ReferralRequest)object;
        ReferralStatus lhsStatus = this.getStatus();
        ReferralStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        CodeableConcept lhsSpecialty = this.getSpecialty();
        CodeableConcept rhsSpecialty = that.getSpecialty();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"specialty", (Object)lhsSpecialty), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"specialty", (Object)rhsSpecialty), (Object)lhsSpecialty, (Object)rhsSpecialty)) {
            return false;
        }
        CodeableConcept lhsPriority = this.getPriority();
        CodeableConcept rhsPriority = that.getPriority();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"priority", (Object)lhsPriority), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"priority", (Object)rhsPriority), (Object)lhsPriority, (Object)rhsPriority)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        Reference lhsRequester = this.getRequester();
        Reference rhsRequester = that.getRequester();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requester", (Object)lhsRequester), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requester", (Object)rhsRequester), (Object)lhsRequester, (Object)rhsRequester)) {
            return false;
        }
        List<Reference> lhsRecipient = this.recipient != null && !this.recipient.isEmpty() ? this.getRecipient() : null;
        List<Reference> list2 = rhsRecipient = that.recipient != null && !that.recipient.isEmpty() ? that.getRecipient() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"recipient", lhsRecipient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"recipient", rhsRecipient), lhsRecipient, rhsRecipient)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter)) {
            return false;
        }
        DateTime lhsDateSent = this.getDateSent();
        DateTime rhsDateSent = that.getDateSent();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dateSent", (Object)lhsDateSent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dateSent", (Object)rhsDateSent), (Object)lhsDateSent, (Object)rhsDateSent)) {
            return false;
        }
        CodeableConcept lhsReason = this.getReason();
        CodeableConcept rhsReason = that.getReason();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reason", (Object)lhsReason), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reason", (Object)rhsReason), (Object)lhsReason, (Object)rhsReason)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription)) {
            return false;
        }
        List<CodeableConcept> lhsServiceRequested = this.serviceRequested != null && !this.serviceRequested.isEmpty() ? this.getServiceRequested() : null;
        List<CodeableConcept> list3 = rhsServiceRequested = that.serviceRequested != null && !that.serviceRequested.isEmpty() ? that.getServiceRequested() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"serviceRequested", lhsServiceRequested), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"serviceRequested", rhsServiceRequested), lhsServiceRequested, rhsServiceRequested)) {
            return false;
        }
        List<Reference> lhsSupportingInformation = this.supportingInformation != null && !this.supportingInformation.isEmpty() ? this.getSupportingInformation() : null;
        List<Reference> list4 = rhsSupportingInformation = that.supportingInformation != null && !that.supportingInformation.isEmpty() ? that.getSupportingInformation() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"supportingInformation", lhsSupportingInformation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"supportingInformation", rhsSupportingInformation), lhsSupportingInformation, rhsSupportingInformation)) {
            return false;
        }
        Period lhsFulfillmentTime = this.getFulfillmentTime();
        Period rhsFulfillmentTime = that.getFulfillmentTime();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"fulfillmentTime", (Object)lhsFulfillmentTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"fulfillmentTime", (Object)rhsFulfillmentTime), (Object)lhsFulfillmentTime, (Object)rhsFulfillmentTime);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        ReferralStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType);
        CodeableConcept theSpecialty = this.getSpecialty();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"specialty", (Object)theSpecialty), currentHashCode, (Object)theSpecialty);
        CodeableConcept thePriority = this.getPriority();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"priority", (Object)thePriority), currentHashCode, (Object)thePriority);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        Reference theRequester = this.getRequester();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requester", (Object)theRequester), currentHashCode, (Object)theRequester);
        List<Reference> theRecipient = this.recipient != null && !this.recipient.isEmpty() ? this.getRecipient() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"recipient", theRecipient), currentHashCode, theRecipient);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter);
        DateTime theDateSent = this.getDateSent();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dateSent", (Object)theDateSent), currentHashCode, (Object)theDateSent);
        CodeableConcept theReason = this.getReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reason", (Object)theReason), currentHashCode, (Object)theReason);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription);
        List<CodeableConcept> theServiceRequested = this.serviceRequested != null && !this.serviceRequested.isEmpty() ? this.getServiceRequested() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"serviceRequested", theServiceRequested), currentHashCode, theServiceRequested);
        List<Reference> theSupportingInformation = this.supportingInformation != null && !this.supportingInformation.isEmpty() ? this.getSupportingInformation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"supportingInformation", theSupportingInformation), currentHashCode, theSupportingInformation);
        Period theFulfillmentTime = this.getFulfillmentTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"fulfillmentTime", (Object)theFulfillmentTime), currentHashCode, (Object)theFulfillmentTime);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        ReferralStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        CodeableConcept theSpecialty = this.getSpecialty();
        strategy.appendField(locator, (Object)this, "specialty", buffer, (Object)theSpecialty);
        CodeableConcept thePriority = this.getPriority();
        strategy.appendField(locator, (Object)this, "priority", buffer, (Object)thePriority);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        Reference theRequester = this.getRequester();
        strategy.appendField(locator, (Object)this, "requester", buffer, (Object)theRequester);
        List<Reference> theRecipient = this.recipient != null && !this.recipient.isEmpty() ? this.getRecipient() : null;
        strategy.appendField(locator, (Object)this, "recipient", buffer, theRecipient);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter);
        DateTime theDateSent = this.getDateSent();
        strategy.appendField(locator, (Object)this, "dateSent", buffer, (Object)theDateSent);
        CodeableConcept theReason = this.getReason();
        strategy.appendField(locator, (Object)this, "reason", buffer, (Object)theReason);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription);
        List<CodeableConcept> theServiceRequested = this.serviceRequested != null && !this.serviceRequested.isEmpty() ? this.getServiceRequested() : null;
        strategy.appendField(locator, (Object)this, "serviceRequested", buffer, theServiceRequested);
        List<Reference> theSupportingInformation = this.supportingInformation != null && !this.supportingInformation.isEmpty() ? this.getSupportingInformation() : null;
        strategy.appendField(locator, (Object)this, "supportingInformation", buffer, theSupportingInformation);
        Period theFulfillmentTime = this.getFulfillmentTime();
        strategy.appendField(locator, (Object)this, "fulfillmentTime", buffer, (Object)theFulfillmentTime);
        return buffer;
    }
}

