/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.RiskAssessmentPrediction;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RiskAssessment", propOrder={"subject", "date", "condition", "performer", "identifier", "method", "basis", "prediction", "mitigation"})
public class RiskAssessment
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected Reference subject;
    protected DateTime date;
    protected Reference condition;
    protected Reference performer;
    protected Identifier identifier;
    protected CodeableConcept method;
    protected List<Reference> basis;
    protected List<RiskAssessmentPrediction> prediction;
    protected String mitigation;

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public Reference getCondition() {
        return this.condition;
    }

    public void setCondition(Reference value) {
        this.condition = value;
    }

    public Reference getPerformer() {
        return this.performer;
    }

    public void setPerformer(Reference value) {
        this.performer = value;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public CodeableConcept getMethod() {
        return this.method;
    }

    public void setMethod(CodeableConcept value) {
        this.method = value;
    }

    public List<Reference> getBasis() {
        if (this.basis == null) {
            this.basis = new ArrayList<Reference>();
        }
        return this.basis;
    }

    public List<RiskAssessmentPrediction> getPrediction() {
        if (this.prediction == null) {
            this.prediction = new ArrayList<RiskAssessmentPrediction>();
        }
        return this.prediction;
    }

    public String getMitigation() {
        return this.mitigation;
    }

    public void setMitigation(String value) {
        this.mitigation = value;
    }

    public RiskAssessment withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public RiskAssessment withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public RiskAssessment withCondition(Reference value) {
        this.setCondition(value);
        return this;
    }

    public RiskAssessment withPerformer(Reference value) {
        this.setPerformer(value);
        return this;
    }

    public RiskAssessment withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public RiskAssessment withMethod(CodeableConcept value) {
        this.setMethod(value);
        return this;
    }

    public RiskAssessment withBasis(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getBasis().add(value);
            }
        }
        return this;
    }

    public RiskAssessment withBasis(Collection<Reference> values) {
        if (values != null) {
            this.getBasis().addAll(values);
        }
        return this;
    }

    public RiskAssessment withPrediction(RiskAssessmentPrediction ... values) {
        if (values != null) {
            for (RiskAssessmentPrediction value : values) {
                this.getPrediction().add(value);
            }
        }
        return this;
    }

    public RiskAssessment withPrediction(Collection<RiskAssessmentPrediction> values) {
        if (values != null) {
            this.getPrediction().addAll(values);
        }
        return this;
    }

    public RiskAssessment withMitigation(String value) {
        this.setMitigation(value);
        return this;
    }

    @Override
    public RiskAssessment withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public RiskAssessment withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public RiskAssessment withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public RiskAssessment withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public RiskAssessment withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public RiskAssessment withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public RiskAssessment withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public RiskAssessment withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public RiskAssessment withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public RiskAssessment withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public RiskAssessment withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<RiskAssessmentPrediction> rhsPrediction;
        List<Reference> rhsBasis;
        if (!(object instanceof RiskAssessment)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        RiskAssessment that = (RiskAssessment)object;
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate)) {
            return false;
        }
        Reference lhsCondition = this.getCondition();
        Reference rhsCondition = that.getCondition();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"condition", (Object)lhsCondition), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"condition", (Object)rhsCondition), (Object)lhsCondition, (Object)rhsCondition)) {
            return false;
        }
        Reference lhsPerformer = this.getPerformer();
        Reference rhsPerformer = that.getPerformer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"performer", (Object)lhsPerformer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"performer", (Object)rhsPerformer), (Object)lhsPerformer, (Object)rhsPerformer)) {
            return false;
        }
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier)) {
            return false;
        }
        CodeableConcept lhsMethod = this.getMethod();
        CodeableConcept rhsMethod = that.getMethod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"method", (Object)lhsMethod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"method", (Object)rhsMethod), (Object)lhsMethod, (Object)rhsMethod)) {
            return false;
        }
        List<Reference> lhsBasis = this.basis != null && !this.basis.isEmpty() ? this.getBasis() : null;
        List<Reference> list = rhsBasis = that.basis != null && !that.basis.isEmpty() ? that.getBasis() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"basis", lhsBasis), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"basis", rhsBasis), lhsBasis, rhsBasis)) {
            return false;
        }
        List<RiskAssessmentPrediction> lhsPrediction = this.prediction != null && !this.prediction.isEmpty() ? this.getPrediction() : null;
        List<RiskAssessmentPrediction> list2 = rhsPrediction = that.prediction != null && !that.prediction.isEmpty() ? that.getPrediction() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"prediction", lhsPrediction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"prediction", rhsPrediction), lhsPrediction, rhsPrediction)) {
            return false;
        }
        String lhsMitigation = this.getMitigation();
        String rhsMitigation = that.getMitigation();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"mitigation", (Object)lhsMitigation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"mitigation", (Object)rhsMitigation), (Object)lhsMitigation, (Object)rhsMitigation);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"date", (Object)theDate), currentHashCode, (Object)theDate);
        Reference theCondition = this.getCondition();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"condition", (Object)theCondition), currentHashCode, (Object)theCondition);
        Reference thePerformer = this.getPerformer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"performer", (Object)thePerformer), currentHashCode, (Object)thePerformer);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier);
        CodeableConcept theMethod = this.getMethod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"method", (Object)theMethod), currentHashCode, (Object)theMethod);
        List<Reference> theBasis = this.basis != null && !this.basis.isEmpty() ? this.getBasis() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"basis", theBasis), currentHashCode, theBasis);
        List<RiskAssessmentPrediction> thePrediction = this.prediction != null && !this.prediction.isEmpty() ? this.getPrediction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"prediction", thePrediction), currentHashCode, thePrediction);
        String theMitigation = this.getMitigation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"mitigation", (Object)theMitigation), currentHashCode, (Object)theMitigation);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate);
        Reference theCondition = this.getCondition();
        strategy.appendField(locator, (Object)this, "condition", buffer, (Object)theCondition);
        Reference thePerformer = this.getPerformer();
        strategy.appendField(locator, (Object)this, "performer", buffer, (Object)thePerformer);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier);
        CodeableConcept theMethod = this.getMethod();
        strategy.appendField(locator, (Object)this, "method", buffer, (Object)theMethod);
        List<Reference> theBasis = this.basis != null && !this.basis.isEmpty() ? this.getBasis() : null;
        strategy.appendField(locator, (Object)this, "basis", buffer, theBasis);
        List<RiskAssessmentPrediction> thePrediction = this.prediction != null && !this.prediction.isEmpty() ? this.getPrediction() : null;
        strategy.appendField(locator, (Object)this, "prediction", buffer, thePrediction);
        String theMitigation = this.getMitigation();
        strategy.appendField(locator, (Object)this, "mitigation", buffer, (Object)theMitigation);
        return buffer;
    }
}

