/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.SpecimenCollection;
import org.hl7.fhir.SpecimenContainer;
import org.hl7.fhir.SpecimenTreatment;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Specimen", propOrder={"identifier", "type", "parent", "subject", "accessionIdentifier", "receivedTime", "collection", "treatment", "container"})
public class Specimen
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    protected CodeableConcept type;
    protected List<Reference> parent;
    @XmlElement(required=true)
    protected Reference subject;
    protected Identifier accessionIdentifier;
    protected DateTime receivedTime;
    protected SpecimenCollection collection;
    protected List<SpecimenTreatment> treatment;
    protected List<SpecimenContainer> container;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public List<Reference> getParent() {
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        return this.parent;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public Identifier getAccessionIdentifier() {
        return this.accessionIdentifier;
    }

    public void setAccessionIdentifier(Identifier value) {
        this.accessionIdentifier = value;
    }

    public DateTime getReceivedTime() {
        return this.receivedTime;
    }

    public void setReceivedTime(DateTime value) {
        this.receivedTime = value;
    }

    public SpecimenCollection getCollection() {
        return this.collection;
    }

    public void setCollection(SpecimenCollection value) {
        this.collection = value;
    }

    public List<SpecimenTreatment> getTreatment() {
        if (this.treatment == null) {
            this.treatment = new ArrayList<SpecimenTreatment>();
        }
        return this.treatment;
    }

    public List<SpecimenContainer> getContainer() {
        if (this.container == null) {
            this.container = new ArrayList<SpecimenContainer>();
        }
        return this.container;
    }

    public Specimen withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Specimen withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Specimen withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public Specimen withParent(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getParent().add(value);
            }
        }
        return this;
    }

    public Specimen withParent(Collection<Reference> values) {
        if (values != null) {
            this.getParent().addAll(values);
        }
        return this;
    }

    public Specimen withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public Specimen withAccessionIdentifier(Identifier value) {
        this.setAccessionIdentifier(value);
        return this;
    }

    public Specimen withReceivedTime(DateTime value) {
        this.setReceivedTime(value);
        return this;
    }

    public Specimen withCollection(SpecimenCollection value) {
        this.setCollection(value);
        return this;
    }

    public Specimen withTreatment(SpecimenTreatment ... values) {
        if (values != null) {
            for (SpecimenTreatment value : values) {
                this.getTreatment().add(value);
            }
        }
        return this;
    }

    public Specimen withTreatment(Collection<SpecimenTreatment> values) {
        if (values != null) {
            this.getTreatment().addAll(values);
        }
        return this;
    }

    public Specimen withContainer(SpecimenContainer ... values) {
        if (values != null) {
            for (SpecimenContainer value : values) {
                this.getContainer().add(value);
            }
        }
        return this;
    }

    public Specimen withContainer(Collection<SpecimenContainer> values) {
        if (values != null) {
            this.getContainer().addAll(values);
        }
        return this;
    }

    @Override
    public Specimen withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Specimen withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Specimen withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Specimen withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Specimen withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Specimen withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Specimen withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Specimen withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Specimen withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Specimen withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Specimen withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<SpecimenContainer> rhsContainer;
        List<SpecimenTreatment> rhsTreatment;
        List<Reference> rhsParent;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof Specimen)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Specimen that = (Specimen)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        List<Reference> lhsParent = this.parent != null && !this.parent.isEmpty() ? this.getParent() : null;
        List<Reference> list2 = rhsParent = that.parent != null && !that.parent.isEmpty() ? that.getParent() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"parent", lhsParent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"parent", rhsParent), lhsParent, rhsParent)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject)) {
            return false;
        }
        Identifier lhsAccessionIdentifier = this.getAccessionIdentifier();
        Identifier rhsAccessionIdentifier = that.getAccessionIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"accessionIdentifier", (Object)lhsAccessionIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"accessionIdentifier", (Object)rhsAccessionIdentifier), (Object)lhsAccessionIdentifier, (Object)rhsAccessionIdentifier)) {
            return false;
        }
        DateTime lhsReceivedTime = this.getReceivedTime();
        DateTime rhsReceivedTime = that.getReceivedTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"receivedTime", (Object)lhsReceivedTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"receivedTime", (Object)rhsReceivedTime), (Object)lhsReceivedTime, (Object)rhsReceivedTime)) {
            return false;
        }
        SpecimenCollection lhsCollection = this.getCollection();
        SpecimenCollection rhsCollection = that.getCollection();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"collection", (Object)lhsCollection), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"collection", (Object)rhsCollection), (Object)lhsCollection, (Object)rhsCollection)) {
            return false;
        }
        List<SpecimenTreatment> lhsTreatment = this.treatment != null && !this.treatment.isEmpty() ? this.getTreatment() : null;
        List<SpecimenTreatment> list3 = rhsTreatment = that.treatment != null && !that.treatment.isEmpty() ? that.getTreatment() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"treatment", lhsTreatment), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"treatment", rhsTreatment), lhsTreatment, rhsTreatment)) {
            return false;
        }
        List<SpecimenContainer> lhsContainer = this.container != null && !this.container.isEmpty() ? this.getContainer() : null;
        List<SpecimenContainer> list4 = rhsContainer = that.container != null && !that.container.isEmpty() ? that.getContainer() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"container", lhsContainer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"container", rhsContainer), lhsContainer, rhsContainer);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"type", (Object)theType), currentHashCode, (Object)theType);
        List<Reference> theParent = this.parent != null && !this.parent.isEmpty() ? this.getParent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"parent", theParent), currentHashCode, theParent);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject);
        Identifier theAccessionIdentifier = this.getAccessionIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"accessionIdentifier", (Object)theAccessionIdentifier), currentHashCode, (Object)theAccessionIdentifier);
        DateTime theReceivedTime = this.getReceivedTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"receivedTime", (Object)theReceivedTime), currentHashCode, (Object)theReceivedTime);
        SpecimenCollection theCollection = this.getCollection();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"collection", (Object)theCollection), currentHashCode, (Object)theCollection);
        List<SpecimenTreatment> theTreatment = this.treatment != null && !this.treatment.isEmpty() ? this.getTreatment() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"treatment", theTreatment), currentHashCode, theTreatment);
        List<SpecimenContainer> theContainer = this.container != null && !this.container.isEmpty() ? this.getContainer() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"container", theContainer), currentHashCode, theContainer);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        List<Reference> theParent = this.parent != null && !this.parent.isEmpty() ? this.getParent() : null;
        strategy.appendField(locator, (Object)this, "parent", buffer, theParent);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject);
        Identifier theAccessionIdentifier = this.getAccessionIdentifier();
        strategy.appendField(locator, (Object)this, "accessionIdentifier", buffer, (Object)theAccessionIdentifier);
        DateTime theReceivedTime = this.getReceivedTime();
        strategy.appendField(locator, (Object)this, "receivedTime", buffer, (Object)theReceivedTime);
        SpecimenCollection theCollection = this.getCollection();
        strategy.appendField(locator, (Object)this, "collection", buffer, (Object)theCollection);
        List<SpecimenTreatment> theTreatment = this.treatment != null && !this.treatment.isEmpty() ? this.getTreatment() : null;
        strategy.appendField(locator, (Object)this, "treatment", buffer, theTreatment);
        List<SpecimenContainer> theContainer = this.container != null && !this.container.isEmpty() ? this.getContainer() : null;
        strategy.appendField(locator, (Object)this, "container", buffer, theContainer);
        return buffer;
    }
}

