/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Coding;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.ExtensionContext;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.StructureDefinitionContact;
import org.hl7.fhir.StructureDefinitionDifferential;
import org.hl7.fhir.StructureDefinitionMapping;
import org.hl7.fhir.StructureDefinitionSnapshot;
import org.hl7.fhir.StructureDefinitionType;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="StructureDefinition", propOrder={"url", "identifier", "version", "name", "useContext", "display", "publisher", "contact", "description", "requirements", "copyright", "code", "status", "experimental", "date", "fhirVersion", "mapping", "type", "_abstract", "contextType", "context", "base", "snapshot", "differential"})
public class StructureDefinition
extends DomainResource
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected Uri url;
    protected List<Identifier> identifier;
    protected String version;
    @XmlElement(required=true)
    protected String name;
    protected List<CodeableConcept> useContext;
    protected String display;
    protected String publisher;
    protected List<StructureDefinitionContact> contact;
    protected String description;
    protected String requirements;
    protected String copyright;
    protected List<Coding> code;
    @XmlElement(required=true)
    protected ConformanceResourceStatus status;
    protected Boolean experimental;
    protected DateTime date;
    protected Id fhirVersion;
    protected List<StructureDefinitionMapping> mapping;
    @XmlElement(required=true)
    protected StructureDefinitionType type;
    @XmlElement(name="abstract", required=true)
    protected Boolean _abstract;
    protected ExtensionContext contextType;
    protected List<String> context;
    protected Uri base;
    protected StructureDefinitionSnapshot snapshot;
    protected StructureDefinitionDifferential differential;

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String value) {
        this.display = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<StructureDefinitionContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<StructureDefinitionContact>();
        }
        return this.contact;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String value) {
        this.requirements = value;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String value) {
        this.copyright = value;
    }

    public List<Coding> getCode() {
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        return this.code;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean value) {
        this.experimental = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public Id getFhirVersion() {
        return this.fhirVersion;
    }

    public void setFhirVersion(Id value) {
        this.fhirVersion = value;
    }

    public List<StructureDefinitionMapping> getMapping() {
        if (this.mapping == null) {
            this.mapping = new ArrayList<StructureDefinitionMapping>();
        }
        return this.mapping;
    }

    public StructureDefinitionType getType() {
        return this.type;
    }

    public void setType(StructureDefinitionType value) {
        this.type = value;
    }

    public Boolean getAbstract() {
        return this._abstract;
    }

    public void setAbstract(Boolean value) {
        this._abstract = value;
    }

    public ExtensionContext getContextType() {
        return this.contextType;
    }

    public void setContextType(ExtensionContext value) {
        this.contextType = value;
    }

    public List<String> getContext() {
        if (this.context == null) {
            this.context = new ArrayList<String>();
        }
        return this.context;
    }

    public Uri getBase() {
        return this.base;
    }

    public void setBase(Uri value) {
        this.base = value;
    }

    public StructureDefinitionSnapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(StructureDefinitionSnapshot value) {
        this.snapshot = value;
    }

    public StructureDefinitionDifferential getDifferential() {
        return this.differential;
    }

    public void setDifferential(StructureDefinitionDifferential value) {
        this.differential = value;
    }

    public StructureDefinition withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public StructureDefinition withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public StructureDefinition withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public StructureDefinition withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public StructureDefinition withName(String value) {
        this.setName(value);
        return this;
    }

    public StructureDefinition withUseContext(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getUseContext().add(value);
            }
        }
        return this;
    }

    public StructureDefinition withUseContext(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getUseContext().addAll(values);
        }
        return this;
    }

    public StructureDefinition withDisplay(String value) {
        this.setDisplay(value);
        return this;
    }

    public StructureDefinition withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public StructureDefinition withContact(StructureDefinitionContact ... values) {
        if (values != null) {
            for (StructureDefinitionContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public StructureDefinition withContact(Collection<StructureDefinitionContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public StructureDefinition withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public StructureDefinition withRequirements(String value) {
        this.setRequirements(value);
        return this;
    }

    public StructureDefinition withCopyright(String value) {
        this.setCopyright(value);
        return this;
    }

    public StructureDefinition withCode(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getCode().add(value);
            }
        }
        return this;
    }

    public StructureDefinition withCode(Collection<Coding> values) {
        if (values != null) {
            this.getCode().addAll(values);
        }
        return this;
    }

    public StructureDefinition withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public StructureDefinition withExperimental(Boolean value) {
        this.setExperimental(value);
        return this;
    }

    public StructureDefinition withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public StructureDefinition withFhirVersion(Id value) {
        this.setFhirVersion(value);
        return this;
    }

    public StructureDefinition withMapping(StructureDefinitionMapping ... values) {
        if (values != null) {
            for (StructureDefinitionMapping value : values) {
                this.getMapping().add(value);
            }
        }
        return this;
    }

    public StructureDefinition withMapping(Collection<StructureDefinitionMapping> values) {
        if (values != null) {
            this.getMapping().addAll(values);
        }
        return this;
    }

    public StructureDefinition withType(StructureDefinitionType value) {
        this.setType(value);
        return this;
    }

    public StructureDefinition withAbstract(Boolean value) {
        this.setAbstract(value);
        return this;
    }

    public StructureDefinition withContextType(ExtensionContext value) {
        this.setContextType(value);
        return this;
    }

    public StructureDefinition withContext(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getContext().add(value);
            }
        }
        return this;
    }

    public StructureDefinition withContext(Collection<String> values) {
        if (values != null) {
            this.getContext().addAll(values);
        }
        return this;
    }

    public StructureDefinition withBase(Uri value) {
        this.setBase(value);
        return this;
    }

    public StructureDefinition withSnapshot(StructureDefinitionSnapshot value) {
        this.setSnapshot(value);
        return this;
    }

    public StructureDefinition withDifferential(StructureDefinitionDifferential value) {
        this.setDifferential(value);
        return this;
    }

    @Override
    public StructureDefinition withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public StructureDefinition withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public StructureDefinition withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public StructureDefinition withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public StructureDefinition withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public StructureDefinition withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public StructureDefinition withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public StructureDefinition withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public StructureDefinition withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public StructureDefinition withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public StructureDefinition withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<String> rhsContext;
        List<StructureDefinitionMapping> rhsMapping;
        List<Coding> rhsCode;
        List<StructureDefinitionContact> rhsContact;
        List<CodeableConcept> rhsUseContext;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof StructureDefinition)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        StructureDefinition that = (StructureDefinition)object;
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"url", (Object)lhsUrl), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"url", (Object)rhsUrl), (Object)lhsUrl, (Object)rhsUrl)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"version", (Object)lhsVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"version", (Object)rhsVersion), (Object)lhsVersion, (Object)rhsVersion)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"name", (Object)lhsName), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"name", (Object)rhsName), (Object)lhsName, (Object)rhsName)) {
            return false;
        }
        List<CodeableConcept> lhsUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        List<CodeableConcept> list2 = rhsUseContext = that.useContext != null && !that.useContext.isEmpty() ? that.getUseContext() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"useContext", lhsUseContext), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"useContext", rhsUseContext), lhsUseContext, rhsUseContext)) {
            return false;
        }
        String lhsDisplay = this.getDisplay();
        String rhsDisplay = that.getDisplay();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"display", (Object)lhsDisplay), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"display", (Object)rhsDisplay), (Object)lhsDisplay, (Object)rhsDisplay)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"publisher", (Object)lhsPublisher), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"publisher", (Object)rhsPublisher), (Object)lhsPublisher, (Object)rhsPublisher)) {
            return false;
        }
        List<StructureDefinitionContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<StructureDefinitionContact> list3 = rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"contact", lhsContact), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"contact", rhsContact), lhsContact, rhsContact)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription)) {
            return false;
        }
        String lhsRequirements = this.getRequirements();
        String rhsRequirements = that.getRequirements();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requirements", (Object)lhsRequirements), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requirements", (Object)rhsRequirements), (Object)lhsRequirements, (Object)rhsRequirements)) {
            return false;
        }
        String lhsCopyright = this.getCopyright();
        String rhsCopyright = that.getCopyright();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"copyright", (Object)lhsCopyright), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"copyright", (Object)rhsCopyright), (Object)lhsCopyright, (Object)rhsCopyright)) {
            return false;
        }
        List<Coding> lhsCode = this.code != null && !this.code.isEmpty() ? this.getCode() : null;
        List<Coding> list4 = rhsCode = that.code != null && !that.code.isEmpty() ? that.getCode() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"code", lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"code", rhsCode), lhsCode, rhsCode)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        Boolean lhsExperimental = this.getExperimental();
        Boolean rhsExperimental = that.getExperimental();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"experimental", (Object)lhsExperimental), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"experimental", (Object)rhsExperimental), (Object)lhsExperimental, (Object)rhsExperimental)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate)) {
            return false;
        }
        Id lhsFhirVersion = this.getFhirVersion();
        Id rhsFhirVersion = that.getFhirVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"fhirVersion", (Object)lhsFhirVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"fhirVersion", (Object)rhsFhirVersion), (Object)lhsFhirVersion, (Object)rhsFhirVersion)) {
            return false;
        }
        List<StructureDefinitionMapping> lhsMapping = this.mapping != null && !this.mapping.isEmpty() ? this.getMapping() : null;
        List<StructureDefinitionMapping> list5 = rhsMapping = that.mapping != null && !that.mapping.isEmpty() ? that.getMapping() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"mapping", lhsMapping), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"mapping", rhsMapping), lhsMapping, rhsMapping)) {
            return false;
        }
        StructureDefinitionType lhsType = this.getType();
        StructureDefinitionType rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        Boolean lhsAbstract = this.getAbstract();
        Boolean rhsAbstract = that.getAbstract();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"_abstract", (Object)lhsAbstract), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"_abstract", (Object)rhsAbstract), (Object)lhsAbstract, (Object)rhsAbstract)) {
            return false;
        }
        ExtensionContext lhsContextType = this.getContextType();
        ExtensionContext rhsContextType = that.getContextType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"contextType", (Object)lhsContextType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"contextType", (Object)rhsContextType), (Object)lhsContextType, (Object)rhsContextType)) {
            return false;
        }
        List<String> lhsContext = this.context != null && !this.context.isEmpty() ? this.getContext() : null;
        List<String> list6 = rhsContext = that.context != null && !that.context.isEmpty() ? that.getContext() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"context", lhsContext), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"context", rhsContext), lhsContext, rhsContext)) {
            return false;
        }
        Uri lhsBase = this.getBase();
        Uri rhsBase = that.getBase();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"base", (Object)lhsBase), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"base", (Object)rhsBase), (Object)lhsBase, (Object)rhsBase)) {
            return false;
        }
        StructureDefinitionSnapshot lhsSnapshot = this.getSnapshot();
        StructureDefinitionSnapshot rhsSnapshot = that.getSnapshot();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"snapshot", (Object)lhsSnapshot), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"snapshot", (Object)rhsSnapshot), (Object)lhsSnapshot, (Object)rhsSnapshot)) {
            return false;
        }
        StructureDefinitionDifferential lhsDifferential = this.getDifferential();
        StructureDefinitionDifferential rhsDifferential = that.getDifferential();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"differential", (Object)lhsDifferential), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"differential", (Object)rhsDifferential), (Object)lhsDifferential, (Object)rhsDifferential);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"url", (Object)theUrl), currentHashCode, (Object)theUrl);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"version", (Object)theVersion), currentHashCode, (Object)theVersion);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"name", (Object)theName), currentHashCode, (Object)theName);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"useContext", theUseContext), currentHashCode, theUseContext);
        String theDisplay = this.getDisplay();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"display", (Object)theDisplay), currentHashCode, (Object)theDisplay);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"publisher", (Object)thePublisher), currentHashCode, (Object)thePublisher);
        List<StructureDefinitionContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"contact", theContact), currentHashCode, theContact);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription);
        String theRequirements = this.getRequirements();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requirements", (Object)theRequirements), currentHashCode, (Object)theRequirements);
        String theCopyright = this.getCopyright();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"copyright", (Object)theCopyright), currentHashCode, (Object)theCopyright);
        List<Coding> theCode = this.code != null && !this.code.isEmpty() ? this.getCode() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"code", theCode), currentHashCode, theCode);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        Boolean theExperimental = this.getExperimental();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"experimental", (Object)theExperimental), currentHashCode, (Object)theExperimental);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"date", (Object)theDate), currentHashCode, (Object)theDate);
        Id theFhirVersion = this.getFhirVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"fhirVersion", (Object)theFhirVersion), currentHashCode, (Object)theFhirVersion);
        List<StructureDefinitionMapping> theMapping = this.mapping != null && !this.mapping.isEmpty() ? this.getMapping() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"mapping", theMapping), currentHashCode, theMapping);
        StructureDefinitionType theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType);
        Boolean theAbstract = this.getAbstract();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"_abstract", (Object)theAbstract), currentHashCode, (Object)theAbstract);
        ExtensionContext theContextType = this.getContextType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"contextType", (Object)theContextType), currentHashCode, (Object)theContextType);
        List<String> theContext = this.context != null && !this.context.isEmpty() ? this.getContext() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"context", theContext), currentHashCode, theContext);
        Uri theBase = this.getBase();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"base", (Object)theBase), currentHashCode, (Object)theBase);
        StructureDefinitionSnapshot theSnapshot = this.getSnapshot();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"snapshot", (Object)theSnapshot), currentHashCode, (Object)theSnapshot);
        StructureDefinitionDifferential theDifferential = this.getDifferential();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"differential", (Object)theDifferential), currentHashCode, (Object)theDifferential);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, (Object)theUrl);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, (Object)theVersion);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, (Object)theName);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        strategy.appendField(locator, (Object)this, "useContext", buffer, theUseContext);
        String theDisplay = this.getDisplay();
        strategy.appendField(locator, (Object)this, "display", buffer, (Object)theDisplay);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, (Object)thePublisher);
        List<StructureDefinitionContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription);
        String theRequirements = this.getRequirements();
        strategy.appendField(locator, (Object)this, "requirements", buffer, (Object)theRequirements);
        String theCopyright = this.getCopyright();
        strategy.appendField(locator, (Object)this, "copyright", buffer, (Object)theCopyright);
        List<Coding> theCode = this.code != null && !this.code.isEmpty() ? this.getCode() : null;
        strategy.appendField(locator, (Object)this, "code", buffer, theCode);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        Boolean theExperimental = this.getExperimental();
        strategy.appendField(locator, (Object)this, "experimental", buffer, (Object)theExperimental);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate);
        Id theFhirVersion = this.getFhirVersion();
        strategy.appendField(locator, (Object)this, "fhirVersion", buffer, (Object)theFhirVersion);
        List<StructureDefinitionMapping> theMapping = this.mapping != null && !this.mapping.isEmpty() ? this.getMapping() : null;
        strategy.appendField(locator, (Object)this, "mapping", buffer, theMapping);
        StructureDefinitionType theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        Boolean theAbstract = this.getAbstract();
        strategy.appendField(locator, (Object)this, "_abstract", buffer, (Object)theAbstract);
        ExtensionContext theContextType = this.getContextType();
        strategy.appendField(locator, (Object)this, "contextType", buffer, (Object)theContextType);
        List<String> theContext = this.context != null && !this.context.isEmpty() ? this.getContext() : null;
        strategy.appendField(locator, (Object)this, "context", buffer, theContext);
        Uri theBase = this.getBase();
        strategy.appendField(locator, (Object)this, "base", buffer, (Object)theBase);
        StructureDefinitionSnapshot theSnapshot = this.getSnapshot();
        strategy.appendField(locator, (Object)this, "snapshot", buffer, (Object)theSnapshot);
        StructureDefinitionDifferential theDifferential = this.getDifferential();
        strategy.appendField(locator, (Object)this, "differential", buffer, (Object)theDifferential);
        return buffer;
    }
}

